/*
 * Decompiled with CFR 0.152.
 */
package android.accessibilityservice;

import android.accessibilityservice.AccessibilityServiceInfo;
import android.accessibilityservice.IAccessibilityServiceClient;
import android.accessibilityservice.IAccessibilityServiceConnection;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.util.Log;
import android.view.KeyEvent;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityInteractionClient;
import android.view.accessibility.AccessibilityNodeInfo;
import android.view.accessibility.AccessibilityWindowInfo;
import com.android.internal.os.HandlerCaller;
import java.util.List;

public abstract class AccessibilityService
extends Service {
    public static final int GESTURE_SWIPE_DOWN = 2;
    public static final int GESTURE_SWIPE_DOWN_AND_LEFT = 15;
    public static final int GESTURE_SWIPE_DOWN_AND_RIGHT = 16;
    public static final int GESTURE_SWIPE_DOWN_AND_UP = 8;
    public static final int GESTURE_SWIPE_LEFT = 3;
    public static final int GESTURE_SWIPE_LEFT_AND_DOWN = 10;
    public static final int GESTURE_SWIPE_LEFT_AND_RIGHT = 5;
    public static final int GESTURE_SWIPE_LEFT_AND_UP = 9;
    public static final int GESTURE_SWIPE_RIGHT = 4;
    public static final int GESTURE_SWIPE_RIGHT_AND_DOWN = 12;
    public static final int GESTURE_SWIPE_RIGHT_AND_LEFT = 6;
    public static final int GESTURE_SWIPE_RIGHT_AND_UP = 11;
    public static final int GESTURE_SWIPE_UP = 1;
    public static final int GESTURE_SWIPE_UP_AND_DOWN = 7;
    public static final int GESTURE_SWIPE_UP_AND_LEFT = 13;
    public static final int GESTURE_SWIPE_UP_AND_RIGHT = 14;
    public static final int GLOBAL_ACTION_BACK = 1;
    public static final int GLOBAL_ACTION_HOME = 2;
    public static final int GLOBAL_ACTION_NOTIFICATIONS = 4;
    public static final int GLOBAL_ACTION_POWER_DIALOG = 6;
    public static final int GLOBAL_ACTION_QUICK_SETTINGS = 5;
    public static final int GLOBAL_ACTION_RECENTS = 3;
    private static final String LOG_TAG = "AccessibilityService";
    public static final String SERVICE_INTERFACE = "android.accessibilityservice.AccessibilityService";
    public static final String SERVICE_META_DATA = "android.accessibilityservice";
    private int mConnectionId;
    private AccessibilityServiceInfo mInfo;

    static /* synthetic */ int access$002(AccessibilityService accessibilityService, int n) {
        accessibilityService.mConnectionId = n;
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void sendServiceInfo() {
        IAccessibilityServiceConnection iAccessibilityServiceConnection = AccessibilityInteractionClient.getInstance().getConnection(this.mConnectionId);
        if (this.mInfo == null || iAccessibilityServiceConnection == null) return;
        try {
            iAccessibilityServiceConnection.setServiceInfo(this.mInfo);
            this.mInfo = null;
            AccessibilityInteractionClient.getInstance().clearCache();
            return;
        }
        catch (RemoteException remoteException) {
            Log.w(LOG_TAG, "Error while setting AccessibilityServiceInfo", remoteException);
            return;
        }
    }

    public AccessibilityNodeInfo findFocus(int n) {
        return AccessibilityInteractionClient.getInstance().findFocus(this.mConnectionId, -2, AccessibilityNodeInfo.ROOT_NODE_ID, n);
    }

    public AccessibilityNodeInfo getRootInActiveWindow() {
        return AccessibilityInteractionClient.getInstance().getRootInActiveWindow(this.mConnectionId);
    }

    public final AccessibilityServiceInfo getServiceInfo() {
        IAccessibilityServiceConnection iAccessibilityServiceConnection = AccessibilityInteractionClient.getInstance().getConnection(this.mConnectionId);
        if (iAccessibilityServiceConnection != null) {
            try {
                AccessibilityServiceInfo accessibilityServiceInfo = iAccessibilityServiceConnection.getServiceInfo();
                return accessibilityServiceInfo;
            }
            catch (RemoteException remoteException) {
                Log.w(LOG_TAG, "Error while getting AccessibilityServiceInfo", remoteException);
            }
        }
        return null;
    }

    public List<AccessibilityWindowInfo> getWindows() {
        return AccessibilityInteractionClient.getInstance().getWindows(this.mConnectionId);
    }

    public abstract void onAccessibilityEvent(AccessibilityEvent var1);

    @Override
    public final IBinder onBind(Intent intent) {
        return new IAccessibilityServiceClientWrapper(this, this.getMainLooper(), new Callbacks(){

            @Override
            public void onAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
                AccessibilityService.this.onAccessibilityEvent(accessibilityEvent);
            }

            @Override
            public boolean onGesture(int n) {
                return AccessibilityService.this.onGesture(n);
            }

            @Override
            public void onInterrupt() {
                AccessibilityService.this.onInterrupt();
            }

            @Override
            public boolean onKeyEvent(KeyEvent keyEvent) {
                return AccessibilityService.this.onKeyEvent(keyEvent);
            }

            @Override
            public void onServiceConnected() {
                AccessibilityService.this.onServiceConnected();
            }

            @Override
            public void onSetConnectionId(int n) {
                AccessibilityService.access$002(AccessibilityService.this, n);
            }
        });
    }

    protected boolean onGesture(int n) {
        return false;
    }

    public abstract void onInterrupt();

    protected boolean onKeyEvent(KeyEvent keyEvent) {
        return false;
    }

    protected void onServiceConnected() {
    }

    public final boolean performGlobalAction(int n) {
        IAccessibilityServiceConnection iAccessibilityServiceConnection = AccessibilityInteractionClient.getInstance().getConnection(this.mConnectionId);
        if (iAccessibilityServiceConnection != null) {
            try {
                boolean bl = iAccessibilityServiceConnection.performGlobalAction(n);
                return bl;
            }
            catch (RemoteException remoteException) {
                Log.w(LOG_TAG, "Error while calling performGlobalAction", remoteException);
            }
        }
        return false;
    }

    public final void setServiceInfo(AccessibilityServiceInfo accessibilityServiceInfo) {
        this.mInfo = accessibilityServiceInfo;
        this.sendServiceInfo();
    }

    public static interface Callbacks {
        public void onAccessibilityEvent(AccessibilityEvent var1);

        public boolean onGesture(int var1);

        public void onInterrupt();

        public boolean onKeyEvent(KeyEvent var1);

        public void onServiceConnected();

        public void onSetConnectionId(int var1);
    }

    public static class IAccessibilityServiceClientWrapper
    extends IAccessibilityServiceClient.Stub
    implements HandlerCaller.Callback {
        private static final int DO_CLEAR_ACCESSIBILITY_CACHE = 5;
        private static final int DO_ON_ACCESSIBILITY_EVENT = 3;
        private static final int DO_ON_GESTURE = 4;
        private static final int DO_ON_INTERRUPT = 2;
        private static final int DO_ON_KEY_EVENT = 6;
        private static final int DO_SET_SET_CONNECTION = 1;
        private final Callbacks mCallback;
        private final HandlerCaller mCaller;
        private int mConnectionId;

        public IAccessibilityServiceClientWrapper(Context context, Looper looper, Callbacks callbacks) {
            this.mCallback = callbacks;
            this.mCaller = new HandlerCaller(context, looper, this, true);
        }

        @Override
        public void clearAccessibilityCache() {
            Message message = this.mCaller.obtainMessage(5);
            this.mCaller.sendMessage(message);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void executeMessage(Message message) {
            switch (message.what) {
                default: {
                    Log.w(AccessibilityService.LOG_TAG, "Unknown message type " + message.what);
                    return;
                }
                case 3: {
                    AccessibilityEvent accessibilityEvent = (AccessibilityEvent)message.obj;
                    if (accessibilityEvent == null) return;
                    AccessibilityInteractionClient.getInstance().onAccessibilityEvent(accessibilityEvent);
                    this.mCallback.onAccessibilityEvent(accessibilityEvent);
                    try {
                        accessibilityEvent.recycle();
                        return;
                    }
                    catch (IllegalStateException illegalStateException) {
                        return;
                    }
                }
                case 2: {
                    this.mCallback.onInterrupt();
                    return;
                }
                case 1: {
                    this.mConnectionId = message.arg1;
                    IAccessibilityServiceConnection iAccessibilityServiceConnection = (IAccessibilityServiceConnection)message.obj;
                    if (iAccessibilityServiceConnection != null) {
                        AccessibilityInteractionClient.getInstance().addConnection(this.mConnectionId, iAccessibilityServiceConnection);
                        this.mCallback.onSetConnectionId(this.mConnectionId);
                        this.mCallback.onServiceConnected();
                        return;
                    }
                    AccessibilityInteractionClient.getInstance().removeConnection(this.mConnectionId);
                    AccessibilityInteractionClient.getInstance().clearCache();
                    this.mCallback.onSetConnectionId(-1);
                    return;
                }
                case 4: {
                    int n = message.arg1;
                    this.mCallback.onGesture(n);
                    return;
                }
                case 5: {
                    AccessibilityInteractionClient.getInstance().clearCache();
                    return;
                }
                case 6: 
            }
            KeyEvent keyEvent = (KeyEvent)message.obj;
            try {
                IAccessibilityServiceConnection iAccessibilityServiceConnection = AccessibilityInteractionClient.getInstance().getConnection(this.mConnectionId);
                if (iAccessibilityServiceConnection == null) return;
                boolean bl = this.mCallback.onKeyEvent(keyEvent);
                int n = message.arg1;
                try {
                    iAccessibilityServiceConnection.setOnKeyEventResult(bl, n);
                    return;
                }
                catch (RemoteException remoteException) {
                    return;
                }
            }
            finally {
                keyEvent.recycle();
            }
        }

        @Override
        public void onAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
            Message message = this.mCaller.obtainMessageO(3, accessibilityEvent);
            this.mCaller.sendMessage(message);
        }

        @Override
        public void onGesture(int n) {
            Message message = this.mCaller.obtainMessageI(4, n);
            this.mCaller.sendMessage(message);
        }

        @Override
        public void onInterrupt() {
            Message message = this.mCaller.obtainMessage(2);
            this.mCaller.sendMessage(message);
        }

        @Override
        public void onKeyEvent(KeyEvent keyEvent, int n) {
            Message message = this.mCaller.obtainMessageIO(6, n, keyEvent);
            this.mCaller.sendMessage(message);
        }

        @Override
        public void setConnection(IAccessibilityServiceConnection iAccessibilityServiceConnection, int n) {
            Message message = this.mCaller.obtainMessageIO(1, n, iAccessibilityServiceConnection);
            this.mCaller.sendMessage(message);
        }
    }
}

