/*
 * Decompiled with CFR 0.152.
 */
package android.accessibilityservice;

import android.content.ComponentName;
import android.content.Context;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.SparseArray;
import android.view.accessibility.AccessibilityEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.xmlpull.v1.XmlPullParserException;

public class AccessibilityServiceInfo
implements Parcelable {
    public static final int CAPABILITY_CAN_REQUEST_ENHANCED_WEB_ACCESSIBILITY = 4;
    public static final int CAPABILITY_CAN_REQUEST_FILTER_KEY_EVENTS = 8;
    public static final int CAPABILITY_CAN_REQUEST_TOUCH_EXPLORATION = 2;
    public static final int CAPABILITY_CAN_RETRIEVE_WINDOW_CONTENT = 1;
    public static final Parcelable.Creator<AccessibilityServiceInfo> CREATOR;
    public static final int DEFAULT = 1;
    public static final int FEEDBACK_ALL_MASK = -1;
    public static final int FEEDBACK_AUDIBLE = 4;
    public static final int FEEDBACK_BRAILLE = 32;
    public static final int FEEDBACK_GENERIC = 16;
    public static final int FEEDBACK_HAPTIC = 2;
    public static final int FEEDBACK_SPOKEN = 1;
    public static final int FEEDBACK_VISUAL = 8;
    public static final int FLAG_INCLUDE_NOT_IMPORTANT_VIEWS = 2;
    public static final int FLAG_REPORT_VIEW_IDS = 16;
    public static final int FLAG_REQUEST_ENHANCED_WEB_ACCESSIBILITY = 8;
    public static final int FLAG_REQUEST_FILTER_KEY_EVENTS = 32;
    public static final int FLAG_REQUEST_TOUCH_EXPLORATION_MODE = 4;
    public static final int FLAG_RETRIEVE_INTERACTIVE_WINDOWS = 64;
    private static final String TAG_ACCESSIBILITY_SERVICE = "accessibility-service";
    private static final SparseArray<CapabilityInfo> sAvailableCapabilityInfos;
    public int eventTypes;
    public int feedbackType;
    public int flags;
    private int mCapabilities;
    private int mDescriptionResId;
    private String mId;
    private String mNonLocalizedDescription;
    private ResolveInfo mResolveInfo;
    private String mSettingsActivityName;
    public long notificationTimeout;
    public String[] packageNames;

    static {
        sAvailableCapabilityInfos = new SparseArray();
        sAvailableCapabilityInfos.put(1, new CapabilityInfo(1, 17039689, 17039690));
        sAvailableCapabilityInfos.put(2, new CapabilityInfo(2, 17039691, 17039692));
        sAvailableCapabilityInfos.put(4, new CapabilityInfo(4, 17039693, 17039694));
        sAvailableCapabilityInfos.put(8, new CapabilityInfo(8, 17039695, 17039696));
        CREATOR = new Parcelable.Creator<AccessibilityServiceInfo>(){

            @Override
            public AccessibilityServiceInfo createFromParcel(Parcel parcel) {
                AccessibilityServiceInfo accessibilityServiceInfo = new AccessibilityServiceInfo();
                accessibilityServiceInfo.initFromParcel(parcel);
                return accessibilityServiceInfo;
            }

            public AccessibilityServiceInfo[] newArray(int n) {
                return new AccessibilityServiceInfo[n];
            }
        };
    }

    public AccessibilityServiceInfo() {
    }

    /*
     * Exception decompiling
     */
    public AccessibilityServiceInfo(ResolveInfo var1_1, Context var2_2) throws XmlPullParserException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [7, 8 : 178->223)] android.content.pm.PackageManager$NameNotFoundException
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void appendCapabilities(StringBuilder stringBuilder, int n) {
        stringBuilder.append("capabilities:");
        stringBuilder.append("[");
        while (n != 0) {
            int n2 = 1 << Integer.numberOfTrailingZeros(n);
            stringBuilder.append(AccessibilityServiceInfo.capabilityToString(n2));
            if ((n &= ~n2) == 0) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append("]");
    }

    private static void appendEventTypes(StringBuilder stringBuilder, int n) {
        stringBuilder.append("eventTypes:");
        stringBuilder.append("[");
        while (n != 0) {
            int n2 = 1 << Integer.numberOfTrailingZeros(n);
            stringBuilder.append(AccessibilityEvent.eventTypeToString(n2));
            if ((n &= ~n2) == 0) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append("]");
    }

    private static void appendFeedbackTypes(StringBuilder stringBuilder, int n) {
        stringBuilder.append("feedbackTypes:");
        stringBuilder.append("[");
        while (n != 0) {
            int n2 = 1 << Integer.numberOfTrailingZeros(n);
            stringBuilder.append(AccessibilityServiceInfo.feedbackTypeToString(n2));
            if ((n &= ~n2) == 0) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append("]");
    }

    private static void appendFlags(StringBuilder stringBuilder, int n) {
        stringBuilder.append("flags:");
        stringBuilder.append("[");
        while (n != 0) {
            int n2 = 1 << Integer.numberOfTrailingZeros(n);
            stringBuilder.append(AccessibilityServiceInfo.flagToString(n2));
            if ((n &= ~n2) == 0) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append("]");
    }

    private static void appendPackageNames(StringBuilder stringBuilder, String[] stringArray) {
        stringBuilder.append("packageNames:");
        stringBuilder.append("[");
        if (stringArray != null) {
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                stringBuilder.append(stringArray[i]);
                if (i >= n - 1) continue;
                stringBuilder.append(", ");
            }
        }
        stringBuilder.append("]");
    }

    public static String capabilityToString(int n) {
        switch (n) {
            default: {
                return "UNKNOWN";
            }
            case 1: {
                return "CAPABILITY_CAN_RETRIEVE_WINDOW_CONTENT";
            }
            case 2: {
                return "CAPABILITY_CAN_REQUEST_TOUCH_EXPLORATION";
            }
            case 4: {
                return "CAPABILITY_CAN_REQUEST_ENHANCED_WEB_ACCESSIBILITY";
            }
            case 8: 
        }
        return "CAPABILITY_CAN_FILTER_KEY_EVENTS";
    }

    public static String feedbackTypeToString(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        block8: while (n != 0) {
            int n2 = 1 << Integer.numberOfTrailingZeros(n);
            n &= ~n2;
            switch (n2) {
                default: {
                    continue block8;
                }
                case 1: {
                    if (stringBuilder.length() > 1) {
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append("FEEDBACK_SPOKEN");
                    continue block8;
                }
                case 4: {
                    if (stringBuilder.length() > 1) {
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append("FEEDBACK_AUDIBLE");
                    continue block8;
                }
                case 2: {
                    if (stringBuilder.length() > 1) {
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append("FEEDBACK_HAPTIC");
                    continue block8;
                }
                case 16: {
                    if (stringBuilder.length() > 1) {
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append("FEEDBACK_GENERIC");
                    continue block8;
                }
                case 8: {
                    if (stringBuilder.length() > 1) {
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append("FEEDBACK_VISUAL");
                    continue block8;
                }
                case 32: 
            }
            if (stringBuilder.length() > 1) {
                stringBuilder.append(", ");
            }
            stringBuilder.append("FEEDBACK_BRAILLE");
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public static String flagToString(int n) {
        switch (n) {
            default: {
                return null;
            }
            case 1: {
                return "DEFAULT";
            }
            case 2: {
                return "FLAG_INCLUDE_NOT_IMPORTANT_VIEWS";
            }
            case 4: {
                return "FLAG_REQUEST_TOUCH_EXPLORATION_MODE";
            }
            case 8: {
                return "FLAG_REQUEST_ENHANCED_WEB_ACCESSIBILITY";
            }
            case 16: {
                return "FLAG_REPORT_VIEW_IDS";
            }
            case 32: {
                return "FLAG_REQUEST_FILTER_KEY_EVENTS";
            }
            case 64: 
        }
        return "FLAG_RETRIEVE_INTERACTIVE_WINDOWS";
    }

    private void initFromParcel(Parcel parcel) {
        this.eventTypes = parcel.readInt();
        this.packageNames = parcel.readStringArray();
        this.feedbackType = parcel.readInt();
        this.notificationTimeout = parcel.readLong();
        this.flags = parcel.readInt();
        this.mId = parcel.readString();
        this.mResolveInfo = (ResolveInfo)parcel.readParcelable(null);
        this.mSettingsActivityName = parcel.readString();
        this.mCapabilities = parcel.readInt();
        this.mDescriptionResId = parcel.readInt();
        this.mNonLocalizedDescription = parcel.readString();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean equals(Object object) {
        if (this == object) return true;
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        AccessibilityServiceInfo accessibilityServiceInfo = (AccessibilityServiceInfo)object;
        if (this.mId == null) {
            if (accessibilityServiceInfo.mId == null) return true;
            return false;
        }
        if (!this.mId.equals(accessibilityServiceInfo.mId)) return false;
        return true;
    }

    public boolean getCanRetrieveWindowContent() {
        return (1 & this.mCapabilities) != 0;
    }

    public int getCapabilities() {
        return this.mCapabilities;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<CapabilityInfo> getCapabilityInfos() {
        if (this.mCapabilities == 0) {
            return Collections.emptyList();
        }
        int n = this.mCapabilities;
        List<CapabilityInfo> list = new ArrayList<CapabilityInfo>();
        while (n != 0) {
            int n2 = 1 << Integer.numberOfTrailingZeros(n);
            n &= ~n2;
            CapabilityInfo capabilityInfo = sAvailableCapabilityInfos.get(n2);
            if (capabilityInfo == null) continue;
            list.add(capabilityInfo);
        }
        return list;
    }

    public String getDescription() {
        return this.mNonLocalizedDescription;
    }

    public String getId() {
        return this.mId;
    }

    public ResolveInfo getResolveInfo() {
        return this.mResolveInfo;
    }

    public String getSettingsActivityName() {
        return this.mSettingsActivityName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int hashCode() {
        if (this.mId == null) {
            return 31;
        }
        int n = this.mId.hashCode();
        return n + 31;
    }

    public String loadDescription(PackageManager packageManager) {
        if (this.mDescriptionResId == 0) {
            return this.mNonLocalizedDescription;
        }
        ServiceInfo serviceInfo = this.mResolveInfo.serviceInfo;
        CharSequence charSequence = packageManager.getText(serviceInfo.packageName, this.mDescriptionResId, serviceInfo.applicationInfo);
        if (charSequence != null) {
            return charSequence.toString().trim();
        }
        return null;
    }

    public void setCapabilities(int n) {
        this.mCapabilities = n;
    }

    public void setComponentName(ComponentName componentName) {
        this.mId = componentName.flattenToShortString();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        AccessibilityServiceInfo.appendEventTypes(stringBuilder, this.eventTypes);
        stringBuilder.append(", ");
        AccessibilityServiceInfo.appendPackageNames(stringBuilder, this.packageNames);
        stringBuilder.append(", ");
        AccessibilityServiceInfo.appendFeedbackTypes(stringBuilder, this.feedbackType);
        stringBuilder.append(", ");
        stringBuilder.append("notificationTimeout: ").append(this.notificationTimeout);
        stringBuilder.append(", ");
        AccessibilityServiceInfo.appendFlags(stringBuilder, this.flags);
        stringBuilder.append(", ");
        stringBuilder.append("id: ").append(this.mId);
        stringBuilder.append(", ");
        stringBuilder.append("resolveInfo: ").append(this.mResolveInfo);
        stringBuilder.append(", ");
        stringBuilder.append("settingsActivityName: ").append(this.mSettingsActivityName);
        stringBuilder.append(", ");
        AccessibilityServiceInfo.appendCapabilities(stringBuilder, this.mCapabilities);
        return stringBuilder.toString();
    }

    public void updateDynamicallyConfigurableProperties(AccessibilityServiceInfo accessibilityServiceInfo) {
        this.eventTypes = accessibilityServiceInfo.eventTypes;
        this.packageNames = accessibilityServiceInfo.packageNames;
        this.feedbackType = accessibilityServiceInfo.feedbackType;
        this.notificationTimeout = accessibilityServiceInfo.notificationTimeout;
        this.flags = accessibilityServiceInfo.flags;
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeInt(this.eventTypes);
        parcel.writeStringArray(this.packageNames);
        parcel.writeInt(this.feedbackType);
        parcel.writeLong(this.notificationTimeout);
        parcel.writeInt(this.flags);
        parcel.writeString(this.mId);
        parcel.writeParcelable(this.mResolveInfo, 0);
        parcel.writeString(this.mSettingsActivityName);
        parcel.writeInt(this.mCapabilities);
        parcel.writeInt(this.mDescriptionResId);
        parcel.writeString(this.mNonLocalizedDescription);
    }

    public static final class CapabilityInfo {
        public final int capability;
        public final int descResId;
        public final int titleResId;

        public CapabilityInfo(int n, int n2, int n3) {
            this.capability = n;
            this.titleResId = n2;
            this.descResId = n3;
        }
    }
}

