/*
 * Decompiled with CFR 0.152.
 */
package android.animation;

import android.animation.Animator;
import android.animation.ArgbEvaluator;
import android.animation.PropertyValuesHolder;
import android.animation.TimeInterpolator;
import android.animation.TypeEvaluator;
import android.os.Looper;
import android.os.Trace;
import android.util.AndroidRuntimeException;
import android.view.Choreographer;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.AnimationUtils;
import android.view.animation.LinearInterpolator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class ValueAnimator
extends Animator {
    public static final int INFINITE = -1;
    public static final int RESTART = 1;
    public static final int REVERSE = 2;
    static final int RUNNING = 1;
    static final int SEEKED = 2;
    static final int STOPPED;
    protected static ThreadLocal<AnimationHandler> sAnimationHandler;
    private static final TimeInterpolator sDefaultInterpolator;
    private static float sDurationScale;
    private float mCurrentFraction = 0.0f;
    private int mCurrentIteration = 0;
    private long mDelayStartTime;
    private long mDuration = (long)(300.0f * sDurationScale);
    boolean mInitialized = false;
    private TimeInterpolator mInterpolator = sDefaultInterpolator;
    private long mPauseTime;
    private boolean mPlayingBackwards = false;
    int mPlayingState = 0;
    private int mRepeatCount = 0;
    private int mRepeatMode = 1;
    private boolean mResumed = false;
    private boolean mRunning = false;
    long mSeekTime = -1L;
    private long mStartDelay = 0L;
    private boolean mStartListenersCalled = false;
    long mStartTime;
    private boolean mStarted = false;
    private boolean mStartedDelay = false;
    private long mUnscaledDuration = 300L;
    private long mUnscaledStartDelay = 0L;
    ArrayList<AnimatorUpdateListener> mUpdateListeners = null;
    PropertyValuesHolder[] mValues;
    HashMap<String, PropertyValuesHolder> mValuesMap;

    static {
        sDurationScale = 1.0f;
        sAnimationHandler = new ThreadLocal();
        sDefaultInterpolator = new AccelerateDecelerateInterpolator();
    }

    static /* synthetic */ boolean access$302(ValueAnimator valueAnimator, boolean bl) {
        valueAnimator.mRunning = bl;
        return bl;
    }

    public static void clearAllAnimations() {
        AnimationHandler animationHandler = sAnimationHandler.get();
        if (animationHandler != null) {
            animationHandler.mAnimations.clear();
            animationHandler.mPendingAnimations.clear();
            animationHandler.mDelayedAnims.clear();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean delayedAnimationFrame(long l) {
        long l2;
        if (!this.mStartedDelay) {
            this.mStartedDelay = true;
            this.mDelayStartTime = l;
        }
        if (this.mPaused) {
            if (this.mPauseTime >= 0L) return false;
            this.mPauseTime = l;
            return false;
        }
        if (this.mResumed) {
            this.mResumed = false;
            if (this.mPauseTime > 0L) {
                this.mDelayStartTime += l - this.mPauseTime;
            }
        }
        if ((l2 = l - this.mDelayStartTime) <= this.mStartDelay) return false;
        this.mStartTime = l - (l2 - this.mStartDelay);
        this.mPlayingState = 1;
        return true;
    }

    public static int getCurrentAnimationsCount() {
        AnimationHandler animationHandler = sAnimationHandler.get();
        if (animationHandler != null) {
            return animationHandler.mAnimations.size();
        }
        return 0;
    }

    public static float getDurationScale() {
        return sDurationScale;
    }

    public static long getFrameDelay() {
        return Choreographer.getFrameDelay();
    }

    private static AnimationHandler getOrCreateAnimationHandler() {
        AnimationHandler animationHandler = sAnimationHandler.get();
        if (animationHandler == null) {
            animationHandler = new AnimationHandler();
            sAnimationHandler.set(animationHandler);
        }
        return animationHandler;
    }

    private void notifyStartListeners() {
        if (this.mListeners != null && !this.mStartListenersCalled) {
            ArrayList arrayList = (ArrayList)this.mListeners.clone();
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                ((Animator.AnimatorListener)arrayList.get(i)).onAnimationStart(this);
            }
        }
        this.mStartListenersCalled = true;
    }

    public static ValueAnimator ofArgb(int ... nArray) {
        ValueAnimator valueAnimator = new ValueAnimator();
        valueAnimator.setIntValues(nArray);
        valueAnimator.setEvaluator(ArgbEvaluator.getInstance());
        return valueAnimator;
    }

    public static ValueAnimator ofFloat(float ... fArray) {
        ValueAnimator valueAnimator = new ValueAnimator();
        valueAnimator.setFloatValues(fArray);
        return valueAnimator;
    }

    public static ValueAnimator ofInt(int ... nArray) {
        ValueAnimator valueAnimator = new ValueAnimator();
        valueAnimator.setIntValues(nArray);
        return valueAnimator;
    }

    public static ValueAnimator ofObject(TypeEvaluator typeEvaluator, Object ... objectArray) {
        ValueAnimator valueAnimator = new ValueAnimator();
        valueAnimator.setObjectValues(objectArray);
        valueAnimator.setEvaluator(typeEvaluator);
        return valueAnimator;
    }

    public static ValueAnimator ofPropertyValuesHolder(PropertyValuesHolder ... propertyValuesHolderArray) {
        ValueAnimator valueAnimator = new ValueAnimator();
        valueAnimator.setValues(propertyValuesHolderArray);
        return valueAnimator;
    }

    public static void setDurationScale(float f) {
        sDurationScale = f;
    }

    public static void setFrameDelay(long l) {
        Choreographer.setFrameDelay(l);
    }

    private void start(boolean bl) {
        if (Looper.myLooper() == null) {
            throw new AndroidRuntimeException("Animators may only be run on Looper threads");
        }
        this.mPlayingBackwards = bl;
        this.mCurrentIteration = 0;
        this.mPlayingState = 0;
        this.mStarted = true;
        this.mStartedDelay = false;
        this.mPaused = false;
        this.updateScaledDuration();
        AnimationHandler animationHandler = ValueAnimator.getOrCreateAnimationHandler();
        animationHandler.mPendingAnimations.add(this);
        if (this.mStartDelay == 0L) {
            this.setCurrentPlayTime(0L);
            this.mPlayingState = 0;
            this.mRunning = true;
            this.notifyStartListeners();
        }
        animationHandler.start();
    }

    private void startAnimation(AnimationHandler animationHandler) {
        if (Trace.isTagEnabled(8L)) {
            Trace.asyncTraceBegin(8L, this.getNameForTrace(), System.identityHashCode(this));
        }
        this.initAnimation();
        animationHandler.mAnimations.add(this);
        if (this.mStartDelay > 0L && this.mListeners != null) {
            this.notifyStartListeners();
        }
    }

    private void updateScaledDuration() {
        this.mDuration = (long)((float)this.mUnscaledDuration * sDurationScale);
    }

    public void addUpdateListener(AnimatorUpdateListener animatorUpdateListener) {
        if (this.mUpdateListeners == null) {
            this.mUpdateListeners = new ArrayList();
        }
        this.mUpdateListeners.add(animatorUpdateListener);
    }

    void animateValue(float f) {
        float f2;
        this.mCurrentFraction = f2 = this.mInterpolator.getInterpolation(f);
        int n = this.mValues.length;
        for (int i = 0; i < n; ++i) {
            this.mValues[i].calculateValue(f2);
        }
        if (this.mUpdateListeners != null) {
            int n2 = this.mUpdateListeners.size();
            for (int i = 0; i < n2; ++i) {
                this.mUpdateListeners.get(i).onAnimationUpdate(this);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    boolean animationFrame(long l) {
        switch (this.mPlayingState) {
            default: {
                return false;
            }
            case 1: 
            case 2: 
        }
        float f = this.mDuration > 0L ? (float)(l - this.mStartTime) / (float)this.mDuration : 1.0f;
        float f2 = f - 1.0f;
        float f3 = f2 == 0.0f ? 0 : (f2 > 0.0f ? 1 : -1);
        boolean bl = false;
        if (f3 >= 0) {
            if (this.mCurrentIteration < this.mRepeatCount || this.mRepeatCount == -1) {
                if (this.mListeners != null) {
                    int n = this.mListeners.size();
                    for (int i = 0; i < n; ++i) {
                        ((Animator.AnimatorListener)this.mListeners.get(i)).onAnimationRepeat(this);
                    }
                }
                if (this.mRepeatMode == 2) {
                    boolean bl2 = !this.mPlayingBackwards;
                    this.mPlayingBackwards = bl2;
                }
                this.mCurrentIteration += (int)f;
                f %= 1.0f;
                this.mStartTime += this.mDuration;
            } else {
                bl = true;
                f = Math.min(f, 1.0f);
            }
        }
        if (this.mPlayingBackwards) {
            f = 1.0f - f;
        }
        this.animateValue(f);
        return bl;
    }

    @Override
    public boolean canReverse() {
        return true;
    }

    @Override
    public void cancel() {
        AnimationHandler animationHandler = ValueAnimator.getOrCreateAnimationHandler();
        if (this.mPlayingState != 0 || animationHandler.mPendingAnimations.contains(this) || animationHandler.mDelayedAnims.contains(this)) {
            if ((this.mStarted || this.mRunning) && this.mListeners != null) {
                if (!this.mRunning) {
                    this.notifyStartListeners();
                }
                Iterator iterator = ((ArrayList)this.mListeners.clone()).iterator();
                while (iterator.hasNext()) {
                    ((Animator.AnimatorListener)iterator.next()).onAnimationCancel(this);
                }
            }
            this.endAnimation(animationHandler);
        }
    }

    @Override
    public ValueAnimator clone() {
        ValueAnimator valueAnimator = (ValueAnimator)super.clone();
        if (this.mUpdateListeners != null) {
            ArrayList<AnimatorUpdateListener> arrayList = this.mUpdateListeners;
            valueAnimator.mUpdateListeners = new ArrayList();
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                valueAnimator.mUpdateListeners.add(arrayList.get(i));
            }
        }
        valueAnimator.mSeekTime = -1L;
        valueAnimator.mPlayingBackwards = false;
        valueAnimator.mCurrentIteration = 0;
        valueAnimator.mInitialized = false;
        valueAnimator.mPlayingState = 0;
        valueAnimator.mStartedDelay = false;
        PropertyValuesHolder[] propertyValuesHolderArray = this.mValues;
        if (propertyValuesHolderArray != null) {
            int n = propertyValuesHolderArray.length;
            valueAnimator.mValues = new PropertyValuesHolder[n];
            valueAnimator.mValuesMap = new HashMap(n);
            for (int i = 0; i < n; ++i) {
                PropertyValuesHolder propertyValuesHolder;
                valueAnimator.mValues[i] = propertyValuesHolder = propertyValuesHolderArray[i].clone();
                valueAnimator.mValuesMap.put(propertyValuesHolder.getPropertyName(), propertyValuesHolder);
            }
        }
        return valueAnimator;
    }

    /*
     * Enabled aggressive block sorting
     */
    final boolean doAnimationFrame(long l) {
        if (this.mPlayingState == 0) {
            this.mPlayingState = 1;
            if (this.mSeekTime < 0L) {
                this.mStartTime = l;
            } else {
                this.mStartTime = l - this.mSeekTime;
                this.mSeekTime = -1L;
            }
        }
        if (this.mPaused) {
            if (this.mPauseTime < 0L) {
                this.mPauseTime = l;
            }
            return false;
        }
        if (this.mResumed) {
            this.mResumed = false;
            if (this.mPauseTime > 0L) {
                this.mStartTime += l - this.mPauseTime;
            }
        }
        return this.animationFrame(Math.max(l, this.mStartTime));
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void end() {
        AnimationHandler animationHandler = ValueAnimator.getOrCreateAnimationHandler();
        if (!animationHandler.mAnimations.contains(this) && !animationHandler.mPendingAnimations.contains(this)) {
            this.mStartedDelay = false;
            this.startAnimation(animationHandler);
            this.mStarted = true;
        } else if (!this.mInitialized) {
            this.initAnimation();
        }
        float f = this.mPlayingBackwards ? 0.0f : 1.0f;
        this.animateValue(f);
        this.endAnimation(animationHandler);
    }

    protected void endAnimation(AnimationHandler animationHandler) {
        animationHandler.mAnimations.remove(this);
        animationHandler.mPendingAnimations.remove(this);
        animationHandler.mDelayedAnims.remove(this);
        this.mPlayingState = 0;
        this.mPaused = false;
        if ((this.mStarted || this.mRunning) && this.mListeners != null) {
            if (!this.mRunning) {
                this.notifyStartListeners();
            }
            ArrayList arrayList = (ArrayList)this.mListeners.clone();
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                ((Animator.AnimatorListener)arrayList.get(i)).onAnimationEnd(this);
            }
        }
        this.mRunning = false;
        this.mStarted = false;
        this.mStartListenersCalled = false;
        this.mPlayingBackwards = false;
        if (Trace.isTagEnabled(8L)) {
            Trace.asyncTraceEnd(8L, this.getNameForTrace(), System.identityHashCode(this));
        }
    }

    public float getAnimatedFraction() {
        return this.mCurrentFraction;
    }

    public Object getAnimatedValue() {
        if (this.mValues != null && this.mValues.length > 0) {
            return this.mValues[0].getAnimatedValue();
        }
        return null;
    }

    public Object getAnimatedValue(String string2) {
        PropertyValuesHolder propertyValuesHolder = this.mValuesMap.get(string2);
        if (propertyValuesHolder != null) {
            return propertyValuesHolder.getAnimatedValue();
        }
        return null;
    }

    public long getCurrentPlayTime() {
        if (!this.mInitialized || this.mPlayingState == 0) {
            return 0L;
        }
        return AnimationUtils.currentAnimationTimeMillis() - this.mStartTime;
    }

    @Override
    public long getDuration() {
        return this.mUnscaledDuration;
    }

    @Override
    public TimeInterpolator getInterpolator() {
        return this.mInterpolator;
    }

    String getNameForTrace() {
        return "animator";
    }

    public int getRepeatCount() {
        return this.mRepeatCount;
    }

    public int getRepeatMode() {
        return this.mRepeatMode;
    }

    @Override
    public long getStartDelay() {
        return this.mUnscaledStartDelay;
    }

    public PropertyValuesHolder[] getValues() {
        return this.mValues;
    }

    void initAnimation() {
        if (!this.mInitialized) {
            int n = this.mValues.length;
            for (int i = 0; i < n; ++i) {
                this.mValues[i].init();
            }
            this.mInitialized = true;
        }
    }

    @Override
    public boolean isRunning() {
        return this.mPlayingState == 1 || this.mRunning;
    }

    @Override
    public boolean isStarted() {
        return this.mStarted;
    }

    @Override
    public void pause() {
        boolean bl = this.mPaused;
        super.pause();
        if (!bl && this.mPaused) {
            this.mPauseTime = -1L;
            this.mResumed = false;
        }
    }

    public void removeAllUpdateListeners() {
        if (this.mUpdateListeners == null) {
            return;
        }
        this.mUpdateListeners.clear();
        this.mUpdateListeners = null;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void removeUpdateListener(AnimatorUpdateListener animatorUpdateListener) {
        block3: {
            block2: {
                if (this.mUpdateListeners == null) break block2;
                this.mUpdateListeners.remove(animatorUpdateListener);
                if (this.mUpdateListeners.size() == 0) break block3;
            }
            return;
        }
        this.mUpdateListeners = null;
    }

    @Override
    public void resume() {
        if (this.mPaused) {
            this.mResumed = true;
        }
        super.resume();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void reverse() {
        boolean bl = !this.mPlayingBackwards;
        this.mPlayingBackwards = bl;
        if (this.mPlayingState == 1) {
            long l = AnimationUtils.currentAnimationTimeMillis();
            long l2 = l - this.mStartTime;
            this.mStartTime = l - (this.mDuration - l2);
            return;
        }
        if (this.mStarted) {
            this.end();
            return;
        }
        this.start(true);
    }

    @Override
    public void setAllowRunningAsynchronously(boolean bl) {
    }

    public void setCurrentPlayTime(long l) {
        this.initAnimation();
        long l2 = AnimationUtils.currentAnimationTimeMillis();
        if (this.mPlayingState != 1) {
            this.mSeekTime = l;
            this.mPlayingState = 2;
        }
        this.mStartTime = l2 - l;
        this.doAnimationFrame(l2);
    }

    @Override
    public ValueAnimator setDuration(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException("Animators cannot have negative duration: " + l);
        }
        this.mUnscaledDuration = l;
        this.updateScaledDuration();
        return this;
    }

    public void setEvaluator(TypeEvaluator typeEvaluator) {
        if (typeEvaluator != null && this.mValues != null && this.mValues.length > 0) {
            this.mValues[0].setEvaluator(typeEvaluator);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setFloatValues(float ... fArray) {
        if (fArray == null || fArray.length == 0) {
            return;
        }
        if (this.mValues == null || this.mValues.length == 0) {
            PropertyValuesHolder[] propertyValuesHolderArray = new PropertyValuesHolder[]{PropertyValuesHolder.ofFloat("", fArray)};
            this.setValues(propertyValuesHolderArray);
        } else {
            this.mValues[0].setFloatValues(fArray);
        }
        this.mInitialized = false;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setIntValues(int ... nArray) {
        if (nArray == null || nArray.length == 0) {
            return;
        }
        if (this.mValues == null || this.mValues.length == 0) {
            PropertyValuesHolder[] propertyValuesHolderArray = new PropertyValuesHolder[]{PropertyValuesHolder.ofInt("", nArray)};
            this.setValues(propertyValuesHolderArray);
        } else {
            this.mValues[0].setIntValues(nArray);
        }
        this.mInitialized = false;
    }

    @Override
    public void setInterpolator(TimeInterpolator timeInterpolator) {
        if (timeInterpolator != null) {
            this.mInterpolator = timeInterpolator;
            return;
        }
        this.mInterpolator = new LinearInterpolator();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setObjectValues(Object ... objectArray) {
        if (objectArray == null || objectArray.length == 0) {
            return;
        }
        if (this.mValues == null || this.mValues.length == 0) {
            PropertyValuesHolder[] propertyValuesHolderArray = new PropertyValuesHolder[]{PropertyValuesHolder.ofObject("", null, objectArray)};
            this.setValues(propertyValuesHolderArray);
        } else {
            this.mValues[0].setObjectValues(objectArray);
        }
        this.mInitialized = false;
    }

    public void setRepeatCount(int n) {
        this.mRepeatCount = n;
    }

    public void setRepeatMode(int n) {
        this.mRepeatMode = n;
    }

    @Override
    public void setStartDelay(long l) {
        this.mStartDelay = (long)((float)l * sDurationScale);
        this.mUnscaledStartDelay = l;
    }

    public void setValues(PropertyValuesHolder ... propertyValuesHolderArray) {
        int n = propertyValuesHolderArray.length;
        this.mValues = propertyValuesHolderArray;
        this.mValuesMap = new HashMap(n);
        for (int i = 0; i < n; ++i) {
            PropertyValuesHolder propertyValuesHolder = propertyValuesHolderArray[i];
            this.mValuesMap.put(propertyValuesHolder.getPropertyName(), propertyValuesHolder);
        }
        this.mInitialized = false;
    }

    @Override
    public void start() {
        this.start(false);
    }

    public String toString() {
        String string2 = "ValueAnimator@" + Integer.toHexString(this.hashCode());
        if (this.mValues != null) {
            for (int i = 0; i < this.mValues.length; ++i) {
                string2 = string2 + "\n    " + this.mValues[i].toString();
            }
        }
        return string2;
    }

    protected static class AnimationHandler
    implements Runnable {
        private boolean mAnimationScheduled;
        protected final ArrayList<ValueAnimator> mAnimations = new ArrayList();
        private final Choreographer mChoreographer;
        protected final ArrayList<ValueAnimator> mDelayedAnims;
        private final ArrayList<ValueAnimator> mEndingAnims;
        protected final ArrayList<ValueAnimator> mPendingAnimations;
        private final ArrayList<ValueAnimator> mReadyAnims;
        private final ArrayList<ValueAnimator> mTmpAnimations = new ArrayList();

        private AnimationHandler() {
            this.mPendingAnimations = new ArrayList();
            this.mDelayedAnims = new ArrayList();
            this.mEndingAnims = new ArrayList();
            this.mReadyAnims = new ArrayList();
            this.mChoreographer = Choreographer.getInstance();
        }

        /*
         * Enabled aggressive block sorting
         */
        private void doAnimationFrame(long l) {
            block0: while (true) {
                if (this.mPendingAnimations.size() <= 0) {
                    int n = this.mDelayedAnims.size();
                    for (int i = 0; i < n; ++i) {
                        ValueAnimator valueAnimator = this.mDelayedAnims.get(i);
                        if (!valueAnimator.delayedAnimationFrame(l)) continue;
                        this.mReadyAnims.add(valueAnimator);
                    }
                    int n2 = this.mReadyAnims.size();
                    if (n2 > 0) {
                        for (int i = 0; i < n2; ++i) {
                            ValueAnimator valueAnimator = this.mReadyAnims.get(i);
                            valueAnimator.startAnimation(this);
                            ValueAnimator.access$302(valueAnimator, true);
                            this.mDelayedAnims.remove(valueAnimator);
                        }
                        this.mReadyAnims.clear();
                    }
                    int n3 = this.mAnimations.size();
                    for (int i = 0; i < n3; ++i) {
                        this.mTmpAnimations.add(this.mAnimations.get(i));
                    }
                    for (int i = 0; i < n3; ++i) {
                        ValueAnimator valueAnimator = this.mTmpAnimations.get(i);
                        if (!this.mAnimations.contains(valueAnimator) || !valueAnimator.doAnimationFrame(l)) continue;
                        this.mEndingAnims.add(valueAnimator);
                    }
                    this.mTmpAnimations.clear();
                    if (this.mEndingAnims.size() > 0) {
                        for (int i = 0; i < this.mEndingAnims.size(); ++i) {
                            this.mEndingAnims.get(i).endAnimation(this);
                        }
                        this.mEndingAnims.clear();
                    }
                    if (!this.mAnimations.isEmpty() || !this.mDelayedAnims.isEmpty()) {
                        this.scheduleAnimation();
                    }
                    return;
                }
                ArrayList arrayList = (ArrayList)this.mPendingAnimations.clone();
                this.mPendingAnimations.clear();
                int n = arrayList.size();
                int n4 = 0;
                while (true) {
                    if (n4 >= n) continue block0;
                    ValueAnimator valueAnimator = (ValueAnimator)arrayList.get(n4);
                    if (valueAnimator.mStartDelay == 0L) {
                        valueAnimator.startAnimation(this);
                    } else {
                        this.mDelayedAnims.add(valueAnimator);
                    }
                    ++n4;
                }
                break;
            }
        }

        private void scheduleAnimation() {
            if (!this.mAnimationScheduled) {
                this.mChoreographer.postCallback(1, this, null);
                this.mAnimationScheduled = true;
            }
        }

        @Override
        public void run() {
            this.mAnimationScheduled = false;
            this.doAnimationFrame(this.mChoreographer.getFrameTime());
        }

        public void start() {
            this.scheduleAnimation();
        }
    }

    public static interface AnimatorUpdateListener {
        public void onAnimationUpdate(ValueAnimator var1);
    }
}

