/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.SystemProperties;
import android.provider.Settings;
import android.util.Printer;
import android.util.Slog;
import com.android.internal.util.FastPrintWriter;
import java.io.PrintWriter;
import java.io.StringWriter;

public class ApplicationErrorReport
implements Parcelable {
    public static final Parcelable.Creator<ApplicationErrorReport> CREATOR = new Parcelable.Creator<ApplicationErrorReport>(){

        @Override
        public ApplicationErrorReport createFromParcel(Parcel parcel) {
            return new ApplicationErrorReport(parcel);
        }

        public ApplicationErrorReport[] newArray(int n) {
            return new ApplicationErrorReport[n];
        }
    };
    static final String DEFAULT_ERROR_RECEIVER_PROPERTY = "ro.error.receiver.default";
    static final String SYSTEM_APPS_ERROR_RECEIVER_PROPERTY = "ro.error.receiver.system.apps";
    public static final int TYPE_ANR = 2;
    public static final int TYPE_BATTERY = 3;
    public static final int TYPE_CRASH = 1;
    public static final int TYPE_NONE = 0;
    public static final int TYPE_RUNNING_SERVICE = 5;
    public AnrInfo anrInfo;
    public BatteryInfo batteryInfo;
    public CrashInfo crashInfo;
    public String installerPackageName;
    public String packageName;
    public String processName;
    public RunningServiceInfo runningServiceInfo;
    public boolean systemApp;
    public long time;
    public int type;

    public ApplicationErrorReport() {
    }

    ApplicationErrorReport(Parcel parcel) {
        this.readFromParcel(parcel);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ComponentName getErrorReportReceiver(Context context, String string2, int n) {
        if (Settings.Global.getInt(context.getContentResolver(), "send_action_app_error", 0) == 0) {
            return null;
        }
        PackageManager packageManager = context.getPackageManager();
        ComponentName componentName = ApplicationErrorReport.getErrorReportReceiver(packageManager, string2, packageManager.getInstallerPackageName(string2));
        if (componentName != null) return componentName;
        if ((n & 1) == 0) return ApplicationErrorReport.getErrorReportReceiver(packageManager, string2, SystemProperties.get(DEFAULT_ERROR_RECEIVER_PROPERTY));
        componentName = ApplicationErrorReport.getErrorReportReceiver(packageManager, string2, SystemProperties.get(SYSTEM_APPS_ERROR_RECEIVER_PROPERTY));
        if (componentName != null) return componentName;
        return ApplicationErrorReport.getErrorReportReceiver(packageManager, string2, SystemProperties.get(DEFAULT_ERROR_RECEIVER_PROPERTY));
    }

    /*
     * Enabled aggressive block sorting
     */
    static ComponentName getErrorReportReceiver(PackageManager packageManager, String string2, String string3) {
        ResolveInfo resolveInfo;
        block3: {
            block2: {
                if (string3 == null || string3.length() == 0 || string3.equals(string2)) break block2;
                Intent intent = new Intent("android.intent.action.APP_ERROR");
                intent.setPackage(string3);
                resolveInfo = packageManager.resolveActivity(intent, 0);
                if (resolveInfo != null && resolveInfo.activityInfo != null) break block3;
            }
            return null;
        }
        return new ComponentName(string3, resolveInfo.activityInfo.name);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public void dump(Printer printer, String string2) {
        printer.println(string2 + "type: " + this.type);
        printer.println(string2 + "packageName: " + this.packageName);
        printer.println(string2 + "installerPackageName: " + this.installerPackageName);
        printer.println(string2 + "processName: " + this.processName);
        printer.println(string2 + "time: " + this.time);
        printer.println(string2 + "systemApp: " + this.systemApp);
        switch (this.type) {
            default: {
                return;
            }
            case 1: {
                this.crashInfo.dump(printer, string2);
                return;
            }
            case 2: {
                this.anrInfo.dump(printer, string2);
                return;
            }
            case 3: {
                this.batteryInfo.dump(printer, string2);
                return;
            }
            case 5: 
        }
        this.runningServiceInfo.dump(printer, string2);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void readFromParcel(Parcel parcel) {
        int n = 1;
        this.type = parcel.readInt();
        this.packageName = parcel.readString();
        this.installerPackageName = parcel.readString();
        this.processName = parcel.readString();
        this.time = parcel.readLong();
        if (parcel.readInt() != n) {
            n = 0;
        }
        this.systemApp = n;
        switch (this.type) {
            default: {
                return;
            }
            case 1: {
                this.crashInfo = new CrashInfo(parcel);
                this.anrInfo = null;
                this.batteryInfo = null;
                this.runningServiceInfo = null;
                return;
            }
            case 2: {
                this.anrInfo = new AnrInfo(parcel);
                this.crashInfo = null;
                this.batteryInfo = null;
                this.runningServiceInfo = null;
                return;
            }
            case 3: {
                this.batteryInfo = new BatteryInfo(parcel);
                this.anrInfo = null;
                this.crashInfo = null;
                this.runningServiceInfo = null;
                return;
            }
            case 5: 
        }
        this.batteryInfo = null;
        this.anrInfo = null;
        this.crashInfo = null;
        this.runningServiceInfo = new RunningServiceInfo(parcel);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeInt(this.type);
        parcel.writeString(this.packageName);
        parcel.writeString(this.installerPackageName);
        parcel.writeString(this.processName);
        parcel.writeLong(this.time);
        int n2 = this.systemApp ? 1 : 0;
        parcel.writeInt(n2);
        switch (this.type) {
            default: {
                return;
            }
            case 1: {
                this.crashInfo.writeToParcel(parcel, n);
                return;
            }
            case 2: {
                this.anrInfo.writeToParcel(parcel, n);
                return;
            }
            case 3: {
                this.batteryInfo.writeToParcel(parcel, n);
                return;
            }
            case 5: 
        }
        this.runningServiceInfo.writeToParcel(parcel, n);
    }

    public static class AnrInfo {
        public String activity;
        public String cause;
        public String info;

        public AnrInfo() {
        }

        public AnrInfo(Parcel parcel) {
            this.activity = parcel.readString();
            this.cause = parcel.readString();
            this.info = parcel.readString();
        }

        public void dump(Printer printer, String string2) {
            printer.println(string2 + "activity: " + this.activity);
            printer.println(string2 + "cause: " + this.cause);
            printer.println(string2 + "info: " + this.info);
        }

        public void writeToParcel(Parcel parcel, int n) {
            parcel.writeString(this.activity);
            parcel.writeString(this.cause);
            parcel.writeString(this.info);
        }
    }

    public static class BatteryInfo {
        public String checkinDetails;
        public long durationMicros;
        public String usageDetails;
        public int usagePercent;

        public BatteryInfo() {
        }

        public BatteryInfo(Parcel parcel) {
            this.usagePercent = parcel.readInt();
            this.durationMicros = parcel.readLong();
            this.usageDetails = parcel.readString();
            this.checkinDetails = parcel.readString();
        }

        public void dump(Printer printer, String string2) {
            printer.println(string2 + "usagePercent: " + this.usagePercent);
            printer.println(string2 + "durationMicros: " + this.durationMicros);
            printer.println(string2 + "usageDetails: " + this.usageDetails);
            printer.println(string2 + "checkinDetails: " + this.checkinDetails);
        }

        public void writeToParcel(Parcel parcel, int n) {
            parcel.writeInt(this.usagePercent);
            parcel.writeLong(this.durationMicros);
            parcel.writeString(this.usageDetails);
            parcel.writeString(this.checkinDetails);
        }
    }

    public static class CrashInfo {
        public String exceptionClassName;
        public String exceptionMessage;
        public String stackTrace;
        public String throwClassName;
        public String throwFileName;
        public int throwLineNumber;
        public String throwMethodName;

        public CrashInfo() {
        }

        public CrashInfo(Parcel parcel) {
            this.exceptionClassName = parcel.readString();
            this.exceptionMessage = parcel.readString();
            this.throwFileName = parcel.readString();
            this.throwClassName = parcel.readString();
            this.throwMethodName = parcel.readString();
            this.throwLineNumber = parcel.readInt();
            this.stackTrace = parcel.readString();
        }

        public CrashInfo(Throwable throwable) {
            StringWriter stringWriter = new StringWriter();
            FastPrintWriter fastPrintWriter = new FastPrintWriter(stringWriter, false, 256);
            throwable.printStackTrace(fastPrintWriter);
            ((PrintWriter)fastPrintWriter).flush();
            this.stackTrace = stringWriter.toString();
            this.exceptionMessage = throwable.getMessage();
            Throwable throwable2 = throwable;
            while (throwable.getCause() != null) {
                String string2;
                if ((throwable = throwable.getCause()).getStackTrace() != null && throwable.getStackTrace().length > 0) {
                    throwable2 = throwable;
                }
                if ((string2 = throwable.getMessage()) == null || string2.length() <= 0) continue;
                this.exceptionMessage = string2;
            }
            this.exceptionClassName = throwable2.getClass().getName();
            if (throwable2.getStackTrace().length > 0) {
                StackTraceElement stackTraceElement = throwable2.getStackTrace()[0];
                this.throwFileName = stackTraceElement.getFileName();
                this.throwClassName = stackTraceElement.getClassName();
                this.throwMethodName = stackTraceElement.getMethodName();
                this.throwLineNumber = stackTraceElement.getLineNumber();
                return;
            }
            this.throwFileName = "unknown";
            this.throwClassName = "unknown";
            this.throwMethodName = "unknown";
            this.throwLineNumber = 0;
        }

        public void dump(Printer printer, String string2) {
            printer.println(string2 + "exceptionClassName: " + this.exceptionClassName);
            printer.println(string2 + "exceptionMessage: " + this.exceptionMessage);
            printer.println(string2 + "throwFileName: " + this.throwFileName);
            printer.println(string2 + "throwClassName: " + this.throwClassName);
            printer.println(string2 + "throwMethodName: " + this.throwMethodName);
            printer.println(string2 + "throwLineNumber: " + this.throwLineNumber);
            printer.println(string2 + "stackTrace: " + this.stackTrace);
        }

        public void writeToParcel(Parcel parcel, int n) {
            int n2 = parcel.dataPosition();
            parcel.writeString(this.exceptionClassName);
            parcel.writeString(this.exceptionMessage);
            parcel.writeString(this.throwFileName);
            parcel.writeString(this.throwClassName);
            parcel.writeString(this.throwMethodName);
            parcel.writeInt(this.throwLineNumber);
            parcel.writeString(this.stackTrace);
            if (parcel.dataPosition() - n2 > 20480) {
                Slog.d("Error", "ERR: exClass=" + this.exceptionClassName);
                Slog.d("Error", "ERR: exMsg=" + this.exceptionMessage);
                Slog.d("Error", "ERR: file=" + this.throwFileName);
                Slog.d("Error", "ERR: class=" + this.throwClassName);
                Slog.d("Error", "ERR: method=" + this.throwMethodName + " line=" + this.throwLineNumber);
                Slog.d("Error", "ERR: stack=" + this.stackTrace);
                Slog.d("Error", "ERR: TOTAL BYTES WRITTEN: " + (parcel.dataPosition() - n2));
            }
        }
    }

    public static class RunningServiceInfo {
        public long durationMillis;
        public String serviceDetails;

        public RunningServiceInfo() {
        }

        public RunningServiceInfo(Parcel parcel) {
            this.durationMillis = parcel.readLong();
            this.serviceDetails = parcel.readString();
        }

        public void dump(Printer printer, String string2) {
            printer.println(string2 + "durationMillis: " + this.durationMillis);
            printer.println(string2 + "serviceDetails: " + this.serviceDetails);
        }

        public void writeToParcel(Parcel parcel, int n) {
            parcel.writeLong(this.durationMillis);
            parcel.writeString(this.serviceDetails);
        }
    }
}

