/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.animation.Animator;
import android.animation.AnimatorInflater;
import android.animation.AnimatorListenerAdapter;
import android.app.Activity;
import android.app.BackStackRecord;
import android.app.BackStackState;
import android.app.Fragment;
import android.app.FragmentContainer;
import android.app.FragmentManager;
import android.app.FragmentManagerState;
import android.app.FragmentState;
import android.app.FragmentTransaction;
import android.content.Context;
import android.content.res.Configuration;
import android.content.res.TypedArray;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.util.DebugUtils;
import android.util.Log;
import android.util.LogWriter;
import android.util.SparseArray;
import android.util.SuperNotCalledException;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import com.android.internal.R;
import com.android.internal.util.FastPrintWriter;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;

final class FragmentManagerImpl
extends FragmentManager
implements LayoutInflater.Factory2 {
    static boolean DEBUG = false;
    static final String TAG = "FragmentManager";
    static final String TARGET_REQUEST_CODE_STATE_TAG = "android:target_req_state";
    static final String TARGET_STATE_TAG = "android:target_state";
    static final String USER_VISIBLE_HINT_TAG = "android:user_visible_hint";
    static final String VIEW_STATE_TAG = "android:view_state";
    ArrayList<Fragment> mActive;
    Activity mActivity;
    ArrayList<Fragment> mAdded;
    ArrayList<Integer> mAvailBackStackIndices;
    ArrayList<Integer> mAvailIndices;
    ArrayList<BackStackRecord> mBackStack;
    ArrayList<FragmentManager.OnBackStackChangedListener> mBackStackChangeListeners;
    ArrayList<BackStackRecord> mBackStackIndices;
    FragmentContainer mContainer;
    ArrayList<Fragment> mCreatedMenus;
    int mCurState = 0;
    boolean mDestroyed;
    Runnable mExecCommit = new Runnable(){

        @Override
        public void run() {
            FragmentManagerImpl.this.execPendingActions();
        }
    };
    boolean mExecutingActions;
    boolean mHavePendingDeferredStart;
    boolean mNeedMenuInvalidate;
    String mNoTransactionsBecause;
    Fragment mParent;
    ArrayList<Runnable> mPendingActions;
    SparseArray<Parcelable> mStateArray = null;
    Bundle mStateBundle = null;
    boolean mStateSaved;
    Runnable[] mTmpActions;

    static {
        DEBUG = false;
    }

    FragmentManagerImpl() {
    }

    private void checkStateLoss() {
        if (this.mStateSaved) {
            throw new IllegalStateException("Can not perform this action after onSaveInstanceState");
        }
        if (this.mNoTransactionsBecause != null) {
            throw new IllegalStateException("Can not perform this action inside of " + this.mNoTransactionsBecause);
        }
    }

    public static int reverseTransit(int n) {
        switch (n) {
            default: {
                return 0;
            }
            case 4097: {
                return 8194;
            }
            case 8194: {
                return 4097;
            }
            case 4099: 
        }
        return 4099;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void throwException(RuntimeException runtimeException) {
        Log.e(TAG, runtimeException.getMessage());
        FastPrintWriter fastPrintWriter = new FastPrintWriter(new LogWriter(6, TAG), false, 1024);
        if (this.mActivity != null) {
            Log.e(TAG, "Activity state:");
            try {
                this.mActivity.dump("  ", null, fastPrintWriter, new String[0]);
            }
            catch (Exception exception) {
                ((PrintWriter)fastPrintWriter).flush();
                Log.e(TAG, "Failed dumping state", exception);
            }
        } else {
            Log.e(TAG, "Fragment manager state:");
            try {
                this.dump("  ", null, fastPrintWriter, new String[0]);
            }
            catch (Exception exception) {
                ((PrintWriter)fastPrintWriter).flush();
                Log.e(TAG, "Failed dumping state", exception);
            }
        }
        ((PrintWriter)fastPrintWriter).flush();
        throw runtimeException;
    }

    public static int transitToStyleIndex(int n, boolean bl) {
        switch (n) {
            default: {
                return -1;
            }
            case 4097: {
                if (bl) {
                    return 0;
                }
                return 1;
            }
            case 8194: {
                if (bl) {
                    return 2;
                }
                return 3;
            }
            case 4099: 
        }
        if (bl) {
            return 4;
        }
        return 5;
    }

    void addBackStackState(BackStackRecord backStackRecord) {
        if (this.mBackStack == null) {
            this.mBackStack = new ArrayList();
        }
        this.mBackStack.add(backStackRecord);
        this.reportBackStackChanged();
    }

    public void addFragment(Fragment fragment, boolean bl) {
        if (this.mAdded == null) {
            this.mAdded = new ArrayList();
        }
        if (DEBUG) {
            Log.v(TAG, "add: " + fragment);
        }
        this.makeActive(fragment);
        if (!fragment.mDetached) {
            if (this.mAdded.contains(fragment)) {
                throw new IllegalStateException("Fragment already added: " + fragment);
            }
            this.mAdded.add(fragment);
            fragment.mAdded = true;
            fragment.mRemoving = false;
            if (fragment.mHasMenu && fragment.mMenuVisible) {
                this.mNeedMenuInvalidate = true;
            }
            if (bl) {
                this.moveToState(fragment);
            }
        }
    }

    @Override
    public void addOnBackStackChangedListener(FragmentManager.OnBackStackChangedListener onBackStackChangedListener) {
        if (this.mBackStackChangeListeners == null) {
            this.mBackStackChangeListeners = new ArrayList();
        }
        this.mBackStackChangeListeners.add(onBackStackChangedListener);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int allocBackStackIndex(BackStackRecord backStackRecord) {
        synchronized (this) {
            if (this.mAvailBackStackIndices == null || this.mAvailBackStackIndices.size() <= 0) {
                if (this.mBackStackIndices == null) {
                    this.mBackStackIndices = new ArrayList();
                }
                int n = this.mBackStackIndices.size();
                if (DEBUG) {
                    Log.v(TAG, "Setting back stack index " + n + " to " + backStackRecord);
                }
                this.mBackStackIndices.add(backStackRecord);
                return n;
            }
            int n = this.mAvailBackStackIndices.remove(-1 + this.mAvailBackStackIndices.size());
            if (DEBUG) {
                Log.v(TAG, "Adding back stack index " + n + " with " + backStackRecord);
            }
            this.mBackStackIndices.set(n, backStackRecord);
            return n;
        }
    }

    public void attachActivity(Activity activity, FragmentContainer fragmentContainer, Fragment fragment) {
        if (this.mActivity != null) {
            throw new IllegalStateException("Already attached");
        }
        this.mActivity = activity;
        this.mContainer = fragmentContainer;
        this.mParent = fragment;
    }

    public void attachFragment(Fragment fragment, int n, int n2) {
        if (DEBUG) {
            Log.v(TAG, "attach: " + fragment);
        }
        if (fragment.mDetached) {
            fragment.mDetached = false;
            if (!fragment.mAdded) {
                if (this.mAdded == null) {
                    this.mAdded = new ArrayList();
                }
                if (this.mAdded.contains(fragment)) {
                    throw new IllegalStateException("Fragment already added: " + fragment);
                }
                if (DEBUG) {
                    Log.v(TAG, "add from attach: " + fragment);
                }
                this.mAdded.add(fragment);
                fragment.mAdded = true;
                if (fragment.mHasMenu && fragment.mMenuVisible) {
                    this.mNeedMenuInvalidate = true;
                }
                this.moveToState(fragment, this.mCurState, n, n2, false);
            }
        }
    }

    @Override
    public FragmentTransaction beginTransaction() {
        return new BackStackRecord(this);
    }

    public void detachFragment(Fragment fragment, int n, int n2) {
        if (DEBUG) {
            Log.v(TAG, "detach: " + fragment);
        }
        if (!fragment.mDetached) {
            fragment.mDetached = true;
            if (fragment.mAdded) {
                if (this.mAdded != null) {
                    if (DEBUG) {
                        Log.v(TAG, "remove from detach: " + fragment);
                    }
                    this.mAdded.remove(fragment);
                }
                if (fragment.mHasMenu && fragment.mMenuVisible) {
                    this.mNeedMenuInvalidate = true;
                }
                fragment.mAdded = false;
                this.moveToState(fragment, 1, n, n2, false);
            }
        }
    }

    public void dispatchActivityCreated() {
        this.mStateSaved = false;
        this.moveToState(2, false);
    }

    public void dispatchConfigurationChanged(Configuration configuration) {
        if (this.mAdded != null) {
            for (int i = 0; i < this.mAdded.size(); ++i) {
                Fragment fragment = this.mAdded.get(i);
                if (fragment == null) continue;
                fragment.performConfigurationChanged(configuration);
            }
        }
    }

    public boolean dispatchContextItemSelected(MenuItem menuItem) {
        if (this.mAdded != null) {
            for (int i = 0; i < this.mAdded.size(); ++i) {
                Fragment fragment = this.mAdded.get(i);
                if (fragment == null || !fragment.performContextItemSelected(menuItem)) continue;
                return true;
            }
        }
        return false;
    }

    public void dispatchCreate() {
        this.mStateSaved = false;
        this.moveToState(1, false);
    }

    public boolean dispatchCreateOptionsMenu(Menu menu2, MenuInflater menuInflater) {
        ArrayList<Fragment> arrayList = this.mAdded;
        ArrayList<Fragment> arrayList2 = null;
        boolean bl = false;
        if (arrayList != null) {
            for (int i = 0; i < this.mAdded.size(); ++i) {
                Fragment fragment = this.mAdded.get(i);
                if (fragment == null || !fragment.performCreateOptionsMenu(menu2, menuInflater)) continue;
                bl = true;
                if (arrayList2 == null) {
                    arrayList2 = new ArrayList<Fragment>();
                }
                arrayList2.add(fragment);
            }
        }
        if (this.mCreatedMenus != null) {
            for (int i = 0; i < this.mCreatedMenus.size(); ++i) {
                Fragment fragment = this.mCreatedMenus.get(i);
                if (arrayList2 != null && arrayList2.contains(fragment)) continue;
                fragment.onDestroyOptionsMenu();
            }
        }
        this.mCreatedMenus = arrayList2;
        return bl;
    }

    public void dispatchDestroy() {
        this.mDestroyed = true;
        this.execPendingActions();
        this.moveToState(0, false);
        this.mActivity = null;
        this.mContainer = null;
        this.mParent = null;
    }

    public void dispatchDestroyView() {
        this.moveToState(1, false);
    }

    public void dispatchLowMemory() {
        if (this.mAdded != null) {
            for (int i = 0; i < this.mAdded.size(); ++i) {
                Fragment fragment = this.mAdded.get(i);
                if (fragment == null) continue;
                fragment.performLowMemory();
            }
        }
    }

    public boolean dispatchOptionsItemSelected(MenuItem menuItem) {
        if (this.mAdded != null) {
            for (int i = 0; i < this.mAdded.size(); ++i) {
                Fragment fragment = this.mAdded.get(i);
                if (fragment == null || !fragment.performOptionsItemSelected(menuItem)) continue;
                return true;
            }
        }
        return false;
    }

    public void dispatchOptionsMenuClosed(Menu menu2) {
        if (this.mAdded != null) {
            for (int i = 0; i < this.mAdded.size(); ++i) {
                Fragment fragment = this.mAdded.get(i);
                if (fragment == null) continue;
                fragment.performOptionsMenuClosed(menu2);
            }
        }
    }

    public void dispatchPause() {
        this.moveToState(4, false);
    }

    public boolean dispatchPrepareOptionsMenu(Menu menu2) {
        ArrayList<Fragment> arrayList = this.mAdded;
        boolean bl = false;
        if (arrayList != null) {
            for (int i = 0; i < this.mAdded.size(); ++i) {
                Fragment fragment = this.mAdded.get(i);
                if (fragment == null || !fragment.performPrepareOptionsMenu(menu2)) continue;
                bl = true;
            }
        }
        return bl;
    }

    public void dispatchResume() {
        this.mStateSaved = false;
        this.moveToState(5, false);
    }

    public void dispatchStart() {
        this.mStateSaved = false;
        this.moveToState(4, false);
    }

    public void dispatchStop() {
        this.moveToState(3, false);
    }

    public void dispatchTrimMemory(int n) {
        if (this.mAdded != null) {
            for (int i = 0; i < this.mAdded.size(); ++i) {
                Fragment fragment = this.mAdded.get(i);
                if (fragment == null) continue;
                fragment.performTrimMemory(n);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void dump(String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        String string3 = string2 + "    ";
        if (this.mActive != null && (n6 = this.mActive.size()) > 0) {
            printWriter.print(string2);
            printWriter.print("Active Fragments in ");
            printWriter.print(Integer.toHexString(System.identityHashCode(this)));
            printWriter.println(":");
            for (int i = 0; i < n6; ++i) {
                Fragment fragment = this.mActive.get(i);
                printWriter.print(string2);
                printWriter.print("  #");
                printWriter.print(i);
                printWriter.print(": ");
                printWriter.println(fragment);
                if (fragment == null) continue;
                fragment.dump(string3, fileDescriptor, printWriter, stringArray);
            }
        }
        if (this.mAdded != null && (n5 = this.mAdded.size()) > 0) {
            printWriter.print(string2);
            printWriter.println("Added Fragments:");
            for (int i = 0; i < n5; ++i) {
                Fragment fragment = this.mAdded.get(i);
                printWriter.print(string2);
                printWriter.print("  #");
                printWriter.print(i);
                printWriter.print(": ");
                printWriter.println(fragment.toString());
            }
        }
        if (this.mCreatedMenus != null && (n4 = this.mCreatedMenus.size()) > 0) {
            printWriter.print(string2);
            printWriter.println("Fragments Created Menus:");
            for (int i = 0; i < n4; ++i) {
                Fragment fragment = this.mCreatedMenus.get(i);
                printWriter.print(string2);
                printWriter.print("  #");
                printWriter.print(i);
                printWriter.print(": ");
                printWriter.println(fragment.toString());
            }
        }
        if (this.mBackStack != null && (n3 = this.mBackStack.size()) > 0) {
            printWriter.print(string2);
            printWriter.println("Back Stack:");
            for (int i = 0; i < n3; ++i) {
                BackStackRecord backStackRecord = this.mBackStack.get(i);
                printWriter.print(string2);
                printWriter.print("  #");
                printWriter.print(i);
                printWriter.print(": ");
                printWriter.println(backStackRecord.toString());
                backStackRecord.dump(string3, fileDescriptor, printWriter, stringArray);
            }
        }
        // MONITORENTER : this
        if (this.mBackStackIndices != null && (n2 = this.mBackStackIndices.size()) > 0) {
            printWriter.print(string2);
            printWriter.println("Back Stack Indices:");
            for (int i = 0; i < n2; ++i) {
                BackStackRecord backStackRecord = this.mBackStackIndices.get(i);
                printWriter.print(string2);
                printWriter.print("  #");
                printWriter.print(i);
                printWriter.print(": ");
                printWriter.println(backStackRecord);
            }
        }
        if (this.mAvailBackStackIndices != null && this.mAvailBackStackIndices.size() > 0) {
            printWriter.print(string2);
            printWriter.print("mAvailBackStackIndices: ");
            printWriter.println(Arrays.toString(this.mAvailBackStackIndices.toArray()));
        }
        // MONITOREXIT : this
        if (this.mPendingActions != null && (n = this.mPendingActions.size()) > 0) {
            printWriter.print(string2);
            printWriter.println("Pending Actions:");
            for (int i = 0; i < n; ++i) {
                Runnable runnable = this.mPendingActions.get(i);
                printWriter.print(string2);
                printWriter.print("  #");
                printWriter.print(i);
                printWriter.print(": ");
                printWriter.println(runnable);
            }
        }
        printWriter.print(string2);
        printWriter.println("FragmentManager misc state:");
        printWriter.print(string2);
        printWriter.print("  mActivity=");
        printWriter.println(this.mActivity);
        printWriter.print(string2);
        printWriter.print("  mContainer=");
        printWriter.println(this.mContainer);
        if (this.mParent != null) {
            printWriter.print(string2);
            printWriter.print("  mParent=");
            printWriter.println(this.mParent);
        }
        printWriter.print(string2);
        printWriter.print("  mCurState=");
        printWriter.print(this.mCurState);
        printWriter.print(" mStateSaved=");
        printWriter.print(this.mStateSaved);
        printWriter.print(" mDestroyed=");
        printWriter.println(this.mDestroyed);
        if (this.mNeedMenuInvalidate) {
            printWriter.print(string2);
            printWriter.print("  mNeedMenuInvalidate=");
            printWriter.println(this.mNeedMenuInvalidate);
        }
        if (this.mNoTransactionsBecause != null) {
            printWriter.print(string2);
            printWriter.print("  mNoTransactionsBecause=");
            printWriter.println(this.mNoTransactionsBecause);
        }
        if (this.mAvailIndices == null) return;
        if (this.mAvailIndices.size() <= 0) return;
        printWriter.print(string2);
        printWriter.print("  mAvailIndices: ");
        printWriter.println(Arrays.toString(this.mAvailIndices.toArray()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void enqueueAction(Runnable runnable, boolean bl) {
        if (!bl) {
            this.checkStateLoss();
        }
        synchronized (this) {
            if (this.mDestroyed || this.mActivity == null) {
                throw new IllegalStateException("Activity has been destroyed");
            }
            if (this.mPendingActions == null) {
                this.mPendingActions = new ArrayList();
            }
            this.mPendingActions.add(runnable);
            if (this.mPendingActions.size() == 1) {
                this.mActivity.mHandler.removeCallbacks(this.mExecCommit);
                this.mActivity.mHandler.post(this.mExecCommit);
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean execPendingActions() {
        boolean bl;
        block12: {
            boolean bl2;
            if (this.mExecutingActions) {
                throw new IllegalStateException("Recursive entry to executePendingTransactions");
            }
            if (Looper.myLooper() != this.mActivity.mHandler.getLooper()) {
                throw new IllegalStateException("Must be called from main thread of process");
            }
            bl = false;
            while (true) {
                int n;
                synchronized (this) {
                    if (this.mPendingActions == null || this.mPendingActions.size() == 0) {
                        // MONITOREXIT @DISABLED, blocks:[3, 4, 11] lbl9 : MonitorExitStatement: MONITOREXIT : this
                        if (!this.mHavePendingDeferredStart) break block12;
                        bl2 = false;
                        for (int i = 0; i < this.mActive.size(); ++i) {
                            Fragment fragment = this.mActive.get(i);
                            if (fragment == null || fragment.mLoaderManager == null) continue;
                            bl2 |= fragment.mLoaderManager.hasRunningLoaders();
                        }
                        break;
                    }
                    n = this.mPendingActions.size();
                    if (this.mTmpActions == null || this.mTmpActions.length < n) {
                        this.mTmpActions = new Runnable[n];
                    }
                    this.mPendingActions.toArray(this.mTmpActions);
                    this.mPendingActions.clear();
                    this.mActivity.mHandler.removeCallbacks(this.mExecCommit);
                }
                this.mExecutingActions = true;
                for (int i = 0; i < n; ++i) {
                    this.mTmpActions[i].run();
                    this.mTmpActions[i] = null;
                }
                this.mExecutingActions = false;
                bl = true;
            }
            if (!bl2) {
                this.mHavePendingDeferredStart = false;
                this.startPendingDeferredFragments();
            }
        }
        return bl;
    }

    @Override
    public boolean executePendingTransactions() {
        return this.execPendingActions();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public Fragment findFragmentById(int n) {
        Fragment fragment;
        if (this.mAdded != null) {
            for (int i = -1 + this.mAdded.size(); i >= 0; --i) {
                fragment = this.mAdded.get(i);
                if (fragment != null && fragment.mFragmentId == n) return fragment;
            }
        }
        if (this.mActive == null) return null;
        for (int i = -1 + this.mActive.size(); i >= 0; --i) {
            fragment = this.mActive.get(i);
            if (fragment == null || fragment.mFragmentId != n) continue;
            return fragment;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public Fragment findFragmentByTag(String string2) {
        Fragment fragment;
        if (this.mAdded != null && string2 != null) {
            for (int i = -1 + this.mAdded.size(); i >= 0; --i) {
                fragment = this.mAdded.get(i);
                if (fragment != null && string2.equals(fragment.mTag)) return fragment;
            }
        }
        if (this.mActive == null || string2 == null) return null;
        for (int i = -1 + this.mActive.size(); i >= 0; --i) {
            fragment = this.mActive.get(i);
            if (fragment == null || !string2.equals(fragment.mTag)) continue;
            return fragment;
        }
        return null;
    }

    public Fragment findFragmentByWho(String string2) {
        if (this.mActive != null && string2 != null) {
            for (int i = -1 + this.mActive.size(); i >= 0; --i) {
                Fragment fragment;
                Fragment fragment2 = this.mActive.get(i);
                if (fragment2 == null || (fragment = fragment2.findFragmentByWho(string2)) == null) continue;
                return fragment;
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void freeBackStackIndex(int n) {
        synchronized (this) {
            this.mBackStackIndices.set(n, null);
            if (this.mAvailBackStackIndices == null) {
                this.mAvailBackStackIndices = new ArrayList();
            }
            if (DEBUG) {
                Log.v(TAG, "Freeing back stack index " + n);
            }
            this.mAvailBackStackIndices.add(n);
            return;
        }
    }

    @Override
    public FragmentManager.BackStackEntry getBackStackEntryAt(int n) {
        return this.mBackStack.get(n);
    }

    @Override
    public int getBackStackEntryCount() {
        if (this.mBackStack != null) {
            return this.mBackStack.size();
        }
        return 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Fragment getFragment(Bundle bundle, String string2) {
        Fragment fragment;
        int n = bundle.getInt(string2, -1);
        if (n == -1) {
            return null;
        }
        if (n >= this.mActive.size()) {
            this.throwException(new IllegalStateException("Fragment no longer exists for key " + string2 + ": index " + n));
        }
        if ((fragment = this.mActive.get(n)) != null) return fragment;
        this.throwException(new IllegalStateException("Fragment no longer exists for key " + string2 + ": index " + n));
        return fragment;
    }

    LayoutInflater.Factory2 getLayoutInflaterFactory() {
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void hideFragment(final Fragment fragment, int n, int n2) {
        if (DEBUG) {
            Log.v(TAG, "hide: " + fragment);
        }
        if (!fragment.mHidden) {
            fragment.mHidden = true;
            if (fragment.mView != null) {
                Animator animator2 = this.loadAnimator(fragment, n, false, n2);
                if (animator2 != null) {
                    animator2.setTarget(fragment.mView);
                    animator2.addListener(new AnimatorListenerAdapter(){

                        @Override
                        public void onAnimationEnd(Animator animator2) {
                            if (fragment.mView != null) {
                                fragment.mView.setVisibility(8);
                            }
                        }
                    });
                    animator2.start();
                } else {
                    fragment.mView.setVisibility(8);
                }
            }
            if (fragment.mAdded && fragment.mHasMenu && fragment.mMenuVisible) {
                this.mNeedMenuInvalidate = true;
            }
            fragment.onHiddenChanged(true);
        }
    }

    @Override
    public void invalidateOptionsMenu() {
        if (this.mActivity != null && this.mCurState == 5) {
            this.mActivity.invalidateOptionsMenu();
            return;
        }
        this.mNeedMenuInvalidate = true;
    }

    @Override
    public boolean isDestroyed() {
        return this.mDestroyed;
    }

    Animator loadAnimator(Fragment fragment, int n, boolean bl, int n2) {
        Animator animator2;
        Animator animator3 = fragment.onCreateAnimator(n, bl, fragment.mNextAnim);
        if (animator3 != null) {
            return animator3;
        }
        if (fragment.mNextAnim != 0 && (animator2 = AnimatorInflater.loadAnimator(this.mActivity, fragment.mNextAnim)) != null) {
            return animator2;
        }
        if (n == 0) {
            return null;
        }
        int n3 = FragmentManagerImpl.transitToStyleIndex(n, bl);
        if (n3 < 0) {
            return null;
        }
        if (n2 == 0 && this.mActivity.getWindow() != null) {
            n2 = this.mActivity.getWindow().getAttributes().windowAnimations;
        }
        if (n2 == 0) {
            return null;
        }
        TypedArray typedArray = this.mActivity.obtainStyledAttributes(n2, R.styleable.FragmentAnimation);
        int n4 = typedArray.getResourceId(n3, 0);
        typedArray.recycle();
        if (n4 == 0) {
            return null;
        }
        return AnimatorInflater.loadAnimator(this.mActivity, n4);
    }

    /*
     * Enabled aggressive block sorting
     */
    void makeActive(Fragment fragment) {
        block7: {
            block6: {
                if (fragment.mIndex >= 0) break block6;
                if (this.mAvailIndices == null || this.mAvailIndices.size() <= 0) {
                    if (this.mActive == null) {
                        this.mActive = new ArrayList();
                    }
                    fragment.setIndex(this.mActive.size(), this.mParent);
                    this.mActive.add(fragment);
                } else {
                    fragment.setIndex(this.mAvailIndices.remove(-1 + this.mAvailIndices.size()), this.mParent);
                    this.mActive.set(fragment.mIndex, fragment);
                }
                if (DEBUG) break block7;
            }
            return;
        }
        Log.v(TAG, "Allocated fragment index " + fragment);
    }

    void makeInactive(Fragment fragment) {
        if (fragment.mIndex < 0) {
            return;
        }
        if (DEBUG) {
            Log.v(TAG, "Freeing fragment index " + fragment);
        }
        this.mActive.set(fragment.mIndex, null);
        if (this.mAvailIndices == null) {
            this.mAvailIndices = new ArrayList();
        }
        this.mAvailIndices.add(fragment.mIndex);
        this.mActivity.invalidateFragment(fragment.mWho);
        fragment.initState();
    }

    /*
     * Enabled aggressive block sorting
     */
    void moveToState(int n, int n2, int n3, boolean bl) {
        block7: {
            block6: {
                if (this.mActivity == null && n != 0) {
                    throw new IllegalStateException("No activity");
                }
                if (!bl && this.mCurState == n) break block6;
                this.mCurState = n;
                if (this.mActive == null) break block6;
                boolean bl2 = false;
                for (int i = 0; i < this.mActive.size(); ++i) {
                    Fragment fragment = this.mActive.get(i);
                    if (fragment == null) continue;
                    this.moveToState(fragment, n, n2, n3, false);
                    if (fragment.mLoaderManager == null) continue;
                    bl2 |= fragment.mLoaderManager.hasRunningLoaders();
                }
                if (!bl2) {
                    this.startPendingDeferredFragments();
                }
                if (this.mNeedMenuInvalidate && this.mActivity != null && this.mCurState == 5) break block7;
            }
            return;
        }
        this.mActivity.invalidateOptionsMenu();
        this.mNeedMenuInvalidate = false;
    }

    void moveToState(int n, boolean bl) {
        this.moveToState(n, 0, 0, bl);
    }

    void moveToState(Fragment fragment) {
        this.moveToState(fragment, this.mCurState, 0, 0, false);
    }

    /*
     * Enabled aggressive block sorting
     */
    void moveToState(final Fragment fragment, int n, int n2, int n3, boolean bl) {
        block60: {
            block59: {
                if (DEBUG) {
                    // empty if block
                }
                if ((!fragment.mAdded || fragment.mDetached) && n > 1) {
                    n = 1;
                }
                if (fragment.mRemoving && n > fragment.mState) {
                    n = fragment.mState;
                }
                if (fragment.mDeferStart && fragment.mState < 4 && n > 3) {
                    n = 3;
                }
                if (fragment.mState >= n) break block59;
                if (fragment.mFromLayout && !fragment.mInLayout) {
                    return;
                }
                if (fragment.mAnimatingAway != null) {
                    fragment.mAnimatingAway = null;
                    this.moveToState(fragment, fragment.mStateAfterAnimating, 0, 0, true);
                }
                switch (fragment.mState) {
                    default: {
                        break block60;
                    }
                    case 0: {
                        if (DEBUG) {
                            Log.v(TAG, "moveto CREATED: " + fragment);
                        }
                        if (fragment.mSavedFragmentState != null) {
                            fragment.mSavedViewState = fragment.mSavedFragmentState.getSparseParcelableArray(VIEW_STATE_TAG);
                            fragment.mTarget = this.getFragment(fragment.mSavedFragmentState, TARGET_STATE_TAG);
                            if (fragment.mTarget != null) {
                                fragment.mTargetRequestCode = fragment.mSavedFragmentState.getInt(TARGET_REQUEST_CODE_STATE_TAG, 0);
                            }
                            fragment.mUserVisibleHint = fragment.mSavedFragmentState.getBoolean(USER_VISIBLE_HINT_TAG, true);
                            if (!fragment.mUserVisibleHint) {
                                fragment.mDeferStart = true;
                                if (n > 3) {
                                    n = 3;
                                }
                            }
                        }
                        fragment.mActivity = this.mActivity;
                        fragment.mParentFragment = this.mParent;
                        FragmentManagerImpl fragmentManagerImpl = this.mParent != null ? this.mParent.mChildFragmentManager : this.mActivity.mFragments;
                        fragment.mFragmentManager = fragmentManagerImpl;
                        fragment.mCalled = false;
                        fragment.onAttach(this.mActivity);
                        if (!fragment.mCalled) {
                            throw new SuperNotCalledException("Fragment " + fragment + " did not call through to super.onAttach()");
                        }
                        if (fragment.mParentFragment == null) {
                            this.mActivity.onAttachFragment(fragment);
                        }
                        if (!fragment.mRetaining) {
                            fragment.performCreate(fragment.mSavedFragmentState);
                        }
                        fragment.mRetaining = false;
                        if (fragment.mFromLayout) {
                            fragment.mView = fragment.performCreateView(fragment.getLayoutInflater(fragment.mSavedFragmentState), null, fragment.mSavedFragmentState);
                            if (fragment.mView != null) {
                                fragment.mView.setSaveFromParentEnabled(false);
                                if (fragment.mHidden) {
                                    fragment.mView.setVisibility(8);
                                }
                                fragment.onViewCreated(fragment.mView, fragment.mSavedFragmentState);
                            }
                        }
                    }
                    case 1: {
                        if (n > 1) {
                            if (DEBUG) {
                                Log.v(TAG, "moveto ACTIVITY_CREATED: " + fragment);
                            }
                            if (!fragment.mFromLayout) {
                                int n4 = fragment.mContainerId;
                                ViewGroup viewGroup = null;
                                if (n4 != 0 && (viewGroup = (ViewGroup)this.mContainer.findViewById(fragment.mContainerId)) == null && !fragment.mRestored) {
                                    this.throwException(new IllegalArgumentException("No view found for id 0x" + Integer.toHexString(fragment.mContainerId) + " (" + fragment.getResources().getResourceName(fragment.mContainerId) + ") for fragment " + fragment));
                                }
                                fragment.mContainer = viewGroup;
                                fragment.mView = fragment.performCreateView(fragment.getLayoutInflater(fragment.mSavedFragmentState), viewGroup, fragment.mSavedFragmentState);
                                if (fragment.mView != null) {
                                    fragment.mView.setSaveFromParentEnabled(false);
                                    if (viewGroup != null) {
                                        Animator animator2 = this.loadAnimator(fragment, n2, true, n3);
                                        if (animator2 != null) {
                                            animator2.setTarget(fragment.mView);
                                            animator2.start();
                                        }
                                        viewGroup.addView(fragment.mView);
                                    }
                                    if (fragment.mHidden) {
                                        fragment.mView.setVisibility(8);
                                    }
                                    fragment.onViewCreated(fragment.mView, fragment.mSavedFragmentState);
                                }
                            }
                            fragment.performActivityCreated(fragment.mSavedFragmentState);
                            if (fragment.mView != null) {
                                fragment.restoreViewState(fragment.mSavedFragmentState);
                            }
                            fragment.mSavedFragmentState = null;
                        }
                    }
                    case 2: 
                    case 3: {
                        if (n <= 3) break;
                        if (DEBUG) {
                            Log.v(TAG, "moveto STARTED: " + fragment);
                        }
                        fragment.performStart();
                        break;
                    }
                    case 4: 
                }
                if (n > 4) {
                    if (DEBUG) {
                        Log.v(TAG, "moveto RESUMED: " + fragment);
                    }
                    fragment.mResumed = true;
                    fragment.performResume();
                    fragment.mSavedFragmentState = null;
                    fragment.mSavedViewState = null;
                }
                break block60;
            }
            if (fragment.mState > n) {
                switch (fragment.mState) {
                    default: {
                        break;
                    }
                    case 5: {
                        if (n < 5) {
                            if (DEBUG) {
                                Log.v(TAG, "movefrom RESUMED: " + fragment);
                            }
                            fragment.performPause();
                            fragment.mResumed = false;
                        }
                    }
                    case 4: {
                        if (n < 4) {
                            if (DEBUG) {
                                Log.v(TAG, "movefrom STARTED: " + fragment);
                            }
                            fragment.performStop();
                        }
                    }
                    case 2: 
                    case 3: {
                        if (n < 2) {
                            if (DEBUG) {
                                Log.v(TAG, "movefrom ACTIVITY_CREATED: " + fragment);
                            }
                            if (fragment.mView != null && !this.mActivity.isFinishing() && fragment.mSavedViewState == null) {
                                this.saveFragmentViewState(fragment);
                            }
                            fragment.performDestroyView();
                            if (fragment.mView != null && fragment.mContainer != null) {
                                int n5 = this.mCurState;
                                Animator animator3 = null;
                                if (n5 > 0) {
                                    boolean bl2 = this.mDestroyed;
                                    animator3 = null;
                                    if (!bl2) {
                                        animator3 = this.loadAnimator(fragment, n2, false, n3);
                                    }
                                }
                                if (animator3 != null) {
                                    final ViewGroup viewGroup = fragment.mContainer;
                                    final View view = fragment.mView;
                                    viewGroup.startViewTransition(view);
                                    fragment.mAnimatingAway = animator3;
                                    fragment.mStateAfterAnimating = n;
                                    animator3.addListener(new AnimatorListenerAdapter(){

                                        @Override
                                        public void onAnimationEnd(Animator animator2) {
                                            viewGroup.endViewTransition(view);
                                            if (fragment.mAnimatingAway != null) {
                                                fragment.mAnimatingAway = null;
                                                FragmentManagerImpl.this.moveToState(fragment, fragment.mStateAfterAnimating, 0, 0, false);
                                            }
                                        }
                                    });
                                    animator3.setTarget(fragment.mView);
                                    animator3.start();
                                }
                                fragment.mContainer.removeView(fragment.mView);
                            }
                            fragment.mContainer = null;
                            fragment.mView = null;
                        }
                    }
                    case 1: {
                        if (n >= 1) break;
                        if (this.mDestroyed && fragment.mAnimatingAway != null) {
                            Animator animator4 = fragment.mAnimatingAway;
                            fragment.mAnimatingAway = null;
                            animator4.cancel();
                        }
                        if (fragment.mAnimatingAway != null) {
                            fragment.mStateAfterAnimating = n;
                            n = 1;
                            break;
                        }
                        if (DEBUG) {
                            Log.v(TAG, "movefrom CREATED: " + fragment);
                        }
                        if (!fragment.mRetaining) {
                            fragment.performDestroy();
                        }
                        fragment.mCalled = false;
                        fragment.onDetach();
                        if (!fragment.mCalled) {
                            throw new SuperNotCalledException("Fragment " + fragment + " did not call through to super.onDetach()");
                        }
                        if (bl) break;
                        if (!fragment.mRetaining) {
                            this.makeInactive(fragment);
                            break;
                        }
                        fragment.mActivity = null;
                        fragment.mParentFragment = null;
                        fragment.mFragmentManager = null;
                        fragment.mChildFragmentManager = null;
                    }
                }
            }
        }
        fragment.mState = n;
    }

    public void noteStateNotSaved() {
        this.mStateSaved = false;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public View onCreateView(View view, String string2, Context context, AttributeSet attributeSet) {
        if (!"fragment".equals(string2)) {
            return null;
        }
        String string3 = attributeSet.getAttributeValue(null, "class");
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.Fragment);
        if (string3 == null) {
            string3 = typedArray.getString(0);
        }
        int n = typedArray.getResourceId(1, -1);
        String string4 = typedArray.getString(2);
        typedArray.recycle();
        int n2 = view != null ? view.getId() : 0;
        if (n2 == -1 && n == -1 && string4 == null) {
            throw new IllegalArgumentException(attributeSet.getPositionDescription() + ": Must specify unique android:id, android:tag, or have a parent with" + " an id for " + string3);
        }
        Fragment fragment = n != -1 ? this.findFragmentById(n) : null;
        if (fragment == null && string4 != null) {
            fragment = this.findFragmentByTag(string4);
        }
        if (fragment == null && n2 != -1) {
            fragment = this.findFragmentById(n2);
        }
        if (DEBUG) {
            Log.v(TAG, "onCreateView: id=0x" + Integer.toHexString(n) + " fname=" + string3 + " existing=" + fragment);
        }
        if (fragment == null) {
            fragment = Fragment.instantiate(context, string3);
            fragment.mFromLayout = true;
            int n3 = n != 0 ? n : n2;
            fragment.mFragmentId = n3;
            fragment.mContainerId = n2;
            fragment.mTag = string4;
            fragment.mInLayout = true;
            fragment.mFragmentManager = this;
            fragment.onInflate(this.mActivity, attributeSet, fragment.mSavedFragmentState);
            this.addFragment(fragment, true);
        } else {
            if (fragment.mInLayout) {
                throw new IllegalArgumentException(attributeSet.getPositionDescription() + ": Duplicate id 0x" + Integer.toHexString(n) + ", tag " + string4 + ", or parent id 0x" + Integer.toHexString(n2) + " with another fragment for " + string3);
            }
            fragment.mInLayout = true;
            if (!fragment.mRetaining) {
                fragment.onInflate(this.mActivity, attributeSet, fragment.mSavedFragmentState);
            }
        }
        if (this.mCurState < 1 && fragment.mFromLayout) {
            this.moveToState(fragment, 1, 0, 0, false);
        } else {
            this.moveToState(fragment);
        }
        if (fragment.mView == null) {
            throw new IllegalStateException("Fragment " + string3 + " did not create a view.");
        }
        if (n != 0) {
            fragment.mView.setId(n);
        }
        if (fragment.mView.getTag() == null) {
            fragment.mView.setTag(string4);
        }
        return fragment.mView;
    }

    @Override
    public View onCreateView(String string2, Context context, AttributeSet attributeSet) {
        return null;
    }

    public void performPendingDeferredStart(Fragment fragment) {
        block3: {
            block2: {
                if (!fragment.mDeferStart) break block2;
                if (!this.mExecutingActions) break block3;
                this.mHavePendingDeferredStart = true;
            }
            return;
        }
        fragment.mDeferStart = false;
        this.moveToState(fragment, this.mCurState, 0, 0, false);
    }

    @Override
    public void popBackStack() {
        this.enqueueAction(new Runnable(){

            @Override
            public void run() {
                FragmentManagerImpl.this.popBackStackState(FragmentManagerImpl.this.mActivity.mHandler, null, -1, 0);
            }
        }, false);
    }

    @Override
    public void popBackStack(final int n, final int n2) {
        if (n < 0) {
            throw new IllegalArgumentException("Bad id: " + n);
        }
        this.enqueueAction(new Runnable(){

            @Override
            public void run() {
                FragmentManagerImpl.this.popBackStackState(FragmentManagerImpl.this.mActivity.mHandler, null, n, n2);
            }
        }, false);
    }

    @Override
    public void popBackStack(final String string2, final int n) {
        this.enqueueAction(new Runnable(){

            @Override
            public void run() {
                FragmentManagerImpl.this.popBackStackState(FragmentManagerImpl.this.mActivity.mHandler, string2, -1, n);
            }
        }, false);
    }

    @Override
    public boolean popBackStackImmediate() {
        this.checkStateLoss();
        this.executePendingTransactions();
        return this.popBackStackState(this.mActivity.mHandler, null, -1, 0);
    }

    @Override
    public boolean popBackStackImmediate(int n, int n2) {
        this.checkStateLoss();
        this.executePendingTransactions();
        if (n < 0) {
            throw new IllegalArgumentException("Bad id: " + n);
        }
        return this.popBackStackState(this.mActivity.mHandler, null, n, n2);
    }

    @Override
    public boolean popBackStackImmediate(String string2, int n) {
        this.checkStateLoss();
        this.executePendingTransactions();
        return this.popBackStackState(this.mActivity.mHandler, string2, -1, n);
    }

    /*
     * Enabled aggressive block sorting
     */
    boolean popBackStackState(Handler handler, String string2, int n, int n2) {
        if (this.mBackStack == null) {
            return false;
        }
        if (string2 == null && n < 0 && (n2 & 1) == 0) {
            int n3 = -1 + this.mBackStack.size();
            if (n3 < 0) {
                return false;
            }
            BackStackRecord backStackRecord = this.mBackStack.remove(n3);
            SparseArray<Fragment> sparseArray = new SparseArray<Fragment>();
            SparseArray<Fragment> sparseArray2 = new SparseArray<Fragment>();
            backStackRecord.calculateBackFragments(sparseArray, sparseArray2);
            backStackRecord.popFromBackStack(true, null, sparseArray, sparseArray2);
            this.reportBackStackChanged();
            return true;
        }
        int n4 = -1;
        if (string2 != null || n >= 0) {
            for (n4 = -1 + this.mBackStack.size(); n4 >= 0; --n4) {
                BackStackRecord backStackRecord = this.mBackStack.get(n4);
                if (string2 != null && string2.equals(backStackRecord.getName()) || n >= 0 && n == backStackRecord.mIndex) break;
            }
            if (n4 < 0) {
                return false;
            }
            if ((n2 & 1) != 0) {
                --n4;
                while (n4 >= 0) {
                    BackStackRecord backStackRecord = this.mBackStack.get(n4);
                    if ((string2 == null || !string2.equals(backStackRecord.getName())) && (n < 0 || n != backStackRecord.mIndex)) break;
                    --n4;
                }
            }
        }
        if (n4 == -1 + this.mBackStack.size()) {
            return false;
        }
        ArrayList<BackStackRecord> arrayList = new ArrayList<BackStackRecord>();
        for (int i = -1 + this.mBackStack.size(); i > n4; --i) {
            arrayList.add(this.mBackStack.remove(i));
        }
        int n5 = -1 + arrayList.size();
        SparseArray<Fragment> sparseArray = new SparseArray<Fragment>();
        SparseArray<Fragment> sparseArray3 = new SparseArray<Fragment>();
        for (int i = 0; i <= n5; ++i) {
            ((BackStackRecord)arrayList.get(i)).calculateBackFragments(sparseArray, sparseArray3);
        }
        BackStackRecord.TransitionState transitionState = null;
        int n6 = 0;
        while (true) {
            if (n6 > n5) {
                this.reportBackStackChanged();
                return true;
            }
            if (DEBUG) {
                Log.v(TAG, "Popping back stack state: " + arrayList.get(n6));
            }
            BackStackRecord backStackRecord = (BackStackRecord)arrayList.get(n6);
            boolean bl = n6 == n5;
            transitionState = backStackRecord.popFromBackStack(bl, transitionState, sparseArray, sparseArray3);
            ++n6;
        }
    }

    @Override
    public void putFragment(Bundle bundle, String string2, Fragment fragment) {
        if (fragment.mIndex < 0) {
            this.throwException(new IllegalStateException("Fragment " + fragment + " is not currently in the FragmentManager"));
        }
        bundle.putInt(string2, fragment.mIndex);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void removeFragment(Fragment fragment, int n, int n2) {
        if (DEBUG) {
            Log.v(TAG, "remove: " + fragment + " nesting=" + fragment.mBackStackNesting);
        }
        boolean bl = !fragment.isInBackStack();
        if (!fragment.mDetached || bl) {
            if (this.mAdded != null) {
                this.mAdded.remove(fragment);
            }
            if (fragment.mHasMenu && fragment.mMenuVisible) {
                this.mNeedMenuInvalidate = true;
            }
            fragment.mAdded = false;
            fragment.mRemoving = true;
            int n3 = bl ? 0 : 1;
            this.moveToState(fragment, n3, n, n2, false);
        }
    }

    @Override
    public void removeOnBackStackChangedListener(FragmentManager.OnBackStackChangedListener onBackStackChangedListener) {
        if (this.mBackStackChangeListeners != null) {
            this.mBackStackChangeListeners.remove(onBackStackChangedListener);
        }
    }

    void reportBackStackChanged() {
        if (this.mBackStackChangeListeners != null) {
            for (int i = 0; i < this.mBackStackChangeListeners.size(); ++i) {
                this.mBackStackChangeListeners.get(i).onBackStackChanged();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    void restoreAllState(Parcelable parcelable, ArrayList<Fragment> arrayList) {
        if (parcelable != null) {
            FragmentManagerState fragmentManagerState = (FragmentManagerState)parcelable;
            if (fragmentManagerState.mActive != null) {
                if (arrayList != null) {
                    for (int i = 0; i < arrayList.size(); ++i) {
                        Fragment fragment = arrayList.get(i);
                        if (DEBUG) {
                            Log.v(TAG, "restoreAllState: re-attaching retained " + fragment);
                        }
                        FragmentState fragmentState = fragmentManagerState.mActive[fragment.mIndex];
                        fragmentState.mInstance = fragment;
                        fragment.mSavedViewState = null;
                        fragment.mBackStackNesting = 0;
                        fragment.mInLayout = false;
                        fragment.mAdded = false;
                        fragment.mTarget = null;
                        if (fragmentState.mSavedFragmentState == null) continue;
                        fragmentState.mSavedFragmentState.setClassLoader(this.mActivity.getClassLoader());
                        fragment.mSavedViewState = fragmentState.mSavedFragmentState.getSparseParcelableArray(VIEW_STATE_TAG);
                        fragment.mSavedFragmentState = fragmentState.mSavedFragmentState;
                    }
                }
                this.mActive = new ArrayList(fragmentManagerState.mActive.length);
                if (this.mAvailIndices != null) {
                    this.mAvailIndices.clear();
                }
                for (int i = 0; i < fragmentManagerState.mActive.length; ++i) {
                    FragmentState fragmentState = fragmentManagerState.mActive[i];
                    if (fragmentState != null) {
                        Fragment fragment = fragmentState.instantiate(this.mActivity, this.mParent);
                        if (DEBUG) {
                            Log.v(TAG, "restoreAllState: active #" + i + ": " + fragment);
                        }
                        this.mActive.add(fragment);
                        fragmentState.mInstance = null;
                        continue;
                    }
                    this.mActive.add(null);
                    if (this.mAvailIndices == null) {
                        this.mAvailIndices = new ArrayList();
                    }
                    if (DEBUG) {
                        Log.v(TAG, "restoreAllState: avail #" + i);
                    }
                    this.mAvailIndices.add(i);
                }
                if (arrayList != null) {
                    for (int i = 0; i < arrayList.size(); ++i) {
                        Fragment fragment = arrayList.get(i);
                        if (fragment.mTargetIndex < 0) continue;
                        if (fragment.mTargetIndex < this.mActive.size()) {
                            fragment.mTarget = this.mActive.get(fragment.mTargetIndex);
                            continue;
                        }
                        Log.w(TAG, "Re-attaching retained fragment " + fragment + " target no longer exists: " + fragment.mTargetIndex);
                        fragment.mTarget = null;
                    }
                }
                if (fragmentManagerState.mAdded == null) {
                    this.mAdded = null;
                } else {
                    this.mAdded = new ArrayList(fragmentManagerState.mAdded.length);
                    for (int i = 0; i < fragmentManagerState.mAdded.length; ++i) {
                        Fragment fragment = this.mActive.get(fragmentManagerState.mAdded[i]);
                        if (fragment == null) {
                            this.throwException(new IllegalStateException("No instantiated fragment for index #" + fragmentManagerState.mAdded[i]));
                        }
                        fragment.mAdded = true;
                        if (DEBUG) {
                            Log.v(TAG, "restoreAllState: added #" + i + ": " + fragment);
                        }
                        if (this.mAdded.contains(fragment)) {
                            throw new IllegalStateException("Already added!");
                        }
                        this.mAdded.add(fragment);
                    }
                }
                if (fragmentManagerState.mBackStack == null) {
                    this.mBackStack = null;
                    return;
                }
                this.mBackStack = new ArrayList(fragmentManagerState.mBackStack.length);
                for (int i = 0; i < fragmentManagerState.mBackStack.length; ++i) {
                    BackStackRecord backStackRecord = fragmentManagerState.mBackStack[i].instantiate(this);
                    if (DEBUG) {
                        Log.v(TAG, "restoreAllState: back stack #" + i + " (index " + backStackRecord.mIndex + "): " + backStackRecord);
                        FastPrintWriter fastPrintWriter = new FastPrintWriter(new LogWriter(2, TAG), false, 1024);
                        backStackRecord.dump("  ", fastPrintWriter, false);
                        ((PrintWriter)fastPrintWriter).flush();
                    }
                    this.mBackStack.add(backStackRecord);
                    if (backStackRecord.mIndex < 0) continue;
                    this.setBackStackIndex(backStackRecord.mIndex, backStackRecord);
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    ArrayList<Fragment> retainNonConfig() {
        ArrayList<Fragment> arrayList = this.mActive;
        ArrayList<Fragment> arrayList2 = null;
        if (arrayList != null) {
            for (int i = 0; i < this.mActive.size(); ++i) {
                Fragment fragment = this.mActive.get(i);
                if (fragment == null || !fragment.mRetainInstance) continue;
                if (arrayList2 == null) {
                    arrayList2 = new ArrayList<Fragment>();
                }
                arrayList2.add(fragment);
                fragment.mRetaining = true;
                int n = fragment.mTarget != null ? fragment.mTarget.mIndex : -1;
                fragment.mTargetIndex = n;
                if (!DEBUG) continue;
                Log.v(TAG, "retainNonConfig: keeping retained " + fragment);
            }
        }
        return arrayList2;
    }

    /*
     * Enabled aggressive block sorting
     */
    Parcelable saveAllState() {
        FragmentState[] fragmentStateArray;
        block22: {
            block23: {
                block19: {
                    this.execPendingActions();
                    this.mStateSaved = true;
                    if (this.mActive == null || this.mActive.size() <= 0) break block19;
                    int n = this.mActive.size();
                    fragmentStateArray = new FragmentState[n];
                    boolean bl = false;
                    for (int i = 0; i < n; ++i) {
                        FragmentState fragmentState;
                        Fragment fragment;
                        block21: {
                            block20: {
                                fragment = this.mActive.get(i);
                                if (fragment == null) continue;
                                if (fragment.mIndex < 0) {
                                    this.throwException(new IllegalStateException("Failure saving state: active " + fragment + " has cleared index: " + fragment.mIndex));
                                }
                                bl = true;
                                fragmentStateArray[i] = fragmentState = new FragmentState(fragment);
                                if (fragment.mState <= 0 || fragmentState.mSavedFragmentState != null) break block20;
                                fragmentState.mSavedFragmentState = this.saveFragmentBasicState(fragment);
                                if (fragment.mTarget != null) {
                                    if (fragment.mTarget.mIndex < 0) {
                                        this.throwException(new IllegalStateException("Failure saving state: " + fragment + " has target not in fragment manager: " + fragment.mTarget));
                                    }
                                    if (fragmentState.mSavedFragmentState == null) {
                                        fragmentState.mSavedFragmentState = new Bundle();
                                    }
                                    this.putFragment(fragmentState.mSavedFragmentState, TARGET_STATE_TAG, fragment.mTarget);
                                    if (fragment.mTargetRequestCode != 0) {
                                        fragmentState.mSavedFragmentState.putInt(TARGET_REQUEST_CODE_STATE_TAG, fragment.mTargetRequestCode);
                                    }
                                }
                                break block21;
                            }
                            fragmentState.mSavedFragmentState = fragment.mSavedFragmentState;
                        }
                        if (!DEBUG) continue;
                        Log.v(TAG, "Saved state of " + fragment + ": " + fragmentState.mSavedFragmentState);
                    }
                    if (bl) break block22;
                    if (DEBUG) break block23;
                }
                return null;
            }
            Log.v(TAG, "saveAllState: no fragments!");
            return null;
        }
        ArrayList<Fragment> arrayList = this.mAdded;
        int[] nArray = null;
        if (arrayList != null) {
            int n = this.mAdded.size();
            nArray = null;
            if (n > 0) {
                nArray = new int[n];
                for (int i = 0; i < n; ++i) {
                    nArray[i] = this.mAdded.get((int)i).mIndex;
                    if (nArray[i] < 0) {
                        this.throwException(new IllegalStateException("Failure saving state: active " + this.mAdded.get(i) + " has cleared index: " + nArray[i]));
                    }
                    if (!DEBUG) continue;
                    Log.v(TAG, "saveAllState: adding fragment #" + i + ": " + this.mAdded.get(i));
                }
            }
        }
        ArrayList<BackStackRecord> arrayList2 = this.mBackStack;
        BackStackState[] backStackStateArray = null;
        if (arrayList2 != null) {
            int n = this.mBackStack.size();
            backStackStateArray = null;
            if (n > 0) {
                backStackStateArray = new BackStackState[n];
                for (int i = 0; i < n; ++i) {
                    backStackStateArray[i] = new BackStackState(this, this.mBackStack.get(i));
                    if (!DEBUG) continue;
                    Log.v(TAG, "saveAllState: adding back stack #" + i + ": " + this.mBackStack.get(i));
                }
            }
        }
        FragmentManagerState fragmentManagerState = new FragmentManagerState();
        fragmentManagerState.mActive = fragmentStateArray;
        fragmentManagerState.mAdded = nArray;
        fragmentManagerState.mBackStack = backStackStateArray;
        return fragmentManagerState;
    }

    Bundle saveFragmentBasicState(Fragment fragment) {
        if (this.mStateBundle == null) {
            this.mStateBundle = new Bundle();
        }
        fragment.performSaveInstanceState(this.mStateBundle);
        boolean bl = this.mStateBundle.isEmpty();
        Bundle bundle = null;
        if (!bl) {
            bundle = this.mStateBundle;
            this.mStateBundle = null;
        }
        if (fragment.mView != null) {
            this.saveFragmentViewState(fragment);
        }
        if (fragment.mSavedViewState != null) {
            if (bundle == null) {
                bundle = new Bundle();
            }
            bundle.putSparseParcelableArray(VIEW_STATE_TAG, fragment.mSavedViewState);
        }
        if (!fragment.mUserVisibleHint) {
            if (bundle == null) {
                bundle = new Bundle();
            }
            bundle.putBoolean(USER_VISIBLE_HINT_TAG, fragment.mUserVisibleHint);
        }
        return bundle;
    }

    @Override
    public Fragment.SavedState saveFragmentInstanceState(Fragment fragment) {
        if (fragment.mIndex < 0) {
            this.throwException(new IllegalStateException("Fragment " + fragment + " is not currently in the FragmentManager"));
        }
        int n = fragment.mState;
        Fragment.SavedState savedState = null;
        if (n > 0) {
            Bundle bundle = this.saveFragmentBasicState(fragment);
            savedState = null;
            if (bundle != null) {
                savedState = new Fragment.SavedState(bundle);
            }
        }
        return savedState;
    }

    /*
     * Enabled aggressive block sorting
     */
    void saveFragmentViewState(Fragment fragment) {
        block6: {
            block5: {
                if (fragment.mView == null) break block5;
                if (this.mStateArray == null) {
                    this.mStateArray = new SparseArray();
                } else {
                    this.mStateArray.clear();
                }
                fragment.mView.saveHierarchyState(this.mStateArray);
                if (this.mStateArray.size() > 0) break block6;
            }
            return;
        }
        fragment.mSavedViewState = this.mStateArray;
        this.mStateArray = null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setBackStackIndex(int n, BackStackRecord backStackRecord) {
        synchronized (this) {
            int n2;
            if (this.mBackStackIndices == null) {
                this.mBackStackIndices = new ArrayList();
            }
            if (n < (n2 = this.mBackStackIndices.size())) {
                if (DEBUG) {
                    Log.v(TAG, "Setting back stack index " + n + " to " + backStackRecord);
                }
                this.mBackStackIndices.set(n, backStackRecord);
            } else {
                while (n2 < n) {
                    this.mBackStackIndices.add(null);
                    if (this.mAvailBackStackIndices == null) {
                        this.mAvailBackStackIndices = new ArrayList();
                    }
                    if (DEBUG) {
                        Log.v(TAG, "Adding available back stack index " + n2);
                    }
                    this.mAvailBackStackIndices.add(n2);
                    ++n2;
                }
                if (DEBUG) {
                    Log.v(TAG, "Adding back stack index " + n + " with " + backStackRecord);
                }
                this.mBackStackIndices.add(backStackRecord);
            }
            return;
        }
    }

    public void showFragment(Fragment fragment, int n, int n2) {
        if (DEBUG) {
            Log.v(TAG, "show: " + fragment);
        }
        if (fragment.mHidden) {
            fragment.mHidden = false;
            if (fragment.mView != null) {
                Animator animator2 = this.loadAnimator(fragment, n, true, n2);
                if (animator2 != null) {
                    animator2.setTarget(fragment.mView);
                    animator2.start();
                }
                fragment.mView.setVisibility(0);
            }
            if (fragment.mAdded && fragment.mHasMenu && fragment.mMenuVisible) {
                this.mNeedMenuInvalidate = true;
            }
            fragment.onHiddenChanged(false);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    void startPendingDeferredFragments() {
        if (this.mActive != null) {
            for (int i = 0; i < this.mActive.size(); ++i) {
                Fragment fragment = this.mActive.get(i);
                if (fragment == null) continue;
                this.performPendingDeferredStart(fragment);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(128);
        stringBuilder.append("FragmentManager{");
        stringBuilder.append(Integer.toHexString(System.identityHashCode(this)));
        stringBuilder.append(" in ");
        if (this.mParent != null) {
            DebugUtils.buildShortClassTag(this.mParent, stringBuilder);
        } else {
            DebugUtils.buildShortClassTag(this.mActivity, stringBuilder);
        }
        stringBuilder.append("}}");
        return stringBuilder.toString();
    }
}

