/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.content.Intent;
import android.os.Binder;
import android.os.IBinder;
import android.os.RemoteException;
import android.view.IOnKeyguardExitResult;
import android.view.IWindowManager;
import android.view.WindowManagerGlobal;

public class KeyguardManager {
    public static final String ACTION_CONFIRM_DEVICE_CREDENTIAL = "android.app.action.CONFIRM_DEVICE_CREDENTIAL";
    public static final String EXTRA_DESCRIPTION = "android.app.extra.DESCRIPTION";
    public static final String EXTRA_TITLE = "android.app.extra.TITLE";
    private IWindowManager mWM = WindowManagerGlobal.getWindowManagerService();

    KeyguardManager() {
    }

    public Intent createConfirmDeviceCredentialIntent(CharSequence charSequence, CharSequence charSequence2) {
        if (!this.isKeyguardSecure()) {
            return null;
        }
        Intent intent = new Intent(ACTION_CONFIRM_DEVICE_CREDENTIAL);
        intent.putExtra(EXTRA_TITLE, charSequence);
        intent.putExtra(EXTRA_DESCRIPTION, charSequence2);
        intent.setPackage("com.android.settings");
        return intent;
    }

    @Deprecated
    public void exitKeyguardSecurely(final OnKeyguardExitResult onKeyguardExitResult) {
        try {
            this.mWM.exitKeyguardSecurely(new IOnKeyguardExitResult.Stub(){

                @Override
                public void onKeyguardExitResult(boolean bl) throws RemoteException {
                    if (onKeyguardExitResult != null) {
                        onKeyguardExitResult.onKeyguardExitResult(bl);
                    }
                }
            });
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    public boolean inKeyguardRestrictedInputMode() {
        try {
            boolean bl = this.mWM.inKeyguardRestrictedInputMode();
            return bl;
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    public boolean isKeyguardLocked() {
        try {
            boolean bl = this.mWM.isKeyguardLocked();
            return bl;
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    public boolean isKeyguardSecure() {
        try {
            boolean bl = this.mWM.isKeyguardSecure();
            return bl;
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    @Deprecated
    public KeyguardLock newKeyguardLock(String string2) {
        return new KeyguardLock(string2);
    }

    public class KeyguardLock {
        private final String mTag;
        private final IBinder mToken = new Binder();

        KeyguardLock(String string2) {
            this.mTag = string2;
        }

        public void disableKeyguard() {
            try {
                KeyguardManager.this.mWM.disableKeyguard(this.mToken, this.mTag);
                return;
            }
            catch (RemoteException remoteException) {
                return;
            }
        }

        public void reenableKeyguard() {
            try {
                KeyguardManager.this.mWM.reenableKeyguard(this.mToken);
                return;
            }
            catch (RemoteException remoteException) {
                return;
            }
        }
    }

    public static interface OnKeyguardExitResult {
        public void onKeyguardExitResult(boolean var1);
    }
}

