/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.IUiModeManager;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.Log;

public class UiModeManager {
    public static String ACTION_ENTER_CAR_MODE = "android.app.action.ENTER_CAR_MODE";
    public static String ACTION_ENTER_DESK_MODE;
    public static String ACTION_EXIT_CAR_MODE;
    public static String ACTION_EXIT_DESK_MODE;
    public static final int DISABLE_CAR_MODE_GO_HOME = 1;
    public static final int ENABLE_CAR_MODE_ALLOW_SLEEP = 2;
    public static final int ENABLE_CAR_MODE_GO_CAR_HOME = 1;
    public static final int MODE_NIGHT_AUTO = 0;
    public static final int MODE_NIGHT_NO = 1;
    public static final int MODE_NIGHT_YES = 2;
    private static final String TAG = "UiModeManager";
    private IUiModeManager mService = IUiModeManager.Stub.asInterface(ServiceManager.getService("uimode"));

    static {
        ACTION_EXIT_CAR_MODE = "android.app.action.EXIT_CAR_MODE";
        ACTION_ENTER_DESK_MODE = "android.app.action.ENTER_DESK_MODE";
        ACTION_EXIT_DESK_MODE = "android.app.action.EXIT_DESK_MODE";
    }

    UiModeManager() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void disableCarMode(int n) {
        if (this.mService == null) return;
        try {
            this.mService.disableCarMode(n);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "disableCarMode: RemoteException", remoteException);
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void enableCarMode(int n) {
        if (this.mService == null) return;
        try {
            this.mService.enableCarMode(n);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "disableCarMode: RemoteException", remoteException);
            return;
        }
    }

    public int getCurrentModeType() {
        if (this.mService != null) {
            try {
                int n = this.mService.getCurrentModeType();
                return n;
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, "getCurrentModeType: RemoteException", remoteException);
            }
        }
        return 1;
    }

    public int getNightMode() {
        if (this.mService != null) {
            try {
                int n = this.mService.getNightMode();
                return n;
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, "getNightMode: RemoteException", remoteException);
            }
        }
        return -1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setNightMode(int n) {
        if (this.mService == null) return;
        try {
            this.mService.setNightMode(n);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "setNightMode: RemoteException", remoteException);
            return;
        }
    }
}

