/*
 * Decompiled with CFR 0.152.
 */
package android.content;

import android.content.ClipDescription;
import android.content.ContentProvider;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.StrictMode;
import android.text.Html;
import android.text.SpannableStringBuilder;
import android.text.Spanned;
import android.text.TextUtils;
import android.text.style.URLSpan;
import java.util.ArrayList;

public class ClipData
implements Parcelable {
    public static final Parcelable.Creator<ClipData> CREATOR;
    static final String[] MIMETYPES_TEXT_HTML;
    static final String[] MIMETYPES_TEXT_INTENT;
    static final String[] MIMETYPES_TEXT_PLAIN;
    static final String[] MIMETYPES_TEXT_URILIST;
    final ClipDescription mClipDescription;
    final Bitmap mIcon;
    final ArrayList<Item> mItems;

    static {
        MIMETYPES_TEXT_PLAIN = new String[]{"text/plain"};
        MIMETYPES_TEXT_HTML = new String[]{"text/html"};
        MIMETYPES_TEXT_URILIST = new String[]{"text/uri-list"};
        MIMETYPES_TEXT_INTENT = new String[]{"text/vnd.android.intent"};
        CREATOR = new Parcelable.Creator<ClipData>(){

            @Override
            public ClipData createFromParcel(Parcel parcel) {
                return new ClipData(parcel);
            }

            public ClipData[] newArray(int n) {
                return new ClipData[n];
            }
        };
    }

    public ClipData(ClipData clipData) {
        this.mClipDescription = clipData.mClipDescription;
        this.mIcon = clipData.mIcon;
        this.mItems = new ArrayList<Item>(clipData.mItems);
    }

    public ClipData(ClipDescription clipDescription, Item item) {
        this.mClipDescription = clipDescription;
        if (item == null) {
            throw new NullPointerException("item is null");
        }
        this.mIcon = null;
        this.mItems = new ArrayList();
        this.mItems.add(item);
    }

    /*
     * Enabled aggressive block sorting
     */
    ClipData(Parcel parcel) {
        this.mClipDescription = new ClipDescription(parcel);
        this.mIcon = parcel.readInt() != 0 ? Bitmap.CREATOR.createFromParcel(parcel) : null;
        this.mItems = new ArrayList();
        int n = parcel.readInt();
        int n2 = 0;
        while (n2 < n) {
            CharSequence charSequence = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(parcel);
            String string2 = parcel.readString();
            Intent intent = parcel.readInt() != 0 ? Intent.CREATOR.createFromParcel(parcel) : null;
            Uri uri = parcel.readInt() != 0 ? Uri.CREATOR.createFromParcel(parcel) : null;
            this.mItems.add(new Item(charSequence, string2, intent, uri));
            ++n2;
        }
        return;
    }

    public ClipData(CharSequence charSequence, String[] stringArray, Item item) {
        this.mClipDescription = new ClipDescription(charSequence, stringArray);
        if (item == null) {
            throw new NullPointerException("item is null");
        }
        this.mIcon = null;
        this.mItems = new ArrayList();
        this.mItems.add(item);
    }

    public static ClipData newHtmlText(CharSequence charSequence, CharSequence charSequence2, String string2) {
        Item item = new Item(charSequence2, string2);
        return new ClipData(charSequence, MIMETYPES_TEXT_HTML, item);
    }

    public static ClipData newIntent(CharSequence charSequence, Intent intent) {
        Item item = new Item(intent);
        return new ClipData(charSequence, MIMETYPES_TEXT_INTENT, item);
    }

    public static ClipData newPlainText(CharSequence charSequence, CharSequence charSequence2) {
        Item item = new Item(charSequence2);
        return new ClipData(charSequence, MIMETYPES_TEXT_PLAIN, item);
    }

    public static ClipData newRawUri(CharSequence charSequence, Uri uri) {
        Item item = new Item(uri);
        return new ClipData(charSequence, MIMETYPES_TEXT_URILIST, item);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static ClipData newUri(ContentResolver contentResolver, CharSequence charSequence, Uri uri) {
        int n = 2;
        Item item = new Item(uri);
        boolean bl = "content".equals(uri.getScheme());
        String[] stringArray = null;
        if (bl) {
            String string2 = contentResolver.getType(uri);
            stringArray = contentResolver.getStreamTypes(uri, "*/*");
            if (stringArray == null) {
                if (string2 != null) {
                    stringArray = new String[n];
                    stringArray[0] = string2;
                    stringArray[1] = "text/uri-list";
                }
            } else {
                int n2 = stringArray.length;
                if (string2 == null) {
                    n = 1;
                }
                String[] stringArray2 = new String[n + n2];
                int n3 = 0;
                if (string2 != null) {
                    stringArray2[0] = string2;
                    n3 = 0 + 1;
                }
                System.arraycopy(stringArray, 0, stringArray2, n3, stringArray.length);
                stringArray2[n3 + stringArray.length] = "text/uri-list";
                stringArray = stringArray2;
            }
        }
        if (stringArray == null) {
            stringArray = MIMETYPES_TEXT_URILIST;
        }
        return new ClipData(charSequence, stringArray, item);
    }

    public void addItem(Item item) {
        if (item == null) {
            throw new NullPointerException("item is null");
        }
        this.mItems.add(item);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public void fixUris(int n) {
        int n2 = this.mItems.size();
        for (int i = 0; i < n2; ++i) {
            Item item = this.mItems.get(i);
            if (item.mIntent != null) {
                item.mIntent.fixUris(n);
            }
            if (item.mUri == null) continue;
            item.mUri = ContentProvider.maybeAddUserId(item.mUri, n);
        }
    }

    public void fixUrisLight(int n) {
        int n2 = this.mItems.size();
        for (int i = 0; i < n2; ++i) {
            Uri uri;
            Item item = this.mItems.get(i);
            if (item.mIntent != null && (uri = item.mIntent.getData()) != null) {
                item.mIntent.setData(ContentProvider.maybeAddUserId(uri, n));
            }
            if (item.mUri == null) continue;
            item.mUri = ContentProvider.maybeAddUserId(item.mUri, n);
        }
    }

    public ClipDescription getDescription() {
        return this.mClipDescription;
    }

    public Bitmap getIcon() {
        return this.mIcon;
    }

    public Item getItemAt(int n) {
        return this.mItems.get(n);
    }

    public int getItemCount() {
        return this.mItems.size();
    }

    public void prepareToLeaveProcess() {
        int n = this.mItems.size();
        for (int i = 0; i < n; ++i) {
            Item item = this.mItems.get(i);
            if (item.mIntent != null) {
                item.mIntent.prepareToLeaveProcess();
            }
            if (item.mUri == null || !StrictMode.vmFileUriExposureEnabled()) continue;
            item.mUri.checkFileUriExposed("ClipData.Item.getUri()");
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void toShortString(StringBuilder stringBuilder) {
        boolean bl = this.mClipDescription != null ? !this.mClipDescription.toShortString(stringBuilder) : true;
        if (this.mIcon != null) {
            if (!bl) {
                stringBuilder.append(' ');
            }
            bl = false;
            stringBuilder.append("I:");
            stringBuilder.append(this.mIcon.getWidth());
            stringBuilder.append('x');
            stringBuilder.append(this.mIcon.getHeight());
        }
        int n = 0;
        while (n < this.mItems.size()) {
            if (!bl) {
                stringBuilder.append(' ');
            }
            stringBuilder.append('{');
            this.mItems.get(n).toShortString(stringBuilder);
            stringBuilder.append('}');
            ++n;
            bl = false;
        }
        return;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(128);
        stringBuilder.append("ClipData { ");
        this.toShortString(stringBuilder);
        stringBuilder.append(" }");
        return stringBuilder.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void writeToParcel(Parcel parcel, int n) {
        this.mClipDescription.writeToParcel(parcel, n);
        if (this.mIcon != null) {
            parcel.writeInt(1);
            this.mIcon.writeToParcel(parcel, n);
        } else {
            parcel.writeInt(0);
        }
        int n2 = this.mItems.size();
        parcel.writeInt(n2);
        int n3 = 0;
        while (n3 < n2) {
            Item item = this.mItems.get(n3);
            TextUtils.writeToParcel(item.mText, parcel, n);
            parcel.writeString(item.mHtmlText);
            if (item.mIntent != null) {
                parcel.writeInt(1);
                item.mIntent.writeToParcel(parcel, n);
            } else {
                parcel.writeInt(0);
            }
            if (item.mUri != null) {
                parcel.writeInt(1);
                item.mUri.writeToParcel(parcel, n);
            } else {
                parcel.writeInt(0);
            }
            ++n3;
        }
        return;
    }

    public static class Item {
        final String mHtmlText;
        final Intent mIntent;
        final CharSequence mText;
        Uri mUri;

        public Item(Intent intent) {
            this.mText = null;
            this.mHtmlText = null;
            this.mIntent = intent;
            this.mUri = null;
        }

        public Item(Uri uri) {
            this.mText = null;
            this.mHtmlText = null;
            this.mIntent = null;
            this.mUri = uri;
        }

        public Item(CharSequence charSequence) {
            this.mText = charSequence;
            this.mHtmlText = null;
            this.mIntent = null;
            this.mUri = null;
        }

        public Item(CharSequence charSequence, Intent intent, Uri uri) {
            this.mText = charSequence;
            this.mHtmlText = null;
            this.mIntent = intent;
            this.mUri = uri;
        }

        public Item(CharSequence charSequence, String string2) {
            this.mText = charSequence;
            this.mHtmlText = string2;
            this.mIntent = null;
            this.mUri = null;
        }

        public Item(CharSequence charSequence, String string2, Intent intent, Uri uri) {
            if (string2 != null && charSequence == null) {
                throw new IllegalArgumentException("Plain text must be supplied if HTML text is supplied");
            }
            this.mText = charSequence;
            this.mHtmlText = string2;
            this.mIntent = intent;
            this.mUri = uri;
        }

        /*
         * Exception decompiling
         */
        private CharSequence coerceToHtmlOrStyledText(Context var1_1, boolean var2_2) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 4[TRYBLOCK] [13, 14, 15 : 234->241)] java.io.FileNotFoundException
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private String uriToHtml(String string2) {
            StringBuilder stringBuilder = new StringBuilder(256);
            stringBuilder.append("<a href=\"");
            stringBuilder.append(Html.escapeHtml(string2));
            stringBuilder.append("\">");
            stringBuilder.append(Html.escapeHtml(string2));
            stringBuilder.append("</a>");
            return stringBuilder.toString();
        }

        private CharSequence uriToStyledText(String string2) {
            SpannableStringBuilder spannableStringBuilder = new SpannableStringBuilder();
            spannableStringBuilder.append(string2);
            spannableStringBuilder.setSpan(new URLSpan(string2), 0, spannableStringBuilder.length(), 33);
            return spannableStringBuilder;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public String coerceToHtmlText(Context context) {
            String string2 = this.getHtmlText();
            if (string2 != null) {
                return string2;
            }
            CharSequence charSequence = this.getText();
            if (charSequence != null) {
                if (!(charSequence instanceof Spanned)) return Html.escapeHtml(charSequence);
                return Html.toHtml((Spanned)charSequence);
            }
            CharSequence charSequence2 = this.coerceToHtmlOrStyledText(context, false);
            if (charSequence2 == null) return null;
            return charSequence2.toString();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public CharSequence coerceToStyledText(Context context) {
            block9: {
                CharSequence charSequence;
                block8: {
                    charSequence = this.getText();
                    if (charSequence instanceof Spanned) break block8;
                    String string2 = this.getHtmlText();
                    if (string2 != null) {
                        try {
                            Spanned spanned = Html.fromHtml(string2);
                            if (spanned != null) {
                                return spanned;
                            }
                        }
                        catch (RuntimeException runtimeException) {
                            // empty catch block
                        }
                    }
                    if (charSequence == null) break block9;
                }
                return charSequence;
            }
            return this.coerceToHtmlOrStyledText(context, true);
        }

        /*
         * Exception decompiling
         */
        public CharSequence coerceToText(Context var1_1) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [10, 11, 12 : 116->123)] java.io.FileNotFoundException
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        public String getHtmlText() {
            return this.mHtmlText;
        }

        public Intent getIntent() {
            return this.mIntent;
        }

        public CharSequence getText() {
            return this.mText;
        }

        public Uri getUri() {
            return this.mUri;
        }

        public void toShortString(StringBuilder stringBuilder) {
            if (this.mHtmlText != null) {
                stringBuilder.append("H:");
                stringBuilder.append(this.mHtmlText);
                return;
            }
            if (this.mText != null) {
                stringBuilder.append("T:");
                stringBuilder.append(this.mText);
                return;
            }
            if (this.mUri != null) {
                stringBuilder.append("U:");
                stringBuilder.append(this.mUri);
                return;
            }
            if (this.mIntent != null) {
                stringBuilder.append("I:");
                this.mIntent.toShortString(stringBuilder, true, true, true, true);
                return;
            }
            stringBuilder.append("NULL");
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(128);
            stringBuilder.append("ClipData.Item { ");
            this.toShortString(stringBuilder);
            stringBuilder.append(" }");
            return stringBuilder.toString();
        }
    }
}

