/*
 * Decompiled with CFR 0.152.
 */
package android.content;

import android.content.ContentProvider;
import android.content.ContentProviderResult;
import android.content.ContentUris;
import android.content.ContentValues;
import android.content.OperationApplicationException;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Log;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ContentProviderOperation
implements Parcelable {
    public static final Parcelable.Creator<ContentProviderOperation> CREATOR = new Parcelable.Creator<ContentProviderOperation>(){

        @Override
        public ContentProviderOperation createFromParcel(Parcel parcel) {
            return new ContentProviderOperation(parcel);
        }

        public ContentProviderOperation[] newArray(int n) {
            return new ContentProviderOperation[n];
        }
    };
    private static final String TAG = "ContentProviderOperation";
    public static final int TYPE_ASSERT = 4;
    public static final int TYPE_DELETE = 3;
    public static final int TYPE_INSERT = 1;
    public static final int TYPE_UPDATE = 2;
    private final Integer mExpectedCount;
    private final String mSelection;
    private final String[] mSelectionArgs;
    private final Map<Integer, Integer> mSelectionArgsBackReferences;
    private final int mType;
    private final Uri mUri;
    private final ContentValues mValues;
    private final ContentValues mValuesBackReferences;
    private final boolean mYieldAllowed;

    private ContentProviderOperation(Builder builder) {
        this.mType = builder.mType;
        this.mUri = builder.mUri;
        this.mValues = builder.mValues;
        this.mSelection = builder.mSelection;
        this.mSelectionArgs = builder.mSelectionArgs;
        this.mExpectedCount = builder.mExpectedCount;
        this.mSelectionArgsBackReferences = builder.mSelectionArgsBackReferences;
        this.mValuesBackReferences = builder.mValuesBackReferences;
        this.mYieldAllowed = builder.mYieldAllowed;
    }

    /*
     * Enabled aggressive block sorting
     */
    public ContentProviderOperation(ContentProviderOperation contentProviderOperation, boolean bl) {
        this.mType = contentProviderOperation.mType;
        this.mUri = bl ? ContentProvider.getUriWithoutUserId(contentProviderOperation.mUri) : contentProviderOperation.mUri;
        this.mValues = contentProviderOperation.mValues;
        this.mSelection = contentProviderOperation.mSelection;
        this.mSelectionArgs = contentProviderOperation.mSelectionArgs;
        this.mExpectedCount = contentProviderOperation.mExpectedCount;
        this.mSelectionArgsBackReferences = contentProviderOperation.mSelectionArgsBackReferences;
        this.mValuesBackReferences = contentProviderOperation.mValuesBackReferences;
        this.mYieldAllowed = contentProviderOperation.mYieldAllowed;
    }

    /*
     * Enabled aggressive block sorting
     */
    private ContentProviderOperation(Parcel parcel) {
        this.mType = parcel.readInt();
        this.mUri = Uri.CREATOR.createFromParcel(parcel);
        ContentValues contentValues = parcel.readInt() != 0 ? ContentValues.CREATOR.createFromParcel(parcel) : null;
        this.mValues = contentValues;
        String string2 = parcel.readInt() != 0 ? parcel.readString() : null;
        this.mSelection = string2;
        String[] stringArray = parcel.readInt() != 0 ? parcel.readStringArray() : null;
        this.mSelectionArgs = stringArray;
        Integer n = parcel.readInt() != 0 ? Integer.valueOf(parcel.readInt()) : null;
        this.mExpectedCount = n;
        ContentValues contentValues2 = parcel.readInt() != 0 ? ContentValues.CREATOR.createFromParcel(parcel) : null;
        this.mValuesBackReferences = contentValues2;
        int n2 = parcel.readInt();
        HashMap hashMap = null;
        if (n2 != 0) {
            hashMap = new HashMap();
        }
        this.mSelectionArgsBackReferences = hashMap;
        if (this.mSelectionArgsBackReferences != null) {
            int n3 = parcel.readInt();
            for (int i = 0; i < n3; ++i) {
                this.mSelectionArgsBackReferences.put(parcel.readInt(), parcel.readInt());
            }
        }
        boolean bl = parcel.readInt() != 0;
        this.mYieldAllowed = bl;
    }

    private long backRefToValue(ContentProviderResult[] contentProviderResultArray, int n, Integer n2) {
        if (n2 >= n) {
            Log.e(TAG, this.toString());
            throw new ArrayIndexOutOfBoundsException("asked for back ref " + n2 + " but there are only " + n + " back refs");
        }
        ContentProviderResult contentProviderResult = contentProviderResultArray[n2];
        if (contentProviderResult.uri != null) {
            return ContentUris.parseId(contentProviderResult.uri);
        }
        return contentProviderResult.count.intValue();
    }

    public static Builder newAssertQuery(Uri uri) {
        return new Builder(4, uri);
    }

    public static Builder newDelete(Uri uri) {
        return new Builder(3, uri);
    }

    public static Builder newInsert(Uri uri) {
        return new Builder(1, uri);
    }

    public static Builder newUpdate(Uri uri) {
        return new Builder(2, uri);
    }

    /*
     * Unable to fully structure code
     */
    public ContentProviderResult apply(ContentProvider var1_1, ContentProviderResult[] var2_2, int var3_3) throws OperationApplicationException {
        block14: {
            block16: {
                block12: {
                    block15: {
                        block13: {
                            var4_4 = this.resolveValueBackReferences(var2_2, var3_3);
                            var5_5 = this.resolveSelectionArgsBackReferences(var2_2, var3_3);
                            if (this.mType == 1) {
                                var19_6 = var1_1.insert(this.mUri, var4_4);
                                if (var19_6 == null) {
                                    throw new OperationApplicationException("insert failed");
                                }
                                return new ContentProviderResult(var19_6);
                            }
                            if (this.mType != 3) break block13;
                            var11_7 = var1_1.delete(this.mUri, this.mSelection, var5_5);
lbl10:
                            // 3 sources

                            while (this.mExpectedCount != null && this.mExpectedCount != var11_7) {
                                Log.e("ContentProviderOperation", this.toString());
                                throw new OperationApplicationException("wrong number of rows: " + var11_7);
                            }
                            break block14;
                        }
                        if (this.mType != 2) break block15;
                        var11_7 = var1_1.update(this.mUri, var4_4, this.mSelection, var5_5);
                        ** GOTO lbl10
                    }
                    if (this.mType != 4) break block16;
                    var6_8 = null;
                    if (var4_4 != null) {
                        var7_9 = new ArrayList<String>();
                        var8_10 = var4_4.valueSet().iterator();
                        while (var8_10.hasNext()) {
                            var7_9.add(var8_10.next().getKey());
                        }
                        var6_8 = var7_9.toArray(new String[var7_9.size()]);
                    }
                    var9_11 = var1_1.query(this.mUri, var6_8, this.mSelection, var5_5, null);
                    var11_7 = var9_11.getCount();
                    if (var6_8 == null) break block12;
                    block6: while (true) {
                        if (!var9_11.moveToNext()) break;
                        var13_12 = 0;
                        while (true) {
                            try {
                                if (var13_12 >= var6_8.length) continue block6;
                                var14_13 = var9_11.getString(var13_12);
                                if (!TextUtils.equals(var14_13, var15_14 = var4_4.getAsString(var6_8[var13_12]))) {
                                    Log.e("ContentProviderOperation", this.toString());
                                    throw new OperationApplicationException("Found value " + var14_13 + " when expected " + var15_14 + " for column " + var6_8[var13_12]);
                                }
                            }
                            catch (Throwable var10_15) {
                                var9_11.close();
                                throw var10_15;
                            }
                            ++var13_12;
                        }
                        break;
                    }
                }
                var9_11.close();
                ** GOTO lbl10
            }
            Log.e("ContentProviderOperation", this.toString());
            throw new IllegalStateException("bad type, " + this.mType);
        }
        return new ContentProviderResult(var11_7);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public int getType() {
        return this.mType;
    }

    public Uri getUri() {
        return this.mUri;
    }

    public ContentProviderOperation getWithoutUserIdInUri() {
        if (ContentProvider.uriHasUserId(contentProviderOperation.mUri)) {
            ContentProviderOperation contentProviderOperation = new ContentProviderOperation(contentProviderOperation, true);
        }
        return contentProviderOperation;
    }

    public boolean isReadOperation() {
        return this.mType == 4;
    }

    public boolean isWriteOperation() {
        return this.mType == 3 || this.mType == 1 || this.mType == 2;
    }

    public boolean isYieldAllowed() {
        return this.mYieldAllowed;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String[] resolveSelectionArgsBackReferences(ContentProviderResult[] contentProviderResultArray, int n) {
        if (this.mSelectionArgsBackReferences == null) {
            return this.mSelectionArgs;
        }
        String[] stringArray = new String[this.mSelectionArgs.length];
        System.arraycopy(this.mSelectionArgs, 0, stringArray, 0, this.mSelectionArgs.length);
        Iterator<Map.Entry<Integer, Integer>> iterator = this.mSelectionArgsBackReferences.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Integer, Integer> entry = iterator.next();
            Integer n2 = entry.getKey();
            int n3 = entry.getValue();
            stringArray[n2.intValue()] = String.valueOf(this.backRefToValue(contentProviderResultArray, n, n3));
        }
        return stringArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    public ContentValues resolveValueBackReferences(ContentProviderResult[] contentProviderResultArray, int n) {
        if (this.mValuesBackReferences == null) {
            return this.mValues;
        }
        ContentValues contentValues = this.mValues == null ? new ContentValues() : new ContentValues(this.mValues);
        Iterator<Map.Entry<String, Object>> iterator = this.mValuesBackReferences.valueSet().iterator();
        while (iterator.hasNext()) {
            String string2 = iterator.next().getKey();
            Integer n2 = this.mValuesBackReferences.getAsInteger(string2);
            if (n2 == null) {
                Log.e(TAG, this.toString());
                throw new IllegalArgumentException("values backref " + string2 + " is not an integer");
            }
            contentValues.put(string2, this.backRefToValue(contentProviderResultArray, n, n2));
        }
        return contentValues;
    }

    public String toString() {
        return "mType: " + this.mType + ", mUri: " + this.mUri + ", mSelection: " + this.mSelection + ", mExpectedCount: " + this.mExpectedCount + ", mYieldAllowed: " + this.mYieldAllowed + ", mValues: " + this.mValues + ", mValuesBackReferences: " + this.mValuesBackReferences + ", mSelectionArgsBackReferences: " + this.mSelectionArgsBackReferences;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeInt(this.mType);
        Uri.writeToParcel(parcel, this.mUri);
        if (this.mValues != null) {
            parcel.writeInt(1);
            this.mValues.writeToParcel(parcel, 0);
        } else {
            parcel.writeInt(0);
        }
        if (this.mSelection != null) {
            parcel.writeInt(1);
            parcel.writeString(this.mSelection);
        } else {
            parcel.writeInt(0);
        }
        if (this.mSelectionArgs != null) {
            parcel.writeInt(1);
            parcel.writeStringArray(this.mSelectionArgs);
        } else {
            parcel.writeInt(0);
        }
        if (this.mExpectedCount != null) {
            parcel.writeInt(1);
            parcel.writeInt(this.mExpectedCount);
        } else {
            parcel.writeInt(0);
        }
        if (this.mValuesBackReferences != null) {
            parcel.writeInt(1);
            this.mValuesBackReferences.writeToParcel(parcel, 0);
        } else {
            parcel.writeInt(0);
        }
        if (this.mSelectionArgsBackReferences != null) {
            parcel.writeInt(1);
            parcel.writeInt(this.mSelectionArgsBackReferences.size());
            for (Map.Entry<Integer, Integer> entry : this.mSelectionArgsBackReferences.entrySet()) {
                parcel.writeInt(entry.getKey());
                parcel.writeInt(entry.getValue());
            }
        } else {
            parcel.writeInt(0);
        }
        int n2 = this.mYieldAllowed ? 1 : 0;
        parcel.writeInt(n2);
    }

    public static class Builder {
        private Integer mExpectedCount;
        private String mSelection;
        private String[] mSelectionArgs;
        private Map<Integer, Integer> mSelectionArgsBackReferences;
        private final int mType;
        private final Uri mUri;
        private ContentValues mValues;
        private ContentValues mValuesBackReferences;
        private boolean mYieldAllowed;

        private Builder(int n, Uri uri) {
            if (uri == null) {
                throw new IllegalArgumentException("uri must not be null");
            }
            this.mType = n;
            this.mUri = uri;
        }

        public ContentProviderOperation build() {
            if (!(this.mType != 2 || this.mValues != null && this.mValues.size() != 0 || this.mValuesBackReferences != null && this.mValuesBackReferences.size() != 0)) {
                throw new IllegalArgumentException("Empty values");
            }
            if (!(this.mType != 4 || this.mValues != null && this.mValues.size() != 0 || this.mValuesBackReferences != null && this.mValuesBackReferences.size() != 0 || this.mExpectedCount != null)) {
                throw new IllegalArgumentException("Empty values");
            }
            return new ContentProviderOperation(this);
        }

        public Builder withExpectedCount(int n) {
            if (this.mType != 2 && this.mType != 3 && this.mType != 4) {
                throw new IllegalArgumentException("only updates, deletes, and asserts can have expected counts");
            }
            this.mExpectedCount = n;
            return this;
        }

        public Builder withSelection(String string2, String[] stringArray) {
            if (this.mType != 2 && this.mType != 3 && this.mType != 4) {
                throw new IllegalArgumentException("only updates, deletes, and asserts can have selections");
            }
            this.mSelection = string2;
            if (stringArray == null) {
                this.mSelectionArgs = null;
                return this;
            }
            this.mSelectionArgs = new String[stringArray.length];
            System.arraycopy(stringArray, 0, this.mSelectionArgs, 0, stringArray.length);
            return this;
        }

        public Builder withSelectionBackReference(int n, int n2) {
            if (this.mType != 2 && this.mType != 3 && this.mType != 4) {
                throw new IllegalArgumentException("only updates, deletes, and asserts can have selection back-references");
            }
            if (this.mSelectionArgsBackReferences == null) {
                this.mSelectionArgsBackReferences = new HashMap<Integer, Integer>();
            }
            this.mSelectionArgsBackReferences.put(n, n2);
            return this;
        }

        public Builder withValue(String string2, Object object) {
            if (this.mType != 1 && this.mType != 2 && this.mType != 4) {
                throw new IllegalArgumentException("only inserts and updates can have values");
            }
            if (this.mValues == null) {
                this.mValues = new ContentValues();
            }
            if (object == null) {
                this.mValues.putNull(string2);
                return this;
            }
            if (object instanceof String) {
                this.mValues.put(string2, (String)object);
                return this;
            }
            if (object instanceof Byte) {
                this.mValues.put(string2, (Byte)object);
                return this;
            }
            if (object instanceof Short) {
                this.mValues.put(string2, (Short)object);
                return this;
            }
            if (object instanceof Integer) {
                this.mValues.put(string2, (Integer)object);
                return this;
            }
            if (object instanceof Long) {
                this.mValues.put(string2, (Long)object);
                return this;
            }
            if (object instanceof Float) {
                this.mValues.put(string2, (Float)object);
                return this;
            }
            if (object instanceof Double) {
                this.mValues.put(string2, (Double)object);
                return this;
            }
            if (object instanceof Boolean) {
                this.mValues.put(string2, (Boolean)object);
                return this;
            }
            if (object instanceof byte[]) {
                this.mValues.put(string2, (byte[])object);
                return this;
            }
            throw new IllegalArgumentException("bad value type: " + object.getClass().getName());
        }

        public Builder withValueBackReference(String string2, int n) {
            if (this.mType != 1 && this.mType != 2 && this.mType != 4) {
                throw new IllegalArgumentException("only inserts, updates, and asserts can have value back-references");
            }
            if (this.mValuesBackReferences == null) {
                this.mValuesBackReferences = new ContentValues();
            }
            this.mValuesBackReferences.put(string2, n);
            return this;
        }

        public Builder withValueBackReferences(ContentValues contentValues) {
            if (this.mType != 1 && this.mType != 2 && this.mType != 4) {
                throw new IllegalArgumentException("only inserts, updates, and asserts can have value back-references");
            }
            this.mValuesBackReferences = contentValues;
            return this;
        }

        public Builder withValues(ContentValues contentValues) {
            if (this.mType != 1 && this.mType != 2 && this.mType != 4) {
                throw new IllegalArgumentException("only inserts, updates, and asserts can have values");
            }
            if (this.mValues == null) {
                this.mValues = new ContentValues();
            }
            this.mValues.putAll(contentValues);
            return this;
        }

        public Builder withYieldAllowed(boolean bl) {
            this.mYieldAllowed = bl;
            return this;
        }
    }
}

