/*
 * Decompiled with CFR 0.152.
 */
package android.content;

import android.content.ContentProviderOperation;
import android.content.ContentProviderResult;
import android.content.ContentValues;
import android.content.IContentProvider;
import android.content.OperationApplicationException;
import android.content.res.AssetFileDescriptor;
import android.database.BulkCursorDescriptor;
import android.database.BulkCursorToCursorAdaptor;
import android.database.Cursor;
import android.database.DatabaseUtils;
import android.net.Uri;
import android.os.Bundle;
import android.os.IBinder;
import android.os.ICancellationSignal;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Iterator;

final class ContentProviderProxy
implements IContentProvider {
    private IBinder mRemote;

    public ContentProviderProxy(IBinder iBinder) {
        this.mRemote = iBinder;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ContentProviderResult[] applyBatch(String string2, ArrayList<ContentProviderOperation> arrayList) throws RemoteException, OperationApplicationException {
        Parcel parcel = Parcel.obtain();
        Parcel parcel2 = Parcel.obtain();
        try {
            parcel.writeInterfaceToken("android.content.IContentProvider");
            parcel.writeString(string2);
            parcel.writeInt(arrayList.size());
            Iterator<ContentProviderOperation> iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                iterator.next().writeToParcel(parcel, 0);
            }
            this.mRemote.transact(20, parcel, parcel2, 0);
            DatabaseUtils.readExceptionWithOperationApplicationExceptionFromParcel(parcel2);
            ContentProviderResult[] contentProviderResultArray = parcel2.createTypedArray(ContentProviderResult.CREATOR);
            return contentProviderResultArray;
        }
        finally {
            parcel.recycle();
            parcel2.recycle();
        }
    }

    @Override
    public IBinder asBinder() {
        return this.mRemote;
    }

    @Override
    public int bulkInsert(String string2, Uri uri, ContentValues[] contentValuesArray) throws RemoteException {
        Parcel parcel = Parcel.obtain();
        Parcel parcel2 = Parcel.obtain();
        try {
            parcel.writeInterfaceToken("android.content.IContentProvider");
            parcel.writeString(string2);
            uri.writeToParcel(parcel, 0);
            parcel.writeTypedArray(contentValuesArray, 0);
            this.mRemote.transact(13, parcel, parcel2, 0);
            DatabaseUtils.readExceptionFromParcel(parcel2);
            int n = parcel2.readInt();
            return n;
        }
        finally {
            parcel.recycle();
            parcel2.recycle();
        }
    }

    @Override
    public Bundle call(String string2, String string3, String string4, Bundle bundle) throws RemoteException {
        Parcel parcel = Parcel.obtain();
        Parcel parcel2 = Parcel.obtain();
        try {
            parcel.writeInterfaceToken("android.content.IContentProvider");
            parcel.writeString(string2);
            parcel.writeString(string3);
            parcel.writeString(string4);
            parcel.writeBundle(bundle);
            this.mRemote.transact(21, parcel, parcel2, 0);
            DatabaseUtils.readExceptionFromParcel(parcel2);
            Bundle bundle2 = parcel2.readBundle();
            return bundle2;
        }
        finally {
            parcel.recycle();
            parcel2.recycle();
        }
    }

    @Override
    public Uri canonicalize(String string2, Uri uri) throws RemoteException {
        Parcel parcel = Parcel.obtain();
        Parcel parcel2 = Parcel.obtain();
        try {
            parcel.writeInterfaceToken("android.content.IContentProvider");
            parcel.writeString(string2);
            uri.writeToParcel(parcel, 0);
            this.mRemote.transact(25, parcel, parcel2, 0);
            DatabaseUtils.readExceptionFromParcel(parcel2);
            Uri uri2 = Uri.CREATOR.createFromParcel(parcel2);
            return uri2;
        }
        finally {
            parcel.recycle();
            parcel2.recycle();
        }
    }

    @Override
    public ICancellationSignal createCancellationSignal() throws RemoteException {
        Parcel parcel = Parcel.obtain();
        Parcel parcel2 = Parcel.obtain();
        try {
            parcel.writeInterfaceToken("android.content.IContentProvider");
            this.mRemote.transact(24, parcel, parcel2, 0);
            DatabaseUtils.readExceptionFromParcel(parcel2);
            ICancellationSignal iCancellationSignal = ICancellationSignal.Stub.asInterface(parcel2.readStrongBinder());
            return iCancellationSignal;
        }
        finally {
            parcel.recycle();
            parcel2.recycle();
        }
    }

    @Override
    public int delete(String string2, Uri uri, String string3, String[] stringArray) throws RemoteException {
        Parcel parcel = Parcel.obtain();
        Parcel parcel2 = Parcel.obtain();
        try {
            parcel.writeInterfaceToken("android.content.IContentProvider");
            parcel.writeString(string2);
            uri.writeToParcel(parcel, 0);
            parcel.writeString(string3);
            parcel.writeStringArray(stringArray);
            this.mRemote.transact(4, parcel, parcel2, 0);
            DatabaseUtils.readExceptionFromParcel(parcel2);
            int n = parcel2.readInt();
            return n;
        }
        finally {
            parcel.recycle();
            parcel2.recycle();
        }
    }

    @Override
    public String[] getStreamTypes(Uri uri, String string2) throws RemoteException {
        Parcel parcel = Parcel.obtain();
        Parcel parcel2 = Parcel.obtain();
        try {
            parcel.writeInterfaceToken("android.content.IContentProvider");
            uri.writeToParcel(parcel, 0);
            parcel.writeString(string2);
            this.mRemote.transact(22, parcel, parcel2, 0);
            DatabaseUtils.readExceptionFromParcel(parcel2);
            String[] stringArray = parcel2.createStringArray();
            return stringArray;
        }
        finally {
            parcel.recycle();
            parcel2.recycle();
        }
    }

    @Override
    public String getType(Uri uri) throws RemoteException {
        Parcel parcel = Parcel.obtain();
        Parcel parcel2 = Parcel.obtain();
        try {
            parcel.writeInterfaceToken("android.content.IContentProvider");
            uri.writeToParcel(parcel, 0);
            this.mRemote.transact(2, parcel, parcel2, 0);
            DatabaseUtils.readExceptionFromParcel(parcel2);
            String string2 = parcel2.readString();
            return string2;
        }
        finally {
            parcel.recycle();
            parcel2.recycle();
        }
    }

    @Override
    public Uri insert(String string2, Uri uri, ContentValues contentValues) throws RemoteException {
        Parcel parcel = Parcel.obtain();
        Parcel parcel2 = Parcel.obtain();
        try {
            parcel.writeInterfaceToken("android.content.IContentProvider");
            parcel.writeString(string2);
            uri.writeToParcel(parcel, 0);
            contentValues.writeToParcel(parcel, 0);
            this.mRemote.transact(3, parcel, parcel2, 0);
            DatabaseUtils.readExceptionFromParcel(parcel2);
            Uri uri2 = Uri.CREATOR.createFromParcel(parcel2);
            return uri2;
        }
        finally {
            parcel.recycle();
            parcel2.recycle();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public AssetFileDescriptor openAssetFile(String string2, Uri uri, String string3, ICancellationSignal iCancellationSignal) throws RemoteException, FileNotFoundException {
        Parcel parcel = Parcel.obtain();
        Parcel parcel2 = Parcel.obtain();
        try {
            parcel.writeInterfaceToken("android.content.IContentProvider");
            parcel.writeString(string2);
            uri.writeToParcel(parcel, 0);
            parcel.writeString(string3);
            IBinder iBinder = iCancellationSignal != null ? iCancellationSignal.asBinder() : null;
            parcel.writeStrongBinder(iBinder);
            this.mRemote.transact(15, parcel, parcel2, 0);
            DatabaseUtils.readExceptionWithFileNotFoundExceptionFromParcel(parcel2);
            int n = parcel2.readInt();
            AssetFileDescriptor assetFileDescriptor = null;
            if (n != 0) {
                AssetFileDescriptor assetFileDescriptor2;
                assetFileDescriptor = assetFileDescriptor2 = AssetFileDescriptor.CREATOR.createFromParcel(parcel2);
            }
            parcel.recycle();
            parcel2.recycle();
            return assetFileDescriptor;
        }
        catch (Throwable throwable) {
            parcel.recycle();
            parcel2.recycle();
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ParcelFileDescriptor openFile(String string2, Uri uri, String string3, ICancellationSignal iCancellationSignal) throws RemoteException, FileNotFoundException {
        Parcel parcel = Parcel.obtain();
        Parcel parcel2 = Parcel.obtain();
        try {
            parcel.writeInterfaceToken("android.content.IContentProvider");
            parcel.writeString(string2);
            uri.writeToParcel(parcel, 0);
            parcel.writeString(string3);
            IBinder iBinder = iCancellationSignal != null ? iCancellationSignal.asBinder() : null;
            parcel.writeStrongBinder(iBinder);
            this.mRemote.transact(14, parcel, parcel2, 0);
            DatabaseUtils.readExceptionWithFileNotFoundExceptionFromParcel(parcel2);
            int n = parcel2.readInt();
            ParcelFileDescriptor parcelFileDescriptor = null;
            if (n != 0) {
                ParcelFileDescriptor parcelFileDescriptor2;
                parcelFileDescriptor = parcelFileDescriptor2 = parcel2.readFileDescriptor();
            }
            parcel.recycle();
            parcel2.recycle();
            return parcelFileDescriptor;
        }
        catch (Throwable throwable) {
            parcel.recycle();
            parcel2.recycle();
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public AssetFileDescriptor openTypedAssetFile(String string2, Uri uri, String string3, Bundle bundle, ICancellationSignal iCancellationSignal) throws RemoteException, FileNotFoundException {
        Parcel parcel = Parcel.obtain();
        Parcel parcel2 = Parcel.obtain();
        try {
            parcel.writeInterfaceToken("android.content.IContentProvider");
            parcel.writeString(string2);
            uri.writeToParcel(parcel, 0);
            parcel.writeString(string3);
            parcel.writeBundle(bundle);
            IBinder iBinder = iCancellationSignal != null ? iCancellationSignal.asBinder() : null;
            parcel.writeStrongBinder(iBinder);
            this.mRemote.transact(23, parcel, parcel2, 0);
            DatabaseUtils.readExceptionWithFileNotFoundExceptionFromParcel(parcel2);
            int n = parcel2.readInt();
            AssetFileDescriptor assetFileDescriptor = null;
            if (n != 0) {
                AssetFileDescriptor assetFileDescriptor2;
                assetFileDescriptor = assetFileDescriptor2 = AssetFileDescriptor.CREATOR.createFromParcel(parcel2);
            }
            parcel.recycle();
            parcel2.recycle();
            return assetFileDescriptor;
        }
        catch (Throwable throwable) {
            parcel.recycle();
            parcel2.recycle();
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Cursor query(String string2, Uri uri, String[] stringArray, String string3, String[] stringArray2, String string4, ICancellationSignal iCancellationSignal) throws RemoteException {
        BulkCursorToCursorAdaptor bulkCursorToCursorAdaptor = new BulkCursorToCursorAdaptor();
        Parcel parcel = Parcel.obtain();
        Parcel parcel2 = Parcel.obtain();
        try {
            parcel.writeInterfaceToken("android.content.IContentProvider");
            parcel.writeString(string2);
            uri.writeToParcel(parcel, 0);
            int n = 0;
            if (stringArray != null) {
                n = stringArray.length;
            }
            parcel.writeInt(n);
            for (int i = 0; i < n; ++i) {
                parcel.writeString(stringArray[i]);
            }
            parcel.writeString(string3);
            int n2 = stringArray2 != null ? stringArray2.length : 0;
            parcel.writeInt(n2);
            for (int i = 0; i < n2; ++i) {
                parcel.writeString(stringArray2[i]);
            }
            parcel.writeString(string4);
            parcel.writeStrongBinder(bulkCursorToCursorAdaptor.getObserver().asBinder());
            IBinder iBinder = iCancellationSignal != null ? iCancellationSignal.asBinder() : null;
            parcel.writeStrongBinder(iBinder);
            this.mRemote.transact(1, parcel, parcel2, 0);
            DatabaseUtils.readExceptionFromParcel(parcel2);
            if (parcel2.readInt() != 0) {
                bulkCursorToCursorAdaptor.initialize(BulkCursorDescriptor.CREATOR.createFromParcel(parcel2));
                return bulkCursorToCursorAdaptor;
            }
            bulkCursorToCursorAdaptor.close();
            bulkCursorToCursorAdaptor = null;
            return bulkCursorToCursorAdaptor;
        }
        catch (RemoteException remoteException) {
            bulkCursorToCursorAdaptor.close();
            throw remoteException;
        }
        catch (RuntimeException runtimeException) {
            bulkCursorToCursorAdaptor.close();
            throw runtimeException;
        }
        finally {
            parcel.recycle();
            parcel2.recycle();
        }
    }

    @Override
    public Uri uncanonicalize(String string2, Uri uri) throws RemoteException {
        Parcel parcel = Parcel.obtain();
        Parcel parcel2 = Parcel.obtain();
        try {
            parcel.writeInterfaceToken("android.content.IContentProvider");
            parcel.writeString(string2);
            uri.writeToParcel(parcel, 0);
            this.mRemote.transact(26, parcel, parcel2, 0);
            DatabaseUtils.readExceptionFromParcel(parcel2);
            Uri uri2 = Uri.CREATOR.createFromParcel(parcel2);
            return uri2;
        }
        finally {
            parcel.recycle();
            parcel2.recycle();
        }
    }

    @Override
    public int update(String string2, Uri uri, ContentValues contentValues, String string3, String[] stringArray) throws RemoteException {
        Parcel parcel = Parcel.obtain();
        Parcel parcel2 = Parcel.obtain();
        try {
            parcel.writeInterfaceToken("android.content.IContentProvider");
            parcel.writeString(string2);
            uri.writeToParcel(parcel, 0);
            contentValues.writeToParcel(parcel, 0);
            parcel.writeString(string3);
            parcel.writeStringArray(stringArray);
            this.mRemote.transact(10, parcel, parcel2, 0);
            DatabaseUtils.readExceptionFromParcel(parcel2);
            int n = parcel2.readInt();
            return n;
        }
        finally {
            parcel.recycle();
            parcel2.recycle();
        }
    }
}

