/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm;

import android.content.ComponentName;
import android.content.Context;
import android.content.pm.ActivityInfo;
import android.content.pm.ApplicationInfo;
import android.content.pm.LauncherApps;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.res.Resources;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.UserHandle;
import android.util.Log;

public class LauncherActivityInfo {
    private static final String TAG = "LauncherActivityInfo";
    private ActivityInfo mActivityInfo;
    private ComponentName mComponentName;
    private long mFirstInstallTime;
    private final PackageManager mPm;
    private UserHandle mUser;

    LauncherActivityInfo(Context context) {
        this.mPm = context.getPackageManager();
    }

    LauncherActivityInfo(Context context, ResolveInfo resolveInfo, UserHandle userHandle, long l) {
        this(context);
        this.mActivityInfo = resolveInfo.activityInfo;
        this.mComponentName = LauncherApps.getComponentName(resolveInfo);
        this.mUser = userHandle;
        this.mFirstInstallTime = l;
    }

    public int getApplicationFlags() {
        return this.mActivityInfo.applicationInfo.flags;
    }

    public ApplicationInfo getApplicationInfo() {
        return this.mActivityInfo.applicationInfo;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Drawable getBadgedIcon(int n) {
        Drawable drawable2;
        int n2 = this.mActivityInfo.getIconResource();
        try {
            Resources resources = this.mPm.getResourcesForApplication(this.mActivityInfo.applicationInfo);
            drawable2 = null;
            if (n != 0) {
                try {
                    Drawable drawable3;
                    drawable2 = drawable3 = resources.getDrawableForDensity(n2, n);
                }
                catch (Resources.NotFoundException notFoundException) {
                    drawable2 = null;
                }
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            drawable2 = null;
        }
        if (drawable2 == null) {
            drawable2 = this.mActivityInfo.loadIcon(this.mPm);
        }
        if (drawable2 instanceof BitmapDrawable) {
            return this.mPm.getUserBadgedIcon(drawable2, this.mUser);
        }
        Log.e(TAG, "Unable to create badged icon for " + this.mActivityInfo);
        return drawable2;
    }

    public ComponentName getComponentName() {
        return this.mComponentName;
    }

    public long getFirstInstallTime() {
        return this.mFirstInstallTime;
    }

    public Drawable getIcon(int n) {
        return this.mActivityInfo.loadIcon(this.mPm);
    }

    public CharSequence getLabel() {
        return this.mActivityInfo.loadLabel(this.mPm);
    }

    public String getName() {
        return this.mActivityInfo.name;
    }

    public UserHandle getUser() {
        return this.mUser;
    }
}

