/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm;

import android.content.pm.ComponentInfo;
import android.content.pm.PathPermission;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.PatternMatcher;
import android.util.Printer;

public final class ProviderInfo
extends ComponentInfo
implements Parcelable {
    public static final Parcelable.Creator<ProviderInfo> CREATOR = new Parcelable.Creator<ProviderInfo>(){

        @Override
        public ProviderInfo createFromParcel(Parcel parcel) {
            return new ProviderInfo(parcel);
        }

        public ProviderInfo[] newArray(int n) {
            return new ProviderInfo[n];
        }
    };
    public static final int FLAG_SINGLE_USER = 0x40000000;
    public String authority;
    public int flags;
    public boolean grantUriPermissions;
    public int initOrder;
    @Deprecated
    public boolean isSyncable;
    public boolean multiprocess;
    public PathPermission[] pathPermissions;
    public String readPermission;
    public PatternMatcher[] uriPermissionPatterns;
    public String writePermission;

    public ProviderInfo() {
        this.authority = null;
        this.readPermission = null;
        this.writePermission = null;
        this.grantUriPermissions = false;
        this.uriPermissionPatterns = null;
        this.pathPermissions = null;
        this.multiprocess = false;
        this.initOrder = 0;
        this.flags = 0;
        this.isSyncable = false;
    }

    public ProviderInfo(ProviderInfo providerInfo) {
        super(providerInfo);
        this.authority = null;
        this.readPermission = null;
        this.writePermission = null;
        this.grantUriPermissions = false;
        this.uriPermissionPatterns = null;
        this.pathPermissions = null;
        this.multiprocess = false;
        this.initOrder = 0;
        this.flags = 0;
        this.isSyncable = false;
        this.authority = providerInfo.authority;
        this.readPermission = providerInfo.readPermission;
        this.writePermission = providerInfo.writePermission;
        this.grantUriPermissions = providerInfo.grantUriPermissions;
        this.uriPermissionPatterns = providerInfo.uriPermissionPatterns;
        this.pathPermissions = providerInfo.pathPermissions;
        this.multiprocess = providerInfo.multiprocess;
        this.initOrder = providerInfo.initOrder;
        this.flags = providerInfo.flags;
        this.isSyncable = providerInfo.isSyncable;
    }

    /*
     * Enabled aggressive block sorting
     */
    private ProviderInfo(Parcel parcel) {
        boolean bl = true;
        super(parcel);
        this.authority = null;
        this.readPermission = null;
        this.writePermission = null;
        this.grantUriPermissions = false;
        this.uriPermissionPatterns = null;
        this.pathPermissions = null;
        this.multiprocess = false;
        this.initOrder = 0;
        this.flags = 0;
        this.isSyncable = false;
        this.authority = parcel.readString();
        this.readPermission = parcel.readString();
        this.writePermission = parcel.readString();
        boolean bl2 = parcel.readInt() != 0 ? bl : false;
        this.grantUriPermissions = bl2;
        this.uriPermissionPatterns = parcel.createTypedArray(PatternMatcher.CREATOR);
        this.pathPermissions = parcel.createTypedArray(PathPermission.CREATOR);
        boolean bl3 = parcel.readInt() != 0 ? bl : false;
        this.multiprocess = bl3;
        this.initOrder = parcel.readInt();
        this.flags = parcel.readInt();
        if (parcel.readInt() == 0) {
            bl = false;
        }
        this.isSyncable = bl;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public void dump(Printer printer, String string2) {
        super.dumpFront(printer, string2);
        printer.println(string2 + "authority=" + this.authority);
        printer.println(string2 + "flags=0x" + Integer.toHexString(this.flags));
    }

    public String toString() {
        return "ContentProviderInfo{name=" + this.authority + " className=" + this.name + "}";
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void writeToParcel(Parcel parcel, int n) {
        int n2 = 1;
        super.writeToParcel(parcel, n);
        parcel.writeString(this.authority);
        parcel.writeString(this.readPermission);
        parcel.writeString(this.writePermission);
        int n3 = this.grantUriPermissions ? n2 : 0;
        parcel.writeInt(n3);
        parcel.writeTypedArray(this.uriPermissionPatterns, n);
        parcel.writeTypedArray(this.pathPermissions, n);
        int n4 = this.multiprocess ? n2 : 0;
        parcel.writeInt(n4);
        parcel.writeInt(this.initOrder);
        parcel.writeInt(this.flags);
        if (!this.isSyncable) {
            n2 = 0;
        }
        parcel.writeInt(n2);
    }
}

