/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm;

import android.os.Parcel;
import android.os.Parcelable;
import com.android.internal.util.ArrayUtils;
import java.io.ByteArrayInputStream;
import java.lang.ref.SoftReference;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Arrays;

public class Signature
implements Parcelable {
    public static final Parcelable.Creator<Signature> CREATOR = new Parcelable.Creator<Signature>(){

        @Override
        public Signature createFromParcel(Parcel parcel) {
            return new Signature(parcel);
        }

        public Signature[] newArray(int n) {
            return new Signature[n];
        }
    };
    private Certificate[] mCertificateChain;
    private int mHashCode;
    private boolean mHaveHashCode;
    private final byte[] mSignature;
    private SoftReference<String> mStringRef;

    private Signature(Parcel parcel) {
        this.mSignature = parcel.createByteArray();
    }

    public Signature(String string2) {
        byte[] byArray = string2.getBytes();
        int n = byArray.length;
        if (n % 2 != 0) {
            throw new IllegalArgumentException("text size " + n + " is not even");
        }
        byte[] byArray2 = new byte[n / 2];
        int n2 = 0;
        int n3 = 0;
        while (n2 < n) {
            int n4 = n2 + 1;
            int n5 = Signature.parseHexDigit(byArray[n2]);
            n2 = n4 + 1;
            int n6 = Signature.parseHexDigit(byArray[n4]);
            int n7 = n3 + 1;
            byArray2[n3] = (byte)(n6 | n5 << 4);
            n3 = n7;
        }
        this.mSignature = byArray2;
    }

    public Signature(byte[] byArray) {
        this.mSignature = (byte[])byArray.clone();
        this.mCertificateChain = null;
    }

    public Signature(Certificate[] certificateArray) throws CertificateEncodingException {
        this.mSignature = certificateArray[0].getEncoded();
        if (certificateArray.length > 1) {
            this.mCertificateChain = Arrays.copyOfRange(certificateArray, 1, certificateArray.length);
        }
    }

    public static boolean areEffectiveMatch(Signature[] signatureArray, Signature[] signatureArray2) throws CertificateException {
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        Signature[] signatureArray3 = new Signature[signatureArray.length];
        for (int i = 0; i < signatureArray.length; ++i) {
            signatureArray3[i] = Signature.bounce(certificateFactory, signatureArray[i]);
        }
        Signature[] signatureArray4 = new Signature[signatureArray2.length];
        for (int i = 0; i < signatureArray2.length; ++i) {
            signatureArray4[i] = Signature.bounce(certificateFactory, signatureArray2[i]);
        }
        return Signature.areExactMatch(signatureArray3, signatureArray4);
    }

    public static boolean areExactMatch(Signature[] signatureArray, Signature[] signatureArray2) {
        return signatureArray.length == signatureArray2.length && ArrayUtils.containsAll(signatureArray, signatureArray2) && ArrayUtils.containsAll(signatureArray2, signatureArray);
    }

    public static Signature bounce(CertificateFactory certificateFactory, Signature signature) throws CertificateException {
        Signature signature2 = new Signature(((X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(signature.mSignature))).getEncoded());
        if (Math.abs(signature2.mSignature.length - signature.mSignature.length) > 2) {
            throw new CertificateException("Bounced cert length looks fishy; before " + signature.mSignature.length + ", after " + signature2.mSignature.length);
        }
        return signature2;
    }

    private static final int parseHexDigit(int n) {
        if (48 <= n && n <= 57) {
            return n - 48;
        }
        if (97 <= n && n <= 102) {
            return 10 + (n - 97);
        }
        if (65 <= n && n <= 70) {
            return 10 + (n - 65);
        }
        throw new IllegalArgumentException("Invalid character " + n + " in hex string");
    }

    @Override
    public int describeContents() {
        return 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        Signature signature;
        boolean bl = false;
        if (object == null) return bl;
        try {
            signature = (Signature)object;
            if (this == signature) return true;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        boolean bl2 = Arrays.equals(this.mSignature, signature.mSignature);
        bl = false;
        if (!bl2) return bl;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    public Signature[] getChainSignatures() throws CertificateEncodingException {
        Signature[] signatureArray;
        if (this.mCertificateChain == null) {
            signatureArray = new Signature[]{this};
            return signatureArray;
        } else {
            signatureArray = new Signature[1 + this.mCertificateChain.length];
            signatureArray[0] = this;
            Certificate[] certificateArray = this.mCertificateChain;
            int n = certificateArray.length;
            int n2 = 1;
            for (int i = 0; i < n; ++i) {
                Certificate certificate = certificateArray[i];
                int n3 = n2 + 1;
                signatureArray[n2] = new Signature(certificate.getEncoded());
                n2 = n3;
            }
        }
        return signatureArray;
    }

    public PublicKey getPublicKey() throws CertificateException {
        return CertificateFactory.getInstance("X.509").generateCertificate(new ByteArrayInputStream(this.mSignature)).getPublicKey();
    }

    public int hashCode() {
        if (this.mHaveHashCode) {
            return this.mHashCode;
        }
        this.mHashCode = Arrays.hashCode(this.mSignature);
        this.mHaveHashCode = true;
        return this.mHashCode;
    }

    public byte[] toByteArray() {
        byte[] byArray = new byte[this.mSignature.length];
        System.arraycopy((byte[])this.mSignature, (int)0, (byte[])byArray, (int)0, (int)this.mSignature.length);
        return byArray;
    }

    public char[] toChars() {
        return this.toChars(null, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    public char[] toChars(char[] cArray, int[] nArray) {
        byte[] byArray = this.mSignature;
        int n = byArray.length;
        int n2 = n * 2;
        char[] cArray2 = cArray == null || n2 > cArray.length ? new char[n2] : cArray;
        for (int i = 0; i < n; ++i) {
            byte by = byArray[i];
            int n3 = 0xF & by >> 4;
            int n4 = i * 2;
            int n5 = n3 >= 10 ? -10 + (n3 + 97) : n3 + 48;
            cArray2[n4] = (char)n5;
            int n6 = by & 0xF;
            int n7 = 1 + i * 2;
            int n8 = n6 >= 10 ? -10 + (n6 + 97) : n6 + 48;
            cArray2[n7] = (char)n8;
        }
        if (nArray != null) {
            nArray[0] = n;
        }
        return cArray2;
    }

    /*
     * Enabled aggressive block sorting
     */
    public String toCharsString() {
        String string2 = this.mStringRef == null ? null : (String)this.mStringRef.get();
        if (string2 != null) {
            return string2;
        }
        String string3 = new String(this.toChars());
        this.mStringRef = new SoftReference<String>(string3);
        return string3;
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeByteArray(this.mSignature);
    }
}

