/*
 * Decompiled with CFR 0.152.
 */
package android.database;

import android.database.CursorWindow;
import android.database.DatabaseUtils;
import android.database.IBulkCursor;
import android.database.IContentObserver;
import android.os.Bundle;
import android.os.IBinder;
import android.os.Parcel;
import android.os.RemoteException;

final class BulkCursorProxy
implements IBulkCursor {
    private Bundle mExtras;
    private IBinder mRemote;

    public BulkCursorProxy(IBinder iBinder) {
        this.mRemote = iBinder;
        this.mExtras = null;
    }

    @Override
    public IBinder asBinder() {
        return this.mRemote;
    }

    @Override
    public void close() throws RemoteException {
        Parcel parcel = Parcel.obtain();
        Parcel parcel2 = Parcel.obtain();
        try {
            parcel.writeInterfaceToken("android.content.IBulkCursor");
            this.mRemote.transact(7, parcel, parcel2, 0);
            DatabaseUtils.readExceptionFromParcel(parcel2);
            return;
        }
        finally {
            parcel.recycle();
            parcel2.recycle();
        }
    }

    @Override
    public void deactivate() throws RemoteException {
        Parcel parcel = Parcel.obtain();
        Parcel parcel2 = Parcel.obtain();
        try {
            parcel.writeInterfaceToken("android.content.IBulkCursor");
            this.mRemote.transact(2, parcel, parcel2, 0);
            DatabaseUtils.readExceptionFromParcel(parcel2);
            return;
        }
        finally {
            parcel.recycle();
            parcel2.recycle();
        }
    }

    @Override
    public Bundle getExtras() throws RemoteException {
        Parcel parcel;
        Parcel parcel2;
        if (this.mExtras == null) {
            parcel2 = Parcel.obtain();
            parcel = Parcel.obtain();
            parcel2.writeInterfaceToken("android.content.IBulkCursor");
            this.mRemote.transact(5, parcel2, parcel, 0);
            DatabaseUtils.readExceptionFromParcel(parcel);
            this.mExtras = parcel.readBundle();
        }
        return this.mExtras;
        finally {
            parcel2.recycle();
            parcel.recycle();
        }
    }

    @Override
    public CursorWindow getWindow(int n) throws RemoteException {
        CursorWindow cursorWindow;
        Parcel parcel;
        Parcel parcel2;
        block3: {
            CursorWindow cursorWindow2;
            parcel2 = Parcel.obtain();
            parcel = Parcel.obtain();
            try {
                parcel2.writeInterfaceToken("android.content.IBulkCursor");
                parcel2.writeInt(n);
                this.mRemote.transact(1, parcel2, parcel, 0);
                DatabaseUtils.readExceptionFromParcel(parcel);
                int n2 = parcel.readInt();
                cursorWindow = null;
                if (n2 != 1) break block3;
            }
            catch (Throwable throwable) {
                parcel2.recycle();
                parcel.recycle();
                throw throwable;
            }
            cursorWindow = cursorWindow2 = CursorWindow.newFromParcel(parcel);
        }
        parcel2.recycle();
        parcel.recycle();
        return cursorWindow;
    }

    @Override
    public void onMove(int n) throws RemoteException {
        Parcel parcel = Parcel.obtain();
        Parcel parcel2 = Parcel.obtain();
        try {
            parcel.writeInterfaceToken("android.content.IBulkCursor");
            parcel.writeInt(n);
            this.mRemote.transact(4, parcel, parcel2, 0);
            DatabaseUtils.readExceptionFromParcel(parcel2);
            return;
        }
        finally {
            parcel.recycle();
            parcel2.recycle();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int requery(IContentObserver iContentObserver) throws RemoteException {
        Parcel parcel;
        Parcel parcel2;
        block5: {
            parcel2 = Parcel.obtain();
            parcel = Parcel.obtain();
            parcel2.writeInterfaceToken("android.content.IBulkCursor");
            parcel2.writeStrongInterface(iContentObserver);
            boolean bl = this.mRemote.transact(3, parcel2, parcel, 0);
            DatabaseUtils.readExceptionFromParcel(parcel);
            if (bl) break block5;
            return -1;
        }
        try {
            int n = parcel.readInt();
            this.mExtras = parcel.readBundle();
            return n;
        }
        finally {
            parcel2.recycle();
            parcel.recycle();
        }
    }

    @Override
    public Bundle respond(Bundle bundle) throws RemoteException {
        Parcel parcel = Parcel.obtain();
        Parcel parcel2 = Parcel.obtain();
        try {
            parcel.writeInterfaceToken("android.content.IBulkCursor");
            parcel.writeBundle(bundle);
            this.mRemote.transact(6, parcel, parcel2, 0);
            DatabaseUtils.readExceptionFromParcel(parcel2);
            Bundle bundle2 = parcel2.readBundle();
            return bundle2;
        }
        finally {
            parcel.recycle();
            parcel2.recycle();
        }
    }
}

