/*
 * Decompiled with CFR 0.152.
 */
package android.database.sqlite;

import android.database.DatabaseUtils;
import android.database.sqlite.SQLiteClosable;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteSession;
import android.database.sqlite.SQLiteStatementInfo;
import android.os.CancellationSignal;
import java.util.Arrays;

public abstract class SQLiteProgram
extends SQLiteClosable {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private final Object[] mBindArgs;
    private final String[] mColumnNames;
    private final SQLiteDatabase mDatabase;
    private final int mNumParameters;
    private final boolean mReadOnly;
    private final String mSql;

    /*
     * Enabled aggressive block sorting
     */
    SQLiteProgram(SQLiteDatabase sQLiteDatabase, String string2, Object[] objectArray, CancellationSignal cancellationSignal) {
        block7: {
            boolean bl;
            block6: {
                bl = true;
                this.mDatabase = sQLiteDatabase;
                this.mSql = string2.trim();
                boolean bl2 = DatabaseUtils.getSqlStatementType(this.mSql);
                switch (bl2) {
                    default: {
                        if (bl2 != bl) break;
                        break block6;
                    }
                    case 4: 
                    case 5: 
                    case 6: {
                        this.mReadOnly = false;
                        this.mColumnNames = EMPTY_STRING_ARRAY;
                        this.mNumParameters = 0;
                        break block7;
                    }
                }
                bl = false;
            }
            SQLiteStatementInfo sQLiteStatementInfo = new SQLiteStatementInfo();
            sQLiteDatabase.getThreadSession().prepare(this.mSql, sQLiteDatabase.getThreadDefaultConnectionFlags(bl), cancellationSignal, sQLiteStatementInfo);
            this.mReadOnly = sQLiteStatementInfo.readOnly;
            this.mColumnNames = sQLiteStatementInfo.columnNames;
            this.mNumParameters = sQLiteStatementInfo.numParameters;
        }
        if (objectArray != null && objectArray.length > this.mNumParameters) {
            throw new IllegalArgumentException("Too many bind arguments.  " + objectArray.length + " arguments were provided but the statement needs " + this.mNumParameters + " arguments.");
        }
        if (this.mNumParameters == 0) {
            this.mBindArgs = null;
            return;
        }
        this.mBindArgs = new Object[this.mNumParameters];
        if (objectArray != null) {
            System.arraycopy(objectArray, 0, this.mBindArgs, 0, objectArray.length);
        }
    }

    private void bind(int n, Object object) {
        if (n < 1 || n > this.mNumParameters) {
            throw new IllegalArgumentException("Cannot bind argument at index " + n + " because the index is out of range.  " + "The statement has " + this.mNumParameters + " parameters.");
        }
        this.mBindArgs[n - 1] = object;
    }

    public void bindAllArgsAsStrings(String[] stringArray) {
        if (stringArray != null) {
            for (int i = stringArray.length; i != 0; --i) {
                this.bindString(i, stringArray[i - 1]);
            }
        }
    }

    public void bindBlob(int n, byte[] byArray) {
        if (byArray == null) {
            throw new IllegalArgumentException("the bind value at index " + n + " is null");
        }
        this.bind(n, byArray);
    }

    public void bindDouble(int n, double d) {
        this.bind(n, d);
    }

    public void bindLong(int n, long l) {
        this.bind(n, l);
    }

    public void bindNull(int n) {
        this.bind(n, null);
    }

    public void bindString(int n, String string2) {
        if (string2 == null) {
            throw new IllegalArgumentException("the bind value at index " + n + " is null");
        }
        this.bind(n, string2);
    }

    public void clearBindings() {
        if (this.mBindArgs != null) {
            Arrays.fill(this.mBindArgs, null);
        }
    }

    final Object[] getBindArgs() {
        return this.mBindArgs;
    }

    final String[] getColumnNames() {
        return this.mColumnNames;
    }

    protected final int getConnectionFlags() {
        return this.mDatabase.getThreadDefaultConnectionFlags(this.mReadOnly);
    }

    final SQLiteDatabase getDatabase() {
        return this.mDatabase;
    }

    protected final SQLiteSession getSession() {
        return this.mDatabase.getThreadSession();
    }

    final String getSql() {
        return this.mSql;
    }

    @Deprecated
    public final int getUniqueId() {
        return -1;
    }

    @Override
    protected void onAllReferencesReleased() {
        this.clearBindings();
    }

    protected final void onCorruption() {
        this.mDatabase.onCorruption();
    }
}

