/*
 * Decompiled with CFR 0.152.
 */
package android.filterfw.core;

import android.filterfw.core.KeyValueMap;
import android.filterfw.core.MutableFrameFormat;
import java.util.Arrays;
import java.util.Map;

public class FrameFormat {
    public static final int BYTES_PER_SAMPLE_UNSPECIFIED = 1;
    protected static final int SIZE_UNKNOWN = -1;
    public static final int SIZE_UNSPECIFIED = 0;
    public static final int TARGET_GPU = 3;
    public static final int TARGET_NATIVE = 2;
    public static final int TARGET_RS = 5;
    public static final int TARGET_SIMPLE = 1;
    public static final int TARGET_UNSPECIFIED = 0;
    public static final int TARGET_VERTEXBUFFER = 4;
    public static final int TYPE_BIT = 1;
    public static final int TYPE_BYTE = 2;
    public static final int TYPE_DOUBLE = 6;
    public static final int TYPE_FLOAT = 5;
    public static final int TYPE_INT16 = 3;
    public static final int TYPE_INT32 = 4;
    public static final int TYPE_OBJECT = 8;
    public static final int TYPE_POINTER = 7;
    public static final int TYPE_UNSPECIFIED;
    protected int mBaseType = 0;
    protected int mBytesPerSample = 1;
    protected int[] mDimensions;
    protected KeyValueMap mMetaData;
    protected Class mObjectClass;
    protected int mSize = -1;
    protected int mTarget = 0;

    protected FrameFormat() {
    }

    public FrameFormat(int n, int n2) {
        this.mBaseType = n;
        this.mTarget = n2;
        this.initDefaults();
    }

    public static String baseTypeToString(int n) {
        switch (n) {
            default: {
                return "unknown";
            }
            case 0: {
                return "unspecified";
            }
            case 1: {
                return "bit";
            }
            case 2: {
                return "byte";
            }
            case 3: {
                return "int";
            }
            case 4: {
                return "int";
            }
            case 5: {
                return "float";
            }
            case 6: {
                return "double";
            }
            case 7: {
                return "pointer";
            }
            case 8: 
        }
        return "object";
    }

    public static int bytesPerSampleOf(int n) {
        switch (n) {
            default: {
                return 1;
            }
            case 3: {
                return 2;
            }
            case 4: 
            case 5: 
            case 7: {
                return 4;
            }
            case 6: 
        }
        return 8;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String dimensionsToString(int[] nArray) {
        StringBuffer stringBuffer = new StringBuffer();
        if (nArray != null) {
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                if (nArray[i] == 0) {
                    stringBuffer.append("[]");
                    continue;
                }
                stringBuffer.append("[" + String.valueOf(nArray[i]) + "]");
            }
        }
        return stringBuffer.toString();
    }

    private void initDefaults() {
        this.mBytesPerSample = FrameFormat.bytesPerSampleOf(this.mBaseType);
    }

    public static String metaDataToString(KeyValueMap keyValueMap) {
        if (keyValueMap == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{ ");
        for (Map.Entry entry : keyValueMap.entrySet()) {
            stringBuffer.append((String)entry.getKey() + ": " + entry.getValue() + " ");
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public static int readTargetString(String string2) {
        if (string2.equalsIgnoreCase("CPU") || string2.equalsIgnoreCase("NATIVE")) {
            return 2;
        }
        if (string2.equalsIgnoreCase("GPU")) {
            return 3;
        }
        if (string2.equalsIgnoreCase("SIMPLE")) {
            return 1;
        }
        if (string2.equalsIgnoreCase("VERTEXBUFFER")) {
            return 4;
        }
        if (string2.equalsIgnoreCase("UNSPECIFIED")) {
            return 0;
        }
        throw new RuntimeException("Unknown target type '" + string2 + "'!");
    }

    public static String targetToString(int n) {
        switch (n) {
            default: {
                return "unknown";
            }
            case 0: {
                return "unspecified";
            }
            case 1: {
                return "simple";
            }
            case 2: {
                return "native";
            }
            case 3: {
                return "gpu";
            }
            case 4: {
                return "vbo";
            }
            case 5: 
        }
        return "renderscript";
    }

    public static FrameFormat unspecified() {
        return new FrameFormat(0, 0);
    }

    int calcSize(int[] nArray) {
        int n;
        if (nArray != null && nArray.length > 0) {
            n = this.getBytesPerSample();
            int n2 = nArray.length;
            for (int i = 0; i < n2; ++i) {
                n *= nArray[i];
            }
        } else {
            n = 0;
        }
        return n;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean equals(Object object) {
        block5: {
            block4: {
                if (this == object) break block4;
                if (!(object instanceof FrameFormat)) {
                    return false;
                }
                FrameFormat frameFormat = (FrameFormat)object;
                if (frameFormat.mBaseType != this.mBaseType || frameFormat.mTarget != this.mTarget || frameFormat.mBytesPerSample != this.mBytesPerSample || !Arrays.equals(frameFormat.mDimensions, this.mDimensions) || !frameFormat.mMetaData.equals(this.mMetaData)) break block5;
            }
            return true;
        }
        return false;
    }

    public int getBaseType() {
        return this.mBaseType;
    }

    public int getBytesPerSample() {
        return this.mBytesPerSample;
    }

    public int getDepth() {
        if (this.mDimensions != null && this.mDimensions.length >= 3) {
            return this.mDimensions[2];
        }
        return -1;
    }

    public int getDimension(int n) {
        return this.mDimensions[n];
    }

    public int getDimensionCount() {
        if (this.mDimensions == null) {
            return 0;
        }
        return this.mDimensions.length;
    }

    public int[] getDimensions() {
        return this.mDimensions;
    }

    public int getHeight() {
        if (this.mDimensions != null && this.mDimensions.length >= 2) {
            return this.mDimensions[1];
        }
        return -1;
    }

    public int getLength() {
        if (this.mDimensions != null && this.mDimensions.length >= 1) {
            return this.mDimensions[0];
        }
        return -1;
    }

    public Object getMetaValue(String string2) {
        if (this.mMetaData != null) {
            return this.mMetaData.get(string2);
        }
        return null;
    }

    public int getNumberOfDimensions() {
        if (this.mDimensions != null) {
            return this.mDimensions.length;
        }
        return 0;
    }

    public Class getObjectClass() {
        return this.mObjectClass;
    }

    public int getSize() {
        if (this.mSize == -1) {
            this.mSize = this.calcSize(this.mDimensions);
        }
        return this.mSize;
    }

    public int getTarget() {
        return this.mTarget;
    }

    public int getValuesPerSample() {
        return this.mBytesPerSample / FrameFormat.bytesPerSampleOf(this.mBaseType);
    }

    public int getWidth() {
        return this.getLength();
    }

    public boolean hasMetaKey(String string2) {
        if (this.mMetaData != null) {
            return this.mMetaData.containsKey(string2);
        }
        return false;
    }

    public boolean hasMetaKey(String string2, Class clazz) {
        if (this.mMetaData != null && this.mMetaData.containsKey(string2)) {
            if (!clazz.isAssignableFrom(this.mMetaData.get(string2).getClass())) {
                throw new RuntimeException("FrameFormat meta-key '" + string2 + "' is of type " + this.mMetaData.get(string2).getClass() + " but expected to be of type " + clazz + "!");
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return 0x1073 ^ this.mBaseType ^ this.mBytesPerSample ^ this.getSize();
    }

    public boolean isBinaryDataType() {
        return this.mBaseType >= 1 && this.mBaseType <= 6;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean isCompatibleWith(FrameFormat frameFormat) {
        if (frameFormat.getBaseType() != 0 && this.getBaseType() != frameFormat.getBaseType() || frameFormat.getTarget() != 0 && this.getTarget() != frameFormat.getTarget() || frameFormat.getBytesPerSample() != 1 && this.getBytesPerSample() != frameFormat.getBytesPerSample() || frameFormat.getDimensionCount() > 0 && this.getDimensionCount() != frameFormat.getDimensionCount()) return false;
        for (int i = 0; i < frameFormat.getDimensionCount(); ++i) {
            int n = frameFormat.getDimension(i);
            if (n != 0 && this.getDimension(i) != n) return false;
        }
        if (frameFormat.getObjectClass() != null && (this.getObjectClass() == null || !frameFormat.getObjectClass().isAssignableFrom(this.getObjectClass()))) return false;
        if (frameFormat.mMetaData == null) return true;
        for (String string2 : frameFormat.mMetaData.keySet()) {
            if (this.mMetaData == null || !this.mMetaData.containsKey(string2)) {
                return false;
            }
            if (this.mMetaData.get(string2).equals(frameFormat.mMetaData.get(string2))) continue;
            return false;
        }
        return true;
    }

    boolean isReplaceableBy(FrameFormat frameFormat) {
        return this.mTarget == frameFormat.mTarget && this.getSize() == frameFormat.getSize() && Arrays.equals(frameFormat.mDimensions, this.mDimensions);
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean mayBeCompatibleWith(FrameFormat frameFormat) {
        if (frameFormat.getBaseType() != 0 && this.getBaseType() != 0 && this.getBaseType() != frameFormat.getBaseType() || frameFormat.getTarget() != 0 && this.getTarget() != 0 && this.getTarget() != frameFormat.getTarget() || frameFormat.getBytesPerSample() != 1 && this.getBytesPerSample() != 1 && this.getBytesPerSample() != frameFormat.getBytesPerSample() || frameFormat.getDimensionCount() > 0 && this.getDimensionCount() > 0 && this.getDimensionCount() != frameFormat.getDimensionCount()) return false;
        for (int i = 0; i < frameFormat.getDimensionCount(); ++i) {
            int n = frameFormat.getDimension(i);
            if (n != 0 && this.getDimension(i) != 0 && this.getDimension(i) != n) return false;
        }
        if (frameFormat.getObjectClass() != null && this.getObjectClass() != null && !frameFormat.getObjectClass().isAssignableFrom(this.getObjectClass())) {
            return false;
        }
        if (frameFormat.mMetaData == null || this.mMetaData == null) return true;
        for (String string2 : frameFormat.mMetaData.keySet()) {
            if (!this.mMetaData.containsKey(string2) || this.mMetaData.get(string2).equals(frameFormat.mMetaData.get(string2))) continue;
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    public MutableFrameFormat mutableCopy() {
        MutableFrameFormat mutableFrameFormat = new MutableFrameFormat();
        mutableFrameFormat.setBaseType(this.getBaseType());
        mutableFrameFormat.setTarget(this.getTarget());
        mutableFrameFormat.setBytesPerSample(this.getBytesPerSample());
        mutableFrameFormat.setDimensions(this.getDimensions());
        mutableFrameFormat.setObjectClass(this.getObjectClass());
        KeyValueMap keyValueMap = this.mMetaData == null ? null : (KeyValueMap)this.mMetaData.clone();
        mutableFrameFormat.mMetaData = keyValueMap;
        return mutableFrameFormat;
    }

    /*
     * Enabled aggressive block sorting
     */
    public String toString() {
        String string2;
        int n = this.getValuesPerSample();
        String string3 = n == 1 ? "" : String.valueOf(n);
        String string4 = this.mTarget == 0 ? "" : FrameFormat.targetToString(this.mTarget) + " ";
        if (this.mObjectClass == null) {
            string2 = "";
            return string4 + FrameFormat.baseTypeToString(this.mBaseType) + string3 + FrameFormat.dimensionsToString(this.mDimensions) + string2 + FrameFormat.metaDataToString(this.mMetaData);
        }
        string2 = " class(" + this.mObjectClass.getSimpleName() + ") ";
        return string4 + FrameFormat.baseTypeToString(this.mBaseType) + string3 + FrameFormat.dimensionsToString(this.mDimensions) + string2 + FrameFormat.metaDataToString(this.mMetaData);
    }
}

