/*
 * Decompiled with CFR 0.152.
 */
package android.filterfw.core;

import android.filterfw.core.Filter;
import android.filterfw.core.FilterContext;
import android.filterfw.core.Frame;
import android.filterfw.core.InputPort;

public class StreamPort
extends InputPort {
    private Frame mFrame;
    private boolean mPersistent;

    public StreamPort(Filter filter, String string2) {
        super(filter, string2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void assignFrame(Frame frame, boolean bl) {
        synchronized (this) {
            this.assertPortIsOpen();
            this.checkFrameType(frame, bl);
            if (bl) {
                if (this.mFrame != null) {
                    this.mFrame.release();
                }
            } else if (this.mFrame != null) {
                throw new RuntimeException("Attempting to push more than one frame on port: " + this + "!");
            }
            this.mFrame = frame.retain();
            this.mFrame.markReadOnly();
            this.mPersistent = bl;
            return;
        }
    }

    @Override
    public void clear() {
        if (this.mFrame != null) {
            this.mFrame.release();
            this.mFrame = null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean hasFrame() {
        synchronized (this) {
            Frame frame = this.mFrame;
            if (frame == null) return false;
            return true;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Frame pullFrame() {
        synchronized (this) {
            if (this.mFrame == null) {
                throw new RuntimeException("No frame available to pull on port: " + this + "!");
            }
            Frame frame = this.mFrame;
            if (this.mPersistent) {
                this.mFrame.retain();
            } else {
                this.mFrame = null;
            }
            return frame;
        }
    }

    @Override
    public void pushFrame(Frame frame) {
        this.assignFrame(frame, false);
    }

    @Override
    public void setFrame(Frame frame) {
        this.assignFrame(frame, true);
    }

    @Override
    public String toString() {
        return "input " + super.toString();
    }

    @Override
    public void transfer(FilterContext filterContext) {
        synchronized (this) {
            if (this.mFrame != null) {
                this.checkFrameManager(this.mFrame, filterContext);
            }
            return;
        }
    }
}

