/*
 * Decompiled with CFR 0.152.
 */
package android.filterpacks.base;

import android.filterfw.core.Filter;
import android.filterfw.core.FilterContext;
import android.filterfw.core.Frame;
import android.filterfw.core.FrameFormat;
import android.filterfw.core.GenerateFieldPort;
import android.filterfw.core.GenerateFinalPort;
import android.filterfw.core.MutableFrameFormat;
import android.filterfw.format.PrimitiveFormat;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public class InputStreamSource
extends Filter {
    @GenerateFieldPort(name="stream")
    private InputStream mInputStream;
    @GenerateFinalPort(hasDefault=true, name="format")
    private MutableFrameFormat mOutputFormat = null;
    @GenerateFinalPort(name="target")
    private String mTarget;

    public InputStreamSource(String string2) {
        super(string2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void process(FilterContext filterContext) {
        Frame frame;
        int n = 0;
        try {
            int n2;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray = new byte[1024];
            while ((n2 = this.mInputStream.read(byArray)) > 0) {
                byteArrayOutputStream.write(byArray, 0, n2);
                n += n2;
            }
            ByteBuffer byteBuffer = ByteBuffer.wrap(byteArrayOutputStream.toByteArray());
            this.mOutputFormat.setDimensions(n);
            frame = filterContext.getFrameManager().newFrame(this.mOutputFormat);
            frame.setData(byteBuffer);
        }
        catch (IOException iOException) {
            throw new RuntimeException("InputStreamSource: Could not read stream: " + iOException.getMessage() + "!");
        }
        this.pushOutput("data", frame);
        frame.release();
        this.closeOutputPort("data");
    }

    @Override
    public void setupPorts() {
        int n = FrameFormat.readTargetString(this.mTarget);
        if (this.mOutputFormat == null) {
            this.mOutputFormat = PrimitiveFormat.createByteFormat(n);
        }
        this.addOutputPort("data", this.mOutputFormat);
    }
}

