/*
 * Decompiled with CFR 0.152.
 */
package android.filterpacks.ui;

import android.filterfw.core.Filter;
import android.filterfw.core.FilterContext;
import android.filterfw.core.Frame;
import android.filterfw.core.GLEnvironment;
import android.filterfw.core.GLFrame;
import android.filterfw.core.GenerateFieldPort;
import android.filterfw.core.GenerateFinalPort;
import android.filterfw.core.MutableFrameFormat;
import android.filterfw.core.ShaderProgram;
import android.filterfw.format.ImageFormat;
import android.util.Log;
import android.view.Surface;

public class SurfaceTargetFilter
extends Filter {
    private static final String TAG = "SurfaceRenderFilter";
    private final int RENDERMODE_FILL_CROP;
    private final int RENDERMODE_FIT;
    private final int RENDERMODE_STRETCH;
    private float mAspectRatio = 1.0f;
    private GLEnvironment mGlEnv;
    private boolean mLogVerbose = Log.isLoggable("SurfaceRenderFilter", 2);
    private ShaderProgram mProgram;
    private int mRenderMode = 1;
    @GenerateFieldPort(hasDefault=true, name="renderMode")
    private String mRenderModeString;
    private GLFrame mScreen;
    @GenerateFieldPort(name="oheight")
    private int mScreenHeight;
    @GenerateFieldPort(name="owidth")
    private int mScreenWidth;
    @GenerateFinalPort(name="surface")
    private Surface mSurface;
    private int mSurfaceId = -1;

    public SurfaceTargetFilter(String string2) {
        super(string2);
        this.RENDERMODE_STRETCH = 0;
        this.RENDERMODE_FIT = 1;
        this.RENDERMODE_FILL_CROP = 2;
    }

    private void registerSurface() {
        this.mSurfaceId = this.mGlEnv.registerSurface(this.mSurface);
        if (this.mSurfaceId < 0) {
            throw new RuntimeException("Could not register Surface: " + this.mSurface);
        }
    }

    private void unregisterSurface() {
        if (this.mSurfaceId > 0) {
            this.mGlEnv.unregisterSurfaceId(this.mSurfaceId);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void updateTargetRect() {
        if (this.mScreenWidth <= 0 || this.mScreenHeight <= 0 || this.mProgram == null) return;
        float f = (float)this.mScreenWidth / (float)this.mScreenHeight / this.mAspectRatio;
        switch (this.mRenderMode) {
            default: {
                return;
            }
            case 0: {
                this.mProgram.setTargetRect(0.0f, 0.0f, 1.0f, 1.0f);
                return;
            }
            case 1: {
                if (f > 1.0f) {
                    this.mProgram.setTargetRect(0.5f - 0.5f / f, 0.0f, 1.0f / f, 1.0f);
                    return;
                }
                this.mProgram.setTargetRect(0.0f, 0.5f - 0.5f * f, 1.0f, f);
                return;
            }
            case 2: 
        }
        if (f > 1.0f) {
            this.mProgram.setTargetRect(0.0f, 0.5f - 0.5f * f, 1.0f, f);
            return;
        }
        this.mProgram.setTargetRect(0.5f - 0.5f / f, 0.0f, 1.0f / f, 1.0f);
    }

    @Override
    public void close(FilterContext filterContext) {
        this.unregisterSurface();
    }

    @Override
    public void fieldPortValueUpdated(String string2, FilterContext filterContext) {
        this.mScreen.setViewport(0, 0, this.mScreenWidth, this.mScreenHeight);
        this.updateTargetRect();
    }

    @Override
    public void open(FilterContext filterContext) {
        this.registerSurface();
    }

    @Override
    public void prepare(FilterContext filterContext) {
        this.mGlEnv = filterContext.getGLEnvironment();
        this.mProgram = ShaderProgram.createIdentity(filterContext);
        this.mProgram.setSourceRect(0.0f, 1.0f, 1.0f, -1.0f);
        this.mProgram.setClearsOutput(true);
        this.mProgram.setClearColor(0.0f, 0.0f, 0.0f);
        MutableFrameFormat mutableFrameFormat = ImageFormat.create(this.mScreenWidth, this.mScreenHeight, 3, 3);
        this.mScreen = (GLFrame)filterContext.getFrameManager().newBoundFrame(mutableFrameFormat, 101, 0L);
        this.updateRenderMode();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void process(FilterContext filterContext) {
        boolean bl;
        Frame frame;
        Frame frame2;
        float f;
        if (this.mLogVerbose) {
            Log.v(TAG, "Starting frame processing");
        }
        if ((f = (float)(frame2 = this.pullInput("frame")).getFormat().getWidth() / (float)frame2.getFormat().getHeight()) != this.mAspectRatio) {
            if (this.mLogVerbose) {
                Log.v(TAG, "New aspect ratio: " + f + ", previously: " + this.mAspectRatio);
            }
            this.mAspectRatio = f;
            this.updateTargetRect();
        }
        if (this.mLogVerbose) {
            Log.v(TAG, "Got input format: " + frame2.getFormat());
        }
        if (frame2.getFormat().getTarget() != 3) {
            frame = filterContext.getFrameManager().duplicateFrameToTarget(frame2, 3);
            bl = true;
        } else {
            frame = frame2;
            bl = false;
        }
        this.mGlEnv.activateSurfaceWithId(this.mSurfaceId);
        this.mProgram.process(frame, (Frame)this.mScreen);
        this.mGlEnv.swapBuffers();
        if (bl) {
            frame.release();
        }
    }

    @Override
    public void setupPorts() {
        if (this.mSurface == null) {
            throw new RuntimeException("NULL Surface passed to SurfaceTargetFilter");
        }
        this.addMaskedInputPort("frame", ImageFormat.create(3));
    }

    @Override
    public void tearDown(FilterContext filterContext) {
        if (this.mScreen != null) {
            this.mScreen.release();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void updateRenderMode() {
        if (this.mRenderModeString != null) {
            if (this.mRenderModeString.equals("stretch")) {
                this.mRenderMode = 0;
            } else if (this.mRenderModeString.equals("fit")) {
                this.mRenderMode = 1;
            } else {
                if (!this.mRenderModeString.equals("fill_crop")) {
                    throw new RuntimeException("Unknown render mode '" + this.mRenderModeString + "'!");
                }
                this.mRenderMode = 2;
            }
        }
        this.updateTargetRect();
    }
}

