/*
 * Decompiled with CFR 0.152.
 */
package android.filterpacks.videosrc;

import android.filterfw.core.Filter;
import android.filterfw.core.FilterContext;
import android.filterfw.core.Frame;
import android.filterfw.core.GLEnvironment;
import android.filterfw.core.GLFrame;
import android.filterfw.core.GenerateFieldPort;
import android.filterfw.core.GenerateFinalPort;
import android.filterfw.core.MutableFrameFormat;
import android.filterfw.core.ShaderProgram;
import android.filterfw.format.ImageFormat;
import android.filterfw.geometry.Point;
import android.filterfw.geometry.Quad;
import android.graphics.SurfaceTexture;
import android.util.Log;

public class SurfaceTextureTarget
extends Filter {
    private static final String TAG = "SurfaceTextureTarget";
    private final int RENDERMODE_CUSTOMIZE;
    private final int RENDERMODE_FILL_CROP;
    private final int RENDERMODE_FIT;
    private final int RENDERMODE_STRETCH;
    private float mAspectRatio = 1.0f;
    private boolean mLogVerbose;
    private ShaderProgram mProgram;
    private int mRenderMode = 1;
    @GenerateFieldPort(hasDefault=true, name="renderMode")
    private String mRenderModeString;
    private GLFrame mScreen;
    @GenerateFinalPort(name="height")
    private int mScreenHeight;
    @GenerateFinalPort(name="width")
    private int mScreenWidth;
    @GenerateFieldPort(hasDefault=true, name="sourceQuad")
    private Quad mSourceQuad = new Quad(new Point(0.0f, 1.0f), new Point(1.0f, 1.0f), new Point(0.0f, 0.0f), new Point(1.0f, 0.0f));
    private int mSurfaceId;
    @GenerateFinalPort(name="surfaceTexture")
    private SurfaceTexture mSurfaceTexture;
    @GenerateFieldPort(hasDefault=true, name="targetQuad")
    private Quad mTargetQuad = new Quad(new Point(0.0f, 0.0f), new Point(1.0f, 0.0f), new Point(0.0f, 1.0f), new Point(1.0f, 1.0f));

    public SurfaceTextureTarget(String string2) {
        super(string2);
        this.RENDERMODE_STRETCH = 0;
        this.RENDERMODE_FIT = 1;
        this.RENDERMODE_FILL_CROP = 2;
        this.RENDERMODE_CUSTOMIZE = 3;
        this.mLogVerbose = Log.isLoggable(TAG, 2);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void updateTargetRect() {
        float f;
        block17: {
            block16: {
                if (this.mLogVerbose) {
                    Log.v(TAG, "updateTargetRect. Thread: " + Thread.currentThread());
                }
                if (this.mScreenWidth <= 0 || this.mScreenHeight <= 0 || this.mProgram == null) break block16;
                float f2 = (float)this.mScreenWidth / (float)this.mScreenHeight;
                f = f2 / this.mAspectRatio;
                if (this.mLogVerbose) {
                    Log.v(TAG, "UTR. screen w = " + (float)this.mScreenWidth + " x screen h = " + (float)this.mScreenHeight + " Screen AR: " + f2 + ", frame AR: " + this.mAspectRatio + ", relative AR: " + f);
                }
                if (f != 1.0f || this.mRenderMode == 3) break block17;
                this.mProgram.setTargetRect(0.0f, 0.0f, 1.0f, 1.0f);
                this.mProgram.setClearsOutput(false);
            }
            return;
        }
        switch (this.mRenderMode) {
            case 0: {
                this.mTargetQuad.p0.set(0.0f, 0.0f);
                this.mTargetQuad.p1.set(1.0f, 0.0f);
                this.mTargetQuad.p2.set(0.0f, 1.0f);
                this.mTargetQuad.p3.set(1.0f, 1.0f);
                this.mProgram.setClearsOutput(false);
                break;
            }
            case 1: {
                if (f > 1.0f) {
                    this.mTargetQuad.p0.set(0.5f - 0.5f / f, 0.0f);
                    this.mTargetQuad.p1.set(0.5f + 0.5f / f, 0.0f);
                    this.mTargetQuad.p2.set(0.5f - 0.5f / f, 1.0f);
                    this.mTargetQuad.p3.set(0.5f + 0.5f / f, 1.0f);
                } else {
                    this.mTargetQuad.p0.set(0.0f, 0.5f - 0.5f * f);
                    this.mTargetQuad.p1.set(1.0f, 0.5f - 0.5f * f);
                    this.mTargetQuad.p2.set(0.0f, 0.5f + 0.5f * f);
                    this.mTargetQuad.p3.set(1.0f, 0.5f + 0.5f * f);
                }
                this.mProgram.setClearsOutput(true);
                break;
            }
            case 2: {
                if (f > 1.0f) {
                    this.mTargetQuad.p0.set(0.0f, 0.5f - 0.5f * f);
                    this.mTargetQuad.p1.set(1.0f, 0.5f - 0.5f * f);
                    this.mTargetQuad.p2.set(0.0f, 0.5f + 0.5f * f);
                    this.mTargetQuad.p3.set(1.0f, 0.5f + 0.5f * f);
                } else {
                    this.mTargetQuad.p0.set(0.5f - 0.5f / f, 0.0f);
                    this.mTargetQuad.p1.set(0.5f + 0.5f / f, 0.0f);
                    this.mTargetQuad.p2.set(0.5f - 0.5f / f, 1.0f);
                    this.mTargetQuad.p3.set(0.5f + 0.5f / f, 1.0f);
                }
                this.mProgram.setClearsOutput(true);
                break;
            }
            case 3: {
                this.mProgram.setSourceRegion(this.mSourceQuad);
                break;
            }
        }
        if (this.mLogVerbose) {
            Log.v(TAG, "UTR. quad: " + this.mTargetQuad);
        }
        this.mProgram.setTargetRegion(this.mTargetQuad);
    }

    @Override
    public void close(FilterContext filterContext) {
        synchronized (this) {
            if (this.mSurfaceId > 0) {
                filterContext.getGLEnvironment().unregisterSurfaceId(this.mSurfaceId);
                this.mSurfaceId = -1;
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void disconnect(FilterContext filterContext) {
        synchronized (this) {
            if (this.mLogVerbose) {
                Log.v(TAG, "disconnect");
            }
            if (this.mSurfaceTexture == null) {
                Log.d(TAG, "SurfaceTexture is already null. Nothing to disconnect.");
            } else {
                this.mSurfaceTexture = null;
                if (this.mSurfaceId > 0) {
                    filterContext.getGLEnvironment().unregisterSurfaceId(this.mSurfaceId);
                    this.mSurfaceId = -1;
                }
            }
            return;
        }
    }

    @Override
    public void fieldPortValueUpdated(String string2, FilterContext filterContext) {
        if (this.mLogVerbose) {
            Log.v(TAG, "FPVU. Thread: " + Thread.currentThread());
        }
        this.updateRenderMode();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void open(FilterContext filterContext) {
        synchronized (this) {
            if (this.mSurfaceTexture == null) {
                Log.e(TAG, "SurfaceTexture is null!!");
                throw new RuntimeException("Could not register SurfaceTexture: " + this.mSurfaceTexture);
            }
            this.mSurfaceId = filterContext.getGLEnvironment().registerSurfaceTexture(this.mSurfaceTexture, this.mScreenWidth, this.mScreenHeight);
            if (this.mSurfaceId <= 0) {
                throw new RuntimeException("Could not register SurfaceTexture: " + this.mSurfaceTexture);
            }
            return;
        }
    }

    @Override
    public void prepare(FilterContext filterContext) {
        if (this.mLogVerbose) {
            Log.v(TAG, "Prepare. Thread: " + Thread.currentThread());
        }
        this.mProgram = ShaderProgram.createIdentity(filterContext);
        this.mProgram.setSourceRect(0.0f, 1.0f, 1.0f, -1.0f);
        this.mProgram.setClearColor(0.0f, 0.0f, 0.0f);
        this.updateRenderMode();
        MutableFrameFormat mutableFrameFormat = new MutableFrameFormat(2, 3);
        mutableFrameFormat.setBytesPerSample(4);
        mutableFrameFormat.setDimensions(this.mScreenWidth, this.mScreenHeight);
        this.mScreen = (GLFrame)filterContext.getFrameManager().newBoundFrame(mutableFrameFormat, 101, 0L);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void process(FilterContext filterContext) {
        synchronized (this) {
            int n = this.mSurfaceId;
            if (n > 0) {
                boolean bl;
                Frame frame;
                GLEnvironment gLEnvironment = filterContext.getGLEnvironment();
                Frame frame2 = this.pullInput("frame");
                float f = (float)frame2.getFormat().getWidth() / (float)frame2.getFormat().getHeight();
                if (f != this.mAspectRatio) {
                    if (this.mLogVerbose) {
                        Log.v(TAG, "Process. New aspect ratio: " + f + ", previously: " + this.mAspectRatio + ". Thread: " + Thread.currentThread());
                    }
                    this.mAspectRatio = f;
                    this.updateTargetRect();
                }
                if (frame2.getFormat().getTarget() != 3) {
                    frame = filterContext.getFrameManager().duplicateFrameToTarget(frame2, 3);
                    bl = true;
                } else {
                    frame = frame2;
                    bl = false;
                }
                gLEnvironment.activateSurfaceWithId(this.mSurfaceId);
                this.mProgram.process(frame, (Frame)this.mScreen);
                gLEnvironment.setSurfaceTimestamp(frame2.getTimestamp());
                gLEnvironment.swapBuffers();
                if (bl) {
                    frame.release();
                }
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void setupPorts() {
        synchronized (this) {
            if (this.mSurfaceTexture == null) {
                throw new RuntimeException("Null SurfaceTexture passed to SurfaceTextureTarget");
            }
            this.addMaskedInputPort("frame", ImageFormat.create(3));
            return;
        }
    }

    @Override
    public void tearDown(FilterContext filterContext) {
        if (this.mScreen != null) {
            this.mScreen.release();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void updateRenderMode() {
        if (this.mLogVerbose) {
            Log.v(TAG, "updateRenderMode. Thread: " + Thread.currentThread());
        }
        if (this.mRenderModeString != null) {
            if (this.mRenderModeString.equals("stretch")) {
                this.mRenderMode = 0;
            } else if (this.mRenderModeString.equals("fit")) {
                this.mRenderMode = 1;
            } else if (this.mRenderModeString.equals("fill_crop")) {
                this.mRenderMode = 2;
            } else {
                if (!this.mRenderModeString.equals("customize")) {
                    throw new RuntimeException("Unknown render mode '" + this.mRenderModeString + "'!");
                }
                this.mRenderMode = 3;
            }
        }
        this.updateTargetRect();
    }
}

