/*
 * Decompiled with CFR 0.152.
 */
package android.gesture;

import android.gesture.GestureStroke;
import android.gesture.GestureUtils;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RectF;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;

public class Gesture
implements Parcelable {
    private static final boolean BITMAP_RENDERING_ANTIALIAS = true;
    private static final boolean BITMAP_RENDERING_DITHER = true;
    private static final int BITMAP_RENDERING_WIDTH = 2;
    public static final Parcelable.Creator<Gesture> CREATOR;
    private static final long GESTURE_ID_BASE;
    private static final AtomicInteger sGestureCount;
    private final RectF mBoundingBox = new RectF();
    private long mGestureID;
    private final ArrayList<GestureStroke> mStrokes = new ArrayList();

    static {
        GESTURE_ID_BASE = System.currentTimeMillis();
        sGestureCount = new AtomicInteger(0);
        CREATOR = new Parcelable.Creator<Gesture>(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public Gesture createFromParcel(Parcel parcel) {
                Gesture gesture;
                DataInputStream dataInputStream;
                long l;
                block5: {
                    l = parcel.readLong();
                    dataInputStream = new DataInputStream(new ByteArrayInputStream(parcel.createByteArray()));
                    try {
                        Gesture gesture2;
                        gesture = gesture2 = Gesture.deserialize(dataInputStream);
                    }
                    catch (IOException iOException) {
                        Log.e("Gestures", "Error reading Gesture from parcel:", iOException);
                        gesture = null;
                        break block5;
                    }
                    GestureUtils.closeStream(dataInputStream);
                }
                if (gesture == null) return gesture;
                Gesture.access$002(gesture, l);
                return gesture;
                finally {
                    GestureUtils.closeStream(dataInputStream);
                }
            }

            public Gesture[] newArray(int n) {
                return new Gesture[n];
            }
        };
    }

    public Gesture() {
        this.mGestureID = GESTURE_ID_BASE + (long)sGestureCount.incrementAndGet();
    }

    static /* synthetic */ long access$002(Gesture gesture, long l) {
        gesture.mGestureID = l;
        return l;
    }

    static Gesture deserialize(DataInputStream dataInputStream) throws IOException {
        Gesture gesture = new Gesture();
        gesture.mGestureID = dataInputStream.readLong();
        int n = dataInputStream.readInt();
        for (int i = 0; i < n; ++i) {
            gesture.addStroke(GestureStroke.deserialize(dataInputStream));
        }
        return gesture;
    }

    public void addStroke(GestureStroke gestureStroke) {
        this.mStrokes.add(gestureStroke);
        this.mBoundingBox.union(gestureStroke.boundingBox);
    }

    public Object clone() {
        Gesture gesture = new Gesture();
        gesture.mBoundingBox.set(this.mBoundingBox.left, this.mBoundingBox.top, this.mBoundingBox.right, this.mBoundingBox.bottom);
        int n = this.mStrokes.size();
        for (int i = 0; i < n; ++i) {
            GestureStroke gestureStroke = this.mStrokes.get(i);
            gesture.mStrokes.add((GestureStroke)gestureStroke.clone());
        }
        return gesture;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public RectF getBoundingBox() {
        return this.mBoundingBox;
    }

    public long getID() {
        return this.mGestureID;
    }

    public float getLength() {
        int n = 0;
        ArrayList<GestureStroke> arrayList = this.mStrokes;
        int n2 = arrayList.size();
        for (int i = 0; i < n2; ++i) {
            n = (int)((float)n + arrayList.get((int)i).length);
        }
        return n;
    }

    public ArrayList<GestureStroke> getStrokes() {
        return this.mStrokes;
    }

    public int getStrokesCount() {
        return this.mStrokes.size();
    }

    void serialize(DataOutputStream dataOutputStream) throws IOException {
        ArrayList<GestureStroke> arrayList = this.mStrokes;
        int n = arrayList.size();
        dataOutputStream.writeLong(this.mGestureID);
        dataOutputStream.writeInt(n);
        for (int i = 0; i < n; ++i) {
            arrayList.get(i).serialize(dataOutputStream);
        }
    }

    void setID(long l) {
        this.mGestureID = l;
    }

    /*
     * Enabled aggressive block sorting
     */
    public Bitmap toBitmap(int n, int n2, int n3, int n4) {
        Bitmap bitmap = Bitmap.createBitmap(n, n2, Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        Paint paint = new Paint();
        paint.setAntiAlias(true);
        paint.setDither(true);
        paint.setColor(n4);
        paint.setStyle(Paint.Style.STROKE);
        paint.setStrokeJoin(Paint.Join.ROUND);
        paint.setStrokeCap(Paint.Cap.ROUND);
        paint.setStrokeWidth(2.0f);
        Path path = this.toPath();
        RectF rectF = new RectF();
        path.computeBounds(rectF, true);
        float f = (float)(n - n3 * 2) / rectF.width();
        float f2 = (float)(n2 - n3 * 2) / rectF.height();
        float f3 = f > f2 ? f2 : f;
        paint.setStrokeWidth(2.0f / f3);
        path.offset(-rectF.left + ((float)n - f3 * rectF.width()) / 2.0f, -rectF.top + ((float)n2 - f3 * rectF.height()) / 2.0f);
        canvas.translate(n3, n3);
        canvas.scale(f3, f3);
        canvas.drawPath(path, paint);
        return bitmap;
    }

    public Bitmap toBitmap(int n, int n2, int n3, int n4, int n5) {
        Bitmap bitmap = Bitmap.createBitmap(n, n2, Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        canvas.translate(n3, n3);
        Paint paint = new Paint();
        paint.setAntiAlias(true);
        paint.setDither(true);
        paint.setColor(n5);
        paint.setStyle(Paint.Style.STROKE);
        paint.setStrokeJoin(Paint.Join.ROUND);
        paint.setStrokeCap(Paint.Cap.ROUND);
        paint.setStrokeWidth(2.0f);
        ArrayList<GestureStroke> arrayList = this.mStrokes;
        int n6 = arrayList.size();
        for (int i = 0; i < n6; ++i) {
            canvas.drawPath(arrayList.get(i).toPath(n - n3 * 2, n2 - n3 * 2, n4), paint);
        }
        return bitmap;
    }

    public Path toPath() {
        return this.toPath(null);
    }

    public Path toPath(int n, int n2, int n3, int n4) {
        return this.toPath(null, n, n2, n3, n4);
    }

    public Path toPath(Path path) {
        if (path == null) {
            path = new Path();
        }
        ArrayList<GestureStroke> arrayList = this.mStrokes;
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            path.addPath(arrayList.get(i).getPath());
        }
        return path;
    }

    public Path toPath(Path path, int n, int n2, int n3, int n4) {
        if (path == null) {
            path = new Path();
        }
        ArrayList<GestureStroke> arrayList = this.mStrokes;
        int n5 = arrayList.size();
        for (int i = 0; i < n5; ++i) {
            path.addPath(arrayList.get(i).toPath(n - n3 * 2, n2 - n3 * 2, n4));
        }
        return path;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void writeToParcel(Parcel parcel, int n) {
        boolean bl;
        DataOutputStream dataOutputStream;
        ByteArrayOutputStream byteArrayOutputStream;
        block5: {
            parcel.writeLong(this.mGestureID);
            byteArrayOutputStream = new ByteArrayOutputStream(32768);
            dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            try {
                this.serialize(dataOutputStream);
                bl = true;
            }
            catch (IOException iOException) {
                Log.e("Gestures", "Error writing Gesture to parcel:", iOException);
                bl = false;
                break block5;
            }
            GestureUtils.closeStream(dataOutputStream);
            GestureUtils.closeStream(byteArrayOutputStream);
        }
        if (!bl) return;
        parcel.writeByteArray(byteArrayOutputStream.toByteArray());
        return;
        finally {
            GestureUtils.closeStream(dataOutputStream);
            GestureUtils.closeStream(byteArrayOutputStream);
        }
    }
}

