/*
 * Decompiled with CFR 0.152.
 */
package android.gesture;

import android.content.Context;
import android.gesture.GestureLibrary;
import android.util.Log;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;

public final class GestureLibraries {
    private GestureLibraries() {
    }

    public static GestureLibrary fromFile(File file) {
        return new FileGestureLibrary(file);
    }

    public static GestureLibrary fromFile(String string2) {
        return GestureLibraries.fromFile(new File(string2));
    }

    public static GestureLibrary fromPrivateFile(Context context, String string2) {
        return GestureLibraries.fromFile(context.getFileStreamPath(string2));
    }

    public static GestureLibrary fromRawResource(Context context, int n) {
        return new ResourceGestureLibrary(context, n);
    }

    private static class FileGestureLibrary
    extends GestureLibrary {
        private final File mPath;

        public FileGestureLibrary(File file) {
            this.mPath = file;
        }

        @Override
        public boolean isReadOnly() {
            return !this.mPath.canWrite();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean load() {
            File file = this.mPath;
            boolean bl = file.exists();
            boolean bl2 = false;
            if (!bl) return bl2;
            boolean bl3 = file.canRead();
            bl2 = false;
            if (!bl3) return bl2;
            try {
                this.mStore.load(new FileInputStream(file), true);
                return true;
            }
            catch (FileNotFoundException fileNotFoundException) {
                Log.d("Gestures", "Could not load the gesture library from " + this.mPath, fileNotFoundException);
                return false;
            }
            catch (IOException iOException) {
                Log.d("Gestures", "Could not load the gesture library from " + this.mPath, iOException);
                return false;
            }
        }

        @Override
        public boolean save() {
            if (!this.mStore.hasChanged()) {
                return true;
            }
            File file = this.mPath;
            File file2 = file.getParentFile();
            if (!file2.exists() && !file2.mkdirs()) {
                return false;
            }
            try {
                file.createNewFile();
                this.mStore.save(new FileOutputStream(file), true);
                return true;
            }
            catch (FileNotFoundException fileNotFoundException) {
                Log.d("Gestures", "Could not save the gesture library in " + this.mPath, fileNotFoundException);
                return false;
            }
            catch (IOException iOException) {
                Log.d("Gestures", "Could not save the gesture library in " + this.mPath, iOException);
                return false;
            }
        }
    }

    private static class ResourceGestureLibrary
    extends GestureLibrary {
        private final WeakReference<Context> mContext;
        private final int mResourceId;

        public ResourceGestureLibrary(Context context, int n) {
            this.mContext = new WeakReference<Context>(context);
            this.mResourceId = n;
        }

        @Override
        public boolean isReadOnly() {
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean load() {
            Context context = (Context)this.mContext.get();
            boolean bl = false;
            if (context == null) return bl;
            InputStream inputStream = context.getResources().openRawResource(this.mResourceId);
            try {
                this.mStore.load(inputStream, true);
                return true;
            }
            catch (IOException iOException) {
                Log.d("Gestures", "Could not load the gesture library from raw resource " + context.getResources().getResourceName(this.mResourceId), iOException);
                return false;
            }
        }

        @Override
        public boolean save() {
            return false;
        }
    }
}

