/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.content.res.AssetManager;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.NinePatch;
import android.graphics.Rect;
import android.os.Trace;
import android.util.Log;
import android.util.TypedValue;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class BitmapFactory {
    private static final int DECODE_BUFFER_SIZE = 16384;

    public static Bitmap decodeByteArray(byte[] byArray, int n, int n2) {
        return BitmapFactory.decodeByteArray(byArray, n, n2, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Bitmap decodeByteArray(byte[] byArray, int n, int n2, Options options) {
        if ((n | n2) < 0) throw new ArrayIndexOutOfBoundsException();
        if (byArray.length < n + n2) {
            throw new ArrayIndexOutOfBoundsException();
        }
        Trace.traceBegin(2L, "decodeBitmap");
        try {
            Bitmap bitmap = BitmapFactory.nativeDecodeByteArray(byArray, n, n2, options);
            if (bitmap == null && options != null && options.inBitmap != null) {
                throw new IllegalArgumentException("Problem decoding into existing bitmap");
            }
            BitmapFactory.setDensityFromOptions(bitmap, options);
            return bitmap;
        }
        finally {
            Trace.traceEnd(2L);
        }
    }

    public static Bitmap decodeFile(String string2) {
        return BitmapFactory.decodeFile(string2, null);
    }

    /*
     * Unable to fully structure code
     */
    public static Bitmap decodeFile(String var0, Options var1_1) {
        var2_2 = null;
        var3_3 = new FileInputStream(var0);
        try {
            var8_5 = var10_4 = BitmapFactory.decodeStream(var3_3, null, var1_1);
            ** if (var3_3 == null) goto lbl-1000
        }
        catch (Throwable var5_13) {
            var2_2 = var3_3;
            ** continue;
        }
        catch (Exception var4_9) {
            var2_2 = var3_3;
            ** continue;
        }
lbl-1000:
        // 1 sources

        {
            try {
                var3_3.close();
            }
            catch (IOException var11_6) {
                return var8_5;
            }
            return var8_5;
        }
lbl-1000:
        // 1 sources

        {
        }
        catch (Exception var4_7) lbl-1000:
        // 2 sources

        {
            while (true) {
                try {
                    Log.e("BitmapFactory", "Unable to decode stream: " + var4_8);
                    var8_5 = null;
                    if (var2_2 == null) ** continue;
                }
                catch (Throwable var5_11) lbl-1000:
                // 2 sources

                {
                    while (true) {
                        if (var2_2 != null) {
                            var2_2.close();
                        }
lbl26:
                        // 4 sources

                        throw var5_12;
                        catch (IOException var6_14) {
                            ** continue;
                        }
                        break;
                    }
                }
                try {
                    var2_2.close();
                    return null;
                }
                catch (IOException var9_10) {
                    return null;
                }
                break;
            }
        }
        return var8_5;
    }

    public static Bitmap decodeFileDescriptor(FileDescriptor fileDescriptor) {
        return BitmapFactory.decodeFileDescriptor(fileDescriptor, null, null);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Bitmap decodeFileDescriptor(FileDescriptor var0, Rect var1_1, Options var2_2) {
        Trace.traceBegin(2L, "decodeFileDescriptor");
        try {
            if (!BitmapFactory.nativeIsSeekable(var0)) ** GOTO lbl-1000
            var8_3 = BitmapFactory.nativeDecodeFileDescriptor(var0, var1_1, var2_2);
lbl5:
            // 3 sources

            while (var8_3 == null && var2_2 != null && var2_2.inBitmap != null) {
                throw new IllegalArgumentException("Problem decoding into existing bitmap");
            }
            ** GOTO lbl26
        }
        catch (Throwable var3_4) {
            Trace.traceEnd(2L);
            throw var3_4;
        }
lbl-1000:
        // 1 sources

        {
            var4_5 = new FileInputStream(var0);
        }
        var8_3 = var7_6 = BitmapFactory.decodeStreamInternal(var4_5, var1_1, var2_2);
        ** GOTO lbl21
        {
            catch (Throwable var5_8) {
                try {
                    var4_5.close();
                }
                finally {
                    throw var5_8;
                }
lbl21:
                // 1 sources

                try {
                    var4_5.close();
                }
                catch (Throwable var9_7) {}
                ** GOTO lbl5
            }
lbl26:
            // 1 sources

            BitmapFactory.setDensityFromOptions(var8_3, var2_2);
        }
        Trace.traceEnd(2L);
        return var8_3;
    }

    public static Bitmap decodeResource(Resources resources, int n) {
        return BitmapFactory.decodeResource(resources, n, null);
    }

    /*
     * Unable to fully structure code
     */
    public static Bitmap decodeResource(Resources var0, int var1_1, Options var2_2) {
        block12: {
            var3_3 = null;
            var4_4 = new TypedValue();
            var3_3 = var0.openRawResource(var1_1, var4_4);
            var8_6 = var10_5 = BitmapFactory.decodeResourceStream(var0, var4_4, var3_3, null, var2_2);
            if (var3_3 == null) ** GOTO lbl9
            try {
                var3_3.close();
            }
            catch (IOException var11_10) {
            }
lbl9:
            // 6 sources

            while (var8_6 == null && var2_2 != null && var2_2.inBitmap != null) {
                throw new IllegalArgumentException("Problem decoding into existing bitmap");
            }
            break block12;
            catch (Exception var7_7) {
                var8_6 = null;
                if (var3_3 == null) ** GOTO lbl9
                try {
                    var3_3.close();
                    var8_6 = null;
                }
                catch (IOException var9_8) {
                    var8_6 = null;
                }
            }
            catch (Throwable var5_9) {
                if (var3_3 != null) {
                    var3_3.close();
                }
lbl26:
                // 4 sources

                throw var5_9;
            }
            {
                catch (IOException var6_11) {
                    ** continue;
                }
            }
        }
        return var8_6;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static Bitmap decodeResourceStream(Resources resources, TypedValue typedValue, InputStream inputStream, Rect rect, Options options) {
        if (options == null) {
            options = new Options();
        }
        if (options.inDensity == 0 && typedValue != null) {
            int n = typedValue.density;
            if (n == 0) {
                options.inDensity = 160;
            } else if (n != 65535) {
                options.inDensity = n;
            }
        }
        if (options.inTargetDensity == 0 && resources != null) {
            options.inTargetDensity = resources.getDisplayMetrics().densityDpi;
        }
        return BitmapFactory.decodeStream(inputStream, rect, options);
    }

    public static Bitmap decodeStream(InputStream inputStream) {
        return BitmapFactory.decodeStream(inputStream, null, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Bitmap decodeStream(InputStream inputStream, Rect rect, Options options) {
        if (inputStream == null) {
            return null;
        }
        Trace.traceBegin(2L, "decodeBitmap");
        try {
            Bitmap bitmap = inputStream instanceof AssetManager.AssetInputStream ? BitmapFactory.nativeDecodeAsset(((AssetManager.AssetInputStream)inputStream).getNativeAsset(), rect, options) : BitmapFactory.decodeStreamInternal(inputStream, rect, options);
            if (bitmap == null && options != null && options.inBitmap != null) {
                throw new IllegalArgumentException("Problem decoding into existing bitmap");
            }
            BitmapFactory.setDensityFromOptions(bitmap, options);
            return bitmap;
        }
        finally {
            Trace.traceEnd(2L);
        }
    }

    private static Bitmap decodeStreamInternal(InputStream inputStream, Rect rect, Options options) {
        byte[] byArray = null;
        if (options != null) {
            byArray = options.inTempStorage;
        }
        if (byArray == null) {
            byArray = new byte[16384];
        }
        return BitmapFactory.nativeDecodeStream(inputStream, byArray, rect, options);
    }

    private static native Bitmap nativeDecodeAsset(long var0, Rect var2, Options var3);

    private static native Bitmap nativeDecodeByteArray(byte[] var0, int var1, int var2, Options var3);

    private static native Bitmap nativeDecodeFileDescriptor(FileDescriptor var0, Rect var1, Options var2);

    private static native Bitmap nativeDecodeStream(InputStream var0, byte[] var1, Rect var2, Options var3);

    private static native boolean nativeIsSeekable(FileDescriptor var0);

    /*
     * Enabled aggressive block sorting
     */
    private static void setDensityFromOptions(Bitmap bitmap, Options options) {
        if (bitmap == null || options == null) return;
        int n = options.inDensity;
        if (n != 0) {
            bitmap.setDensity(n);
            int n2 = options.inTargetDensity;
            if (n2 == 0 || n == n2 || n == options.inScreenDensity) return;
            byte[] byArray = bitmap.getNinePatchChunk();
            boolean bl = byArray != null && NinePatch.isNinePatchChunk(byArray);
            if (!options.inScaled && !bl) return;
            bitmap.setDensity(n2);
            return;
        }
        if (options.inBitmap == null) {
            return;
        }
        bitmap.setDensity(Bitmap.getDefaultDensity());
    }

    public static class Options {
        public Bitmap inBitmap;
        public int inDensity;
        public boolean inDither = false;
        @Deprecated
        public boolean inInputShareable;
        public boolean inJustDecodeBounds;
        public boolean inMutable;
        public boolean inPreferQualityOverSpeed;
        public Bitmap.Config inPreferredConfig = Bitmap.Config.ARGB_8888;
        public boolean inPremultiplied = true;
        @Deprecated
        public boolean inPurgeable;
        public int inSampleSize;
        public boolean inScaled = true;
        public int inScreenDensity;
        public int inTargetDensity;
        public byte[] inTempStorage;
        public boolean mCancel;
        public int outHeight;
        public String outMimeType;
        public int outWidth;

        private native void requestCancel();

        public void requestCancelDecode() {
            this.mCancel = true;
            this.requestCancel();
        }
    }
}

