/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.os.SystemClock;

public class Interpolator {
    private int mFrameCount;
    private int mValueCount;
    private final long native_instance;

    public Interpolator(int n) {
        this.mValueCount = n;
        this.mFrameCount = 2;
        this.native_instance = Interpolator.nativeConstructor(n, 2);
    }

    public Interpolator(int n, int n2) {
        this.mValueCount = n;
        this.mFrameCount = n2;
        this.native_instance = Interpolator.nativeConstructor(n, n2);
    }

    private static native long nativeConstructor(int var0, int var1);

    private static native void nativeDestructor(long var0);

    private static native void nativeReset(long var0, int var2, int var3);

    private static native void nativeSetKeyFrame(long var0, int var2, int var3, float[] var4, float[] var5);

    private static native void nativeSetRepeatMirror(long var0, float var2, boolean var3);

    private static native int nativeTimeToValues(long var0, int var2, float[] var3);

    protected void finalize() throws Throwable {
        Interpolator.nativeDestructor(this.native_instance);
    }

    public final int getKeyFrameCount() {
        return this.mFrameCount;
    }

    public final int getValueCount() {
        return this.mValueCount;
    }

    public void reset(int n) {
        this.reset(n, 2);
    }

    public void reset(int n, int n2) {
        this.mValueCount = n;
        this.mFrameCount = n2;
        Interpolator.nativeReset(this.native_instance, n, n2);
    }

    public void setKeyFrame(int n, int n2, float[] fArray) {
        this.setKeyFrame(n, n2, fArray, null);
    }

    public void setKeyFrame(int n, int n2, float[] fArray, float[] fArray2) {
        if (n < 0 || n >= this.mFrameCount) {
            throw new IndexOutOfBoundsException();
        }
        if (fArray.length < this.mValueCount) {
            throw new ArrayStoreException();
        }
        if (fArray2 != null && fArray2.length < 4) {
            throw new ArrayStoreException();
        }
        Interpolator.nativeSetKeyFrame(this.native_instance, n, n2, fArray, fArray2);
    }

    public void setRepeatMirror(float f, boolean bl) {
        if (f >= 0.0f) {
            Interpolator.nativeSetRepeatMirror(this.native_instance, f, bl);
        }
    }

    public Result timeToValues(int n, float[] fArray) {
        if (fArray != null && fArray.length < this.mValueCount) {
            throw new ArrayStoreException();
        }
        switch (Interpolator.nativeTimeToValues(this.native_instance, n, fArray)) {
            default: {
                return Result.FREEZE_END;
            }
            case 0: {
                return Result.NORMAL;
            }
            case 1: 
        }
        return Result.FREEZE_START;
    }

    public Result timeToValues(float[] fArray) {
        return this.timeToValues((int)SystemClock.uptimeMillis(), fArray);
    }

    public static final class Result
    extends Enum<Result> {
        private static final /* synthetic */ Result[] $VALUES;
        public static final /* enum */ Result FREEZE_END;
        public static final /* enum */ Result FREEZE_START;
        public static final /* enum */ Result NORMAL;

        static {
            NORMAL = new Result();
            FREEZE_START = new Result();
            FREEZE_END = new Result();
            Result[] resultArray = new Result[]{NORMAL, FREEZE_START, FREEZE_END};
            $VALUES = resultArray;
        }

        public static Result valueOf(String string2) {
            return Enum.valueOf(Result.class, string2);
        }

        public static Result[] values() {
            return (Result[])$VALUES.clone();
        }
    }
}

