/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.drawable;

import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.Gravity;
import com.android.internal.R;
import java.io.IOException;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class ClipDrawable
extends Drawable
implements Drawable.Callback {
    public static final int HORIZONTAL = 1;
    public static final int VERTICAL = 2;
    private ClipState mClipState;
    private final Rect mTmpRect = new Rect();

    ClipDrawable() {
        this(null, null);
    }

    private ClipDrawable(ClipState clipState, Resources resources) {
        this.mClipState = new ClipState(clipState, this, resources);
    }

    public ClipDrawable(Drawable drawable2, int n, int n2) {
        this(null, null);
        this.mClipState.mDrawable = drawable2;
        this.mClipState.mGravity = n;
        this.mClipState.mOrientation = n2;
        if (drawable2 != null) {
            drawable2.setCallback(this);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void draw(Canvas canvas) {
        Rect rect;
        block6: {
            block5: {
                if (this.mClipState.mDrawable.getLevel() == 0) break block5;
                rect = this.mTmpRect;
                Rect rect2 = this.getBounds();
                int n = this.getLevel();
                int n2 = rect2.width();
                if ((1 & this.mClipState.mOrientation) != 0) {
                    n2 -= (n2 + 0) * (10000 - n) / 10000;
                }
                int n3 = rect2.height();
                if ((2 & this.mClipState.mOrientation) != 0) {
                    n3 -= (n3 + 0) * (10000 - n) / 10000;
                }
                int n4 = this.getLayoutDirection();
                Gravity.apply(this.mClipState.mGravity, n2, n3, rect2, rect, n4);
                if (n2 > 0 && n3 > 0) break block6;
            }
            return;
        }
        canvas.save();
        canvas.clipRect(rect);
        this.mClipState.mDrawable.draw(canvas);
        canvas.restore();
    }

    @Override
    public int getAlpha() {
        return this.mClipState.mDrawable.getAlpha();
    }

    @Override
    public int getChangingConfigurations() {
        return super.getChangingConfigurations() | this.mClipState.mChangingConfigurations | this.mClipState.mDrawable.getChangingConfigurations();
    }

    @Override
    public Drawable.ConstantState getConstantState() {
        if (this.mClipState.canConstantState()) {
            this.mClipState.mChangingConfigurations = this.getChangingConfigurations();
            return this.mClipState;
        }
        return null;
    }

    @Override
    public int getIntrinsicHeight() {
        return this.mClipState.mDrawable.getIntrinsicHeight();
    }

    @Override
    public int getIntrinsicWidth() {
        return this.mClipState.mDrawable.getIntrinsicWidth();
    }

    @Override
    public int getOpacity() {
        return this.mClipState.mDrawable.getOpacity();
    }

    @Override
    public boolean getPadding(Rect rect) {
        return this.mClipState.mDrawable.getPadding(rect);
    }

    @Override
    public void inflate(Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet, Resources.Theme theme) throws XmlPullParserException, IOException {
        int n;
        super.inflate(resources, xmlPullParser, attributeSet, theme);
        TypedArray typedArray = ClipDrawable.obtainAttributes(resources, theme, attributeSet, R.styleable.ClipDrawable);
        int n2 = typedArray.getInt(2, 1);
        int n3 = typedArray.getInt(0, 3);
        Drawable drawable2 = typedArray.getDrawable(1);
        typedArray.recycle();
        int n4 = xmlPullParser.getDepth();
        while ((n = xmlPullParser.next()) != 1 && (n != 3 || xmlPullParser.getDepth() > n4)) {
            if (n != 2) continue;
            drawable2 = Drawable.createFromXmlInner(resources, xmlPullParser, attributeSet, theme);
        }
        if (drawable2 == null) {
            throw new IllegalArgumentException("No drawable specified for <clip>");
        }
        this.mClipState.mDrawable = drawable2;
        this.mClipState.mOrientation = n2;
        this.mClipState.mGravity = n3;
        drawable2.setCallback(this);
    }

    @Override
    public void invalidateDrawable(Drawable drawable2) {
        Drawable.Callback callback = this.getCallback();
        if (callback != null) {
            callback.invalidateDrawable(this);
        }
    }

    @Override
    public boolean isStateful() {
        return this.mClipState.mDrawable.isStateful();
    }

    @Override
    protected void onBoundsChange(Rect rect) {
        this.mClipState.mDrawable.setBounds(rect);
    }

    @Override
    protected boolean onLevelChange(int n) {
        this.mClipState.mDrawable.setLevel(n);
        this.invalidateSelf();
        return true;
    }

    @Override
    protected boolean onStateChange(int[] nArray) {
        return this.mClipState.mDrawable.setState(nArray);
    }

    @Override
    public void scheduleDrawable(Drawable drawable2, Runnable runnable, long l) {
        Drawable.Callback callback = this.getCallback();
        if (callback != null) {
            callback.scheduleDrawable(this, runnable, l);
        }
    }

    @Override
    public void setAlpha(int n) {
        this.mClipState.mDrawable.setAlpha(n);
    }

    @Override
    public void setColorFilter(ColorFilter colorFilter) {
        this.mClipState.mDrawable.setColorFilter(colorFilter);
    }

    @Override
    public void setLayoutDirection(int n) {
        this.mClipState.mDrawable.setLayoutDirection(n);
        super.setLayoutDirection(n);
    }

    @Override
    public void setTintList(ColorStateList colorStateList) {
        this.mClipState.mDrawable.setTintList(colorStateList);
    }

    @Override
    public void setTintMode(PorterDuff.Mode mode) {
        this.mClipState.mDrawable.setTintMode(mode);
    }

    @Override
    public boolean setVisible(boolean bl, boolean bl2) {
        this.mClipState.mDrawable.setVisible(bl, bl2);
        return super.setVisible(bl, bl2);
    }

    @Override
    public void unscheduleDrawable(Drawable drawable2, Runnable runnable) {
        Drawable.Callback callback = this.getCallback();
        if (callback != null) {
            callback.unscheduleDrawable(this, runnable);
        }
    }

    static final class ClipState
    extends Drawable.ConstantState {
        private boolean mCanConstantState;
        int mChangingConfigurations;
        private boolean mCheckedConstantState;
        Drawable mDrawable;
        int mGravity;
        int mOrientation;

        /*
         * Enabled aggressive block sorting
         */
        ClipState(ClipState clipState, ClipDrawable clipDrawable, Resources resources) {
            if (clipState != null) {
                this.mDrawable = resources != null ? clipState.mDrawable.getConstantState().newDrawable(resources) : clipState.mDrawable.getConstantState().newDrawable();
                this.mDrawable.setCallback(clipDrawable);
                this.mDrawable.setLayoutDirection(clipState.mDrawable.getLayoutDirection());
                this.mDrawable.setBounds(clipState.mDrawable.getBounds());
                this.mDrawable.setLevel(clipState.mDrawable.getLevel());
                this.mOrientation = clipState.mOrientation;
                this.mGravity = clipState.mGravity;
                this.mCanConstantState = true;
                this.mCheckedConstantState = true;
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        boolean canConstantState() {
            if (!this.mCheckedConstantState) {
                boolean bl = this.mDrawable.getConstantState() != null;
                this.mCanConstantState = bl;
                this.mCheckedConstantState = true;
            }
            return this.mCanConstantState;
        }

        @Override
        public int getChangingConfigurations() {
            return this.mChangingConfigurations;
        }

        @Override
        public Drawable newDrawable() {
            return new ClipDrawable(this, null);
        }

        @Override
        public Drawable newDrawable(Resources resources) {
            return new ClipDrawable(this, resources);
        }
    }
}

