/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.drawable;

import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.DrawableContainer;
import android.util.AttributeSet;
import com.android.internal.R;
import java.io.IOException;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class LevelListDrawable
extends DrawableContainer {
    private final LevelListState mLevelListState;
    private boolean mMutated;

    public LevelListDrawable() {
        this(null, null);
    }

    private LevelListDrawable(LevelListState levelListState, Resources resources) {
        LevelListState levelListState2;
        this.mLevelListState = levelListState2 = new LevelListState(levelListState, this, resources);
        this.setConstantState(levelListState2);
        this.onLevelChange(this.getLevel());
    }

    public void addLevel(int n, int n2, Drawable drawable2) {
        if (drawable2 != null) {
            this.mLevelListState.addLevel(n, n2, drawable2);
            this.onLevelChange(this.getLevel());
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void inflate(Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet, Resources.Theme theme) throws XmlPullParserException, IOException {
        int n;
        int n2;
        super.inflate(resources, xmlPullParser, attributeSet, theme);
        int n3 = 1 + xmlPullParser.getDepth();
        while ((n2 = xmlPullParser.next()) != 1 && ((n = xmlPullParser.getDepth()) >= n3 || n2 != 3)) {
            Drawable drawable2;
            if (n2 != 2 || n > n3 || !xmlPullParser.getName().equals("item")) continue;
            TypedArray typedArray = LevelListDrawable.obtainAttributes(resources, theme, attributeSet, R.styleable.LevelListDrawableItem);
            int n4 = typedArray.getInt(1, 0);
            int n5 = typedArray.getInt(2, 0);
            int n6 = typedArray.getResourceId(0, 0);
            typedArray.recycle();
            if (n5 < 0) {
                throw new XmlPullParserException(xmlPullParser.getPositionDescription() + ": <item> tag requires a 'maxLevel' attribute");
            }
            if (n6 != 0) {
                drawable2 = resources.getDrawable(n6, theme);
            } else {
                int n7;
                while ((n7 = xmlPullParser.next()) == 4) {
                }
                if (n7 != 2) {
                    throw new XmlPullParserException(xmlPullParser.getPositionDescription() + ": <item> tag requires a 'drawable' attribute or " + "child tag defining a drawable");
                }
                drawable2 = Drawable.createFromXmlInner(resources, xmlPullParser, attributeSet, theme);
            }
            this.mLevelListState.addLevel(n4, n5, drawable2);
        }
        this.onLevelChange(this.getLevel());
    }

    @Override
    public Drawable mutate() {
        if (!this.mMutated && super.mutate() == this) {
            LevelListState.access$002(this.mLevelListState, (int[])this.mLevelListState.mLows.clone());
            LevelListState.access$102(this.mLevelListState, (int[])this.mLevelListState.mHighs.clone());
            this.mMutated = true;
        }
        return this;
    }

    @Override
    protected boolean onLevelChange(int n) {
        if (this.selectDrawable(this.mLevelListState.indexOfLevel(n))) {
            return true;
        }
        return super.onLevelChange(n);
    }

    private static final class LevelListState
    extends DrawableContainer.DrawableContainerState {
        private int[] mHighs;
        private int[] mLows;

        LevelListState(LevelListState levelListState, LevelListDrawable levelListDrawable, Resources resources) {
            super(levelListState, levelListDrawable, resources);
            if (levelListState != null) {
                this.mLows = levelListState.mLows;
                this.mHighs = levelListState.mHighs;
                return;
            }
            this.mLows = new int[this.getCapacity()];
            this.mHighs = new int[this.getCapacity()];
        }

        static /* synthetic */ int[] access$002(LevelListState levelListState, int[] nArray) {
            levelListState.mLows = nArray;
            return nArray;
        }

        static /* synthetic */ int[] access$102(LevelListState levelListState, int[] nArray) {
            levelListState.mHighs = nArray;
            return nArray;
        }

        public void addLevel(int n, int n2, Drawable drawable2) {
            int n3 = this.addChild(drawable2);
            this.mLows[n3] = n;
            this.mHighs[n3] = n2;
        }

        @Override
        public void growArray(int n, int n2) {
            super.growArray(n, n2);
            int[] nArray = new int[n2];
            System.arraycopy((int[])this.mLows, (int)0, (int[])nArray, (int)0, (int)n);
            this.mLows = nArray;
            int[] nArray2 = new int[n2];
            System.arraycopy((int[])this.mHighs, (int)0, (int[])nArray2, (int)0, (int)n);
            this.mHighs = nArray2;
        }

        public int indexOfLevel(int n) {
            int[] nArray = this.mLows;
            int[] nArray2 = this.mHighs;
            int n2 = this.getChildCount();
            for (int i = 0; i < n2; ++i) {
                if (n < nArray[i] || n > nArray2[i]) continue;
                return i;
            }
            return -1;
        }

        @Override
        public Drawable newDrawable() {
            return new LevelListDrawable(this, null);
        }

        @Override
        public Drawable newDrawable(Resources resources) {
            return new LevelListDrawable(this, resources);
        }
    }
}

