/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.drawable;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.graphics.Canvas;
import android.graphics.CanvasProperty;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.RippleDrawable;
import android.util.MathUtils;
import android.view.HardwareCanvas;
import android.view.RenderNodeAnimator;
import android.view.animation.LinearInterpolator;
import java.util.ArrayList;

class Ripple {
    private static final TimeInterpolator DECEL_INTERPOLATOR;
    private static final float GLOBAL_SPEED = 1.0f;
    private static final TimeInterpolator LINEAR_INTERPOLATOR;
    private static final long RIPPLE_ENTER_DELAY = 80L;
    private static final float WAVE_OPACITY_DECAY_VELOCITY = 3.0f;
    private static final float WAVE_TOUCH_DOWN_ACCELERATION = 1024.0f;
    private static final float WAVE_TOUCH_UP_ACCELERATION = 3400.0f;
    private ObjectAnimator mAnimOpacity;
    private ObjectAnimator mAnimRadius;
    private ObjectAnimator mAnimX;
    private ObjectAnimator mAnimY;
    private final AnimatorListenerAdapter mAnimationListener;
    private final Rect mBounds;
    private boolean mCanUseHardware;
    private boolean mCanceled;
    private float mClampedStartingX;
    private float mClampedStartingY;
    private int mColorOpaque;
    private float mDensity;
    private boolean mHardwareAnimating;
    private boolean mHasMaxRadius;
    private float mOpacity = 1.0f;
    private float mOuterRadius;
    private float mOuterX;
    private float mOuterY;
    private final RippleDrawable mOwner;
    private final ArrayList<RenderNodeAnimator> mPendingAnimations;
    private CanvasProperty<Paint> mPropPaint;
    private CanvasProperty<Float> mPropRadius;
    private CanvasProperty<Float> mPropX;
    private CanvasProperty<Float> mPropY;
    private final ArrayList<RenderNodeAnimator> mRunningAnimations = new ArrayList();
    private float mStartingX;
    private float mStartingY;
    private Paint mTempPaint;
    private float mTweenRadius = 0.0f;
    private float mTweenX = 0.0f;
    private float mTweenY = 0.0f;

    static {
        LINEAR_INTERPOLATOR = new LinearInterpolator();
        DECEL_INTERPOLATOR = new LogInterpolator();
    }

    public Ripple(RippleDrawable rippleDrawable, Rect rect, float f, float f2) {
        this.mPendingAnimations = new ArrayList();
        this.mAnimationListener = new AnimatorListenerAdapter(){

            @Override
            public void onAnimationEnd(Animator animator2) {
                Ripple.this.removeSelf();
            }
        };
        this.mOwner = rippleDrawable;
        this.mBounds = rect;
        this.mStartingX = f;
        this.mStartingY = f2;
    }

    private void cancelHardwareAnimations(boolean bl) {
        ArrayList<RenderNodeAnimator> arrayList = this.mRunningAnimations;
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            arrayList.get(i).cancel();
        }
        arrayList.clear();
        if (bl && !this.mPendingAnimations.isEmpty()) {
            this.mPendingAnimations.clear();
        }
        this.mHardwareAnimating = false;
    }

    private void cancelSoftwareAnimations() {
        if (this.mAnimRadius != null) {
            this.mAnimRadius.cancel();
            this.mAnimRadius = null;
        }
        if (this.mAnimOpacity != null) {
            this.mAnimOpacity.cancel();
            this.mAnimOpacity = null;
        }
        if (this.mAnimX != null) {
            this.mAnimX.cancel();
            this.mAnimX = null;
        }
        if (this.mAnimY != null) {
            this.mAnimY.cancel();
            this.mAnimY = null;
        }
    }

    private void clampStartingPosition() {
        float f;
        float f2;
        float f3;
        float f4 = this.mBounds.exactCenterX();
        float f5 = this.mStartingX - f4;
        if (f5 * f5 + (f3 = this.mStartingY - (f2 = this.mBounds.exactCenterY())) * f3 > (f = this.mOuterRadius) * f) {
            double d = Math.atan2(f3, f5);
            this.mClampedStartingX = f4 + (float)(Math.cos(d) * (double)f);
            this.mClampedStartingY = f2 + (float)(Math.sin(d) * (double)f);
            return;
        }
        this.mClampedStartingX = this.mStartingX;
        this.mClampedStartingY = this.mStartingY;
    }

    private boolean drawHardware(HardwareCanvas hardwareCanvas) {
        ArrayList<RenderNodeAnimator> arrayList = this.mPendingAnimations;
        int n = arrayList.size();
        if (n > 0) {
            this.cancelHardwareAnimations(false);
            this.mHardwareAnimating = true;
            for (int i = 0; i < n; ++i) {
                arrayList.get(i).setTarget(hardwareCanvas);
                arrayList.get(i).start();
            }
            this.mRunningAnimations.addAll(arrayList);
            arrayList.clear();
        }
        hardwareCanvas.drawCircle(this.mPropX, this.mPropY, this.mPropRadius, this.mPropPaint);
        return true;
    }

    private boolean drawSoftware(Canvas canvas, Paint paint) {
        paint.setColor(this.mColorOpaque);
        int n = (int)(0.5f + 255.0f * this.mOpacity);
        float f = MathUtils.lerp(0.0f, this.mOuterRadius, this.mTweenRadius);
        boolean bl = false;
        if (n > 0) {
            float f2 = f - 0.0f;
            float f3 = f2 == 0.0f ? 0 : (f2 > 0.0f ? 1 : -1);
            bl = false;
            if (f3 > 0) {
                float f4 = MathUtils.lerp(this.mClampedStartingX - this.mBounds.exactCenterX(), this.mOuterX, this.mTweenX);
                float f5 = MathUtils.lerp(this.mClampedStartingY - this.mBounds.exactCenterY(), this.mOuterY, this.mTweenY);
                paint.setAlpha(n);
                paint.setStyle(Paint.Style.FILL);
                canvas.drawCircle(f4, f5, f, paint);
                bl = true;
            }
        }
        return bl;
    }

    private void endSoftwareAnimations() {
        if (this.mAnimRadius != null) {
            this.mAnimRadius.end();
            this.mAnimRadius = null;
        }
        if (this.mAnimOpacity != null) {
            this.mAnimOpacity.end();
            this.mAnimOpacity = null;
        }
        if (this.mAnimX != null) {
            this.mAnimX.end();
            this.mAnimX = null;
        }
        if (this.mAnimY != null) {
            this.mAnimY.end();
            this.mAnimY = null;
        }
    }

    private void exitHardware(int n, int n2) {
        this.mPendingAnimations.clear();
        float f = MathUtils.lerp(this.mClampedStartingX - this.mBounds.exactCenterX(), this.mOuterX, this.mTweenX);
        float f2 = MathUtils.lerp(this.mClampedStartingY - this.mBounds.exactCenterY(), this.mOuterY, this.mTweenY);
        float f3 = MathUtils.lerp(0.0f, this.mOuterRadius, this.mTweenRadius);
        Paint paint = this.getTempPaint();
        paint.setAntiAlias(true);
        paint.setColor(this.mColorOpaque);
        paint.setAlpha((int)(0.5f + 255.0f * this.mOpacity));
        paint.setStyle(Paint.Style.FILL);
        this.mPropPaint = CanvasProperty.createPaint(paint);
        this.mPropRadius = CanvasProperty.createFloat(f3);
        this.mPropX = CanvasProperty.createFloat(f);
        this.mPropY = CanvasProperty.createFloat(f2);
        RenderNodeAnimator renderNodeAnimator = new RenderNodeAnimator(this.mPropRadius, this.mOuterRadius);
        renderNodeAnimator.setDuration(n);
        renderNodeAnimator.setInterpolator(DECEL_INTERPOLATOR);
        RenderNodeAnimator renderNodeAnimator2 = new RenderNodeAnimator(this.mPropX, this.mOuterX);
        renderNodeAnimator2.setDuration(n);
        renderNodeAnimator2.setInterpolator(DECEL_INTERPOLATOR);
        RenderNodeAnimator renderNodeAnimator3 = new RenderNodeAnimator(this.mPropY, this.mOuterY);
        renderNodeAnimator3.setDuration(n);
        renderNodeAnimator3.setInterpolator(DECEL_INTERPOLATOR);
        RenderNodeAnimator renderNodeAnimator4 = new RenderNodeAnimator(this.mPropPaint, 1, 0.0f);
        renderNodeAnimator4.setDuration(n2);
        renderNodeAnimator4.setInterpolator(LINEAR_INTERPOLATOR);
        renderNodeAnimator4.addListener(this.mAnimationListener);
        this.mPendingAnimations.add(renderNodeAnimator);
        this.mPendingAnimations.add(renderNodeAnimator4);
        this.mPendingAnimations.add(renderNodeAnimator2);
        this.mPendingAnimations.add(renderNodeAnimator3);
        this.mHardwareAnimating = true;
        this.mOpacity = 0.0f;
        this.mTweenX = 1.0f;
        this.mTweenY = 1.0f;
        this.mTweenRadius = 1.0f;
        this.invalidateSelf();
    }

    private void exitSoftware(int n, int n2) {
        ObjectAnimator objectAnimator = ObjectAnimator.ofFloat((Object)this, "radiusGravity", 1.0f);
        objectAnimator.setAutoCancel(true);
        objectAnimator.setDuration(n);
        objectAnimator.setInterpolator(DECEL_INTERPOLATOR);
        ObjectAnimator objectAnimator2 = ObjectAnimator.ofFloat((Object)this, "xGravity", 1.0f);
        objectAnimator2.setAutoCancel(true);
        objectAnimator2.setDuration(n);
        objectAnimator2.setInterpolator(DECEL_INTERPOLATOR);
        ObjectAnimator objectAnimator3 = ObjectAnimator.ofFloat((Object)this, "yGravity", 1.0f);
        objectAnimator3.setAutoCancel(true);
        objectAnimator3.setDuration(n);
        objectAnimator3.setInterpolator(DECEL_INTERPOLATOR);
        ObjectAnimator objectAnimator4 = ObjectAnimator.ofFloat((Object)this, "opacity", 0.0f);
        objectAnimator4.setAutoCancel(true);
        objectAnimator4.setDuration(n2);
        objectAnimator4.setInterpolator(LINEAR_INTERPOLATOR);
        objectAnimator4.addListener(this.mAnimationListener);
        this.mAnimRadius = objectAnimator;
        this.mAnimOpacity = objectAnimator4;
        this.mAnimX = objectAnimator2;
        this.mAnimY = objectAnimator3;
        objectAnimator.start();
        objectAnimator4.start();
        objectAnimator2.start();
        objectAnimator3.start();
    }

    private Paint getTempPaint() {
        if (this.mTempPaint == null) {
            this.mTempPaint = new Paint();
        }
        return this.mTempPaint;
    }

    private void invalidateSelf() {
        this.mOwner.invalidateSelf();
    }

    private void removeSelf() {
        if (!this.mCanceled) {
            this.mOwner.removeRipple(this);
        }
    }

    public void cancel() {
        this.mCanceled = true;
        this.cancelSoftwareAnimations();
        this.cancelHardwareAnimations(true);
        this.mCanceled = false;
    }

    public boolean draw(Canvas canvas, Paint paint) {
        boolean bl = canvas.isHardwareAccelerated();
        if (this.mCanUseHardware != bl && this.mCanUseHardware) {
            this.cancelHardwareAnimations(true);
        }
        this.mCanUseHardware = bl;
        if (bl && this.mHardwareAnimating) {
            return this.drawHardware((HardwareCanvas)canvas);
        }
        return this.drawSoftware(canvas, paint);
    }

    public void enter() {
        this.cancel();
        int n = (int)(0.5 + 1000.0 * Math.sqrt(this.mOuterRadius / 1024.0f * this.mDensity));
        ObjectAnimator objectAnimator = ObjectAnimator.ofFloat((Object)this, "radiusGravity", 1.0f);
        objectAnimator.setAutoCancel(true);
        objectAnimator.setDuration(n);
        objectAnimator.setInterpolator(LINEAR_INTERPOLATOR);
        objectAnimator.setStartDelay(80L);
        ObjectAnimator objectAnimator2 = ObjectAnimator.ofFloat((Object)this, "xGravity", 1.0f);
        objectAnimator2.setAutoCancel(true);
        objectAnimator2.setDuration(n);
        objectAnimator2.setInterpolator(LINEAR_INTERPOLATOR);
        objectAnimator2.setStartDelay(80L);
        ObjectAnimator objectAnimator3 = ObjectAnimator.ofFloat((Object)this, "yGravity", 1.0f);
        objectAnimator3.setAutoCancel(true);
        objectAnimator3.setDuration(n);
        objectAnimator3.setInterpolator(LINEAR_INTERPOLATOR);
        objectAnimator3.setStartDelay(80L);
        this.mAnimRadius = objectAnimator;
        this.mAnimX = objectAnimator2;
        this.mAnimY = objectAnimator3;
        objectAnimator.start();
        objectAnimator2.start();
        objectAnimator3.start();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void exit() {
        this.cancel();
        float f = MathUtils.lerp(0.0f, this.mOuterRadius, this.mTweenRadius);
        float f2 = this.mAnimRadius != null && this.mAnimRadius.isRunning() ? this.mOuterRadius - f : this.mOuterRadius;
        int n = (int)(0.5 + 1000.0 * Math.sqrt(f2 / 4424.0f * this.mDensity));
        int n2 = (int)(0.5f + 1000.0f * this.mOpacity / 3.0f);
        if (this.mCanUseHardware) {
            this.exitHardware(n, n2);
            return;
        }
        this.exitSoftware(n, n2);
    }

    public void getBounds(Rect rect) {
        int n = (int)this.mOuterX;
        int n2 = (int)this.mOuterY;
        int n3 = 1 + (int)this.mOuterRadius;
        rect.set(n - n3, n2 - n3, n + n3, n2 + n3);
    }

    public float getOpacity() {
        return this.mOpacity;
    }

    public float getRadiusGravity() {
        return this.mTweenRadius;
    }

    public float getXGravity() {
        return this.mTweenX;
    }

    public float getYGravity() {
        return this.mTweenY;
    }

    public boolean isHardwareAnimating() {
        return this.mHardwareAnimating;
    }

    public void jump() {
        this.mCanceled = true;
        this.endSoftwareAnimations();
        this.cancelHardwareAnimations(true);
        this.mCanceled = false;
    }

    public void move(float f, float f2) {
        this.mStartingX = f;
        this.mStartingY = f2;
        this.clampStartingPosition();
    }

    public void onHotspotBoundsChanged() {
        if (!this.mHasMaxRadius) {
            float f = (float)this.mBounds.width() / 2.0f;
            float f2 = (float)this.mBounds.height() / 2.0f;
            this.mOuterRadius = (float)Math.sqrt(f * f + f2 * f2);
            this.clampStartingPosition();
        }
    }

    public void setOpacity(float f) {
        this.mOpacity = f;
        this.invalidateSelf();
    }

    public void setRadiusGravity(float f) {
        this.mTweenRadius = f;
        this.invalidateSelf();
    }

    public void setXGravity(float f) {
        this.mTweenX = f;
        this.invalidateSelf();
    }

    public void setYGravity(float f) {
        this.mTweenY = f;
        this.invalidateSelf();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setup(int n, int n2, float f) {
        this.mColorOpaque = 0xFF000000 | n2;
        if (n != -1) {
            this.mHasMaxRadius = true;
            this.mOuterRadius = n;
        } else {
            float f2 = (float)this.mBounds.width() / 2.0f;
            float f3 = (float)this.mBounds.height() / 2.0f;
            this.mOuterRadius = (float)Math.sqrt(f2 * f2 + f3 * f3);
        }
        this.mOuterX = 0.0f;
        this.mOuterY = 0.0f;
        this.mDensity = f;
        this.clampStartingPosition();
    }

    private static final class LogInterpolator
    implements TimeInterpolator {
        private LogInterpolator() {
        }

        @Override
        public float getInterpolation(float f) {
            return 1.0f - (float)Math.pow(400.0, 1.4 * (double)(-f));
        }
    }
}

