/*
 * Decompiled with CFR 0.152.
 */
package android.hardware;

import android.hardware.CameraInfo;
import android.hardware.ICameraClient;
import android.hardware.ICameraServiceListener;
import android.hardware.IProCameraCallbacks;
import android.hardware.camera2.ICameraDeviceCallbacks;
import android.hardware.camera2.impl.CameraMetadataNative;
import android.hardware.camera2.utils.BinderHolder;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface ICameraService
extends IInterface {
    public int addListener(ICameraServiceListener var1) throws RemoteException;

    public int connect(ICameraClient var1, int var2, String var3, int var4, BinderHolder var5) throws RemoteException;

    public int connectDevice(ICameraDeviceCallbacks var1, int var2, String var3, int var4, BinderHolder var5) throws RemoteException;

    public int connectLegacy(ICameraClient var1, int var2, int var3, String var4, int var5, BinderHolder var6) throws RemoteException;

    public int connectPro(IProCameraCallbacks var1, int var2, String var3, int var4, BinderHolder var5) throws RemoteException;

    public int getCameraCharacteristics(int var1, CameraMetadataNative var2) throws RemoteException;

    public int getCameraInfo(int var1, CameraInfo var2) throws RemoteException;

    public int getCameraVendorTagDescriptor(BinderHolder var1) throws RemoteException;

    public int getLegacyParameters(int var1, String[] var2) throws RemoteException;

    public int getNumberOfCameras() throws RemoteException;

    public int removeListener(ICameraServiceListener var1) throws RemoteException;

    public int supportsCameraApi(int var1, int var2) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ICameraService {
        private static final String DESCRIPTOR = "android.hardware.ICameraService";
        static final int TRANSACTION_addListener = 6;
        static final int TRANSACTION_connect = 3;
        static final int TRANSACTION_connectDevice = 5;
        static final int TRANSACTION_connectLegacy = 12;
        static final int TRANSACTION_connectPro = 4;
        static final int TRANSACTION_getCameraCharacteristics = 8;
        static final int TRANSACTION_getCameraInfo = 2;
        static final int TRANSACTION_getCameraVendorTagDescriptor = 9;
        static final int TRANSACTION_getLegacyParameters = 10;
        static final int TRANSACTION_getNumberOfCameras = 1;
        static final int TRANSACTION_removeListener = 7;
        static final int TRANSACTION_supportsCameraApi = 11;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static ICameraService asInterface(IBinder iBinder) {
            if (iBinder == null) {
                return null;
            }
            IInterface iInterface = iBinder.queryLocalInterface(DESCRIPTOR);
            if (iInterface != null && iInterface instanceof ICameraService) {
                return (ICameraService)iInterface;
            }
            return new Proxy(iBinder);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public boolean onTransact(int n, Parcel parcel, Parcel parcel2, int n2) throws RemoteException {
            switch (n) {
                default: {
                    return super.onTransact(n, parcel, parcel2, n2);
                }
                case 1598968902: {
                    parcel2.writeString(DESCRIPTOR);
                    return true;
                }
                case 1: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n3 = this.getNumberOfCameras();
                    parcel2.writeNoException();
                    parcel2.writeInt(n3);
                    return true;
                }
                case 2: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n4 = parcel.readInt();
                    CameraInfo cameraInfo = new CameraInfo();
                    int n5 = this.getCameraInfo(n4, cameraInfo);
                    parcel2.writeNoException();
                    parcel2.writeInt(n5);
                    if (cameraInfo != null) {
                        parcel2.writeInt(1);
                        cameraInfo.writeToParcel(parcel2, 1);
                        return true;
                    }
                    parcel2.writeInt(0);
                    return true;
                }
                case 3: {
                    parcel.enforceInterface(DESCRIPTOR);
                    ICameraClient iCameraClient = ICameraClient.Stub.asInterface(parcel.readStrongBinder());
                    int n6 = parcel.readInt();
                    String string2 = parcel.readString();
                    int n7 = parcel.readInt();
                    BinderHolder binderHolder = new BinderHolder();
                    int n8 = this.connect(iCameraClient, n6, string2, n7, binderHolder);
                    parcel2.writeNoException();
                    parcel2.writeInt(n8);
                    if (binderHolder != null) {
                        parcel2.writeInt(1);
                        binderHolder.writeToParcel(parcel2, 1);
                        return true;
                    }
                    parcel2.writeInt(0);
                    return true;
                }
                case 4: {
                    parcel.enforceInterface(DESCRIPTOR);
                    IProCameraCallbacks iProCameraCallbacks = IProCameraCallbacks.Stub.asInterface(parcel.readStrongBinder());
                    int n9 = parcel.readInt();
                    String string3 = parcel.readString();
                    int n10 = parcel.readInt();
                    BinderHolder binderHolder = new BinderHolder();
                    int n11 = this.connectPro(iProCameraCallbacks, n9, string3, n10, binderHolder);
                    parcel2.writeNoException();
                    parcel2.writeInt(n11);
                    if (binderHolder != null) {
                        parcel2.writeInt(1);
                        binderHolder.writeToParcel(parcel2, 1);
                        return true;
                    }
                    parcel2.writeInt(0);
                    return true;
                }
                case 5: {
                    parcel.enforceInterface(DESCRIPTOR);
                    ICameraDeviceCallbacks iCameraDeviceCallbacks = ICameraDeviceCallbacks.Stub.asInterface(parcel.readStrongBinder());
                    int n12 = parcel.readInt();
                    String string4 = parcel.readString();
                    int n13 = parcel.readInt();
                    BinderHolder binderHolder = new BinderHolder();
                    int n14 = this.connectDevice(iCameraDeviceCallbacks, n12, string4, n13, binderHolder);
                    parcel2.writeNoException();
                    parcel2.writeInt(n14);
                    if (binderHolder != null) {
                        parcel2.writeInt(1);
                        binderHolder.writeToParcel(parcel2, 1);
                        return true;
                    }
                    parcel2.writeInt(0);
                    return true;
                }
                case 6: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n15 = this.addListener(ICameraServiceListener.Stub.asInterface(parcel.readStrongBinder()));
                    parcel2.writeNoException();
                    parcel2.writeInt(n15);
                    return true;
                }
                case 7: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n16 = this.removeListener(ICameraServiceListener.Stub.asInterface(parcel.readStrongBinder()));
                    parcel2.writeNoException();
                    parcel2.writeInt(n16);
                    return true;
                }
                case 8: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n17 = parcel.readInt();
                    CameraMetadataNative cameraMetadataNative = new CameraMetadataNative();
                    int n18 = this.getCameraCharacteristics(n17, cameraMetadataNative);
                    parcel2.writeNoException();
                    parcel2.writeInt(n18);
                    if (cameraMetadataNative != null) {
                        parcel2.writeInt(1);
                        cameraMetadataNative.writeToParcel(parcel2, 1);
                        return true;
                    }
                    parcel2.writeInt(0);
                    return true;
                }
                case 9: {
                    parcel.enforceInterface(DESCRIPTOR);
                    BinderHolder binderHolder = new BinderHolder();
                    int n19 = this.getCameraVendorTagDescriptor(binderHolder);
                    parcel2.writeNoException();
                    parcel2.writeInt(n19);
                    if (binderHolder != null) {
                        parcel2.writeInt(1);
                        binderHolder.writeToParcel(parcel2, 1);
                        return true;
                    }
                    parcel2.writeInt(0);
                    return true;
                }
                case 10: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n20 = parcel.readInt();
                    int n21 = parcel.readInt();
                    String[] stringArray = n21 < 0 ? null : new String[n21];
                    int n22 = this.getLegacyParameters(n20, stringArray);
                    parcel2.writeNoException();
                    parcel2.writeInt(n22);
                    parcel2.writeStringArray(stringArray);
                    return true;
                }
                case 11: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n23 = this.supportsCameraApi(parcel.readInt(), parcel.readInt());
                    parcel2.writeNoException();
                    parcel2.writeInt(n23);
                    return true;
                }
                case 12: 
            }
            parcel.enforceInterface(DESCRIPTOR);
            ICameraClient iCameraClient = ICameraClient.Stub.asInterface(parcel.readStrongBinder());
            int n24 = parcel.readInt();
            int n25 = parcel.readInt();
            String string5 = parcel.readString();
            int n26 = parcel.readInt();
            BinderHolder binderHolder = new BinderHolder();
            int n27 = this.connectLegacy(iCameraClient, n24, n25, string5, n26, binderHolder);
            parcel2.writeNoException();
            parcel2.writeInt(n27);
            if (binderHolder != null) {
                parcel2.writeInt(1);
                binderHolder.writeToParcel(parcel2, 1);
                return true;
            }
            parcel2.writeInt(0);
            return true;
        }

        private static class Proxy
        implements ICameraService {
            private IBinder mRemote;

            Proxy(IBinder iBinder) {
                this.mRemote = iBinder;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public int addListener(ICameraServiceListener iCameraServiceListener) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    IBinder iBinder = iCameraServiceListener != null ? iCameraServiceListener.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    this.mRemote.transact(6, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    parcel2.recycle();
                    parcel.recycle();
                    return n;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public int connect(ICameraClient iCameraClient, int n, String string2, int n2, BinderHolder binderHolder) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    IBinder iBinder = iCameraClient != null ? iCameraClient.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    parcel.writeInt(n);
                    parcel.writeString(string2);
                    parcel.writeInt(n2);
                    this.mRemote.transact(3, parcel, parcel2, 0);
                    parcel2.readException();
                    int n3 = parcel2.readInt();
                    if (parcel2.readInt() != 0) {
                        binderHolder.readFromParcel(parcel2);
                    }
                    parcel2.recycle();
                    parcel.recycle();
                    return n3;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public int connectDevice(ICameraDeviceCallbacks iCameraDeviceCallbacks, int n, String string2, int n2, BinderHolder binderHolder) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    IBinder iBinder = iCameraDeviceCallbacks != null ? iCameraDeviceCallbacks.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    parcel.writeInt(n);
                    parcel.writeString(string2);
                    parcel.writeInt(n2);
                    this.mRemote.transact(5, parcel, parcel2, 0);
                    parcel2.readException();
                    int n3 = parcel2.readInt();
                    if (parcel2.readInt() != 0) {
                        binderHolder.readFromParcel(parcel2);
                    }
                    parcel2.recycle();
                    parcel.recycle();
                    return n3;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public int connectLegacy(ICameraClient iCameraClient, int n, int n2, String string2, int n3, BinderHolder binderHolder) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    IBinder iBinder = iCameraClient != null ? iCameraClient.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    parcel.writeInt(n);
                    parcel.writeInt(n2);
                    parcel.writeString(string2);
                    parcel.writeInt(n3);
                    this.mRemote.transact(12, parcel, parcel2, 0);
                    parcel2.readException();
                    int n4 = parcel2.readInt();
                    if (parcel2.readInt() != 0) {
                        binderHolder.readFromParcel(parcel2);
                    }
                    parcel2.recycle();
                    parcel.recycle();
                    return n4;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public int connectPro(IProCameraCallbacks iProCameraCallbacks, int n, String string2, int n2, BinderHolder binderHolder) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    IBinder iBinder = iProCameraCallbacks != null ? iProCameraCallbacks.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    parcel.writeInt(n);
                    parcel.writeString(string2);
                    parcel.writeInt(n2);
                    this.mRemote.transact(4, parcel, parcel2, 0);
                    parcel2.readException();
                    int n3 = parcel2.readInt();
                    if (parcel2.readInt() != 0) {
                        binderHolder.readFromParcel(parcel2);
                    }
                    parcel2.recycle();
                    parcel.recycle();
                    return n3;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public int getCameraCharacteristics(int n, CameraMetadataNative cameraMetadataNative) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    this.mRemote.transact(8, parcel, parcel2, 0);
                    parcel2.readException();
                    int n2 = parcel2.readInt();
                    if (parcel2.readInt() != 0) {
                        cameraMetadataNative.readFromParcel(parcel2);
                    }
                    return n2;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public int getCameraInfo(int n, CameraInfo cameraInfo) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    this.mRemote.transact(2, parcel, parcel2, 0);
                    parcel2.readException();
                    int n2 = parcel2.readInt();
                    if (parcel2.readInt() != 0) {
                        cameraInfo.readFromParcel(parcel2);
                    }
                    return n2;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public int getCameraVendorTagDescriptor(BinderHolder binderHolder) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(9, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    if (parcel2.readInt() != 0) {
                        binderHolder.readFromParcel(parcel2);
                    }
                    return n;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public int getLegacyParameters(int n, String[] stringArray) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    if (stringArray == null) {
                        parcel.writeInt(-1);
                    } else {
                        parcel.writeInt(stringArray.length);
                    }
                    this.mRemote.transact(10, parcel, parcel2, 0);
                    parcel2.readException();
                    int n2 = parcel2.readInt();
                    parcel2.readStringArray(stringArray);
                    return n2;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public int getNumberOfCameras() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(1, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    return n;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public int removeListener(ICameraServiceListener iCameraServiceListener) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    IBinder iBinder = iCameraServiceListener != null ? iCameraServiceListener.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    this.mRemote.transact(7, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    parcel2.recycle();
                    parcel.recycle();
                    return n;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public int supportsCameraApi(int n, int n2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    parcel.writeInt(n2);
                    this.mRemote.transact(11, parcel, parcel2, 0);
                    parcel2.readException();
                    int n3 = parcel2.readInt();
                    return n3;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }
        }
    }
}

