/*
 * Decompiled with CFR 0.152.
 */
package android.hardware;

import android.content.Context;
import android.hardware.ISerialManager;
import android.hardware.SerialPort;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.util.Log;
import java.io.IOException;

public class SerialManager {
    private static final String TAG = "SerialManager";
    private final Context mContext;
    private final ISerialManager mService;

    public SerialManager(Context context, ISerialManager iSerialManager) {
        this.mContext = context;
        this.mService = iSerialManager;
    }

    public String[] getSerialPorts() {
        try {
            String[] stringArray = this.mService.getSerialPorts();
            return stringArray;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "RemoteException in getSerialPorts", remoteException);
            return null;
        }
    }

    public SerialPort openSerialPort(String string2, int n) throws IOException {
        block4: {
            ParcelFileDescriptor parcelFileDescriptor;
            try {
                parcelFileDescriptor = this.mService.openSerialPort(string2);
                if (parcelFileDescriptor == null) break block4;
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, "exception in UsbManager.openDevice", remoteException);
                return null;
            }
            SerialPort serialPort = new SerialPort(string2);
            serialPort.open(parcelFileDescriptor, n);
            return serialPort;
        }
        throw new IOException("Could not open serial port " + string2);
    }
}

