/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.params;

import android.graphics.ImageFormat;
import android.graphics.PixelFormat;
import android.graphics.SurfaceTexture;
import android.hardware.camera2.params.HighSpeedVideoConfiguration;
import android.hardware.camera2.params.StreamConfiguration;
import android.hardware.camera2.params.StreamConfigurationDuration;
import android.hardware.camera2.utils.HashCodeHelpers;
import android.media.ImageReader;
import android.media.MediaCodec;
import android.media.MediaRecorder;
import android.renderscript.Allocation;
import android.util.Range;
import android.util.Size;
import android.view.Surface;
import android.view.SurfaceHolder;
import com.android.internal.util.Preconditions;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Objects;
import java.util.Set;

public final class StreamConfigurationMap {
    private static final int DURATION_MIN_FRAME = 0;
    private static final int DURATION_STALL = 1;
    private static final int HAL_PIXEL_FORMAT_BLOB = 33;
    private static final int HAL_PIXEL_FORMAT_IMPLEMENTATION_DEFINED = 34;
    private static final int HAL_PIXEL_FORMAT_RAW_OPAQUE = 36;
    private static final String TAG = "StreamConfigurationMap";
    private final StreamConfiguration[] mConfigurations;
    private final HighSpeedVideoConfiguration[] mHighSpeedVideoConfigurations;
    private final HashMap<Range<Integer>, Integer> mHighSpeedVideoFpsRangeMap;
    private final HashMap<Size, Integer> mHighSpeedVideoSizeMap;
    private final HashMap<Integer, Integer> mInputFormats;
    private final StreamConfigurationDuration[] mMinFrameDurations;
    private final HashMap<Integer, Integer> mOutputFormats = new HashMap();
    private final StreamConfigurationDuration[] mStallDurations;

    /*
     * Enabled aggressive block sorting
     */
    public StreamConfigurationMap(StreamConfiguration[] streamConfigurationArray, StreamConfigurationDuration[] streamConfigurationDurationArray, StreamConfigurationDuration[] streamConfigurationDurationArray2, HighSpeedVideoConfiguration[] highSpeedVideoConfigurationArray) {
        this.mInputFormats = new HashMap();
        this.mHighSpeedVideoSizeMap = new HashMap();
        this.mHighSpeedVideoFpsRangeMap = new HashMap();
        this.mConfigurations = Preconditions.checkArrayElementsNotNull(streamConfigurationArray, "configurations");
        this.mMinFrameDurations = Preconditions.checkArrayElementsNotNull(streamConfigurationDurationArray, "minFrameDurations");
        this.mStallDurations = Preconditions.checkArrayElementsNotNull(streamConfigurationDurationArray2, "stallDurations");
        this.mHighSpeedVideoConfigurations = highSpeedVideoConfigurationArray == null ? new HighSpeedVideoConfiguration[0] : Preconditions.checkArrayElementsNotNull(highSpeedVideoConfigurationArray, "highSpeedVideoConfigurations");
        for (StreamConfiguration streamConfiguration : streamConfigurationArray) {
            HashMap<Integer, Integer> hashMap = streamConfiguration.isOutput() ? this.mOutputFormats : this.mInputFormats;
            Integer n = hashMap.get(streamConfiguration.getFormat());
            if (n == null) {
                n = 0;
            }
            Integer n2 = 1 + n;
            hashMap.put(streamConfiguration.getFormat(), n2);
        }
        if (!this.mOutputFormats.containsKey(34)) {
            throw new AssertionError((Object)"At least one stream configuration for IMPLEMENTATION_DEFINED must exist");
        }
        HighSpeedVideoConfiguration[] highSpeedVideoConfigurationArray2 = this.mHighSpeedVideoConfigurations;
        int n = highSpeedVideoConfigurationArray2.length;
        int n3 = 0;
        while (n3 < n) {
            HighSpeedVideoConfiguration highSpeedVideoConfiguration = highSpeedVideoConfigurationArray2[n3];
            Size size = highSpeedVideoConfiguration.getSize();
            Range<Integer> range = highSpeedVideoConfiguration.getFpsRange();
            Integer n4 = this.mHighSpeedVideoSizeMap.get(size);
            if (n4 == null) {
                n4 = 0;
            }
            this.mHighSpeedVideoSizeMap.put(size, 1 + n4);
            Integer n5 = this.mHighSpeedVideoFpsRangeMap.get(range);
            if (n5 == null) {
                n5 = 0;
            }
            this.mHighSpeedVideoFpsRangeMap.put(range, 1 + n5);
            ++n3;
        }
        return;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static <T> boolean arrayContains(T[] TArray, T t) {
        if (TArray != null) {
            int n = TArray.length;
            for (int i = 0; i < n; ++i) {
                if (!Objects.equals(TArray[i], t)) continue;
                return true;
            }
        }
        return false;
    }

    static int checkArgumentFormat(int n) {
        if (!ImageFormat.isPublicFormat(n) && !PixelFormat.isPublicFormat(n)) {
            Object[] objectArray = new Object[]{n};
            throw new IllegalArgumentException(String.format("format 0x%x was not defined in either ImageFormat or PixelFormat", objectArray));
        }
        return n;
    }

    static int checkArgumentFormatInternal(int n) {
        switch (n) {
            default: {
                n = StreamConfigurationMap.checkArgumentFormat(n);
            }
            case 33: 
            case 34: 
            case 36: {
                return n;
            }
            case 256: 
        }
        throw new IllegalArgumentException("ImageFormat.JPEG is an unknown internal format");
    }

    /*
     * Enabled aggressive block sorting
     */
    private int checkArgumentFormatSupported(int n, boolean bl) {
        StreamConfigurationMap.checkArgumentFormat(n);
        int[] nArray = bl ? this.getOutputFormats() : this.getInputFormats();
        int n2 = 0;
        while (true) {
            if (n2 >= nArray.length) {
                Object[] objectArray = new Object[]{n};
                throw new IllegalArgumentException(String.format("format %x is not supported by this stream configuration map", objectArray));
            }
            if (n == nArray[n2]) {
                return n;
            }
            ++n2;
        }
    }

    private StreamConfigurationDuration[] getDurations(int n) {
        switch (n) {
            default: {
                throw new IllegalArgumentException("duration was invalid");
            }
            case 0: {
                return this.mMinFrameDurations;
            }
            case 1: 
        }
        return this.mStallDurations;
    }

    private HashMap<Integer, Integer> getFormatsMap(boolean bl) {
        if (bl) {
            return this.mOutputFormats;
        }
        return this.mInputFormats;
    }

    private long getInternalFormatDuration(int n, Size size, int n2) {
        if (!StreamConfigurationMap.arrayContains(this.getInternalFormatSizes(n, true), size)) {
            throw new IllegalArgumentException("size was not supported");
        }
        for (StreamConfigurationDuration streamConfigurationDuration : this.getDurations(n2)) {
            if (streamConfigurationDuration.getFormat() != n || streamConfigurationDuration.getWidth() != size.getWidth() || streamConfigurationDuration.getHeight() != size.getHeight()) continue;
            return streamConfigurationDuration.getDuration();
        }
        return 0L;
    }

    /*
     * Enabled aggressive block sorting
     */
    private Size[] getInternalFormatSizes(int n, boolean bl) {
        Integer n2 = this.getFormatsMap(bl).get(n);
        if (n2 == null) {
            throw new IllegalArgumentException("format not available");
        }
        int n3 = n2;
        Size[] sizeArray = new Size[n3];
        StreamConfiguration[] streamConfigurationArray = this.mConfigurations;
        int n4 = streamConfigurationArray.length;
        int n5 = 0;
        for (int i = 0; i < n4; ++i) {
            int n6;
            StreamConfiguration streamConfiguration = streamConfigurationArray[i];
            if (streamConfiguration.getFormat() == n && streamConfiguration.isOutput() == bl) {
                n6 = n5 + 1;
                sizeArray[n5] = streamConfiguration.getSize();
            } else {
                n6 = n5;
            }
            n5 = n6;
        }
        if (n5 != n3) {
            throw new AssertionError((Object)("Too few sizes (expected " + n3 + ", actual " + n5 + ")"));
        }
        return sizeArray;
    }

    private int getPublicFormatCount(boolean bl) {
        HashMap<Integer, Integer> hashMap = this.getFormatsMap(bl);
        int n = hashMap.size();
        if (hashMap.containsKey(34)) {
            --n;
        }
        return n;
    }

    private Size[] getPublicFormatSizes(int n, boolean bl) {
        try {
            this.checkArgumentFormatSupported(n, bl);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
        return this.getInternalFormatSizes(StreamConfigurationMap.imageFormatToInternal(n), bl);
    }

    private int[] getPublicFormats(boolean bl) {
        int[] nArray = new int[this.getPublicFormatCount(bl)];
        int n = 0;
        for (int n2 : this.getFormatsMap(bl).keySet()) {
            if (n2 == 34) continue;
            int n3 = n + 1;
            nArray[n] = n2;
            n = n3;
        }
        if (nArray.length != n) {
            throw new AssertionError((Object)("Too few formats " + n + ", expected " + nArray.length));
        }
        return StreamConfigurationMap.imageFormatToPublic(nArray);
    }

    static int imageFormatToInternal(int n) {
        switch (n) {
            default: {
                return n;
            }
            case 256: {
                return 33;
            }
            case 34: 
        }
        throw new IllegalArgumentException("IMPLEMENTATION_DEFINED is not allowed via public API");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int[] imageFormatToInternal(int[] nArray) {
        if (nArray == null) {
            return null;
        }
        int n = 0;
        while (n < nArray.length) {
            nArray[n] = StreamConfigurationMap.imageFormatToInternal(nArray[n]);
            ++n;
        }
        return nArray;
    }

    static int imageFormatToPublic(int n) {
        switch (n) {
            default: {
                return n;
            }
            case 33: {
                return 256;
            }
            case 256: {
                throw new IllegalArgumentException("ImageFormat.JPEG is an unknown internal format");
            }
            case 34: 
        }
        throw new IllegalArgumentException("IMPLEMENTATION_DEFINED must not leak to public API");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static int[] imageFormatToPublic(int[] nArray) {
        if (nArray == null) {
            return null;
        }
        int n = 0;
        while (n < nArray.length) {
            nArray[n] = StreamConfigurationMap.imageFormatToPublic(nArray[n]);
            ++n;
        }
        return nArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static <T> boolean isOutputSupportedFor(Class<T> clazz) {
        Preconditions.checkNotNull(clazz, "klass must not be null");
        return clazz == ImageReader.class || clazz == MediaRecorder.class || clazz == MediaCodec.class || clazz == Allocation.class || clazz == SurfaceHolder.class || clazz == SurfaceTexture.class;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        boolean bl = true;
        if (object == null) {
            return false;
        }
        if (this == object) {
            return bl;
        }
        if (!(object instanceof StreamConfigurationMap)) return false;
        StreamConfigurationMap streamConfigurationMap = (StreamConfigurationMap)object;
        if (!Arrays.equals(this.mConfigurations, streamConfigurationMap.mConfigurations)) return false;
        if (!Arrays.equals(this.mMinFrameDurations, streamConfigurationMap.mMinFrameDurations)) return false;
        if (!Arrays.equals(this.mStallDurations, streamConfigurationMap.mStallDurations)) return false;
        if (!Arrays.equals(this.mHighSpeedVideoConfigurations, streamConfigurationMap.mHighSpeedVideoConfigurations)) return false;
        return bl;
    }

    public Range<Integer>[] getHighSpeedVideoFpsRanges() {
        Set<Range<Integer>> set = this.mHighSpeedVideoFpsRangeMap.keySet();
        return set.toArray(new Range[set.size()]);
    }

    /*
     * Enabled aggressive block sorting
     */
    public Range<Integer>[] getHighSpeedVideoFpsRangesFor(Size size) {
        Integer n = this.mHighSpeedVideoSizeMap.get(size);
        if (n == null || n == 0) {
            throw new IllegalArgumentException(String.format("Size %s does not support high speed video recording", size));
        }
        Range[] rangeArray = new Range[n.intValue()];
        HighSpeedVideoConfiguration[] highSpeedVideoConfigurationArray = this.mHighSpeedVideoConfigurations;
        int n2 = highSpeedVideoConfigurationArray.length;
        int n3 = 0;
        int n4 = 0;
        while (n3 < n2) {
            int n5;
            HighSpeedVideoConfiguration highSpeedVideoConfiguration = highSpeedVideoConfigurationArray[n3];
            if (size.equals(highSpeedVideoConfiguration.getSize())) {
                n5 = n4 + 1;
                rangeArray[n4] = highSpeedVideoConfiguration.getFpsRange();
            } else {
                n5 = n4;
            }
            ++n3;
            n4 = n5;
        }
        return rangeArray;
    }

    public Size[] getHighSpeedVideoSizes() {
        Set<Size> set = this.mHighSpeedVideoSizeMap.keySet();
        return set.toArray(new Size[set.size()]);
    }

    /*
     * Enabled aggressive block sorting
     */
    public Size[] getHighSpeedVideoSizesFor(Range<Integer> range) {
        Integer n = this.mHighSpeedVideoFpsRangeMap.get(range);
        if (n == null || n == 0) {
            throw new IllegalArgumentException(String.format("FpsRange %s does not support high speed video recording", range));
        }
        Size[] sizeArray = new Size[n.intValue()];
        HighSpeedVideoConfiguration[] highSpeedVideoConfigurationArray = this.mHighSpeedVideoConfigurations;
        int n2 = highSpeedVideoConfigurationArray.length;
        int n3 = 0;
        int n4 = 0;
        while (n3 < n2) {
            int n5;
            HighSpeedVideoConfiguration highSpeedVideoConfiguration = highSpeedVideoConfigurationArray[n3];
            if (range.equals(highSpeedVideoConfiguration.getFpsRange())) {
                n5 = n4 + 1;
                sizeArray[n4] = highSpeedVideoConfiguration.getSize();
            } else {
                n5 = n4;
            }
            ++n3;
            n4 = n5;
        }
        return sizeArray;
    }

    public final int[] getInputFormats() {
        return this.getPublicFormats(false);
    }

    public Size[] getInputSizes(int n) {
        return this.getPublicFormatSizes(n, false);
    }

    public final int[] getOutputFormats() {
        return this.getPublicFormats(true);
    }

    public long getOutputMinFrameDuration(int n, Size size) {
        Preconditions.checkNotNull(size, "size must not be null");
        this.checkArgumentFormatSupported(n, true);
        return this.getInternalFormatDuration(StreamConfigurationMap.imageFormatToInternal(n), size, 0);
    }

    public <T> long getOutputMinFrameDuration(Class<T> clazz, Size size) {
        if (!StreamConfigurationMap.isOutputSupportedFor(clazz)) {
            throw new IllegalArgumentException("klass was not supported");
        }
        return this.getInternalFormatDuration(34, size, 0);
    }

    public Size[] getOutputSizes(int n) {
        return this.getPublicFormatSizes(n, true);
    }

    public <T> Size[] getOutputSizes(Class<T> clazz) {
        if (ImageReader.class.isAssignableFrom(clazz)) {
            return new Size[0];
        }
        if (!StreamConfigurationMap.isOutputSupportedFor(clazz)) {
            return null;
        }
        return this.getInternalFormatSizes(34, true);
    }

    public long getOutputStallDuration(int n, Size size) {
        this.checkArgumentFormatSupported(n, true);
        return this.getInternalFormatDuration(StreamConfigurationMap.imageFormatToInternal(n), size, 1);
    }

    public <T> long getOutputStallDuration(Class<T> clazz, Size size) {
        if (!StreamConfigurationMap.isOutputSupportedFor(clazz)) {
            throw new IllegalArgumentException("klass was not supported");
        }
        return this.getInternalFormatDuration(34, size, 1);
    }

    public int hashCode() {
        return HashCodeHelpers.hashCode(this.mConfigurations, this.mMinFrameDurations, this.mStallDurations, this.mHighSpeedVideoConfigurations);
    }

    public boolean isOutputSupportedFor(int n) {
        StreamConfigurationMap.checkArgumentFormat(n);
        int n2 = StreamConfigurationMap.imageFormatToInternal(n);
        return this.getFormatsMap(true).containsKey(n2);
    }

    public boolean isOutputSupportedFor(Surface surface) {
        Preconditions.checkNotNull(surface, "surface must not be null");
        throw new UnsupportedOperationException("Not implemented yet");
    }
}

