/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.utils;

import android.util.Log;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public class ArrayUtils {
    private static final String TAG = "ArrayUtils";
    private static final boolean VERBOSE = Log.isLoggable("ArrayUtils", 2);

    private ArrayUtils() {
        throw new AssertionError();
    }

    public static boolean contains(int[] nArray, int n) {
        return ArrayUtils.getArrayIndex(nArray, n) != -1;
    }

    public static <T> boolean contains(T[] TArray, T t) {
        return ArrayUtils.getArrayIndex(TArray, t) != -1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int[] convertStringListToIntArray(List<String> list, String[] stringArray, int[] nArray) {
        if (list == null) {
            return null;
        }
        List<Integer> list2 = ArrayUtils.convertStringListToIntList(list, stringArray, nArray);
        int[] nArray2 = new int[list2.size()];
        int n = 0;
        while (n < nArray2.length) {
            nArray2[n] = list2.get(n);
            ++n;
        }
        return nArray2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<Integer> convertStringListToIntList(List<String> list, String[] stringArray, int[] nArray) {
        if (list == null) {
            return null;
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>(list.size());
        Iterator<String> iterator = list.iterator();
        while (iterator.hasNext()) {
            String string2 = iterator.next();
            int n = ArrayUtils.getArrayIndex(stringArray, string2);
            if (n < 0) {
                Log.w(TAG, "Ignoring invalid value " + string2);
                continue;
            }
            if (n >= nArray.length) continue;
            arrayList.add(nArray[n]);
        }
        return arrayList;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int getArrayIndex(int[] nArray, int n) {
        if (nArray == null) {
            return -1;
        }
        int n2 = 0;
        while (n2 < nArray.length) {
            if (nArray[n2] == n) return n2;
            ++n2;
        }
        return -1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static <T> int getArrayIndex(T[] TArray, T t) {
        if (TArray == null) {
            return -1;
        }
        int n = 0;
        int n2 = TArray.length;
        int n3 = 0;
        while (n3 < n2) {
            if (Objects.equals(TArray[n3], t)) return n;
            ++n;
            ++n3;
        }
        return -1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int[] toIntArray(List<Integer> list) {
        if (list == null) {
            return null;
        }
        int[] nArray = new int[list.size()];
        int n = 0;
        Iterator<Integer> iterator = list.iterator();
        while (iterator.hasNext()) {
            nArray[n] = iterator.next();
            ++n;
        }
        return nArray;
    }
}

