/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.display;

import android.os.Parcel;
import android.os.Parcelable;
import libcore.util.Objects;

public final class WifiDisplay
implements Parcelable {
    public static final Parcelable.Creator<WifiDisplay> CREATOR;
    public static final WifiDisplay[] EMPTY_ARRAY;
    private final boolean mCanConnect;
    private final String mDeviceAddress;
    private final String mDeviceAlias;
    private final String mDeviceName;
    private final boolean mIsAvailable;
    private final boolean mIsRemembered;

    static {
        EMPTY_ARRAY = new WifiDisplay[0];
        CREATOR = new Parcelable.Creator<WifiDisplay>(){

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public WifiDisplay createFromParcel(Parcel parcel) {
                boolean bl;
                String string2 = parcel.readString();
                String string3 = parcel.readString();
                String string4 = parcel.readString();
                boolean bl2 = parcel.readInt() != 0;
                boolean bl3 = parcel.readInt() != 0;
                if (parcel.readInt() != 0) {
                    bl = true;
                    return new WifiDisplay(string2, string3, string4, bl2, bl3, bl);
                }
                bl = false;
                return new WifiDisplay(string2, string3, string4, bl2, bl3, bl);
            }

            public WifiDisplay[] newArray(int n) {
                if (n == 0) {
                    return EMPTY_ARRAY;
                }
                return new WifiDisplay[n];
            }
        };
    }

    public WifiDisplay(String string2, String string3, String string4, boolean bl, boolean bl2, boolean bl3) {
        if (string2 == null) {
            throw new IllegalArgumentException("deviceAddress must not be null");
        }
        if (string3 == null) {
            throw new IllegalArgumentException("deviceName must not be null");
        }
        this.mDeviceAddress = string2;
        this.mDeviceName = string3;
        this.mDeviceAlias = string4;
        this.mIsAvailable = bl;
        this.mCanConnect = bl2;
        this.mIsRemembered = bl3;
    }

    public boolean canConnect() {
        return this.mCanConnect;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public boolean equals(WifiDisplay wifiDisplay) {
        return wifiDisplay != null && this.mDeviceAddress.equals(wifiDisplay.mDeviceAddress) && this.mDeviceName.equals(wifiDisplay.mDeviceName) && Objects.equal((Object)this.mDeviceAlias, (Object)wifiDisplay.mDeviceAlias);
    }

    public boolean equals(Object object) {
        return object instanceof WifiDisplay && this.equals((WifiDisplay)object);
    }

    public String getDeviceAddress() {
        return this.mDeviceAddress;
    }

    public String getDeviceAlias() {
        return this.mDeviceAlias;
    }

    public String getDeviceName() {
        return this.mDeviceName;
    }

    public String getFriendlyDisplayName() {
        if (this.mDeviceAlias != null) {
            return this.mDeviceAlias;
        }
        return this.mDeviceName;
    }

    public boolean hasSameAddress(WifiDisplay wifiDisplay) {
        return wifiDisplay != null && this.mDeviceAddress.equals(wifiDisplay.mDeviceAddress);
    }

    public int hashCode() {
        return this.mDeviceAddress.hashCode();
    }

    public boolean isAvailable() {
        return this.mIsAvailable;
    }

    public boolean isRemembered() {
        return this.mIsRemembered;
    }

    public String toString() {
        String string2 = this.mDeviceName + " (" + this.mDeviceAddress + ")";
        if (this.mDeviceAlias != null) {
            string2 = string2 + ", alias " + this.mDeviceAlias;
        }
        return string2 + ", isAvailable " + this.mIsAvailable + ", canConnect " + this.mCanConnect + ", isRemembered " + this.mIsRemembered;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void writeToParcel(Parcel parcel, int n) {
        int n2 = 1;
        parcel.writeString(this.mDeviceAddress);
        parcel.writeString(this.mDeviceName);
        parcel.writeString(this.mDeviceAlias);
        int n3 = this.mIsAvailable ? n2 : 0;
        parcel.writeInt(n3);
        int n4 = this.mCanConnect ? n2 : 0;
        parcel.writeInt(n4);
        if (!this.mIsRemembered) {
            n2 = 0;
        }
        parcel.writeInt(n2);
    }
}

