/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.hdmi;

import android.hardware.hdmi.HdmiClient;
import android.hardware.hdmi.HdmiDeviceInfo;
import android.hardware.hdmi.HdmiRecordListener;
import android.hardware.hdmi.HdmiRecordSources;
import android.hardware.hdmi.HdmiTimerRecordSources;
import android.hardware.hdmi.IHdmiControlCallback;
import android.hardware.hdmi.IHdmiControlService;
import android.hardware.hdmi.IHdmiInputChangeListener;
import android.hardware.hdmi.IHdmiMhlVendorCommandListener;
import android.hardware.hdmi.IHdmiRecordListener;
import android.os.RemoteException;
import android.util.Log;
import libcore.util.EmptyArray;

public final class HdmiTvClient
extends HdmiClient {
    private static final String TAG = "HdmiTvClient";
    public static final int VENDOR_DATA_SIZE = 16;

    HdmiTvClient(IHdmiControlService iHdmiControlService) {
        super(iHdmiControlService);
    }

    private void checkTimerRecordingSourceType(int n) {
        switch (n) {
            default: {
                throw new IllegalArgumentException("Invalid source type:" + n);
            }
            case 1: 
            case 2: 
            case 3: 
        }
    }

    static HdmiTvClient create(IHdmiControlService iHdmiControlService) {
        return new HdmiTvClient(iHdmiControlService);
    }

    private static IHdmiControlCallback getCallbackWrapper(final SelectCallback selectCallback) {
        return new IHdmiControlCallback.Stub(){

            @Override
            public void onComplete(int n) {
                selectCallback.onComplete(n);
            }
        };
    }

    private static IHdmiInputChangeListener getListenerWrapper(final InputChangeListener inputChangeListener) {
        return new IHdmiInputChangeListener.Stub(){

            @Override
            public void onChanged(HdmiDeviceInfo hdmiDeviceInfo) {
                inputChangeListener.onChanged(hdmiDeviceInfo);
            }
        };
    }

    private IHdmiMhlVendorCommandListener getListenerWrapper(final HdmiMhlVendorCommandListener hdmiMhlVendorCommandListener) {
        return new IHdmiMhlVendorCommandListener.Stub(){

            @Override
            public void onReceived(int n, int n2, int n3, byte[] byArray) {
                hdmiMhlVendorCommandListener.onReceived(n, n2, n3, byArray);
            }
        };
    }

    private static IHdmiRecordListener getListenerWrapper(final HdmiRecordListener hdmiRecordListener) {
        return new IHdmiRecordListener.Stub(){

            @Override
            public byte[] getOneTouchRecordSource(int n) {
                HdmiRecordSources.RecordSource recordSource = hdmiRecordListener.getOneTouchRecordSource(n);
                if (recordSource == null) {
                    return EmptyArray.BYTE;
                }
                byte[] byArray = new byte[recordSource.getDataSize(true)];
                recordSource.toByteArray(true, byArray, 0);
                return byArray;
            }

            @Override
            public void onClearTimerRecordingResult(int n) {
                hdmiRecordListener.onClearTimerRecordingResult(n);
            }

            @Override
            public void onOneTouchRecordResult(int n) {
                hdmiRecordListener.onOneTouchRecordResult(n);
            }

            @Override
            public void onTimerRecordingResult(int n) {
                hdmiRecordListener.onTimerRecordingResult(HdmiRecordListener.TimerStatusData.parseFrom(n));
            }
        };
    }

    public void clearTimerRecording(int n, int n2, HdmiTimerRecordSources.TimerRecordSource timerRecordSource) {
        if (timerRecordSource == null) {
            throw new IllegalArgumentException("source must not be null.");
        }
        this.checkTimerRecordingSourceType(n2);
        try {
            byte[] byArray = new byte[timerRecordSource.getDataSize()];
            timerRecordSource.toByteArray(byArray, 0);
            this.mService.clearTimerRecording(n, n2, byArray);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "failed to start record: ", remoteException);
            return;
        }
    }

    public void deviceSelect(int n, SelectCallback selectCallback) {
        if (selectCallback == null) {
            throw new IllegalArgumentException("callback must not be null.");
        }
        try {
            this.mService.deviceSelect(n, HdmiTvClient.getCallbackWrapper(selectCallback));
            return;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "failed to select device: ", remoteException);
            return;
        }
    }

    @Override
    public int getDeviceType() {
        return 0;
    }

    public void portSelect(int n, SelectCallback selectCallback) {
        if (selectCallback == null) {
            throw new IllegalArgumentException("Callback must not be null");
        }
        try {
            this.mService.portSelect(n, HdmiTvClient.getCallbackWrapper(selectCallback));
            return;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "failed to select port: ", remoteException);
            return;
        }
    }

    public void sendMhlVendorCommand(int n, int n2, int n3, byte[] byArray) {
        if (byArray == null || byArray.length != 16) {
            throw new IllegalArgumentException("Invalid vendor command data.");
        }
        if (n2 < 0 || n2 >= 16) {
            throw new IllegalArgumentException("Invalid offset:" + n2);
        }
        if (n3 < 0 || n2 + n3 > 16) {
            throw new IllegalArgumentException("Invalid length:" + n3);
        }
        try {
            this.mService.sendMhlVendorCommand(n, n2, n3, byArray);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "failed to send vendor command: ", remoteException);
            return;
        }
    }

    public void setHdmiMhlVendorCommandListener(HdmiMhlVendorCommandListener hdmiMhlVendorCommandListener) {
        if (hdmiMhlVendorCommandListener == null) {
            throw new IllegalArgumentException("listener must not be null.");
        }
        try {
            this.mService.addHdmiMhlVendorCommandListener(this.getListenerWrapper(hdmiMhlVendorCommandListener));
            return;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "failed to set hdmi mhl vendor command listener: ", remoteException);
            return;
        }
    }

    public void setInputChangeListener(InputChangeListener inputChangeListener) {
        if (inputChangeListener == null) {
            throw new IllegalArgumentException("listener must not be null.");
        }
        try {
            this.mService.setInputChangeListener(HdmiTvClient.getListenerWrapper(inputChangeListener));
            return;
        }
        catch (RemoteException remoteException) {
            Log.e("TAG", "Failed to set InputChangeListener:", remoteException);
            return;
        }
    }

    public void setRecordListener(HdmiRecordListener hdmiRecordListener) {
        if (hdmiRecordListener == null) {
            throw new IllegalArgumentException("listener must not be null.");
        }
        try {
            this.mService.setHdmiRecordListener(HdmiTvClient.getListenerWrapper(hdmiRecordListener));
            return;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "failed to set record listener.", remoteException);
            return;
        }
    }

    public void setSystemAudioMute(boolean bl) {
        try {
            this.mService.setSystemAudioMute(bl);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "failed to set mute: ", remoteException);
            return;
        }
    }

    public void setSystemAudioVolume(int n, int n2, int n3) {
        try {
            this.mService.setSystemAudioVolume(n, n2, n3);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "failed to set volume: ", remoteException);
            return;
        }
    }

    public void startOneTouchRecord(int n, HdmiRecordSources.RecordSource recordSource) {
        if (recordSource == null) {
            throw new IllegalArgumentException("source must not be null.");
        }
        try {
            byte[] byArray = new byte[recordSource.getDataSize(true)];
            recordSource.toByteArray(true, byArray, 0);
            this.mService.startOneTouchRecord(n, byArray);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "failed to start record: ", remoteException);
            return;
        }
    }

    public void startTimerRecording(int n, int n2, HdmiTimerRecordSources.TimerRecordSource timerRecordSource) {
        if (timerRecordSource == null) {
            throw new IllegalArgumentException("source must not be null.");
        }
        this.checkTimerRecordingSourceType(n2);
        try {
            byte[] byArray = new byte[timerRecordSource.getDataSize()];
            timerRecordSource.toByteArray(byArray, 0);
            this.mService.startTimerRecording(n, n2, byArray);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "failed to start record: ", remoteException);
            return;
        }
    }

    public void stopOneTouchRecord(int n) {
        try {
            this.mService.stopOneTouchRecord(n);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "failed to stop record: ", remoteException);
            return;
        }
    }

    public static interface HdmiMhlVendorCommandListener {
        public void onReceived(int var1, int var2, int var3, byte[] var4);
    }

    public static interface InputChangeListener {
        public void onChanged(HdmiDeviceInfo var1);
    }

    public static interface SelectCallback {
        public void onComplete(int var1);
    }
}

