/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.usb;

import android.hardware.usb.UsbConfiguration;
import android.hardware.usb.UsbInterface;
import android.os.Parcel;
import android.os.Parcelable;

public class UsbDevice
implements Parcelable {
    public static final Parcelable.Creator<UsbDevice> CREATOR = new Parcelable.Creator<UsbDevice>(){

        @Override
        public UsbDevice createFromParcel(Parcel parcel) {
            String string2 = parcel.readString();
            int n = parcel.readInt();
            int n2 = parcel.readInt();
            int n3 = parcel.readInt();
            int n4 = parcel.readInt();
            int n5 = parcel.readInt();
            String string3 = parcel.readString();
            String string4 = parcel.readString();
            String string5 = parcel.readString();
            Parcelable[] parcelableArray = parcel.readParcelableArray(UsbInterface.class.getClassLoader());
            UsbDevice usbDevice = new UsbDevice(string2, n, n2, n3, n4, n5, string3, string4, string5);
            usbDevice.setConfigurations(parcelableArray);
            return usbDevice;
        }

        public UsbDevice[] newArray(int n) {
            return new UsbDevice[n];
        }
    };
    private static final String TAG = "UsbDevice";
    private final int mClass;
    private Parcelable[] mConfigurations;
    private UsbInterface[] mInterfaces;
    private final String mManufacturerName;
    private final String mName;
    private final int mProductId;
    private final String mProductName;
    private final int mProtocol;
    private final String mSerialNumber;
    private final int mSubclass;
    private final int mVendorId;

    public UsbDevice(String string2, int n, int n2, int n3, int n4, int n5, String string3, String string4, String string5) {
        this.mName = string2;
        this.mVendorId = n;
        this.mProductId = n2;
        this.mClass = n3;
        this.mSubclass = n4;
        this.mProtocol = n5;
        this.mManufacturerName = string3;
        this.mProductName = string4;
        this.mSerialNumber = string5;
    }

    public static int getDeviceId(String string2) {
        return UsbDevice.native_get_device_id(string2);
    }

    public static String getDeviceName(int n) {
        return UsbDevice.native_get_device_name(n);
    }

    private UsbInterface[] getInterfaceList() {
        if (this.mInterfaces == null) {
            int n = this.mConfigurations.length;
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                n2 += ((UsbConfiguration)this.mConfigurations[i]).getInterfaceCount();
            }
            this.mInterfaces = new UsbInterface[n2];
            int n3 = 0;
            for (int i = 0; i < n; ++i) {
                UsbConfiguration usbConfiguration = (UsbConfiguration)this.mConfigurations[i];
                int n4 = usbConfiguration.getInterfaceCount();
                int n5 = n3;
                for (int j = 0; j < n4; ++j) {
                    UsbInterface[] usbInterfaceArray = this.mInterfaces;
                    int n6 = n5 + 1;
                    usbInterfaceArray[n5] = usbConfiguration.getInterface(j);
                    n5 = n6;
                }
                n3 = n5;
            }
        }
        return this.mInterfaces;
    }

    private static native int native_get_device_id(String var0);

    private static native String native_get_device_name(int var0);

    @Override
    public int describeContents() {
        return 0;
    }

    public boolean equals(Object object) {
        if (object instanceof UsbDevice) {
            return ((UsbDevice)object).mName.equals(this.mName);
        }
        if (object instanceof String) {
            return ((String)object).equals(this.mName);
        }
        return false;
    }

    public UsbConfiguration getConfiguration(int n) {
        return (UsbConfiguration)this.mConfigurations[n];
    }

    public int getConfigurationCount() {
        return this.mConfigurations.length;
    }

    public int getDeviceClass() {
        return this.mClass;
    }

    public int getDeviceId() {
        return UsbDevice.getDeviceId(this.mName);
    }

    public String getDeviceName() {
        return this.mName;
    }

    public int getDeviceProtocol() {
        return this.mProtocol;
    }

    public int getDeviceSubclass() {
        return this.mSubclass;
    }

    public UsbInterface getInterface(int n) {
        return this.getInterfaceList()[n];
    }

    public int getInterfaceCount() {
        return this.getInterfaceList().length;
    }

    public String getManufacturerName() {
        return this.mManufacturerName;
    }

    public int getProductId() {
        return this.mProductId;
    }

    public String getProductName() {
        return this.mProductName;
    }

    public String getSerialNumber() {
        return this.mSerialNumber;
    }

    public int getVendorId() {
        return this.mVendorId;
    }

    public int hashCode() {
        return this.mName.hashCode();
    }

    public void setConfigurations(Parcelable[] parcelableArray) {
        this.mConfigurations = parcelableArray;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("UsbDevice[mName=" + this.mName + ",mVendorId=" + this.mVendorId + ",mProductId=" + this.mProductId + ",mClass=" + this.mClass + ",mSubclass=" + this.mSubclass + ",mProtocol=" + this.mProtocol + ",mManufacturerName=" + this.mManufacturerName + ",mProductName=" + this.mProductName + ",mSerialNumber=" + this.mSerialNumber + ",mConfigurations=[");
        for (int i = 0; i < this.mConfigurations.length; ++i) {
            stringBuilder.append("\n");
            stringBuilder.append(this.mConfigurations[i].toString());
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeString(this.mName);
        parcel.writeInt(this.mVendorId);
        parcel.writeInt(this.mProductId);
        parcel.writeInt(this.mClass);
        parcel.writeInt(this.mSubclass);
        parcel.writeInt(this.mProtocol);
        parcel.writeString(this.mManufacturerName);
        parcel.writeString(this.mProductName);
        parcel.writeString(this.mSerialNumber);
        parcel.writeParcelableArray(this.mConfigurations, 0);
    }
}

