/*
 * Decompiled with CFR 0.152.
 */
package android.inputmethodservice;

import android.R;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.Region;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.inputmethodservice.Keyboard;
import android.media.AudioManager;
import android.os.Handler;
import android.os.Message;
import android.provider.Settings;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityManager;
import android.widget.PopupWindow;
import android.widget.TextView;
import com.android.internal.R;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class KeyboardView
extends View
implements View.OnClickListener {
    private static final int DEBOUNCE_TIME = 70;
    private static final boolean DEBUG = false;
    private static final int DELAY_AFTER_PREVIEW = 70;
    private static final int DELAY_BEFORE_PREVIEW = 0;
    private static final int[] KEY_DELETE = new int[]{-5};
    private static final int LONGPRESS_TIMEOUT = 0;
    private static final int[] LONG_PRESSABLE_STATE_SET = new int[]{16843324};
    private static int MAX_NEARBY_KEYS = 0;
    private static final int MSG_LONGPRESS = 4;
    private static final int MSG_REMOVE_PREVIEW = 2;
    private static final int MSG_REPEAT = 3;
    private static final int MSG_SHOW_PREVIEW = 1;
    private static final int MULTITAP_INTERVAL = 800;
    private static final int NOT_A_KEY = -1;
    private static final int REPEAT_INTERVAL = 50;
    private static final int REPEAT_START_DELAY = 400;
    private boolean mAbortKey;
    private AccessibilityManager mAccessibilityManager;
    private AudioManager mAudioManager;
    private float mBackgroundDimAmount;
    private Bitmap mBuffer;
    private Canvas mCanvas;
    private Rect mClipRegion;
    private final int[] mCoordinates = new int[2];
    private int mCurrentKey = -1;
    private int mCurrentKeyIndex = -1;
    private long mCurrentKeyTime;
    private Rect mDirtyRect;
    private boolean mDisambiguateSwipe;
    private int[] mDistances;
    private int mDownKey = -1;
    private long mDownTime;
    private boolean mDrawPending;
    private GestureDetector mGestureDetector;
    Handler mHandler;
    private boolean mHeadsetRequiredToHearPasswordsAnnounced;
    private boolean mInMultiTap;
    private Keyboard.Key mInvalidatedKey;
    private Drawable mKeyBackground;
    private int[] mKeyIndices = new int[12];
    private int mKeyTextColor;
    private int mKeyTextSize;
    private Keyboard mKeyboard;
    private OnKeyboardActionListener mKeyboardActionListener;
    private boolean mKeyboardChanged;
    private Keyboard.Key[] mKeys;
    private int mLabelTextSize;
    private int mLastCodeX;
    private int mLastCodeY;
    private int mLastKey;
    private long mLastKeyTime;
    private long mLastMoveTime;
    private int mLastSentIndex;
    private long mLastTapTime;
    private int mLastX;
    private int mLastY;
    private KeyboardView mMiniKeyboard;
    private Map<Keyboard.Key, View> mMiniKeyboardCache;
    private View mMiniKeyboardContainer;
    private int mMiniKeyboardOffsetX;
    private int mMiniKeyboardOffsetY;
    private boolean mMiniKeyboardOnScreen;
    private int mOldPointerCount = 1;
    private float mOldPointerX;
    private float mOldPointerY;
    private Rect mPadding;
    private Paint mPaint;
    private PopupWindow mPopupKeyboard;
    private int mPopupLayout;
    private View mPopupParent;
    private int mPopupPreviewX;
    private int mPopupPreviewY;
    private int mPopupX;
    private int mPopupY;
    private boolean mPossiblePoly;
    private boolean mPreviewCentered = false;
    private int mPreviewHeight;
    private StringBuilder mPreviewLabel;
    private int mPreviewOffset;
    private PopupWindow mPreviewPopup;
    private TextView mPreviewText;
    private int mPreviewTextSizeLarge;
    private boolean mProximityCorrectOn;
    private int mProximityThreshold;
    private int mRepeatKeyIndex = -1;
    private int mShadowColor;
    private float mShadowRadius;
    private boolean mShowPreview = true;
    private boolean mShowTouchPoints = true;
    private int mStartX;
    private int mStartY;
    private int mSwipeThreshold;
    private SwipeTracker mSwipeTracker;
    private int mTapCount;
    private int mVerticalCorrection;

    static {
        LONGPRESS_TIMEOUT = ViewConfiguration.getLongPressTimeout();
        MAX_NEARBY_KEYS = 12;
    }

    public KeyboardView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 16844110);
    }

    public KeyboardView(Context context, AttributeSet attributeSet, int n) {
        this(context, attributeSet, n, 0);
    }

    /*
     * Enabled aggressive block sorting
     */
    public KeyboardView(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n, n2);
        this.mClipRegion = new Rect(0, 0, 0, 0);
        this.mSwipeTracker = new SwipeTracker();
        this.mDistances = new int[MAX_NEARBY_KEYS];
        this.mPreviewLabel = new StringBuilder(1);
        this.mDirtyRect = new Rect();
        this.mHandler = new Handler(){

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public void handleMessage(Message message) {
                switch (message.what) {
                    case 1: {
                        KeyboardView.this.showKey(message.arg1);
                        return;
                    }
                    case 2: {
                        KeyboardView.this.mPreviewText.setVisibility(4);
                        return;
                    }
                    case 3: {
                        if (KeyboardView.this.repeatKey()) {
                            this.sendMessageDelayed(Message.obtain((Handler)this, 3), 50L);
                            return;
                        }
                    }
                    default: {
                        return;
                    }
                    case 4: 
                }
                KeyboardView.this.openPopupIfRequired((MotionEvent)message.obj);
            }
        };
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.KeyboardView, n, n2);
        LayoutInflater layoutInflater = (LayoutInflater)context.getSystemService("layout_inflater");
        int n3 = 0;
        int n4 = typedArray.getIndexCount();
        block13: for (int i = 0; i < n4; ++i) {
            int n5 = typedArray.getIndex(i);
            switch (n5) {
                case 2: {
                    this.mKeyBackground = typedArray.getDrawable(n5);
                    continue block13;
                }
                case 9: {
                    this.mVerticalCorrection = typedArray.getDimensionPixelOffset(n5, 0);
                    continue block13;
                }
                case 6: {
                    n3 = typedArray.getResourceId(n5, 0);
                    continue block13;
                }
                case 7: {
                    this.mPreviewOffset = typedArray.getDimensionPixelOffset(n5, 0);
                    continue block13;
                }
                case 8: {
                    this.mPreviewHeight = typedArray.getDimensionPixelSize(n5, 80);
                    continue block13;
                }
                case 3: {
                    this.mKeyTextSize = typedArray.getDimensionPixelSize(n5, 18);
                    continue block13;
                }
                case 5: {
                    this.mKeyTextColor = typedArray.getColor(n5, -16777216);
                    continue block13;
                }
                case 4: {
                    this.mLabelTextSize = typedArray.getDimensionPixelSize(n5, 14);
                    continue block13;
                }
                case 10: {
                    this.mPopupLayout = typedArray.getResourceId(n5, 0);
                    continue block13;
                }
                case 0: {
                    this.mShadowColor = typedArray.getColor(n5, 0);
                    continue block13;
                }
                case 1: {
                    this.mShadowRadius = typedArray.getFloat(n5, 0.0f);
                    continue block13;
                }
            }
        }
        this.mBackgroundDimAmount = this.mContext.obtainStyledAttributes(R.styleable.Theme).getFloat(2, 0.5f);
        this.mPreviewPopup = new PopupWindow(context);
        if (n3 != 0) {
            this.mPreviewText = (TextView)layoutInflater.inflate(n3, null);
            this.mPreviewTextSizeLarge = (int)this.mPreviewText.getTextSize();
            this.mPreviewPopup.setContentView(this.mPreviewText);
            this.mPreviewPopup.setBackgroundDrawable(null);
        } else {
            this.mShowPreview = false;
        }
        this.mPreviewPopup.setTouchable(false);
        this.mPopupKeyboard = new PopupWindow(context);
        this.mPopupKeyboard.setBackgroundDrawable(null);
        this.mPopupParent = this;
        this.mPaint = new Paint();
        this.mPaint.setAntiAlias(true);
        this.mPaint.setTextSize(0.0f);
        this.mPaint.setTextAlign(Paint.Align.CENTER);
        this.mPaint.setAlpha(255);
        this.mPadding = new Rect(0, 0, 0, 0);
        this.mMiniKeyboardCache = new HashMap<Keyboard.Key, View>();
        this.mKeyBackground.getPadding(this.mPadding);
        this.mSwipeThreshold = (int)(500.0f * this.getResources().getDisplayMetrics().density);
        this.mDisambiguateSwipe = this.getResources().getBoolean(17956919);
        this.mAccessibilityManager = AccessibilityManager.getInstance(context);
        this.mAudioManager = (AudioManager)context.getSystemService("audio");
        this.resetMultiTap();
        this.initGestureDetector();
    }

    private CharSequence adjustCase(CharSequence charSequence) {
        if (this.mKeyboard.isShifted() && charSequence != null && charSequence.length() < 3 && Character.isLowerCase(charSequence.charAt(0))) {
            charSequence = charSequence.toString().toUpperCase();
        }
        return charSequence;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void checkMultiTap(long l, int n) {
        block6: {
            block5: {
                if (n == -1) break block5;
                Keyboard.Key key = this.mKeys[n];
                if (key.codes.length > 1) {
                    this.mInMultiTap = true;
                    if (l < 800L + this.mLastTapTime && n == this.mLastSentIndex) {
                        this.mTapCount = (1 + this.mTapCount) % key.codes.length;
                        return;
                    }
                    this.mTapCount = -1;
                    return;
                }
                if (l > 800L + this.mLastTapTime || n != this.mLastSentIndex) break block6;
            }
            return;
        }
        this.resetMultiTap();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void computeProximityThreshold(Keyboard keyboard) {
        int n;
        int n2;
        block4: {
            block3: {
                Keyboard.Key key;
                Keyboard.Key[] keyArray;
                if (keyboard == null || (keyArray = this.mKeys) == null) break block3;
                n2 = keyArray.length;
                n = 0;
                for (int i = 0; i < n2; n += Math.min(key.width, key.height) + key.gap, ++i) {
                    key = keyArray[i];
                }
                if (n >= 0 && n2 != 0) break block4;
            }
            return;
        }
        this.mProximityThreshold = (int)(1.4f * (float)n / (float)n2);
        this.mProximityThreshold *= this.mProximityThreshold;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void detectAndSendKey(int n, int n2, int n3, long l) {
        if (n != -1 && n < this.mKeys.length) {
            Keyboard.Key key = this.mKeys[n];
            if (key.text != null) {
                this.mKeyboardActionListener.onText(key.text);
                this.mKeyboardActionListener.onRelease(-1);
            } else {
                int n4 = key.codes[0];
                int[] nArray = new int[MAX_NEARBY_KEYS];
                Arrays.fill(nArray, -1);
                this.getKeyIndices(n2, n3, nArray);
                if (this.mInMultiTap) {
                    if (this.mTapCount != -1) {
                        this.mKeyboardActionListener.onKey(-5, KEY_DELETE);
                    } else {
                        this.mTapCount = 0;
                    }
                    n4 = key.codes[this.mTapCount];
                }
                this.mKeyboardActionListener.onKey(n4, nArray);
                this.mKeyboardActionListener.onRelease(n4);
            }
            this.mLastSentIndex = n;
            this.mLastTapTime = l;
        }
    }

    private void dismissPopupKeyboard() {
        if (this.mPopupKeyboard.isShowing()) {
            this.mPopupKeyboard.dismiss();
            this.mMiniKeyboardOnScreen = false;
            this.invalidateAllKeys();
        }
    }

    /*
     * Unable to fully structure code
     */
    private int getKeyIndices(int var1_1, int var2_2, int[] var3_3) {
        var4_4 = this.mKeys;
        var5_5 = -1;
        var6_6 = -1;
        var7_7 = 1 + this.mProximityThreshold;
        Arrays.fill(this.mDistances, 0x7FFFFFFF);
        var8_8 = this.mKeyboard.getNearestKeys(var1_1, var2_2);
        var9_9 = var8_8.length;
        block0: for (var10_10 = 0; var10_10 < var9_9; ++var10_10) {
            block12: {
                block11: {
                    var11_11 = var4_4[var8_8[var10_10]];
                    var12_12 = var11_11.isInside(var1_1, var2_2);
                    if (var12_12) {
                        var5_5 = var8_8[var10_10];
                    }
                    var13_13 = this.mProximityCorrectOn;
                    var14_14 = 0;
                    if ((!var13_13 || (var14_14 = var11_11.squaredDistanceFrom(var1_1, var2_2)) >= this.mProximityThreshold) && !var12_12 || var11_11.codes[0] <= 32) break block11;
                    var15_15 = var11_11.codes.length;
                    if (var14_14 < var7_7) {
                        var7_7 = var14_14;
                        var6_6 = var8_8[var10_10];
                    }
                    if (var3_3 != null) break block12;
                }
lbl22:
                // 3 sources

                continue block0;
            }
            var16_16 = 0;
            while (true) {
                if (var16_16 >= this.mDistances.length) ** GOTO lbl22
                if (this.mDistances[var16_16] > var14_14) {
                    System.arraycopy((int[])this.mDistances, (int)var16_16, (int[])this.mDistances, (int)(var16_16 + var15_15), (int)(this.mDistances.length - var16_16 - var15_15));
                    System.arraycopy((int[])var3_3, (int)var16_16, (int[])var3_3, (int)(var16_16 + var15_15), (int)(var3_3.length - var16_16 - var15_15));
                    var17_17 = 0;
                    while (true) {
                        if (var17_17 < var15_15) ** break;
                        ** continue;
                        var3_3[var16_16 + var17_17] = var11_11.codes[var17_17];
                        this.mDistances[var16_16 + var17_17] = var14_14;
                        ++var17_17;
                    }
                }
                ++var16_16;
            }
        }
        if (var5_5 == -1) {
            var5_5 = var6_6;
        }
        return var5_5;
    }

    /*
     * Enabled aggressive block sorting
     */
    private CharSequence getPreviewText(Keyboard.Key key) {
        if (!this.mInMultiTap) {
            return this.adjustCase(key.label);
        }
        this.mPreviewLabel.setLength(0);
        StringBuilder stringBuilder = this.mPreviewLabel;
        int[] nArray = key.codes;
        int n = this.mTapCount;
        int n2 = 0;
        if (n >= 0) {
            n2 = this.mTapCount;
        }
        stringBuilder.append((char)nArray[n2]);
        return this.adjustCase(this.mPreviewLabel);
    }

    private void initGestureDetector() {
        this.mGestureDetector = new GestureDetector(this.getContext(), new GestureDetector.SimpleOnGestureListener(){

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public boolean onFling(MotionEvent motionEvent, MotionEvent motionEvent2, float f, float f2) {
                block16: {
                    boolean bl;
                    block15: {
                        if (KeyboardView.this.mPossiblePoly) {
                            return false;
                        }
                        float f3 = Math.abs(f);
                        float f4 = Math.abs(f2);
                        float f5 = motionEvent2.getX() - motionEvent.getX();
                        float f6 = motionEvent2.getY() - motionEvent.getY();
                        int n = KeyboardView.this.getWidth() / 2;
                        int n2 = KeyboardView.this.getHeight() / 2;
                        KeyboardView.this.mSwipeTracker.computeCurrentVelocity(1000);
                        float f7 = KeyboardView.this.mSwipeTracker.getXVelocity();
                        float f8 = KeyboardView.this.mSwipeTracker.getYVelocity();
                        if (f > (float)KeyboardView.this.mSwipeThreshold && f4 < f3 && f5 > (float)n) {
                            if (KeyboardView.this.mDisambiguateSwipe && f7 < f / 4.0f) {
                                bl = true;
                                break block15;
                            } else {
                                KeyboardView.this.swipeRight();
                                return true;
                            }
                        }
                        if (f < (float)(-KeyboardView.this.mSwipeThreshold) && f4 < f3 && f5 < (float)(-n)) {
                            if (KeyboardView.this.mDisambiguateSwipe && f7 > f / 4.0f) {
                                bl = true;
                                break block15;
                            } else {
                                KeyboardView.this.swipeLeft();
                                return true;
                            }
                        }
                        if (f2 < (float)(-KeyboardView.this.mSwipeThreshold) && f3 < f4 && f6 < (float)(-n2)) {
                            if (KeyboardView.this.mDisambiguateSwipe && f8 > f2 / 4.0f) {
                                bl = true;
                                break block15;
                            } else {
                                KeyboardView.this.swipeUp();
                                return true;
                            }
                        }
                        float f9 = f2 - (float)KeyboardView.this.mSwipeThreshold;
                        float f10 = f9 == 0.0f ? 0 : (f9 > 0.0f ? 1 : -1);
                        bl = false;
                        if (f10 <= 0) break block15;
                        float f11 = f3 - f4 / 2.0f;
                        float f12 = f11 == 0.0f ? 0 : (f11 < 0.0f ? -1 : 1);
                        bl = false;
                        if (f12 >= 0) break block15;
                        float f13 = f6 - (float)n2;
                        float f14 = f13 == 0.0f ? 0 : (f13 > 0.0f ? 1 : -1);
                        bl = false;
                        if (f14 <= 0) break block15;
                        if (!KeyboardView.this.mDisambiguateSwipe || !(f8 < f2 / 4.0f)) break block16;
                        bl = true;
                    }
                    if (bl) {
                        KeyboardView.this.detectAndSendKey(KeyboardView.this.mDownKey, KeyboardView.this.mStartX, KeyboardView.this.mStartY, motionEvent.getEventTime());
                    }
                    return false;
                }
                KeyboardView.this.swipeDown();
                return true;
            }
        });
        this.mGestureDetector.setIsLongpressEnabled(false);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void onBufferDraw() {
        if (this.mBuffer == null || this.mKeyboardChanged) {
            if (this.mBuffer == null || this.mKeyboardChanged && (this.mBuffer.getWidth() != this.getWidth() || this.mBuffer.getHeight() != this.getHeight())) {
                this.mBuffer = Bitmap.createBitmap(Math.max(1, this.getWidth()), Math.max(1, this.getHeight()), Bitmap.Config.ARGB_8888);
                this.mCanvas = new Canvas(this.mBuffer);
            }
            this.invalidateAllKeys();
            this.mKeyboardChanged = false;
        }
        Canvas canvas = this.mCanvas;
        canvas.clipRect(this.mDirtyRect, Region.Op.REPLACE);
        if (this.mKeyboard == null) {
            return;
        }
        Paint paint = this.mPaint;
        Drawable drawable2 = this.mKeyBackground;
        Rect rect = this.mClipRegion;
        Rect rect2 = this.mPadding;
        int n = this.mPaddingLeft;
        int n2 = this.mPaddingTop;
        Keyboard.Key[] keyArray = this.mKeys;
        Keyboard.Key key = this.mInvalidatedKey;
        paint.setColor(this.mKeyTextColor);
        boolean bl = false;
        if (key != null) {
            boolean bl2 = canvas.getClipBounds(rect);
            bl = false;
            if (bl2) {
                int n3 = -1 + (n + key.x);
                int n4 = rect.left;
                bl = false;
                if (n3 <= n4) {
                    int n5 = -1 + (n2 + key.y);
                    int n6 = rect.top;
                    bl = false;
                    if (n5 <= n6) {
                        int n7 = 1 + (n + (key.x + key.width));
                        int n8 = rect.right;
                        bl = false;
                        if (n7 >= n8) {
                            int n9 = 1 + (n2 + (key.y + key.height));
                            int n10 = rect.bottom;
                            bl = false;
                            if (n9 >= n10) {
                                bl = true;
                            }
                        }
                    }
                }
            }
        }
        canvas.drawColor(0, PorterDuff.Mode.CLEAR);
        for (Keyboard.Key key2 : keyArray) {
            if (bl && key != key2) continue;
            drawable2.setState(key2.getCurrentDrawableState());
            String string2 = key2.label == null ? null : this.adjustCase(key2.label).toString();
            Rect rect3 = drawable2.getBounds();
            if (key2.width != rect3.right || key2.height != rect3.bottom) {
                drawable2.setBounds(0, 0, key2.width, key2.height);
            }
            canvas.translate(n + key2.x, n2 + key2.y);
            drawable2.draw(canvas);
            if (string2 != null) {
                if (string2.length() > 1 && key2.codes.length < 2) {
                    paint.setTextSize(this.mLabelTextSize);
                    paint.setTypeface(Typeface.DEFAULT_BOLD);
                } else {
                    paint.setTextSize(this.mKeyTextSize);
                    paint.setTypeface(Typeface.DEFAULT);
                }
                paint.setShadowLayer(this.mShadowRadius, 0.0f, 0.0f, this.mShadowColor);
                float f = (key2.width - rect2.left - rect2.right) / 2 + rect2.left;
                float f2 = (float)((key2.height - rect2.top - rect2.bottom) / 2) + (paint.getTextSize() - paint.descent()) / 2.0f + (float)rect2.top;
                canvas.drawText(string2, f, f2, paint);
                paint.setShadowLayer(0.0f, 0.0f, 0.0f, 0);
            } else if (key2.icon != null) {
                int n11 = (key2.width - rect2.left - rect2.right - key2.icon.getIntrinsicWidth()) / 2 + rect2.left;
                int n12 = (key2.height - rect2.top - rect2.bottom - key2.icon.getIntrinsicHeight()) / 2 + rect2.top;
                canvas.translate(n11, n12);
                key2.icon.setBounds(0, 0, key2.icon.getIntrinsicWidth(), key2.icon.getIntrinsicHeight());
                key2.icon.draw(canvas);
                canvas.translate(-n11, -n12);
            }
            canvas.translate(-key2.x - n, -key2.y - n2);
        }
        this.mInvalidatedKey = null;
        if (this.mMiniKeyboardOnScreen) {
            paint.setColor((int)(255.0f * this.mBackgroundDimAmount) << 24);
            canvas.drawRect(0.0f, 0.0f, this.getWidth(), this.getHeight(), paint);
        }
        this.mDrawPending = false;
        this.mDirtyRect.setEmpty();
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean onModifiedTouchEvent(MotionEvent motionEvent, boolean bl) {
        int n = (int)motionEvent.getX() - this.mPaddingLeft;
        int n2 = (int)motionEvent.getY() - this.mPaddingTop;
        if (n2 >= -this.mVerticalCorrection) {
            n2 += this.mVerticalCorrection;
        }
        int n3 = motionEvent.getAction();
        long l = motionEvent.getEventTime();
        int n4 = this.getKeyIndices(n, n2, null);
        this.mPossiblePoly = bl;
        if (n3 == 0) {
            this.mSwipeTracker.clear();
        }
        this.mSwipeTracker.addMovement(motionEvent);
        if (this.mAbortKey && n3 != 0 && n3 != 3) {
            return true;
        }
        if (this.mGestureDetector.onTouchEvent(motionEvent)) {
            this.showPreview(-1);
            this.mHandler.removeMessages(3);
            this.mHandler.removeMessages(4);
            return true;
        }
        if (this.mMiniKeyboardOnScreen && n3 != 3) {
            return true;
        }
        switch (n3) {
            case 0: {
                this.mAbortKey = false;
                this.mStartX = n;
                this.mStartY = n2;
                this.mLastCodeX = n;
                this.mLastCodeY = n2;
                this.mLastKeyTime = 0L;
                this.mCurrentKeyTime = 0L;
                this.mLastKey = -1;
                this.mCurrentKey = n4;
                this.mDownKey = n4;
                this.mLastMoveTime = this.mDownTime = motionEvent.getEventTime();
                this.checkMultiTap(l, n4);
                OnKeyboardActionListener onKeyboardActionListener = this.mKeyboardActionListener;
                int n5 = n4 != -1 ? this.mKeys[n4].codes[0] : 0;
                onKeyboardActionListener.onPress(n5);
                if (this.mCurrentKey >= 0 && this.mKeys[this.mCurrentKey].repeatable) {
                    this.mRepeatKeyIndex = this.mCurrentKey;
                    Message message = this.mHandler.obtainMessage(3);
                    this.mHandler.sendMessageDelayed(message, 400L);
                    this.repeatKey();
                    if (this.mAbortKey) {
                        this.mRepeatKeyIndex = -1;
                        break;
                    }
                }
                if (this.mCurrentKey != -1) {
                    Message message = this.mHandler.obtainMessage(4, motionEvent);
                    this.mHandler.sendMessageDelayed(message, LONGPRESS_TIMEOUT);
                }
                this.showPreview(n4);
                break;
            }
            case 2: {
                boolean bl2 = false;
                if (n4 != -1) {
                    if (this.mCurrentKey == -1) {
                        this.mCurrentKey = n4;
                        this.mCurrentKeyTime = l - this.mDownTime;
                    } else if (n4 == this.mCurrentKey) {
                        this.mCurrentKeyTime += l - this.mLastMoveTime;
                        bl2 = true;
                    } else {
                        int n6 = this.mRepeatKeyIndex;
                        bl2 = false;
                        if (n6 == -1) {
                            this.resetMultiTap();
                            this.mLastKey = this.mCurrentKey;
                            this.mLastCodeX = this.mLastX;
                            this.mLastCodeY = this.mLastY;
                            this.mLastKeyTime = l + this.mCurrentKeyTime - this.mLastMoveTime;
                            this.mCurrentKey = n4;
                            this.mCurrentKeyTime = 0L;
                            bl2 = false;
                        }
                    }
                }
                if (!bl2) {
                    this.mHandler.removeMessages(4);
                    if (n4 != -1) {
                        Message message = this.mHandler.obtainMessage(4, motionEvent);
                        this.mHandler.sendMessageDelayed(message, LONGPRESS_TIMEOUT);
                    }
                }
                this.showPreview(this.mCurrentKey);
                this.mLastMoveTime = l;
                break;
            }
            case 1: {
                this.removeMessages();
                if (n4 == this.mCurrentKey) {
                    this.mCurrentKeyTime += l - this.mLastMoveTime;
                } else {
                    this.resetMultiTap();
                    this.mLastKey = this.mCurrentKey;
                    this.mLastKeyTime = l + this.mCurrentKeyTime - this.mLastMoveTime;
                    this.mCurrentKey = n4;
                    this.mCurrentKeyTime = 0L;
                }
                if (this.mCurrentKeyTime < this.mLastKeyTime && this.mCurrentKeyTime < 70L && this.mLastKey != -1) {
                    this.mCurrentKey = this.mLastKey;
                    n = this.mLastCodeX;
                    n2 = this.mLastCodeY;
                }
                this.showPreview(-1);
                Arrays.fill(this.mKeyIndices, -1);
                if (this.mRepeatKeyIndex == -1 && !this.mMiniKeyboardOnScreen && !this.mAbortKey) {
                    this.detectAndSendKey(this.mCurrentKey, n, n2, l);
                }
                this.invalidateKey(n4);
                this.mRepeatKeyIndex = -1;
                break;
            }
            case 3: {
                this.removeMessages();
                this.dismissPopupKeyboard();
                this.mAbortKey = true;
                this.showPreview(-1);
                this.invalidateKey(this.mCurrentKey);
                break;
            }
        }
        this.mLastX = n;
        this.mLastY = n2;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean openPopupIfRequired(MotionEvent motionEvent) {
        boolean bl;
        block3: {
            block2: {
                int n = this.mPopupLayout;
                bl = false;
                if (n == 0) break block2;
                int n2 = this.mCurrentKey;
                bl = false;
                if (n2 < 0) break block2;
                int n3 = this.mCurrentKey;
                int n4 = this.mKeys.length;
                bl = false;
                if (n3 < n4 && (bl = this.onLongPress(this.mKeys[this.mCurrentKey]))) break block3;
            }
            return bl;
        }
        this.mAbortKey = true;
        this.showPreview(-1);
        return bl;
    }

    private void removeMessages() {
        this.mHandler.removeMessages(3);
        this.mHandler.removeMessages(4);
        this.mHandler.removeMessages(1);
    }

    private boolean repeatKey() {
        Keyboard.Key key = this.mKeys[this.mRepeatKeyIndex];
        this.detectAndSendKey(this.mCurrentKey, key.x, key.y, this.mLastTapTime);
        return true;
    }

    private void resetMultiTap() {
        this.mLastSentIndex = -1;
        this.mTapCount = 0;
        this.mLastTapTime = -1L;
        this.mInMultiTap = false;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void sendAccessibilityEventForUnicodeCharacter(int n, int n2) {
        if (this.mAccessibilityManager.isEnabled()) {
            String string2;
            AccessibilityEvent accessibilityEvent = AccessibilityEvent.obtain(n);
            this.onInitializeAccessibilityEvent(accessibilityEvent);
            int n3 = Settings.Secure.getInt(this.mContext.getContentResolver(), "speak_password", 0);
            boolean bl = false;
            if (n3 != 0) {
                bl = true;
            }
            if (bl || this.mAudioManager.isBluetoothA2dpOn() || this.mAudioManager.isWiredHeadsetOn()) {
                switch (n2) {
                    default: {
                        string2 = String.valueOf((char)n2);
                        break;
                    }
                    case -6: {
                        string2 = this.mContext.getString(17040766);
                        break;
                    }
                    case -3: {
                        string2 = this.mContext.getString(17040767);
                        break;
                    }
                    case -5: {
                        string2 = this.mContext.getString(17040768);
                        break;
                    }
                    case -4: {
                        string2 = this.mContext.getString(17040769);
                        break;
                    }
                    case -2: {
                        string2 = this.mContext.getString(17040770);
                        break;
                    }
                    case -1: {
                        string2 = this.mContext.getString(17040771);
                        break;
                    }
                    case 10: {
                        string2 = this.mContext.getString(17040772);
                        break;
                    }
                }
            } else if (!this.mHeadsetRequiredToHearPasswordsAnnounced) {
                if (n == 256) {
                    this.mHeadsetRequiredToHearPasswordsAnnounced = true;
                }
                string2 = this.mContext.getString(17040779);
            } else {
                string2 = this.mContext.getString(17040780);
            }
            accessibilityEvent.getText().add(string2);
            this.mAccessibilityManager.sendAccessibilityEvent(accessibilityEvent);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void showKey(int n) {
        PopupWindow popupWindow = this.mPreviewPopup;
        Keyboard.Key[] keyArray = this.mKeys;
        if (n < 0 || n >= this.mKeys.length) {
            return;
        }
        Keyboard.Key key = keyArray[n];
        if (key.icon != null) {
            TextView textView = this.mPreviewText;
            Drawable drawable2 = key.iconPreview != null ? key.iconPreview : key.icon;
            textView.setCompoundDrawables(null, null, null, drawable2);
            this.mPreviewText.setText(null);
        } else {
            this.mPreviewText.setCompoundDrawables(null, null, null, null);
            this.mPreviewText.setText(this.getPreviewText(key));
            if (key.label.length() > 1 && key.codes.length < 2) {
                this.mPreviewText.setTextSize(0, this.mKeyTextSize);
                this.mPreviewText.setTypeface(Typeface.DEFAULT_BOLD);
            } else {
                this.mPreviewText.setTextSize(0, this.mPreviewTextSizeLarge);
                this.mPreviewText.setTypeface(Typeface.DEFAULT);
            }
        }
        this.mPreviewText.measure(View.MeasureSpec.makeMeasureSpec(0, 0), View.MeasureSpec.makeMeasureSpec(0, 0));
        int n2 = Math.max(this.mPreviewText.getMeasuredWidth(), key.width + this.mPreviewText.getPaddingLeft() + this.mPreviewText.getPaddingRight());
        int n3 = this.mPreviewHeight;
        ViewGroup.LayoutParams layoutParams = this.mPreviewText.getLayoutParams();
        if (layoutParams != null) {
            layoutParams.width = n2;
            layoutParams.height = n3;
        }
        if (!this.mPreviewCentered) {
            this.mPopupPreviewX = key.x - this.mPreviewText.getPaddingLeft() + this.mPaddingLeft;
            this.mPopupPreviewY = key.y - n3 + this.mPreviewOffset;
        } else {
            this.mPopupPreviewX = 160 - this.mPreviewText.getMeasuredWidth() / 2;
            this.mPopupPreviewY = -this.mPreviewText.getMeasuredHeight();
        }
        this.mHandler.removeMessages(2);
        this.getLocationInWindow(this.mCoordinates);
        int[] nArray = this.mCoordinates;
        nArray[0] = nArray[0] + this.mMiniKeyboardOffsetX;
        int[] nArray2 = this.mCoordinates;
        nArray2[1] = nArray2[1] + this.mMiniKeyboardOffsetY;
        Drawable drawable3 = this.mPreviewText.getBackground();
        int[] nArray3 = key.popupResId != 0 ? LONG_PRESSABLE_STATE_SET : EMPTY_STATE_SET;
        drawable3.setState(nArray3);
        this.mPopupPreviewX += this.mCoordinates[0];
        this.mPopupPreviewY += this.mCoordinates[1];
        this.getLocationOnScreen(this.mCoordinates);
        if (this.mPopupPreviewY + this.mCoordinates[1] < 0) {
            this.mPopupPreviewX = key.x + key.width <= this.getWidth() / 2 ? (this.mPopupPreviewX += (int)(2.5 * (double)key.width)) : (this.mPopupPreviewX -= (int)(2.5 * (double)key.width));
            this.mPopupPreviewY = n3 + this.mPopupPreviewY;
        }
        if (popupWindow.isShowing()) {
            popupWindow.update(this.mPopupPreviewX, this.mPopupPreviewY, n2, n3);
        } else {
            popupWindow.setWidth(n2);
            popupWindow.setHeight(n3);
            popupWindow.showAtLocation(this.mPopupParent, 0, this.mPopupPreviewX, this.mPopupPreviewY);
        }
        this.mPreviewText.setVisibility(0);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void showPreview(int n) {
        block8: {
            block7: {
                int n2 = this.mCurrentKeyIndex;
                PopupWindow popupWindow = this.mPreviewPopup;
                this.mCurrentKeyIndex = n;
                Keyboard.Key[] keyArray = this.mKeys;
                if (n2 != this.mCurrentKeyIndex) {
                    if (n2 != -1 && keyArray.length > n2) {
                        Keyboard.Key key = keyArray[n2];
                        boolean bl = this.mCurrentKeyIndex == -1;
                        key.onReleased(bl);
                        this.invalidateKey(n2);
                        int n3 = key.codes[0];
                        this.sendAccessibilityEventForUnicodeCharacter(256, n3);
                        this.sendAccessibilityEventForUnicodeCharacter(65536, n3);
                    }
                    if (this.mCurrentKeyIndex != -1 && keyArray.length > this.mCurrentKeyIndex) {
                        Keyboard.Key key = keyArray[this.mCurrentKeyIndex];
                        key.onPressed();
                        this.invalidateKey(this.mCurrentKeyIndex);
                        int n4 = key.codes[0];
                        this.sendAccessibilityEventForUnicodeCharacter(128, n4);
                        this.sendAccessibilityEventForUnicodeCharacter(32768, n4);
                    }
                }
                if (n2 == this.mCurrentKeyIndex || !this.mShowPreview) break block7;
                this.mHandler.removeMessages(1);
                if (popupWindow.isShowing() && n == -1) {
                    this.mHandler.sendMessageDelayed(this.mHandler.obtainMessage(2), 70L);
                }
                if (n == -1) break block7;
                if (!popupWindow.isShowing() || this.mPreviewText.getVisibility() != 0) break block8;
                this.showKey(n);
            }
            return;
        }
        this.mHandler.sendMessageDelayed(this.mHandler.obtainMessage(1, n, 0), 0L);
    }

    public void closing() {
        if (this.mPreviewPopup.isShowing()) {
            this.mPreviewPopup.dismiss();
        }
        this.removeMessages();
        this.dismissPopupKeyboard();
        this.mBuffer = null;
        this.mCanvas = null;
        this.mMiniKeyboardCache.clear();
    }

    public Keyboard getKeyboard() {
        return this.mKeyboard;
    }

    protected OnKeyboardActionListener getOnKeyboardActionListener() {
        return this.mKeyboardActionListener;
    }

    public boolean handleBack() {
        if (this.mPopupKeyboard.isShowing()) {
            this.dismissPopupKeyboard();
            return true;
        }
        return false;
    }

    public void invalidateAllKeys() {
        this.mDirtyRect.union(0, 0, this.getWidth(), this.getHeight());
        this.mDrawPending = true;
        this.invalidate();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void invalidateKey(int n) {
        Keyboard.Key key;
        if (this.mKeys == null || n < 0 || n >= this.mKeys.length) {
            return;
        }
        this.mInvalidatedKey = key = this.mKeys[n];
        this.mDirtyRect.union(key.x + this.mPaddingLeft, key.y + this.mPaddingTop, key.x + key.width + this.mPaddingLeft, key.y + key.height + this.mPaddingTop);
        this.onBufferDraw();
        this.invalidate(key.x + this.mPaddingLeft, key.y + this.mPaddingTop, key.x + key.width + this.mPaddingLeft, key.y + key.height + this.mPaddingTop);
    }

    public boolean isPreviewEnabled() {
        return this.mShowPreview;
    }

    public boolean isProximityCorrectionEnabled() {
        return this.mProximityCorrectOn;
    }

    public boolean isShifted() {
        if (this.mKeyboard != null) {
            return this.mKeyboard.isShifted();
        }
        return false;
    }

    @Override
    public void onClick(View view) {
        this.dismissPopupKeyboard();
    }

    @Override
    public void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.closing();
    }

    @Override
    public void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.mDrawPending || this.mBuffer == null || this.mKeyboardChanged) {
            this.onBufferDraw();
        }
        canvas.drawBitmap(this.mBuffer, 0.0f, 0.0f, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean onHoverEvent(MotionEvent motionEvent) {
        int n = 1;
        if (!this.mAccessibilityManager.isTouchExplorationEnabled()) return n != 0;
        if (motionEvent.getPointerCount() != n) return n != 0;
        switch (motionEvent.getAction()) {
            case 9: {
                motionEvent.setAction(0);
                return (int)(this.onTouchEvent(motionEvent) ? 1 : 0) != 0;
            }
            case 7: {
                motionEvent.setAction(2);
                return (int)(this.onTouchEvent(motionEvent) ? 1 : 0) != 0;
            }
            case 10: {
                motionEvent.setAction(n);
                return (int)(this.onTouchEvent(motionEvent) ? 1 : 0) != 0;
            }
        }
        return (int)(this.onTouchEvent(motionEvent) ? 1 : 0) != 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected boolean onLongPress(Keyboard.Key key) {
        int n = key.popupResId;
        boolean bl = false;
        if (n == 0) return bl;
        this.mMiniKeyboardContainer = this.mMiniKeyboardCache.get(key);
        if (this.mMiniKeyboardContainer == null) {
            this.mMiniKeyboardContainer = ((LayoutInflater)this.getContext().getSystemService("layout_inflater")).inflate(this.mPopupLayout, null);
            this.mMiniKeyboard = (KeyboardView)this.mMiniKeyboardContainer.findViewById(16908326);
            View view = this.mMiniKeyboardContainer.findViewById(16908327);
            if (view != null) {
                view.setOnClickListener(this);
            }
            this.mMiniKeyboard.setOnKeyboardActionListener(new OnKeyboardActionListener(){

                @Override
                public void onKey(int n, int[] nArray) {
                    KeyboardView.this.mKeyboardActionListener.onKey(n, nArray);
                    KeyboardView.this.dismissPopupKeyboard();
                }

                @Override
                public void onPress(int n) {
                    KeyboardView.this.mKeyboardActionListener.onPress(n);
                }

                @Override
                public void onRelease(int n) {
                    KeyboardView.this.mKeyboardActionListener.onRelease(n);
                }

                @Override
                public void onText(CharSequence charSequence) {
                    KeyboardView.this.mKeyboardActionListener.onText(charSequence);
                    KeyboardView.this.dismissPopupKeyboard();
                }

                @Override
                public void swipeDown() {
                }

                @Override
                public void swipeLeft() {
                }

                @Override
                public void swipeRight() {
                }

                @Override
                public void swipeUp() {
                }
            });
            Keyboard keyboard = key.popupCharacters != null ? new Keyboard(this.getContext(), n, key.popupCharacters, -1, this.getPaddingLeft() + this.getPaddingRight()) : new Keyboard(this.getContext(), n);
            this.mMiniKeyboard.setKeyboard(keyboard);
            this.mMiniKeyboard.setPopupParent(this);
            this.mMiniKeyboardContainer.measure(View.MeasureSpec.makeMeasureSpec(this.getWidth(), Integer.MIN_VALUE), View.MeasureSpec.makeMeasureSpec(this.getHeight(), Integer.MIN_VALUE));
            this.mMiniKeyboardCache.put(key, this.mMiniKeyboardContainer);
        } else {
            this.mMiniKeyboard = (KeyboardView)this.mMiniKeyboardContainer.findViewById(16908326);
        }
        this.getLocationInWindow(this.mCoordinates);
        this.mPopupX = key.x + this.mPaddingLeft;
        this.mPopupY = key.y + this.mPaddingTop;
        this.mPopupX = this.mPopupX + key.width - this.mMiniKeyboardContainer.getMeasuredWidth();
        this.mPopupY -= this.mMiniKeyboardContainer.getMeasuredHeight();
        int n2 = this.mPopupX + this.mMiniKeyboardContainer.getPaddingRight() + this.mCoordinates[0];
        int n3 = this.mPopupY + this.mMiniKeyboardContainer.getPaddingBottom() + this.mCoordinates[1];
        KeyboardView keyboardView = this.mMiniKeyboard;
        int n4 = n2 < 0 ? 0 : n2;
        keyboardView.setPopupOffset(n4, n3);
        this.mMiniKeyboard.setShifted(this.isShifted());
        this.mPopupKeyboard.setContentView(this.mMiniKeyboardContainer);
        this.mPopupKeyboard.setWidth(this.mMiniKeyboardContainer.getMeasuredWidth());
        this.mPopupKeyboard.setHeight(this.mMiniKeyboardContainer.getMeasuredHeight());
        this.mPopupKeyboard.showAtLocation(this, 0, n2, n3);
        this.mMiniKeyboardOnScreen = true;
        this.invalidateAllKeys();
        return true;
    }

    @Override
    public void onMeasure(int n, int n2) {
        if (this.mKeyboard == null) {
            this.setMeasuredDimension(this.mPaddingLeft + this.mPaddingRight, this.mPaddingTop + this.mPaddingBottom);
            return;
        }
        int n3 = this.mKeyboard.getMinWidth() + this.mPaddingLeft + this.mPaddingRight;
        if (View.MeasureSpec.getSize(n) < n3 + 10) {
            n3 = View.MeasureSpec.getSize(n);
        }
        this.setMeasuredDimension(n3, this.mKeyboard.getHeight() + this.mPaddingTop + this.mPaddingBottom);
    }

    @Override
    public void onSizeChanged(int n, int n2, int n3, int n4) {
        super.onSizeChanged(n, n2, n3, n4);
        if (this.mKeyboard != null) {
            this.mKeyboard.resize(n, n2);
        }
        this.mBuffer = null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean onTouchEvent(MotionEvent motionEvent) {
        boolean bl;
        int n;
        block6: {
            block5: {
                n = motionEvent.getPointerCount();
                int n2 = motionEvent.getAction();
                long l = motionEvent.getEventTime();
                if (n == this.mOldPointerCount) break block5;
                if (n == 1) {
                    MotionEvent motionEvent2 = MotionEvent.obtain(l, l, 0, motionEvent.getX(), motionEvent.getY(), motionEvent.getMetaState());
                    bl = this.onModifiedTouchEvent(motionEvent2, false);
                    motionEvent2.recycle();
                    if (n2 == 1) {
                        bl = this.onModifiedTouchEvent(motionEvent, true);
                    }
                    break block6;
                } else {
                    MotionEvent motionEvent3 = MotionEvent.obtain(l, l, 1, this.mOldPointerX, this.mOldPointerY, motionEvent.getMetaState());
                    bl = this.onModifiedTouchEvent(motionEvent3, true);
                    motionEvent3.recycle();
                }
                break block6;
            }
            if (n == 1) {
                bl = this.onModifiedTouchEvent(motionEvent, false);
                this.mOldPointerX = motionEvent.getX();
                this.mOldPointerY = motionEvent.getY();
            } else {
                bl = true;
            }
        }
        this.mOldPointerCount = n;
        return bl;
    }

    public void setKeyboard(Keyboard keyboard) {
        if (this.mKeyboard != null) {
            this.showPreview(-1);
        }
        this.removeMessages();
        this.mKeyboard = keyboard;
        List<Keyboard.Key> list = this.mKeyboard.getKeys();
        this.mKeys = list.toArray(new Keyboard.Key[list.size()]);
        this.requestLayout();
        this.mKeyboardChanged = true;
        this.invalidateAllKeys();
        this.computeProximityThreshold(keyboard);
        this.mMiniKeyboardCache.clear();
        this.mAbortKey = true;
    }

    public void setOnKeyboardActionListener(OnKeyboardActionListener onKeyboardActionListener) {
        this.mKeyboardActionListener = onKeyboardActionListener;
    }

    public void setPopupOffset(int n, int n2) {
        this.mMiniKeyboardOffsetX = n;
        this.mMiniKeyboardOffsetY = n2;
        if (this.mPreviewPopup.isShowing()) {
            this.mPreviewPopup.dismiss();
        }
    }

    public void setPopupParent(View view) {
        this.mPopupParent = view;
    }

    public void setPreviewEnabled(boolean bl) {
        this.mShowPreview = bl;
    }

    public void setProximityCorrectionEnabled(boolean bl) {
        this.mProximityCorrectOn = bl;
    }

    public boolean setShifted(boolean bl) {
        if (this.mKeyboard != null && this.mKeyboard.setShifted(bl)) {
            this.invalidateAllKeys();
            return true;
        }
        return false;
    }

    public void setVerticalCorrection(int n) {
    }

    protected void swipeDown() {
        this.mKeyboardActionListener.swipeDown();
    }

    protected void swipeLeft() {
        this.mKeyboardActionListener.swipeLeft();
    }

    protected void swipeRight() {
        this.mKeyboardActionListener.swipeRight();
    }

    protected void swipeUp() {
        this.mKeyboardActionListener.swipeUp();
    }

    public static interface OnKeyboardActionListener {
        public void onKey(int var1, int[] var2);

        public void onPress(int var1);

        public void onRelease(int var1);

        public void onText(CharSequence var1);

        public void swipeDown();

        public void swipeLeft();

        public void swipeRight();

        public void swipeUp();
    }

    private static class SwipeTracker {
        static final int LONGEST_PAST_TIME = 200;
        static final int NUM_PAST = 4;
        final long[] mPastTime;
        final float[] mPastX = new float[4];
        final float[] mPastY = new float[4];
        float mXVelocity;
        float mYVelocity;

        private SwipeTracker() {
            this.mPastTime = new long[4];
        }

        private void addPoint(float f, float f2, long l) {
            int n = -1;
            long[] lArray = this.mPastTime;
            int n2 = 0;
            while (true) {
                if (n2 >= 4 || lArray[n2] == 0L) {
                    if (n2 == 4 && n < 0) {
                        n = 0;
                    }
                    if (n == n2) {
                        --n;
                    }
                    float[] fArray = this.mPastX;
                    float[] fArray2 = this.mPastY;
                    if (n >= 0) {
                        int n3 = n + 1;
                        int n4 = -1 + (4 - n);
                        System.arraycopy((float[])fArray, (int)n3, (float[])fArray, (int)0, (int)n4);
                        System.arraycopy((float[])fArray2, (int)n3, (float[])fArray2, (int)0, (int)n4);
                        System.arraycopy((long[])lArray, (int)n3, (long[])lArray, (int)0, (int)n4);
                        n2 -= n + 1;
                    }
                    fArray[n2] = f;
                    fArray2[n2] = f2;
                    lArray[n2] = l;
                    int n5 = n2 + 1;
                    if (n5 < 4) {
                        lArray[n5] = 0L;
                    }
                    return;
                }
                if (lArray[n2] < l - 200L) {
                    n = n2;
                }
                ++n2;
            }
        }

        public void addMovement(MotionEvent motionEvent) {
            long l = motionEvent.getEventTime();
            int n = motionEvent.getHistorySize();
            for (int i = 0; i < n; ++i) {
                this.addPoint(motionEvent.getHistoricalX(i), motionEvent.getHistoricalY(i), motionEvent.getHistoricalEventTime(i));
            }
            this.addPoint(motionEvent.getX(), motionEvent.getY(), l);
        }

        public void clear() {
            this.mPastTime[0] = 0L;
        }

        public void computeCurrentVelocity(int n) {
            this.computeCurrentVelocity(n, Float.MAX_VALUE);
        }

        /*
         * Enabled aggressive block sorting
         */
        public void computeCurrentVelocity(int n, float f) {
            float[] fArray = this.mPastX;
            float[] fArray2 = this.mPastY;
            long[] lArray = this.mPastTime;
            float f2 = fArray[0];
            float f3 = fArray2[0];
            long l = lArray[0];
            float f4 = 0.0f;
            float f5 = 0.0f;
            int n2 = 0;
            while (n2 < 4 && lArray[n2] != 0L) {
                ++n2;
            }
            for (int i = 1; i < n2; ++i) {
                int n3 = (int)(lArray[i] - l);
                if (n3 == 0) continue;
                float f6 = (fArray[i] - f2) / (float)n3 * (float)n;
                f4 = f4 == 0.0f ? f6 : 0.5f * (f4 + f6);
                float f7 = (fArray2[i] - f3) / (float)n3 * (float)n;
                f5 = f5 == 0.0f ? f7 : 0.5f * (f5 + f7);
            }
            float f8 = f4 < 0.0f ? Math.max(f4, -f) : Math.min(f4, f);
            this.mXVelocity = f8;
            float f9 = f5 < 0.0f ? Math.max(f5, -f) : Math.min(f5, f);
            this.mYVelocity = f9;
        }

        public float getXVelocity() {
            return this.mXVelocity;
        }

        public float getYVelocity() {
            return this.mYVelocity;
        }
    }
}

