/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.graphics.Bitmap;
import android.media.MediaMetadata;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.Log;
import android.util.SparseIntArray;

@Deprecated
public abstract class MediaMetadataEditor {
    public static final int BITMAP_KEY_ARTWORK = 100;
    public static final int KEY_EDITABLE_MASK = 0x1FFFFFFF;
    protected static final SparseIntArray METADATA_KEYS_TYPE = new SparseIntArray(17);
    protected static final int METADATA_TYPE_BITMAP = 2;
    protected static final int METADATA_TYPE_INVALID = -1;
    protected static final int METADATA_TYPE_LONG = 0;
    protected static final int METADATA_TYPE_RATING = 3;
    protected static final int METADATA_TYPE_STRING = 1;
    public static final int RATING_KEY_BY_OTHERS = 101;
    public static final int RATING_KEY_BY_USER = 0x10000001;
    private static final String TAG = "MediaMetadataEditor";
    protected boolean mApplied = false;
    protected boolean mArtworkChanged = false;
    protected long mEditableKeys;
    protected Bitmap mEditorArtwork;
    protected Bundle mEditorMetadata;
    protected MediaMetadata.Builder mMetadataBuilder;
    protected boolean mMetadataChanged = false;

    static {
        METADATA_KEYS_TYPE.put(0, 0);
        METADATA_KEYS_TYPE.put(14, 0);
        METADATA_KEYS_TYPE.put(9, 0);
        METADATA_KEYS_TYPE.put(8, 0);
        METADATA_KEYS_TYPE.put(1, 1);
        METADATA_KEYS_TYPE.put(13, 1);
        METADATA_KEYS_TYPE.put(7, 1);
        METADATA_KEYS_TYPE.put(2, 1);
        METADATA_KEYS_TYPE.put(3, 1);
        METADATA_KEYS_TYPE.put(15, 1);
        METADATA_KEYS_TYPE.put(4, 1);
        METADATA_KEYS_TYPE.put(5, 1);
        METADATA_KEYS_TYPE.put(6, 1);
        METADATA_KEYS_TYPE.put(11, 1);
        METADATA_KEYS_TYPE.put(100, 2);
        METADATA_KEYS_TYPE.put(101, 3);
        METADATA_KEYS_TYPE.put(0x10000001, 3);
    }

    protected MediaMetadataEditor() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addEditableKey(int n) {
        synchronized (this) {
            if (this.mApplied) {
                Log.e(TAG, "Can't change editable keys of a previously applied MetadataEditor");
            } else if (n == 0x10000001) {
                this.mEditableKeys |= (long)(0x1FFFFFFF & n);
                this.mMetadataChanged = true;
            } else {
                Log.e(TAG, "Metadata key " + n + " cannot be edited");
            }
            return;
        }
    }

    public abstract void apply();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void clear() {
        synchronized (this) {
            if (this.mApplied) {
                Log.e(TAG, "Can't clear a previously applied MediaMetadataEditor");
            } else {
                this.mEditorMetadata.clear();
                this.mEditorArtwork = null;
                this.mMetadataBuilder = new MediaMetadata.Builder();
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Bitmap getBitmap(int n, Bitmap bitmap) throws IllegalArgumentException {
        synchronized (this) {
            if (n != 100) {
                throw new IllegalArgumentException("Invalid type 'Bitmap' for key " + n);
            }
            if (this.mEditorArtwork == null) return bitmap;
            return this.mEditorArtwork;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int[] getEditableKeys() {
        synchronized (this) {
            if (this.mEditableKeys != 0x10000001L) return null;
            int[] nArray = new int[]{0x10000001};
            return nArray;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long getLong(int n, long l) throws IllegalArgumentException {
        synchronized (this) {
            if (METADATA_KEYS_TYPE.get(n, -1) == 0) return this.mEditorMetadata.getLong(String.valueOf(n), l);
            throw new IllegalArgumentException("Invalid type 'long' for key " + n);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object getObject(int n, Object object) throws IllegalArgumentException {
        synchronized (this) {
            switch (METADATA_KEYS_TYPE.get(n, -1)) {
                default: {
                    throw new IllegalArgumentException("Invalid key " + n);
                }
                case 0: {
                    if (!this.mEditorMetadata.containsKey(String.valueOf(n))) return object;
                    Long l = this.mEditorMetadata.getLong(String.valueOf(n));
                    return l;
                }
                case 1: {
                    if (!this.mEditorMetadata.containsKey(String.valueOf(n))) return object;
                    return this.mEditorMetadata.getString(String.valueOf(n));
                }
                case 3: {
                    if (!this.mEditorMetadata.containsKey(String.valueOf(n))) return object;
                    return this.mEditorMetadata.getParcelable(String.valueOf(n));
                }
                case 2: {
                    if (n != 100) throw new IllegalArgumentException("Invalid key " + n);
                    if (this.mEditorArtwork == null) return object;
                    return this.mEditorArtwork;
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getString(int n, String string2) throws IllegalArgumentException {
        synchronized (this) {
            if (METADATA_KEYS_TYPE.get(n, -1) == 1) return this.mEditorMetadata.getString(String.valueOf(n), string2);
            throw new IllegalArgumentException("Invalid type 'String' for key " + n);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MediaMetadataEditor putBitmap(int n, Bitmap bitmap) throws IllegalArgumentException {
        synchronized (this) {
            if (this.mApplied) {
                Log.e(TAG, "Can't edit a previously applied MediaMetadataEditor");
                return this;
            }
            if (n != 100) {
                throw new IllegalArgumentException("Invalid type 'Bitmap' for key " + n);
            }
            this.mEditorArtwork = bitmap;
            this.mArtworkChanged = true;
            return this;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MediaMetadataEditor putLong(int n, long l) throws IllegalArgumentException {
        synchronized (this) {
            if (this.mApplied) {
                Log.e(TAG, "Can't edit a previously applied MediaMetadataEditor");
                return this;
            }
            if (METADATA_KEYS_TYPE.get(n, -1) != 0) {
                throw new IllegalArgumentException("Invalid type 'long' for key " + n);
            }
            this.mEditorMetadata.putLong(String.valueOf(n), l);
            this.mMetadataChanged = true;
            return this;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MediaMetadataEditor putObject(int n, Object object) throws IllegalArgumentException {
        synchronized (this) {
            if (this.mApplied) {
                Log.e(TAG, "Can't edit a previously applied MediaMetadataEditor");
                return this;
            }
            switch (METADATA_KEYS_TYPE.get(n, -1)) {
                default: {
                    throw new IllegalArgumentException("Invalid key " + n);
                }
                case 0: {
                    if (object instanceof Long) return this.putLong(n, (Long)object);
                    throw new IllegalArgumentException("Not a non-null Long for key " + n);
                }
                case 1: {
                    if (object == null) return this.putString(n, (String)object);
                    if (object instanceof String) return this.putString(n, (String)object);
                    throw new IllegalArgumentException("Not a String for key " + n);
                }
                case 3: {
                    this.mEditorMetadata.putParcelable(String.valueOf(n), (Parcelable)object);
                    this.mMetadataChanged = true;
                    return this;
                }
                case 2: {
                    if (object == null) return this.putBitmap(n, (Bitmap)object);
                    if (object instanceof Bitmap) return this.putBitmap(n, (Bitmap)object);
                    throw new IllegalArgumentException("Not a Bitmap for key " + n);
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MediaMetadataEditor putString(int n, String string2) throws IllegalArgumentException {
        synchronized (this) {
            if (this.mApplied) {
                Log.e(TAG, "Can't edit a previously applied MediaMetadataEditor");
                return this;
            }
            if (METADATA_KEYS_TYPE.get(n, -1) != 1) {
                throw new IllegalArgumentException("Invalid type 'String' for key " + n);
            }
            this.mEditorMetadata.putString(String.valueOf(n), string2);
            this.mMetadataChanged = true;
            return this;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void removeEditableKeys() {
        synchronized (this) {
            if (this.mApplied) {
                Log.e(TAG, "Can't remove all editable keys of a previously applied MetadataEditor");
            } else if (this.mEditableKeys != 0L) {
                this.mEditableKeys = 0L;
                this.mMetadataChanged = true;
            }
            return;
        }
    }
}

