/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.content.Context;
import android.graphics.Bitmap;
import android.media.MediaHTTPService;
import android.net.Uri;
import android.os.IBinder;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Map;

public class MediaMetadataRetriever {
    private static final int EMBEDDED_PICTURE_TYPE_ANY = 65535;
    public static final int METADATA_KEY_ALBUM = 1;
    public static final int METADATA_KEY_ALBUMARTIST = 13;
    public static final int METADATA_KEY_ARTIST = 2;
    public static final int METADATA_KEY_AUTHOR = 3;
    public static final int METADATA_KEY_BITRATE = 20;
    public static final int METADATA_KEY_CD_TRACK_NUMBER = 0;
    public static final int METADATA_KEY_COMPILATION = 15;
    public static final int METADATA_KEY_COMPOSER = 4;
    public static final int METADATA_KEY_DATE = 5;
    public static final int METADATA_KEY_DISC_NUMBER = 14;
    public static final int METADATA_KEY_DURATION = 9;
    public static final int METADATA_KEY_GENRE = 6;
    public static final int METADATA_KEY_HAS_AUDIO = 16;
    public static final int METADATA_KEY_HAS_VIDEO = 17;
    public static final int METADATA_KEY_IS_DRM = 22;
    public static final int METADATA_KEY_LOCATION = 23;
    public static final int METADATA_KEY_MIMETYPE = 12;
    public static final int METADATA_KEY_NUM_TRACKS = 10;
    public static final int METADATA_KEY_TIMED_TEXT_LANGUAGES = 21;
    public static final int METADATA_KEY_TITLE = 7;
    public static final int METADATA_KEY_VIDEO_HEIGHT = 19;
    public static final int METADATA_KEY_VIDEO_ROTATION = 24;
    public static final int METADATA_KEY_VIDEO_WIDTH = 18;
    public static final int METADATA_KEY_WRITER = 11;
    public static final int METADATA_KEY_YEAR = 8;
    public static final int OPTION_CLOSEST = 3;
    public static final int OPTION_CLOSEST_SYNC = 2;
    public static final int OPTION_NEXT_SYNC = 1;
    public static final int OPTION_PREVIOUS_SYNC;
    private long mNativeContext;

    static {
        System.loadLibrary("media_jni");
        MediaMetadataRetriever.native_init();
    }

    public MediaMetadataRetriever() {
        this.native_setup();
    }

    private native Bitmap _getFrameAtTime(long var1, int var3);

    private native void _setDataSource(IBinder var1, String var2, String[] var3, String[] var4) throws IllegalArgumentException;

    private native byte[] getEmbeddedPicture(int var1);

    private final native void native_finalize();

    private static native void native_init();

    private native void native_setup();

    public native String extractMetadata(int var1);

    protected void finalize() throws Throwable {
        try {
            this.native_finalize();
            return;
        }
        finally {
            super.finalize();
        }
    }

    public byte[] getEmbeddedPicture() {
        return this.getEmbeddedPicture(65535);
    }

    public Bitmap getFrameAtTime() {
        return this.getFrameAtTime(-1L, 2);
    }

    public Bitmap getFrameAtTime(long l) {
        return this.getFrameAtTime(l, 2);
    }

    public Bitmap getFrameAtTime(long l, int n) {
        if (n < 0 || n > 3) {
            throw new IllegalArgumentException("Unsupported option: " + n);
        }
        return this._getFrameAtTime(l, n);
    }

    public native void release();

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setDataSource(Context var1_1, Uri var2_2) throws IllegalArgumentException, SecurityException {
        block20: {
            if (var2_2 == null) {
                throw new IllegalArgumentException();
            }
            var3_3 = var2_2.getScheme();
            if (var3_3 == null || var3_3.equals("file")) {
                this.setDataSource(var2_2.getPath());
                return;
            }
            var4_4 = null;
            var9_5 = var1_1.getContentResolver();
            var4_4 = var11_6 = var9_5.openAssetFileDescriptor(var2_2, "r");
            if (var4_4 == null) {
                throw new IllegalArgumentException();
            }
            ** GOTO lbl-1000
            {
                catch (SecurityException var7_7) {
                    if (var4_4 == null) ** GOTO lbl-1000
                    var4_4.close();
                    catch (FileNotFoundException var10_8) {}
                    throw new IllegalArgumentException();
lbl-1000:
                    // 2 sources

                    {
                        while (true) {
                            this.setDataSource(var2_2.toString());
                            return;
                        }
                        catch (Throwable var5_9) {}
                        if (var4_4 == null) throw var5_9;
                        try {}
                        catch (IOException var6_13) {
                            throw var5_9;
                        }
                        ** break block19
lbl-1000:
                        // 1 sources

                        {
                            var12_10 = var4_4.getFileDescriptor();
                            if (!var12_10.valid()) {
                                throw new IllegalArgumentException();
                            }
                            if (var4_4.getDeclaredLength() >= 0L) ** GOTO lbl-1000
                            this.setDataSource(var12_10);
                            break block20;
                        }
lbl-1000:
                        // 1 sources

                        {
                            this.setDataSource(var12_10, var4_4.getStartOffset(), var4_4.getDeclaredLength());
                            break block20;
                        }
                        catch (IOException var8_12) {}
                    }
                    ** continue;
                }
lbl-1000:
                // 1 sources

                {
                    var4_4.close();
                    throw var5_9;
                }
            }
        }
        if (var4_4 == null) return;
        try {
            var4_4.close();
            return;
        }
        catch (IOException var13_11) {
            return;
        }
    }

    public void setDataSource(FileDescriptor fileDescriptor) throws IllegalArgumentException {
        this.setDataSource(fileDescriptor, 0L, 0x7FFFFFFFFFFFFFFL);
    }

    public native void setDataSource(FileDescriptor var1, long var2, long var4) throws IllegalArgumentException;

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setDataSource(String string2) throws IllegalArgumentException {
        if (string2 == null) {
            throw new IllegalArgumentException();
        }
        FileInputStream fileInputStream = new FileInputStream(string2);
        this.setDataSource(fileInputStream.getFD(), 0L, 0x7FFFFFFFFFFFFFFL);
        if (fileInputStream == null) return;
        try {
            fileInputStream.close();
            return;
        }
        catch (Exception exception) {
            return;
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new IllegalArgumentException();
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException();
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException();
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new IllegalArgumentException();
        }
    }

    public void setDataSource(String string2, Map<String, String> map) throws IllegalArgumentException {
        int n = 0;
        String[] stringArray = new String[map.size()];
        String[] stringArray2 = new String[map.size()];
        for (Map.Entry<String, String> entry : map.entrySet()) {
            stringArray[n] = entry.getKey();
            stringArray2[n] = entry.getValue();
            ++n;
        }
        this._setDataSource(MediaHTTPService.createHttpServiceBinderIfNecessary(string2), string2, stringArray, stringArray2);
    }
}

