/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.content.Context;
import android.media.MediaFormat;
import android.media.SRTTrack;
import android.media.SubtitleController;
import android.media.SubtitleTrack;
import android.media.WebVttRenderingWidget;
import android.os.Handler;

public class SRTRenderer
extends SubtitleController.Renderer {
    private final Context mContext;
    private final Handler mEventHandler;
    private final boolean mRender;
    private WebVttRenderingWidget mRenderingWidget;

    public SRTRenderer(Context context) {
        this(context, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    SRTRenderer(Context context, Handler handler) {
        this.mContext = context;
        boolean bl = handler == null;
        this.mRender = bl;
        this.mEventHandler = handler;
    }

    @Override
    public SubtitleTrack createTrack(MediaFormat mediaFormat) {
        if (this.mRender && this.mRenderingWidget == null) {
            this.mRenderingWidget = new WebVttRenderingWidget(this.mContext);
        }
        if (this.mRender) {
            return new SRTTrack(this.mRenderingWidget, mediaFormat);
        }
        return new SRTTrack(this.mEventHandler, mediaFormat);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean supports(MediaFormat mediaFormat) {
        boolean bl = true;
        if (!mediaFormat.containsKey("mime")) return false;
        if (!mediaFormat.getString("mime").equals("application/x-subrip")) {
            return false;
        }
        boolean bl2 = this.mRender;
        boolean bl3 = mediaFormat.getInteger("is-timed-text", 0) == 0 ? bl : false;
        if (bl2 != bl3) return false;
        return bl;
    }
}

