/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.graphics.Canvas;
import android.media.MediaFormat;
import android.media.MediaTimeProvider;
import android.media.SubtitleData;
import android.os.Handler;
import android.util.Log;
import android.util.LongSparseArray;
import android.util.Pair;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.Vector;

public abstract class SubtitleTrack
implements MediaTimeProvider.OnMediaTimeListener {
    private static final String TAG = "SubtitleTrack";
    public boolean DEBUG = false;
    protected final Vector<Cue> mActiveCues;
    protected CueList mCues;
    private MediaFormat mFormat;
    protected Handler mHandler;
    private long mLastTimeMs;
    private long mLastUpdateTimeMs;
    private long mNextScheduledTimeMs = -1L;
    private Runnable mRunnable;
    protected final LongSparseArray<Run> mRunsByEndTime = new LongSparseArray();
    protected final LongSparseArray<Run> mRunsByID = new LongSparseArray();
    protected MediaTimeProvider mTimeProvider;
    protected boolean mVisible;

    public SubtitleTrack(MediaFormat mediaFormat) {
        this.mActiveCues = new Vector();
        this.mHandler = new Handler();
        this.mFormat = mediaFormat;
        this.mCues = new CueList();
        this.clearActiveCues();
        this.mLastTimeMs = -1L;
    }

    static /* synthetic */ Runnable access$102(SubtitleTrack subtitleTrack, Runnable runnable) {
        subtitleTrack.mRunnable = runnable;
        return runnable;
    }

    private void removeRunsByEndTimeIndex(int n) {
        Run run = this.mRunsByEndTime.valueAt(n);
        while (run != null) {
            Cue cue = run.mFirstCue;
            while (cue != null) {
                this.mCues.remove(cue);
                Cue cue2 = cue.mNextInRun;
                cue.mNextInRun = null;
                cue = cue2;
            }
            this.mRunsByID.remove(run.mRunID);
            Run run2 = run.mNextRunAtEndTimeMs;
            run.mPrevRunAtEndTimeMs = null;
            run.mNextRunAtEndTimeMs = null;
            run = run2;
        }
        this.mRunsByEndTime.removeAt(n);
    }

    private void takeTime(long l) {
        synchronized (this) {
            this.mLastTimeMs = l;
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean addCue(Cue cue) {
        boolean bl = true;
        synchronized (this) {
            this.mCues.add(cue);
            if (cue.mRunID != 0L) {
                Run run = this.mRunsByID.get(cue.mRunID);
                if (run == null) {
                    run = new Run();
                    this.mRunsByID.put(cue.mRunID, run);
                    run.mEndTimeMs = cue.mEndTimeMs;
                } else if (run.mEndTimeMs < cue.mEndTimeMs) {
                    run.mEndTimeMs = cue.mEndTimeMs;
                }
                cue.mNextInRun = run.mFirstCue;
                run.mFirstCue = cue;
            }
            final long l = -1L;
            MediaTimeProvider mediaTimeProvider = this.mTimeProvider;
            if (mediaTimeProvider != null) {
                try {
                    l = this.mTimeProvider.getCurrentTimeUs(false, true) / 1000L;
                }
                catch (IllegalStateException illegalStateException) {}
            }
            if (this.DEBUG) {
                Log.v(TAG, "mVisible=" + this.mVisible + ", " + cue.mStartTimeMs + " <= " + l + ", " + cue.mEndTimeMs + " >= " + this.mLastTimeMs);
            }
            if (this.mVisible && cue.mStartTimeMs <= l && cue.mEndTimeMs >= this.mLastTimeMs) {
                if (this.mRunnable != null) {
                    this.mHandler.removeCallbacks(this.mRunnable);
                }
                this.mRunnable = new Runnable(){

                    /*
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    @Override
                    public void run() {
                        SubtitleTrack subtitleTrack = this;
                        synchronized (subtitleTrack) {
                            SubtitleTrack.access$102(SubtitleTrack.this, null);
                            SubtitleTrack.this.updateActiveCues(true, l);
                            SubtitleTrack.this.updateView(SubtitleTrack.this.mActiveCues);
                            return;
                        }
                    }
                };
                if (this.mHandler.postDelayed(this.mRunnable, 10L)) {
                    if (!this.DEBUG) return bl;
                    Log.v(TAG, "scheduling update");
                } else {
                    if (!this.DEBUG) return bl;
                    Log.w(TAG, "failed to schedule subtitle view update");
                }
            } else {
                if (!this.mVisible) return false;
                if (cue.mEndTimeMs < this.mLastTimeMs) return false;
                if (cue.mStartTimeMs >= this.mNextScheduledTimeMs) {
                    if (this.mNextScheduledTimeMs >= 0L) return false;
                }
                this.scheduleTimedEvents();
                return false;
            }
            return bl;
        }
    }

    protected void clearActiveCues() {
        synchronized (this) {
            if (this.DEBUG) {
                Log.v(TAG, "Clearing " + this.mActiveCues.size() + " active cues");
            }
            this.mActiveCues.clear();
            this.mLastUpdateTimeMs = -1L;
            return;
        }
    }

    protected void finalize() throws Throwable {
        for (int i = -1 + this.mRunsByEndTime.size(); i >= 0; --i) {
            this.removeRunsByEndTimeIndex(i);
        }
        super.finalize();
    }

    protected void finishedRun(long l) {
        Run run;
        if (l != 0L && l != -1L && (run = this.mRunsByID.get(l)) != null) {
            run.storeByEndTimeMs(this.mRunsByEndTime);
        }
    }

    public final MediaFormat getFormat() {
        return this.mFormat;
    }

    public abstract RenderingWidget getRenderingWidget();

    public void hide() {
        RenderingWidget renderingWidget;
        if (!this.mVisible) {
            return;
        }
        if (this.mTimeProvider != null) {
            this.mTimeProvider.cancelNotifications(this);
        }
        if ((renderingWidget = this.getRenderingWidget()) != null) {
            renderingWidget.setVisible(false);
        }
        this.mVisible = false;
    }

    public boolean isTimedText() {
        return this.getRenderingWidget() == null;
    }

    protected void onData(SubtitleData subtitleData) {
        long l = 1L + subtitleData.getStartTimeUs();
        this.onData(subtitleData.getData(), true, l);
        this.setRunDiscardTimeMs(l, (subtitleData.getStartTimeUs() + subtitleData.getDurationUs()) / 1000L);
    }

    public abstract void onData(byte[] var1, boolean var2, long var3);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void onSeek(long l) {
        if (this.DEBUG) {
            Log.d(TAG, "onSeek " + l);
        }
        synchronized (this) {
            long l2 = l / 1000L;
            this.updateActiveCues(true, l2);
            this.takeTime(l2);
        }
        this.updateView(this.mActiveCues);
        this.scheduleTimedEvents();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void onStop() {
        synchronized (this) {
            if (this.DEBUG) {
                Log.d(TAG, "onStop");
            }
            this.clearActiveCues();
            this.mLastTimeMs = -1L;
        }
        this.updateView(this.mActiveCues);
        this.mNextScheduledTimeMs = -1L;
        this.mTimeProvider.notifyAt(-1L, this);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void onTimedEvent(long l) {
        if (this.DEBUG) {
            Log.d(TAG, "onTimedEvent " + l);
        }
        synchronized (this) {
            long l2 = l / 1000L;
            this.updateActiveCues(false, l2);
            this.takeTime(l2);
        }
        this.updateView(this.mActiveCues);
        this.scheduleTimedEvents();
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void scheduleTimedEvents() {
        if (this.mTimeProvider != null) {
            this.mNextScheduledTimeMs = this.mCues.nextTimeAfter(this.mLastTimeMs);
            if (this.DEBUG) {
                Log.d(TAG, "sched @" + this.mNextScheduledTimeMs + " after " + this.mLastTimeMs);
            }
            MediaTimeProvider mediaTimeProvider = this.mTimeProvider;
            long l = this.mNextScheduledTimeMs >= 0L ? 1000L * this.mNextScheduledTimeMs : -1L;
            mediaTimeProvider.notifyAt(l, this);
        }
    }

    public void setRunDiscardTimeMs(long l, long l2) {
        Run run;
        if (l != 0L && l != -1L && (run = this.mRunsByID.get(l)) != null) {
            run.mEndTimeMs = l2;
            run.storeByEndTimeMs(this.mRunsByEndTime);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setTimeProvider(MediaTimeProvider mediaTimeProvider) {
        synchronized (this) {
            MediaTimeProvider mediaTimeProvider2 = this.mTimeProvider;
            if (mediaTimeProvider2 != mediaTimeProvider) {
                if (this.mTimeProvider != null) {
                    this.mTimeProvider.cancelNotifications(this);
                }
                this.mTimeProvider = mediaTimeProvider;
                if (this.mTimeProvider != null) {
                    this.mTimeProvider.scheduleUpdate(this);
                }
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void show() {
        block5: {
            block4: {
                if (this.mVisible) break block4;
                this.mVisible = true;
                RenderingWidget renderingWidget = this.getRenderingWidget();
                if (renderingWidget != null) {
                    renderingWidget.setVisible(true);
                }
                if (this.mTimeProvider != null) break block5;
            }
            return;
        }
        this.mTimeProvider.scheduleUpdate(this);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void updateActiveCues(boolean bl, long l) {
        synchronized (this) {
            if (bl || this.mLastUpdateTimeMs > l) {
                this.clearActiveCues();
            }
            Iterator<Pair<Long, Cue>> iterator = this.mCues.entriesBetween(this.mLastUpdateTimeMs, l).iterator();
            while (iterator.hasNext()) {
                Pair<Long, Cue> pair = iterator.next();
                Cue cue = (Cue)pair.second;
                if (cue.mEndTimeMs == (Long)pair.first) {
                    if (this.DEBUG) {
                        Log.v(TAG, "Removing " + cue);
                    }
                    this.mActiveCues.remove(cue);
                    if (cue.mRunID != 0L) continue;
                    iterator.remove();
                    continue;
                }
                if (cue.mStartTimeMs == (Long)pair.first) {
                    if (this.DEBUG) {
                        Log.v(TAG, "Adding " + cue);
                    }
                    if (cue.mInnerTimesMs != null) {
                        cue.onTime(l);
                    }
                    this.mActiveCues.add(cue);
                    continue;
                }
                if (cue.mInnerTimesMs == null) continue;
                cue.onTime(l);
            }
            while (this.mRunsByEndTime.size() > 0 && this.mRunsByEndTime.keyAt(0) <= l) {
                this.removeRunsByEndTimeIndex(0);
            }
            this.mLastUpdateTimeMs = l;
            return;
        }
    }

    public abstract void updateView(Vector<Cue> var1);

    public static class Cue {
        public long mEndTimeMs;
        public long[] mInnerTimesMs;
        public Cue mNextInRun;
        public long mRunID;
        public long mStartTimeMs;

        public void onTime(long l) {
        }
    }

    static class CueList {
        private static final String TAG = "CueList";
        public boolean DEBUG = false;
        private SortedMap<Long, Vector<Cue>> mCues = new TreeMap<Long, Vector<Cue>>();

        CueList() {
        }

        /*
         * Enabled aggressive block sorting
         */
        private boolean addEvent(Cue cue, long l) {
            Vector<Cue> vector = (Vector<Cue>)this.mCues.get(l);
            if (vector == null) {
                vector = new Vector<Cue>(2);
                this.mCues.put(l, vector);
            } else if (vector.contains(cue)) {
                return false;
            }
            vector.add(cue);
            return true;
        }

        private void removeEvent(Cue cue, long l) {
            Vector vector = (Vector)this.mCues.get(l);
            if (vector != null) {
                vector.remove(cue);
                if (vector.size() == 0) {
                    this.mCues.remove(l);
                }
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        public void add(Cue cue) {
            if (cue.mStartTimeMs >= cue.mEndTimeMs || !this.addEvent(cue, cue.mStartTimeMs)) {
                return;
            }
            long l = cue.mStartTimeMs;
            if (cue.mInnerTimesMs != null) {
                for (long l2 : cue.mInnerTimesMs) {
                    if (l2 <= l || l2 >= cue.mEndTimeMs) continue;
                    this.addEvent(cue, l2);
                    l = l2;
                }
            }
            this.addEvent(cue, cue.mEndTimeMs);
        }

        public Iterable<Pair<Long, Cue>> entriesBetween(final long l, final long l2) {
            return new Iterable<Pair<Long, Cue>>(){

                @Override
                public Iterator<Pair<Long, Cue>> iterator() {
                    if (CueList.this.DEBUG) {
                        Log.d(CueList.TAG, "slice (" + l + ", " + l2 + "]=");
                    }
                    try {
                        EntryIterator entryIterator = new EntryIterator(CueList.this.mCues.subMap(1L + l, 1L + l2));
                        return entryIterator;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        return new EntryIterator(null);
                    }
                }
            };
        }

        public long nextTimeAfter(long l) {
            block4: {
                SortedMap<Long, Vector<Cue>> sortedMap = this.mCues.tailMap(1L + l);
                if (sortedMap == null) break block4;
                try {
                    long l2 = sortedMap.firstKey();
                    return l2;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    return -1L;
                }
                catch (NoSuchElementException noSuchElementException) {
                    return -1L;
                }
            }
            return -1L;
        }

        public void remove(Cue cue) {
            this.removeEvent(cue, cue.mStartTimeMs);
            if (cue.mInnerTimesMs != null) {
                long[] lArray = cue.mInnerTimesMs;
                int n = lArray.length;
                for (int i = 0; i < n; ++i) {
                    this.removeEvent(cue, lArray[i]);
                }
            }
            this.removeEvent(cue, cue.mEndTimeMs);
        }

        class EntryIterator
        implements Iterator<Pair<Long, Cue>> {
            private long mCurrentTimeMs;
            private boolean mDone;
            private Pair<Long, Cue> mLastEntry;
            private Iterator<Cue> mLastListIterator;
            private Iterator<Cue> mListIterator;
            private SortedMap<Long, Vector<Cue>> mRemainingCues;

            public EntryIterator(SortedMap<Long, Vector<Cue>> sortedMap) {
                if (CueList.this.DEBUG) {
                    Log.v(CueList.TAG, sortedMap + "");
                }
                this.mRemainingCues = sortedMap;
                this.mLastListIterator = null;
                this.nextKey();
            }

            /*
             * Exception decompiling
             */
            private void nextKey() {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 34->106)] java.util.NoSuchElementException
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }

            @Override
            public boolean hasNext() {
                return !this.mDone;
            }

            @Override
            public Pair<Long, Cue> next() {
                if (this.mDone) {
                    throw new NoSuchElementException("");
                }
                this.mLastEntry = new Pair<Long, Cue>(this.mCurrentTimeMs, this.mListIterator.next());
                this.mLastListIterator = this.mListIterator;
                if (!this.mListIterator.hasNext()) {
                    this.nextKey();
                }
                return this.mLastEntry;
            }

            @Override
            public void remove() {
                if (this.mLastListIterator == null || ((Cue)this.mLastEntry.second).mEndTimeMs != (Long)this.mLastEntry.first) {
                    throw new IllegalStateException("");
                }
                this.mLastListIterator.remove();
                this.mLastListIterator = null;
                if (((Vector)CueList.this.mCues.get(this.mLastEntry.first)).size() == 0) {
                    CueList.this.mCues.remove(this.mLastEntry.first);
                }
                Cue cue = (Cue)this.mLastEntry.second;
                CueList.this.removeEvent(cue, cue.mStartTimeMs);
                if (cue.mInnerTimesMs != null) {
                    for (long l : cue.mInnerTimesMs) {
                        CueList.this.removeEvent(cue, l);
                    }
                }
            }
        }
    }

    public static interface RenderingWidget {
        public void draw(Canvas var1);

        public void onAttachedToWindow();

        public void onDetachedFromWindow();

        public void setOnChangedListener(OnChangedListener var1);

        public void setSize(int var1, int var2);

        public void setVisible(boolean var1);

        public static interface OnChangedListener {
            public void onChanged(RenderingWidget var1);
        }
    }

    private static class Run {
        static final /* synthetic */ boolean $assertionsDisabled;
        public long mEndTimeMs = -1L;
        public Cue mFirstCue;
        public Run mNextRunAtEndTimeMs;
        public Run mPrevRunAtEndTimeMs;
        public long mRunID = 0L;
        private long mStoredEndTimeMs = -1L;

        /*
         * Enabled aggressive block sorting
         */
        static {
            boolean bl = !SubtitleTrack.class.desiredAssertionStatus();
            $assertionsDisabled = bl;
        }

        private Run() {
        }

        public void removeAtEndTimeMs() {
            Run run = this.mPrevRunAtEndTimeMs;
            if (this.mPrevRunAtEndTimeMs != null) {
                this.mPrevRunAtEndTimeMs.mNextRunAtEndTimeMs = this.mNextRunAtEndTimeMs;
                this.mPrevRunAtEndTimeMs = null;
            }
            if (this.mNextRunAtEndTimeMs != null) {
                this.mNextRunAtEndTimeMs.mPrevRunAtEndTimeMs = run;
                this.mNextRunAtEndTimeMs = null;
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        public void storeByEndTimeMs(LongSparseArray<Run> longSparseArray) {
            int n = longSparseArray.indexOfKey(this.mStoredEndTimeMs);
            if (n >= 0) {
                if (this.mPrevRunAtEndTimeMs == null) {
                    if (!$assertionsDisabled && this != longSparseArray.valueAt(n)) {
                        throw new AssertionError();
                    }
                    if (this.mNextRunAtEndTimeMs == null) {
                        longSparseArray.removeAt(n);
                    } else {
                        longSparseArray.setValueAt(n, this.mNextRunAtEndTimeMs);
                    }
                }
                this.removeAtEndTimeMs();
            }
            if (this.mEndTimeMs >= 0L) {
                this.mPrevRunAtEndTimeMs = null;
                this.mNextRunAtEndTimeMs = longSparseArray.get(this.mEndTimeMs);
                if (this.mNextRunAtEndTimeMs != null) {
                    this.mNextRunAtEndTimeMs.mPrevRunAtEndTimeMs = this;
                }
                longSparseArray.put(this.mEndTimeMs, this);
                this.mStoredEndTimeMs = this.mEndTimeMs;
            }
        }
    }
}

