/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.graphics.Rect;
import android.os.Parcel;
import android.util.Log;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

public final class TimedText {
    private static final int FIRST_PRIVATE_KEY = 101;
    private static final int FIRST_PUBLIC_KEY = 1;
    private static final int KEY_BACKGROUND_COLOR_RGBA = 3;
    private static final int KEY_DISPLAY_FLAGS = 1;
    private static final int KEY_END_CHAR = 104;
    private static final int KEY_FONT_ID = 105;
    private static final int KEY_FONT_SIZE = 106;
    private static final int KEY_GLOBAL_SETTING = 101;
    private static final int KEY_HIGHLIGHT_COLOR_RGBA = 4;
    private static final int KEY_LOCAL_SETTING = 102;
    private static final int KEY_SCROLL_DELAY = 5;
    private static final int KEY_START_CHAR = 103;
    private static final int KEY_START_TIME = 7;
    private static final int KEY_STRUCT_BLINKING_TEXT_LIST = 8;
    private static final int KEY_STRUCT_FONT_LIST = 9;
    private static final int KEY_STRUCT_HIGHLIGHT_LIST = 10;
    private static final int KEY_STRUCT_HYPER_TEXT_LIST = 11;
    private static final int KEY_STRUCT_JUSTIFICATION = 15;
    private static final int KEY_STRUCT_KARAOKE_LIST = 12;
    private static final int KEY_STRUCT_STYLE_LIST = 13;
    private static final int KEY_STRUCT_TEXT = 16;
    private static final int KEY_STRUCT_TEXT_POS = 14;
    private static final int KEY_STYLE_FLAGS = 2;
    private static final int KEY_TEXT_COLOR_RGBA = 107;
    private static final int KEY_WRAP_TEXT = 6;
    private static final int LAST_PRIVATE_KEY = 107;
    private static final int LAST_PUBLIC_KEY = 16;
    private static final String TAG = "TimedText";
    private int mBackgroundColorRGBA = -1;
    private List<CharPos> mBlinkingPosList = null;
    private int mDisplayFlags = -1;
    private List<Font> mFontList = null;
    private int mHighlightColorRGBA = -1;
    private List<CharPos> mHighlightPosList = null;
    private List<HyperText> mHyperTextList = null;
    private Justification mJustification;
    private List<Karaoke> mKaraokeList = null;
    private final HashMap<Integer, Object> mKeyObjectMap = new HashMap();
    private int mScrollDelay = -1;
    private List<Style> mStyleList = null;
    private Rect mTextBounds = null;
    private String mTextChars = null;
    private int mWrapText = -1;

    public TimedText(Parcel parcel) {
        if (!this.parseParcel(parcel)) {
            this.mKeyObjectMap.clear();
            throw new IllegalArgumentException("parseParcel() fails");
        }
    }

    private boolean containsKey(int n) {
        return this.isValidKey(n) && this.mKeyObjectMap.containsKey(n);
    }

    private Object getObject(int n) {
        if (this.containsKey(n)) {
            return this.mKeyObjectMap.get(n);
        }
        throw new IllegalArgumentException("Invalid key: " + n);
    }

    private boolean isValidKey(int n) {
        int n2 = 1;
        if (!(n >= n2 && n <= 16 || n >= 101 && n <= 107)) {
            n2 = 0;
        }
        return n2 != 0;
    }

    private Set keySet() {
        return this.mKeyObjectMap.keySet();
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean parseParcel(Parcel parcel) {
        parcel.setDataPosition(0);
        if (parcel.dataAvail() == 0) {
            return false;
        }
        int n = parcel.readInt();
        if (n == 102) {
            int n2 = parcel.readInt();
            if (n2 != 7) {
                return false;
            }
            int n3 = parcel.readInt();
            this.mKeyObjectMap.put(n2, n3);
            if (parcel.readInt() != 16) {
                return false;
            }
            parcel.readInt();
            byte[] byArray = parcel.createByteArray();
            this.mTextChars = byArray == null || byArray.length == 0 ? null : new String(byArray);
        } else if (n != 101) {
            Log.w(TAG, "Invalid timed text key found: " + n);
            return false;
        }
        while (parcel.dataAvail() > 0) {
            int n4 = parcel.readInt();
            if (!this.isValidKey(n4)) {
                Log.w(TAG, "Invalid timed text key found: " + n4);
                return false;
            }
            Object object = null;
            switch (n4) {
                case 13: {
                    this.readStyle(parcel);
                    object = this.mStyleList;
                    break;
                }
                case 9: {
                    this.readFont(parcel);
                    object = this.mFontList;
                    break;
                }
                case 10: {
                    this.readHighlight(parcel);
                    object = this.mHighlightPosList;
                    break;
                }
                case 12: {
                    this.readKaraoke(parcel);
                    object = this.mKaraokeList;
                    break;
                }
                case 11: {
                    this.readHyperText(parcel);
                    object = this.mHyperTextList;
                    break;
                }
                case 8: {
                    this.readBlinkingText(parcel);
                    object = this.mBlinkingPosList;
                    break;
                }
                case 6: {
                    this.mWrapText = parcel.readInt();
                    object = this.mWrapText;
                    break;
                }
                case 4: {
                    this.mHighlightColorRGBA = parcel.readInt();
                    object = this.mHighlightColorRGBA;
                    break;
                }
                case 1: {
                    this.mDisplayFlags = parcel.readInt();
                    object = this.mDisplayFlags;
                    break;
                }
                case 15: {
                    this.mJustification = new Justification(parcel.readInt(), parcel.readInt());
                    object = this.mJustification;
                    break;
                }
                case 3: {
                    this.mBackgroundColorRGBA = parcel.readInt();
                    object = this.mBackgroundColorRGBA;
                    break;
                }
                case 14: {
                    int n5 = parcel.readInt();
                    int n6 = parcel.readInt();
                    int n7 = parcel.readInt();
                    this.mTextBounds = new Rect(n6, n5, parcel.readInt(), n7);
                    object = null;
                    break;
                }
                case 5: {
                    this.mScrollDelay = parcel.readInt();
                    object = this.mScrollDelay;
                    break;
                }
            }
            if (object == null) continue;
            if (this.mKeyObjectMap.containsKey(n4)) {
                this.mKeyObjectMap.remove(n4);
            }
            this.mKeyObjectMap.put(n4, object);
        }
        return true;
    }

    private void readBlinkingText(Parcel parcel) {
        CharPos charPos = new CharPos(parcel.readInt(), parcel.readInt());
        if (this.mBlinkingPosList == null) {
            this.mBlinkingPosList = new ArrayList<CharPos>();
        }
        this.mBlinkingPosList.add(charPos);
    }

    private void readFont(Parcel parcel) {
        int n = parcel.readInt();
        for (int i = 0; i < n; ++i) {
            int n2 = parcel.readInt();
            int n3 = parcel.readInt();
            Font font = new Font(n2, new String(parcel.createByteArray(), 0, n3));
            if (this.mFontList == null) {
                this.mFontList = new ArrayList<Font>();
            }
            this.mFontList.add(font);
        }
    }

    private void readHighlight(Parcel parcel) {
        CharPos charPos = new CharPos(parcel.readInt(), parcel.readInt());
        if (this.mHighlightPosList == null) {
            this.mHighlightPosList = new ArrayList<CharPos>();
        }
        this.mHighlightPosList.add(charPos);
    }

    private void readHyperText(Parcel parcel) {
        int n = parcel.readInt();
        int n2 = parcel.readInt();
        int n3 = parcel.readInt();
        String string2 = new String(parcel.createByteArray(), 0, n3);
        int n4 = parcel.readInt();
        HyperText hyperText = new HyperText(n, n2, string2, new String(parcel.createByteArray(), 0, n4));
        if (this.mHyperTextList == null) {
            this.mHyperTextList = new ArrayList<HyperText>();
        }
        this.mHyperTextList.add(hyperText);
    }

    private void readKaraoke(Parcel parcel) {
        int n = parcel.readInt();
        for (int i = 0; i < n; ++i) {
            Karaoke karaoke = new Karaoke(parcel.readInt(), parcel.readInt(), parcel.readInt(), parcel.readInt());
            if (this.mKaraokeList == null) {
                this.mKaraokeList = new ArrayList<Karaoke>();
            }
            this.mKaraokeList.add(karaoke);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void readStyle(Parcel parcel) {
        boolean bl = false;
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        int n4 = -1;
        int n5 = -1;
        block8: while (!bl && parcel.dataAvail() > 0) {
            switch (parcel.readInt()) {
                default: {
                    parcel.setDataPosition(-4 + parcel.dataPosition());
                    bl = true;
                    continue block8;
                }
                case 103: {
                    n = parcel.readInt();
                    continue block8;
                }
                case 104: {
                    n2 = parcel.readInt();
                    continue block8;
                }
                case 105: {
                    n3 = parcel.readInt();
                    continue block8;
                }
                case 2: {
                    int n6 = parcel.readInt();
                    bl2 = n6 % 2 == 1;
                    bl3 = n6 % 4 >= 2;
                    if (n6 / 4 == 1) {
                        bl4 = true;
                        continue block8;
                    }
                    bl4 = false;
                    continue block8;
                }
                case 106: {
                    n4 = parcel.readInt();
                    continue block8;
                }
                case 107: 
            }
            n5 = parcel.readInt();
        }
        Style style2 = new Style(n, n2, n3, bl2, bl3, bl4, n4, n5);
        if (this.mStyleList == null) {
            this.mStyleList = new ArrayList<Style>();
        }
        this.mStyleList.add(style2);
    }

    public Rect getBounds() {
        return this.mTextBounds;
    }

    public String getText() {
        return this.mTextChars;
    }

    public static final class CharPos {
        public final int endChar;
        public final int startChar;

        public CharPos(int n, int n2) {
            this.startChar = n;
            this.endChar = n2;
        }
    }

    public static final class Font {
        public final int ID;
        public final String name;

        public Font(int n, String string2) {
            this.ID = n;
            this.name = string2;
        }
    }

    public static final class HyperText {
        public final String URL;
        public final String altString;
        public final int endChar;
        public final int startChar;

        public HyperText(int n, int n2, String string2, String string3) {
            this.startChar = n;
            this.endChar = n2;
            this.URL = string2;
            this.altString = string3;
        }
    }

    public static final class Justification {
        public final int horizontalJustification;
        public final int verticalJustification;

        public Justification(int n, int n2) {
            this.horizontalJustification = n;
            this.verticalJustification = n2;
        }
    }

    public static final class Karaoke {
        public final int endChar;
        public final int endTimeMs;
        public final int startChar;
        public final int startTimeMs;

        public Karaoke(int n, int n2, int n3, int n4) {
            this.startTimeMs = n;
            this.endTimeMs = n2;
            this.startChar = n3;
            this.endChar = n4;
        }
    }

    public static final class Style {
        public final int colorRGBA;
        public final int endChar;
        public final int fontID;
        public final int fontSize;
        public final boolean isBold;
        public final boolean isItalic;
        public final boolean isUnderlined;
        public final int startChar;

        public Style(int n, int n2, int n3, boolean bl, boolean bl2, boolean bl3, int n4, int n5) {
            this.startChar = n;
            this.endChar = n2;
            this.fontID = n3;
            this.isBold = bl;
            this.isItalic = bl2;
            this.isUnderlined = bl3;
            this.fontSize = n4;
            this.colorRGBA = n5;
        }
    }
}

