/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.content.Context;
import android.media.SubtitleTrack;
import android.media.TtmlCue;
import android.util.AttributeSet;
import android.view.View;
import android.view.accessibility.CaptioningManager;
import android.widget.LinearLayout;
import android.widget.TextView;
import java.util.Vector;

class TtmlRenderingWidget
extends LinearLayout
implements SubtitleTrack.RenderingWidget {
    private SubtitleTrack.RenderingWidget.OnChangedListener mListener;
    private final TextView mTextView;

    public TtmlRenderingWidget(Context context) {
        this(context, null);
    }

    public TtmlRenderingWidget(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public TtmlRenderingWidget(Context context, AttributeSet attributeSet, int n) {
        this(context, attributeSet, n, 0);
    }

    public TtmlRenderingWidget(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n, n2);
        this.setLayerType(1, null);
        CaptioningManager captioningManager = (CaptioningManager)context.getSystemService("captioning");
        this.mTextView = new TextView(context);
        this.mTextView.setTextColor(captioningManager.getUserStyle().foregroundColor);
        this.addView((View)this.mTextView, -1, -1);
        this.mTextView.setGravity(81);
    }

    @Override
    public void onAttachedToWindow() {
        super.onAttachedToWindow();
    }

    @Override
    public void onDetachedFromWindow() {
        super.onDetachedFromWindow();
    }

    public void setActiveCues(Vector<SubtitleTrack.Cue> vector) {
        int n = vector.size();
        String string2 = "";
        for (int i = 0; i < n; ++i) {
            TtmlCue ttmlCue = (TtmlCue)vector.get(i);
            string2 = string2 + ttmlCue.mText + "\n";
        }
        this.mTextView.setText(string2);
        if (this.mListener != null) {
            this.mListener.onChanged(this);
        }
    }

    @Override
    public void setOnChangedListener(SubtitleTrack.RenderingWidget.OnChangedListener onChangedListener) {
        this.mListener = onChangedListener;
    }

    @Override
    public void setSize(int n, int n2) {
        this.measure(View.MeasureSpec.makeMeasureSpec(n, 0x40000000), View.MeasureSpec.makeMeasureSpec(n2, 0x40000000));
        this.layout(0, 0, n, n2);
    }

    @Override
    public void setVisible(boolean bl) {
        if (bl) {
            this.setVisibility(0);
            return;
        }
        this.setVisibility(8);
    }
}

