/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.media.TtmlNode;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class TtmlUtils {
    public static final String ATTR_BEGIN = "begin";
    public static final String ATTR_DURATION = "dur";
    public static final String ATTR_END = "end";
    private static final Pattern CLOCK_TIME = Pattern.compile("^([0-9][0-9]+):([0-9][0-9]):([0-9][0-9])(?:(\\.[0-9]+)|:([0-9][0-9])(?:\\.([0-9]+))?)?$");
    public static final long INVALID_TIMESTAMP = Long.MAX_VALUE;
    private static final Pattern OFFSET_TIME = Pattern.compile("^([0-9]+(?:\\.[0-9]+)?)(h|m|s|ms|f|t)$");
    public static final String PCDATA = "#pcdata";
    public static final String TAG_BODY = "body";
    public static final String TAG_BR = "br";
    public static final String TAG_DIV = "div";
    public static final String TAG_HEAD = "head";
    public static final String TAG_LAYOUT = "layout";
    public static final String TAG_METADATA = "metadata";
    public static final String TAG_P = "p";
    public static final String TAG_REGION = "region";
    public static final String TAG_SMPTE_DATA = "smpte:data";
    public static final String TAG_SMPTE_IMAGE = "smpte:image";
    public static final String TAG_SMPTE_INFORMATION = "smpte:information";
    public static final String TAG_SPAN = "span";
    public static final String TAG_STYLE = "style";
    public static final String TAG_STYLING = "styling";
    public static final String TAG_TT = "tt";

    private TtmlUtils() {
    }

    public static String applyDefaultSpacePolicy(String string2) {
        return TtmlUtils.applySpacePolicy(string2, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String applySpacePolicy(String string2, boolean bl) {
        String string3;
        String string4 = string2.replaceAll("\r\n", "\n").replaceAll(" *\n *", "\n");
        if (bl) {
            string3 = string4.replaceAll("\n", " ");
            return string3.replaceAll("[ \t\\x0B\f\r]+", " ");
        }
        string3 = string4;
        return string3.replaceAll("[ \t\\x0B\f\r]+", " ");
    }

    public static String extractText(TtmlNode ttmlNode, long l, long l2) {
        StringBuilder stringBuilder = new StringBuilder();
        TtmlUtils.extractText(ttmlNode, l, l2, stringBuilder, false);
        return stringBuilder.toString().replaceAll("\n$", "");
    }

    /*
     * Enabled aggressive block sorting
     * Lifted jumps to return sites
     */
    private static void extractText(TtmlNode ttmlNode, long l, long l2, StringBuilder stringBuilder, boolean bl) {
        if (ttmlNode.mName.equals(PCDATA) && bl) {
            stringBuilder.append(ttmlNode.mText);
            return;
        }
        if (ttmlNode.mName.equals(TAG_BR) && bl) {
            stringBuilder.append("\n");
            return;
        }
        if (ttmlNode.mName.equals(TAG_METADATA)) return;
        if (!ttmlNode.isActive(l, l2)) return;
        boolean bl2 = ttmlNode.mName.equals(TAG_P);
        int n = stringBuilder.length();
        int n2 = 0;
        while (true) {
            if (n2 >= ttmlNode.mChildren.size()) {
                if (!bl2) return;
                if (n == stringBuilder.length()) return;
                stringBuilder.append("\n");
                return;
            }
            TtmlNode ttmlNode2 = ttmlNode.mChildren.get(n2);
            boolean bl3 = bl2 || bl;
            TtmlUtils.extractText(ttmlNode2, l, l2, stringBuilder, bl3);
            ++n2;
        }
    }

    public static String extractTtmlFragment(TtmlNode ttmlNode, long l, long l2) {
        StringBuilder stringBuilder = new StringBuilder();
        TtmlUtils.extractTtmlFragment(ttmlNode, l, l2, stringBuilder);
        return stringBuilder.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void extractTtmlFragment(TtmlNode ttmlNode, long l, long l2, StringBuilder stringBuilder) {
        if (ttmlNode.mName.equals(PCDATA)) {
            stringBuilder.append(ttmlNode.mText);
            return;
        } else {
            if (ttmlNode.mName.equals(TAG_BR)) {
                stringBuilder.append("<br/>");
                return;
            }
            if (!ttmlNode.isActive(l, l2)) return;
            stringBuilder.append("<");
            stringBuilder.append(ttmlNode.mName);
            stringBuilder.append(ttmlNode.mAttributes);
            stringBuilder.append(">");
            int n = 0;
            while (true) {
                if (n >= ttmlNode.mChildren.size()) {
                    stringBuilder.append("</");
                    stringBuilder.append(ttmlNode.mName);
                    stringBuilder.append(">");
                    return;
                }
                TtmlUtils.extractTtmlFragment(ttmlNode.mChildren.get(n), l, l2, stringBuilder);
                ++n;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static long parseTimeExpression(String string2, int n, int n2, int n3) throws NumberFormatException {
        Matcher matcher = CLOCK_TIME.matcher(string2);
        if (matcher.matches()) {
            double d;
            double d2 = (double)(3600L * Long.parseLong(matcher.group(1))) + (double)(60L * Long.parseLong(matcher.group(2))) + (double)Long.parseLong(matcher.group(3));
            String string3 = matcher.group(4);
            double d3 = string3 != null ? Double.parseDouble(string3) : 0.0;
            double d4 = d2 + d3;
            String string4 = matcher.group(5);
            double d5 = string4 != null ? (double)Long.parseLong(string4) / (double)n : 0.0;
            double d6 = d4 + d5;
            String string5 = matcher.group(6);
            if (string5 != null) {
                d = (double)Long.parseLong(string5) / (double)n2 / (double)n;
                return (long)(1000.0 * (d6 + d));
            }
            d = 0.0;
            return (long)(1000.0 * (d6 + d));
        }
        Matcher matcher2 = OFFSET_TIME.matcher(string2);
        if (!matcher2.matches()) throw new NumberFormatException("Malformed time expression : " + string2);
        double d = Double.parseDouble(matcher2.group(1));
        String string6 = matcher2.group(2);
        if (string6.equals("h")) {
            d *= 3.6E9;
            return (long)d;
        }
        if (string6.equals("m")) {
            return (long)(d *= 6.0E7);
        }
        if (string6.equals("s")) {
            return (long)(d *= 1000000.0);
        }
        if (string6.equals("ms")) {
            return (long)(d *= 1000.0);
        }
        if (string6.equals("f")) {
            d = 1000000.0 * (d / (double)n);
            return (long)d;
        }
        if (!string6.equals("t")) return (long)d;
        d = 1000000.0 * (d / (double)n3);
        return (long)d;
    }
}

