/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.media.TextTrackCueSpan;
import android.media.Tokenizer;
import java.util.Vector;

class UnstyledTextExtractor
implements Tokenizer.OnTokenListener {
    Vector<TextTrackCueSpan> mCurrentLine;
    long mLastTimestamp;
    StringBuilder mLine = new StringBuilder();
    Vector<TextTrackCueSpan[]> mLines = new Vector();

    UnstyledTextExtractor() {
        this.mCurrentLine = new Vector();
        this.init();
    }

    private void init() {
        this.mLine.delete(0, this.mLine.length());
        this.mLines.clear();
        this.mCurrentLine.clear();
        this.mLastTimestamp = -1L;
    }

    public TextTrackCueSpan[][] getText() {
        if (this.mLine.length() > 0 || this.mCurrentLine.size() > 0) {
            this.onLineEnd();
        }
        TextTrackCueSpan[][] textTrackCueSpanArray = new TextTrackCueSpan[this.mLines.size()][];
        this.mLines.toArray((T[])textTrackCueSpanArray);
        this.init();
        return textTrackCueSpanArray;
    }

    @Override
    public void onData(String string2) {
        this.mLine.append(string2);
    }

    @Override
    public void onEnd(String string2) {
    }

    @Override
    public void onLineEnd() {
        if (this.mLine.length() > 0) {
            this.mCurrentLine.add(new TextTrackCueSpan(this.mLine.toString(), this.mLastTimestamp));
            this.mLine.delete(0, this.mLine.length());
        }
        TextTrackCueSpan[] textTrackCueSpanArray = new TextTrackCueSpan[this.mCurrentLine.size()];
        this.mCurrentLine.toArray(textTrackCueSpanArray);
        this.mCurrentLine.clear();
        this.mLines.add(textTrackCueSpanArray);
    }

    @Override
    public void onStart(String string2, String[] stringArray, String string3) {
    }

    @Override
    public void onTimeStamp(long l) {
        if (this.mLine.length() > 0 && l != this.mLastTimestamp) {
            this.mCurrentLine.add(new TextTrackCueSpan(this.mLine.toString(), this.mLastTimestamp));
            this.mLine.delete(0, this.mLine.length());
        }
        this.mLastTimestamp = l;
    }
}

