/*
 * Decompiled with CFR 0.152.
 */
package android.media.audiopolicy;

import android.media.AudioAttributes;
import android.media.AudioFormat;
import android.media.audiopolicy.AudioMix;
import android.media.audiopolicy.AudioMixingRule;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import java.util.ArrayList;
import java.util.Iterator;

public class AudioPolicyConfig
implements Parcelable {
    public static final Parcelable.Creator<AudioPolicyConfig> CREATOR = new Parcelable.Creator<AudioPolicyConfig>(){

        @Override
        public AudioPolicyConfig createFromParcel(Parcel parcel) {
            return new AudioPolicyConfig(parcel);
        }

        public AudioPolicyConfig[] newArray(int n) {
            return new AudioPolicyConfig[n];
        }
    };
    private static final String TAG = "AudioPolicyConfig";
    ArrayList<AudioMix> mMixes;

    /*
     * Enabled aggressive block sorting
     */
    private AudioPolicyConfig(Parcel parcel) {
        this.mMixes = new ArrayList();
        int n = parcel.readInt();
        int n2 = 0;
        while (n2 < n) {
            AudioMix.Builder builder = new AudioMix.Builder();
            builder.setRouteFlags(parcel.readInt());
            int n3 = parcel.readInt();
            int n4 = parcel.readInt();
            int n5 = parcel.readInt();
            builder.setFormat(new AudioFormat.Builder().setSampleRate(n3).setChannelMask(n5).setEncoding(n4).build());
            int n6 = parcel.readInt();
            AudioMixingRule.Builder builder2 = new AudioMixingRule.Builder();
            for (int i = 0; i < n6; ++i) {
                int n7 = parcel.readInt();
                if (n7 == 2 || n7 == 1) {
                    int n8 = parcel.readInt();
                    builder2.addRule(new AudioAttributes.Builder().setUsage(n8).build(), n7);
                    continue;
                }
                Log.w(TAG, "Encountered unsupported rule, skipping");
                parcel.readInt();
            }
            builder.setMixingRule(builder2.build());
            this.mMixes.add(builder.build());
            ++n2;
        }
        return;
    }

    AudioPolicyConfig(ArrayList<AudioMix> arrayList) {
        this.mMixes = arrayList;
    }

    public void addMix(AudioMix audioMix) throws IllegalArgumentException {
        if (audioMix == null) {
            throw new IllegalArgumentException("Illegal null AudioMix argument");
        }
        this.mMixes.add(audioMix);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    public String toString() {
        String string2 = new String("android.media.audiopolicy.AudioPolicyConfig:\n");
        String string3 = string2 + this.mMixes.size() + " AudioMix:\n";
        Iterator<AudioMix> iterator = this.mMixes.iterator();
        block4: while (iterator.hasNext()) {
            AudioMix audioMix = iterator.next();
            String string4 = string3 + "* route flags=0x" + Integer.toHexString(audioMix.getRouteFlags()) + "\n";
            String string5 = string4 + "  rate=" + audioMix.getFormat().getSampleRate() + "Hz\n";
            String string6 = string5 + "  encoding=" + audioMix.getFormat().getEncoding() + "\n";
            String string7 = string6 + "  channels=0x";
            string3 = string7 + Integer.toHexString(audioMix.getFormat().getChannelMask()).toUpperCase() + "\n";
            Iterator<AudioMixingRule.AttributeMatchCriterion> iterator2 = audioMix.getRule().getCriteria().iterator();
            while (true) {
                String string8;
                if (!iterator2.hasNext()) continue block4;
                AudioMixingRule.AttributeMatchCriterion attributeMatchCriterion = iterator2.next();
                switch (attributeMatchCriterion.mRule) {
                    default: {
                        string8 = string3 + "invalid rule!";
                        break;
                    }
                    case 2: {
                        String string9 = string3 + "  exclude usage ";
                        string8 = string9 + attributeMatchCriterion.mAttr.usageToString();
                        break;
                    }
                    case 1: {
                        String string10 = string3 + "  match usage ";
                        string8 = string10 + attributeMatchCriterion.mAttr.usageToString();
                    }
                }
                string3 = string8 + "\n";
            }
            break;
        }
        return string3;
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeInt(this.mMixes.size());
        for (AudioMix audioMix : this.mMixes) {
            parcel.writeInt(audioMix.getRouteFlags());
            parcel.writeInt(audioMix.getFormat().getSampleRate());
            parcel.writeInt(audioMix.getFormat().getEncoding());
            parcel.writeInt(audioMix.getFormat().getChannelMask());
            ArrayList<AudioMixingRule.AttributeMatchCriterion> arrayList = audioMix.getRule().getCriteria();
            parcel.writeInt(arrayList.size());
            for (AudioMixingRule.AttributeMatchCriterion attributeMatchCriterion : arrayList) {
                parcel.writeInt(attributeMatchCriterion.mRule);
                parcel.writeInt(attributeMatchCriterion.mAttr.getUsage());
            }
        }
    }
}

