/*
 * Decompiled with CFR 0.152.
 */
package android.media.tv;

import android.hardware.hdmi.HdmiDeviceInfo;
import android.media.tv.ITvInputServiceCallback;
import android.media.tv.ITvInputSessionCallback;
import android.media.tv.TvInputHardwareInfo;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.view.InputChannel;

public interface ITvInputService
extends IInterface {
    public void createSession(InputChannel var1, ITvInputSessionCallback var2, String var3) throws RemoteException;

    public void notifyHardwareAdded(TvInputHardwareInfo var1) throws RemoteException;

    public void notifyHardwareRemoved(TvInputHardwareInfo var1) throws RemoteException;

    public void notifyHdmiDeviceAdded(HdmiDeviceInfo var1) throws RemoteException;

    public void notifyHdmiDeviceRemoved(HdmiDeviceInfo var1) throws RemoteException;

    public void registerCallback(ITvInputServiceCallback var1) throws RemoteException;

    public void unregisterCallback(ITvInputServiceCallback var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ITvInputService {
        private static final String DESCRIPTOR = "android.media.tv.ITvInputService";
        static final int TRANSACTION_createSession = 3;
        static final int TRANSACTION_notifyHardwareAdded = 4;
        static final int TRANSACTION_notifyHardwareRemoved = 5;
        static final int TRANSACTION_notifyHdmiDeviceAdded = 6;
        static final int TRANSACTION_notifyHdmiDeviceRemoved = 7;
        static final int TRANSACTION_registerCallback = 1;
        static final int TRANSACTION_unregisterCallback = 2;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static ITvInputService asInterface(IBinder iBinder) {
            if (iBinder == null) {
                return null;
            }
            IInterface iInterface = iBinder.queryLocalInterface(DESCRIPTOR);
            if (iInterface != null && iInterface instanceof ITvInputService) {
                return (ITvInputService)iInterface;
            }
            return new Proxy(iBinder);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public boolean onTransact(int n, Parcel parcel, Parcel parcel2, int n2) throws RemoteException {
            switch (n) {
                default: {
                    return super.onTransact(n, parcel, parcel2, n2);
                }
                case 1598968902: {
                    parcel2.writeString(DESCRIPTOR);
                    return true;
                }
                case 1: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.registerCallback(ITvInputServiceCallback.Stub.asInterface(parcel.readStrongBinder()));
                    return true;
                }
                case 2: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.unregisterCallback(ITvInputServiceCallback.Stub.asInterface(parcel.readStrongBinder()));
                    return true;
                }
                case 3: {
                    parcel.enforceInterface(DESCRIPTOR);
                    InputChannel inputChannel = parcel.readInt() != 0 ? InputChannel.CREATOR.createFromParcel(parcel) : null;
                    this.createSession(inputChannel, ITvInputSessionCallback.Stub.asInterface(parcel.readStrongBinder()), parcel.readString());
                    return true;
                }
                case 4: {
                    parcel.enforceInterface(DESCRIPTOR);
                    TvInputHardwareInfo tvInputHardwareInfo = parcel.readInt() != 0 ? TvInputHardwareInfo.CREATOR.createFromParcel(parcel) : null;
                    this.notifyHardwareAdded(tvInputHardwareInfo);
                    return true;
                }
                case 5: {
                    parcel.enforceInterface(DESCRIPTOR);
                    TvInputHardwareInfo tvInputHardwareInfo = parcel.readInt() != 0 ? TvInputHardwareInfo.CREATOR.createFromParcel(parcel) : null;
                    this.notifyHardwareRemoved(tvInputHardwareInfo);
                    return true;
                }
                case 6: {
                    parcel.enforceInterface(DESCRIPTOR);
                    HdmiDeviceInfo hdmiDeviceInfo = parcel.readInt() != 0 ? HdmiDeviceInfo.CREATOR.createFromParcel(parcel) : null;
                    this.notifyHdmiDeviceAdded(hdmiDeviceInfo);
                    return true;
                }
                case 7: 
            }
            parcel.enforceInterface(DESCRIPTOR);
            HdmiDeviceInfo hdmiDeviceInfo = parcel.readInt() != 0 ? HdmiDeviceInfo.CREATOR.createFromParcel(parcel) : null;
            this.notifyHdmiDeviceRemoved(hdmiDeviceInfo);
            return true;
        }

        private static class Proxy
        implements ITvInputService {
            private IBinder mRemote;

            Proxy(IBinder iBinder) {
                this.mRemote = iBinder;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void createSession(InputChannel inputChannel, ITvInputSessionCallback iTvInputSessionCallback, String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (inputChannel != null) {
                        parcel.writeInt(1);
                        inputChannel.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    IBinder iBinder = null;
                    if (iTvInputSessionCallback != null) {
                        iBinder = iTvInputSessionCallback.asBinder();
                    }
                    parcel.writeStrongBinder(iBinder);
                    parcel.writeString(string2);
                    this.mRemote.transact(3, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void notifyHardwareAdded(TvInputHardwareInfo tvInputHardwareInfo) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (tvInputHardwareInfo != null) {
                        parcel.writeInt(1);
                        tvInputHardwareInfo.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.mRemote.transact(4, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void notifyHardwareRemoved(TvInputHardwareInfo tvInputHardwareInfo) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (tvInputHardwareInfo != null) {
                        parcel.writeInt(1);
                        tvInputHardwareInfo.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.mRemote.transact(5, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void notifyHdmiDeviceAdded(HdmiDeviceInfo hdmiDeviceInfo) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (hdmiDeviceInfo != null) {
                        parcel.writeInt(1);
                        hdmiDeviceInfo.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.mRemote.transact(6, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void notifyHdmiDeviceRemoved(HdmiDeviceInfo hdmiDeviceInfo) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (hdmiDeviceInfo != null) {
                        parcel.writeInt(1);
                        hdmiDeviceInfo.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.mRemote.transact(7, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void registerCallback(ITvInputServiceCallback iTvInputServiceCallback) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    IBinder iBinder = null;
                    if (iTvInputServiceCallback != null) {
                        iBinder = iTvInputServiceCallback.asBinder();
                    }
                    parcel.writeStrongBinder(iBinder);
                    this.mRemote.transact(1, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void unregisterCallback(ITvInputServiceCallback iTvInputServiceCallback) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    IBinder iBinder = null;
                    if (iTvInputServiceCallback != null) {
                        iBinder = iTvInputServiceCallback.asBinder();
                    }
                    parcel.writeStrongBinder(iBinder);
                    this.mRemote.transact(2, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }
        }
    }
}

