/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.net.NetworkUtils;
import android.os.Parcel;
import android.os.Parcelable;
import android.system.ErrnoException;
import com.android.okhttp.ConnectionPool;
import com.android.okhttp.HostResolver;
import com.android.okhttp.HttpHandler;
import com.android.okhttp.HttpsHandler;
import com.android.okhttp.OkHttpClient;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import javax.net.SocketFactory;

public class Network
implements Parcelable {
    public static final Parcelable.Creator<Network> CREATOR;
    private static final boolean httpKeepAlive;
    private static final long httpKeepAliveDurationMs;
    private static final int httpMaxConnections;
    private volatile ConnectionPool mConnectionPool = null;
    private volatile HostResolver mHostResolver = null;
    private Object mLock = new Object();
    private volatile NetworkBoundSocketFactory mNetworkBoundSocketFactory = null;
    public final int netId;

    /*
     * Enabled aggressive block sorting
     */
    static {
        httpKeepAlive = Boolean.parseBoolean(System.getProperty("http.keepAlive", "true"));
        int n = httpKeepAlive ? Integer.parseInt(System.getProperty("http.maxConnections", "5")) : 0;
        httpMaxConnections = n;
        httpKeepAliveDurationMs = Long.parseLong(System.getProperty("http.keepAliveDuration", "300000"));
        CREATOR = new Parcelable.Creator<Network>(){

            @Override
            public Network createFromParcel(Parcel parcel) {
                return new Network(parcel.readInt());
            }

            public Network[] newArray(int n) {
                return new Network[n];
            }
        };
    }

    public Network(int n) {
        this.netId = n;
    }

    public Network(Network network) {
        this.netId = network.netId;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void maybeInitHttpClient() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mHostResolver == null) {
                this.mHostResolver = new HostResolver(){

                    public InetAddress[] getAllByName(String string2) throws UnknownHostException {
                        return Network.this.getAllByName(string2);
                    }
                };
            }
            if (this.mConnectionPool == null) {
                this.mConnectionPool = new ConnectionPool(httpMaxConnections, httpKeepAliveDurationMs);
            }
            return;
        }
    }

    public void bindSocket(Socket socket) throws IOException {
        if (socket.isConnected()) {
            throw new SocketException("Socket is connected");
        }
        socket.getReuseAddress();
        int n = NetworkUtils.bindSocketToNetwork(socket.getFileDescriptor$().getInt$(), this.netId);
        if (n != 0) {
            throw new ErrnoException("Binding socket to network " + this.netId, -n).rethrowAsSocketException();
        }
    }

    @Override
    public int describeContents() {
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean equals(Object object) {
        block3: {
            block2: {
                if (!(object instanceof Network)) break block2;
                Network network = (Network)object;
                if (this.netId == network.netId) break block3;
            }
            return false;
        }
        return true;
    }

    public InetAddress[] getAllByName(String string2) throws UnknownHostException {
        return InetAddress.getAllByNameOnNet((String)string2, (int)this.netId);
    }

    public InetAddress getByName(String string2) throws UnknownHostException {
        return InetAddress.getByNameOnNet((String)string2, (int)this.netId);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SocketFactory getSocketFactory() {
        if (this.mNetworkBoundSocketFactory == null) {
            Object object = this.mLock;
            synchronized (object) {
                if (this.mNetworkBoundSocketFactory == null) {
                    this.mNetworkBoundSocketFactory = new NetworkBoundSocketFactory(this.netId);
                }
            }
        }
        return this.mNetworkBoundSocketFactory;
    }

    public int hashCode() {
        return 11 * this.netId;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public URLConnection openConnection(URL uRL) throws IOException {
        OkHttpClient okHttpClient;
        this.maybeInitHttpClient();
        String string2 = uRL.getProtocol();
        if (string2.equals("http")) {
            okHttpClient = HttpHandler.createHttpOkHttpClient(null);
            return okHttpClient.setSocketFactory(this.getSocketFactory()).setHostResolver(this.mHostResolver).setConnectionPool(this.mConnectionPool).open(uRL);
        }
        if (!string2.equals("https")) throw new MalformedURLException("Invalid URL or unrecognized protocol " + string2);
        okHttpClient = HttpsHandler.createHttpsOkHttpClient(null);
        return okHttpClient.setSocketFactory(this.getSocketFactory()).setHostResolver(this.mHostResolver).setConnectionPool(this.mConnectionPool).open(uRL);
    }

    public String toString() {
        return Integer.toString(this.netId);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeInt(this.netId);
    }

    private class NetworkBoundSocketFactory
    extends SocketFactory {
        private final int mNetId;

        public NetworkBoundSocketFactory(int n) {
            this.mNetId = n;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private Socket connectToHost(String string2, int n, SocketAddress socketAddress) throws IOException {
            InetAddress[] inetAddressArray = Network.this.getAllByName(string2);
            int n2 = 0;
            while (true) {
                if (n2 >= inetAddressArray.length) {
                    throw new UnknownHostException(string2);
                }
                try {
                    Socket socket = this.createSocket();
                    if (socketAddress != null) {
                        socket.bind(socketAddress);
                    }
                    socket.connect(new InetSocketAddress(inetAddressArray[n2], n));
                    return socket;
                }
                catch (IOException iOException) {
                    if (n2 == -1 + inetAddressArray.length) {
                        throw iOException;
                    }
                    ++n2;
                    continue;
                }
                break;
            }
        }

        @Override
        public Socket createSocket() throws IOException {
            Socket socket = new Socket();
            Network.this.bindSocket(socket);
            return socket;
        }

        @Override
        public Socket createSocket(String string2, int n) throws IOException {
            return this.connectToHost(string2, n, null);
        }

        @Override
        public Socket createSocket(String string2, int n, InetAddress inetAddress, int n2) throws IOException {
            return this.connectToHost(string2, n, new InetSocketAddress(inetAddress, n2));
        }

        @Override
        public Socket createSocket(InetAddress inetAddress, int n) throws IOException {
            Socket socket = this.createSocket();
            socket.connect(new InetSocketAddress(inetAddress, n));
            return socket;
        }

        @Override
        public Socket createSocket(InetAddress inetAddress, int n, InetAddress inetAddress2, int n2) throws IOException {
            Socket socket = this.createSocket();
            socket.bind(new InetSocketAddress(inetAddress2, n2));
            socket.connect(new InetSocketAddress(inetAddress, n));
            return socket;
        }
    }
}

