/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.net.NetworkStats;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.MathUtils;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.IndentingPrintWriter;
import java.io.CharArrayWriter;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Writer;
import java.net.ProtocolException;
import java.util.Arrays;
import java.util.Random;

public class NetworkStatsHistory
implements Parcelable {
    public static final Parcelable.Creator<NetworkStatsHistory> CREATOR = new Parcelable.Creator<NetworkStatsHistory>(){

        @Override
        public NetworkStatsHistory createFromParcel(Parcel parcel) {
            return new NetworkStatsHistory(parcel);
        }

        public NetworkStatsHistory[] newArray(int n) {
            return new NetworkStatsHistory[n];
        }
    };
    public static final int FIELD_ACTIVE_TIME = 1;
    public static final int FIELD_ALL = -1;
    public static final int FIELD_OPERATIONS = 32;
    public static final int FIELD_RX_BYTES = 2;
    public static final int FIELD_RX_PACKETS = 4;
    public static final int FIELD_TX_BYTES = 8;
    public static final int FIELD_TX_PACKETS = 16;
    private static final int VERSION_ADD_ACTIVE = 3;
    private static final int VERSION_ADD_PACKETS = 2;
    private static final int VERSION_INIT = 1;
    private long[] activeTime;
    private int bucketCount;
    private long bucketDuration;
    private long[] bucketStart;
    private long[] operations;
    private long[] rxBytes;
    private long[] rxPackets;
    private long totalBytes;
    private long[] txBytes;
    private long[] txPackets;

    public NetworkStatsHistory(long l) {
        this(l, 10, -1);
    }

    public NetworkStatsHistory(long l, int n) {
        this(l, n, -1);
    }

    public NetworkStatsHistory(long l, int n, int n2) {
        this.bucketDuration = l;
        this.bucketStart = new long[n];
        if ((n2 & 1) != 0) {
            this.activeTime = new long[n];
        }
        if ((n2 & 2) != 0) {
            this.rxBytes = new long[n];
        }
        if ((n2 & 4) != 0) {
            this.rxPackets = new long[n];
        }
        if ((n2 & 8) != 0) {
            this.txBytes = new long[n];
        }
        if ((n2 & 0x10) != 0) {
            this.txPackets = new long[n];
        }
        if ((n2 & 0x20) != 0) {
            this.operations = new long[n];
        }
        this.bucketCount = 0;
        this.totalBytes = 0L;
    }

    public NetworkStatsHistory(NetworkStatsHistory networkStatsHistory, long l) {
        this(l, networkStatsHistory.estimateResizeBuckets(l));
        this.recordEntireHistory(networkStatsHistory);
    }

    public NetworkStatsHistory(Parcel parcel) {
        this.bucketDuration = parcel.readLong();
        this.bucketStart = ParcelUtils.readLongArray(parcel);
        this.activeTime = ParcelUtils.readLongArray(parcel);
        this.rxBytes = ParcelUtils.readLongArray(parcel);
        this.rxPackets = ParcelUtils.readLongArray(parcel);
        this.txBytes = ParcelUtils.readLongArray(parcel);
        this.txPackets = ParcelUtils.readLongArray(parcel);
        this.operations = ParcelUtils.readLongArray(parcel);
        this.bucketCount = this.bucketStart.length;
        this.totalBytes = parcel.readLong();
    }

    /*
     * Enabled aggressive block sorting
     */
    public NetworkStatsHistory(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readInt();
        switch (n) {
            default: {
                throw new ProtocolException("unexpected version: " + n);
            }
            case 1: {
                this.bucketDuration = dataInputStream.readLong();
                this.bucketStart = DataStreamUtils.readFullLongArray(dataInputStream);
                this.rxBytes = DataStreamUtils.readFullLongArray(dataInputStream);
                this.rxPackets = new long[this.bucketStart.length];
                this.txBytes = DataStreamUtils.readFullLongArray(dataInputStream);
                this.txPackets = new long[this.bucketStart.length];
                this.operations = new long[this.bucketStart.length];
                this.bucketCount = this.bucketStart.length;
                this.totalBytes = ArrayUtils.total(this.rxBytes) + ArrayUtils.total(this.txBytes);
                break;
            }
            case 2: 
            case 3: {
                this.bucketDuration = dataInputStream.readLong();
                this.bucketStart = DataStreamUtils.readVarLongArray(dataInputStream);
                long[] lArray = n >= 3 ? DataStreamUtils.readVarLongArray(dataInputStream) : new long[this.bucketStart.length];
                this.activeTime = lArray;
                this.rxBytes = DataStreamUtils.readVarLongArray(dataInputStream);
                this.rxPackets = DataStreamUtils.readVarLongArray(dataInputStream);
                this.txBytes = DataStreamUtils.readVarLongArray(dataInputStream);
                this.txPackets = DataStreamUtils.readVarLongArray(dataInputStream);
                this.operations = DataStreamUtils.readVarLongArray(dataInputStream);
                this.bucketCount = this.bucketStart.length;
                this.totalBytes = ArrayUtils.total(this.rxBytes) + ArrayUtils.total(this.txBytes);
            }
        }
        if (this.bucketStart.length != this.bucketCount || this.rxBytes.length != this.bucketCount || this.rxPackets.length != this.bucketCount || this.txBytes.length != this.bucketCount || this.txPackets.length != this.bucketCount || this.operations.length != this.bucketCount) {
            throw new ProtocolException("Mismatched history lengths");
        }
    }

    private static void addLong(long[] lArray, int n, long l) {
        if (lArray != null) {
            lArray[n] = l + lArray[n];
        }
    }

    private void ensureBuckets(long l, long l2) {
        long l3 = l - l % this.bucketDuration;
        long l4 = l2 + (this.bucketDuration - l2 % this.bucketDuration) % this.bucketDuration;
        for (long i = l3; i < l4; i += this.bucketDuration) {
            int n = Arrays.binarySearch(this.bucketStart, 0, this.bucketCount, i);
            if (n >= 0) continue;
            this.insertBucket(~n, i);
        }
    }

    private static long getLong(long[] lArray, int n, long l) {
        if (lArray != null) {
            l = lArray[n];
        }
        return l;
    }

    private void insertBucket(int n, long l) {
        if (this.bucketCount >= this.bucketStart.length) {
            int n2 = 3 * Math.max(this.bucketStart.length, 10) / 2;
            this.bucketStart = Arrays.copyOf(this.bucketStart, n2);
            if (this.activeTime != null) {
                this.activeTime = Arrays.copyOf(this.activeTime, n2);
            }
            if (this.rxBytes != null) {
                this.rxBytes = Arrays.copyOf(this.rxBytes, n2);
            }
            if (this.rxPackets != null) {
                this.rxPackets = Arrays.copyOf(this.rxPackets, n2);
            }
            if (this.txBytes != null) {
                this.txBytes = Arrays.copyOf(this.txBytes, n2);
            }
            if (this.txPackets != null) {
                this.txPackets = Arrays.copyOf(this.txPackets, n2);
            }
            if (this.operations != null) {
                this.operations = Arrays.copyOf(this.operations, n2);
            }
        }
        if (n < this.bucketCount) {
            int n3 = n + 1;
            int n4 = this.bucketCount - n;
            System.arraycopy((long[])this.bucketStart, (int)n, (long[])this.bucketStart, (int)n3, (int)n4);
            if (this.activeTime != null) {
                System.arraycopy((long[])this.activeTime, (int)n, (long[])this.activeTime, (int)n3, (int)n4);
            }
            if (this.rxBytes != null) {
                System.arraycopy((long[])this.rxBytes, (int)n, (long[])this.rxBytes, (int)n3, (int)n4);
            }
            if (this.rxPackets != null) {
                System.arraycopy((long[])this.rxPackets, (int)n, (long[])this.rxPackets, (int)n3, (int)n4);
            }
            if (this.txBytes != null) {
                System.arraycopy((long[])this.txBytes, (int)n, (long[])this.txBytes, (int)n3, (int)n4);
            }
            if (this.txPackets != null) {
                System.arraycopy((long[])this.txPackets, (int)n, (long[])this.txPackets, (int)n3, (int)n4);
            }
            if (this.operations != null) {
                System.arraycopy((long[])this.operations, (int)n, (long[])this.operations, (int)n3, (int)n4);
            }
        }
        this.bucketStart[n] = l;
        NetworkStatsHistory.setLong(this.activeTime, n, 0L);
        NetworkStatsHistory.setLong(this.rxBytes, n, 0L);
        NetworkStatsHistory.setLong(this.rxPackets, n, 0L);
        NetworkStatsHistory.setLong(this.txBytes, n, 0L);
        NetworkStatsHistory.setLong(this.txPackets, n, 0L);
        NetworkStatsHistory.setLong(this.operations, n, 0L);
        this.bucketCount = 1 + this.bucketCount;
    }

    public static long randomLong(Random random, long l, long l2) {
        return (long)((float)l + random.nextFloat() * (float)(l2 - l));
    }

    private static void setLong(long[] lArray, int n, long l) {
        if (lArray != null) {
            lArray[n] = l;
        }
    }

    @Override
    public int describeContents() {
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void dump(IndentingPrintWriter indentingPrintWriter, boolean bl) {
        indentingPrintWriter.print("NetworkStatsHistory: bucketDuration=");
        indentingPrintWriter.println(this.bucketDuration);
        indentingPrintWriter.increaseIndent();
        int n = 0;
        if (!bl) {
            n = Math.max(0, -32 + this.bucketCount);
        }
        if (n > 0) {
            indentingPrintWriter.print("(omitting ");
            indentingPrintWriter.print(n);
            indentingPrintWriter.println(" buckets)");
        }
        int n2 = n;
        while (true) {
            if (n2 >= this.bucketCount) {
                indentingPrintWriter.decreaseIndent();
                return;
            }
            indentingPrintWriter.print("bucketStart=");
            indentingPrintWriter.print(this.bucketStart[n2]);
            if (this.activeTime != null) {
                indentingPrintWriter.print(" activeTime=");
                indentingPrintWriter.print(this.activeTime[n2]);
            }
            if (this.rxBytes != null) {
                indentingPrintWriter.print(" rxBytes=");
                indentingPrintWriter.print(this.rxBytes[n2]);
            }
            if (this.rxPackets != null) {
                indentingPrintWriter.print(" rxPackets=");
                indentingPrintWriter.print(this.rxPackets[n2]);
            }
            if (this.txBytes != null) {
                indentingPrintWriter.print(" txBytes=");
                indentingPrintWriter.print(this.txBytes[n2]);
            }
            if (this.txPackets != null) {
                indentingPrintWriter.print(" txPackets=");
                indentingPrintWriter.print(this.txPackets[n2]);
            }
            if (this.operations != null) {
                indentingPrintWriter.print(" operations=");
                indentingPrintWriter.print(this.operations[n2]);
            }
            indentingPrintWriter.println();
            ++n2;
        }
    }

    public int estimateResizeBuckets(long l) {
        return (int)((long)this.size() * this.getBucketDuration() / l);
    }

    @Deprecated
    public void generateRandom(long l, long l2, long l3) {
        Random random = new Random();
        float f = random.nextFloat();
        long l4 = (long)(f * (float)l3);
        long l5 = (long)((float)l3 * (1.0f - f));
        this.generateRandom(l, l2, l4, l4 / 1024L, l5, l5 / 1024L, l4 / 2048L, random);
    }

    @Deprecated
    public void generateRandom(long l, long l2, long l3, long l4, long l5, long l6, long l7, Random random) {
        this.ensureBuckets(l, l2);
        NetworkStats.Entry entry = new NetworkStats.Entry(NetworkStats.IFACE_ALL, -1, 0, 0, 0L, 0L, 0L, 0L, 0L);
        while (l3 > 1024L || l4 > 128L || l5 > 1024L || l6 > 128L || l7 > 32L) {
            long l8 = NetworkStatsHistory.randomLong(random, l, l2);
            long l9 = l8 + NetworkStatsHistory.randomLong(random, 0L, (l2 - l8) / 2L);
            entry.rxBytes = NetworkStatsHistory.randomLong(random, 0L, l3);
            entry.rxPackets = NetworkStatsHistory.randomLong(random, 0L, l4);
            entry.txBytes = NetworkStatsHistory.randomLong(random, 0L, l5);
            entry.txPackets = NetworkStatsHistory.randomLong(random, 0L, l6);
            entry.operations = NetworkStatsHistory.randomLong(random, 0L, l7);
            l3 -= entry.rxBytes;
            l4 -= entry.rxPackets;
            l5 -= entry.txBytes;
            l6 -= entry.txPackets;
            l7 -= entry.operations;
            this.recordData(l8, l9, entry);
        }
    }

    public long getBucketDuration() {
        return this.bucketDuration;
    }

    public long getEnd() {
        if (this.bucketCount > 0) {
            return this.bucketStart[-1 + this.bucketCount] + this.bucketDuration;
        }
        return Long.MIN_VALUE;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getIndexAfter(long l) {
        int n;
        int n2 = Arrays.binarySearch(this.bucketStart, 0, this.bucketCount, l);
        if (n2 < 0) {
            n = ~n2;
            return MathUtils.constrain(n, 0, -1 + this.bucketCount);
        }
        n = n2 + 1;
        return MathUtils.constrain(n, 0, -1 + this.bucketCount);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getIndexBefore(long l) {
        int n;
        int n2 = Arrays.binarySearch(this.bucketStart, 0, this.bucketCount, l);
        if (n2 < 0) {
            n = -1 + ~n2;
            return MathUtils.constrain(n, 0, -1 + this.bucketCount);
        }
        n = n2 - 1;
        return MathUtils.constrain(n, 0, -1 + this.bucketCount);
    }

    public long getStart() {
        if (this.bucketCount > 0) {
            return this.bucketStart[0];
        }
        return Long.MAX_VALUE;
    }

    public long getTotalBytes() {
        return this.totalBytes;
    }

    /*
     * Enabled aggressive block sorting
     */
    public Entry getValues(int n, Entry entry) {
        Entry entry2 = entry != null ? entry : new Entry();
        entry2.bucketStart = this.bucketStart[n];
        entry2.bucketDuration = this.bucketDuration;
        entry2.activeTime = NetworkStatsHistory.getLong(this.activeTime, n, -1L);
        entry2.rxBytes = NetworkStatsHistory.getLong(this.rxBytes, n, -1L);
        entry2.rxPackets = NetworkStatsHistory.getLong(this.rxPackets, n, -1L);
        entry2.txBytes = NetworkStatsHistory.getLong(this.txBytes, n, -1L);
        entry2.txPackets = NetworkStatsHistory.getLong(this.txPackets, n, -1L);
        entry2.operations = NetworkStatsHistory.getLong(this.operations, n, -1L);
        return entry2;
    }

    /*
     * Enabled aggressive block sorting
     */
    public Entry getValues(long l, long l2, long l3, Entry entry) {
        Entry entry2 = entry != null ? entry : new Entry();
        entry2.bucketDuration = l2 - l;
        entry2.bucketStart = l;
        long l4 = this.activeTime != null ? 0L : -1L;
        entry2.activeTime = l4;
        long l5 = this.rxBytes != null ? 0L : -1L;
        entry2.rxBytes = l5;
        long l6 = this.rxPackets != null ? 0L : -1L;
        entry2.rxPackets = l6;
        long l7 = this.txBytes != null ? 0L : -1L;
        entry2.txBytes = l7;
        long l8 = this.txPackets != null ? 0L : -1L;
        entry2.txPackets = l8;
        long l9 = this.operations != null ? 0L : -1L;
        entry2.operations = l9;
        int n = this.getIndexAfter(l2);
        long l10;
        long l11;
        while (n >= 0 && (l11 = (l10 = this.bucketStart[n]) + this.bucketDuration) > l) {
            if (l10 < l2) {
                long l12;
                boolean bl = l10 < l3 && l11 > l3;
                if (bl) {
                    l12 = this.bucketDuration;
                } else {
                    long l13 = l11 < l2 ? l11 : l2;
                    long l14 = l10 > l ? l10 : l;
                    l12 = l13 - l14;
                }
                if (l12 > 0L) {
                    if (this.activeTime != null) {
                        entry2.activeTime += l12 * this.activeTime[n] / this.bucketDuration;
                    }
                    if (this.rxBytes != null) {
                        entry2.rxBytes += l12 * this.rxBytes[n] / this.bucketDuration;
                    }
                    if (this.rxPackets != null) {
                        entry2.rxPackets += l12 * this.rxPackets[n] / this.bucketDuration;
                    }
                    if (this.txBytes != null) {
                        entry2.txBytes += l12 * this.txBytes[n] / this.bucketDuration;
                    }
                    if (this.txPackets != null) {
                        entry2.txPackets += l12 * this.txPackets[n] / this.bucketDuration;
                    }
                    if (this.operations != null) {
                        entry2.operations += l12 * this.operations[n] / this.bucketDuration;
                    }
                }
            }
            --n;
        }
        return entry2;
    }

    public Entry getValues(long l, long l2, Entry entry) {
        return this.getValues(l, l2, Long.MAX_VALUE, entry);
    }

    @Deprecated
    public void recordData(long l, long l2, long l3, long l4) {
        this.recordData(l, l2, new NetworkStats.Entry(NetworkStats.IFACE_ALL, -1, 0, 0, l3, 0L, l4, 0L, 0L));
    }

    /*
     * Enabled aggressive block sorting
     */
    public void recordData(long l, long l2, NetworkStats.Entry entry) {
        long l3 = entry.rxBytes;
        long l4 = entry.rxPackets;
        long l5 = entry.txBytes;
        long l6 = entry.txPackets;
        long l7 = entry.operations;
        if (entry.isNegative()) {
            throw new IllegalArgumentException("tried recording negative data");
        }
        if (entry.isEmpty()) {
            return;
        }
        this.ensureBuckets(l, l2);
        long l8 = l2 - l;
        int n = this.getIndexAfter(l2);
        while (true) {
            long l9;
            long l10;
            long l11;
            if (n < 0 || (l11 = (l10 = this.bucketStart[n]) + this.bucketDuration) < l) {
                this.totalBytes += entry.rxBytes + entry.txBytes;
                return;
            }
            if (l10 <= l2 && (l9 = Math.min(l11, l2) - Math.max(l10, l)) > 0L) {
                long l12 = l3 * l9 / l8;
                long l13 = l4 * l9 / l8;
                long l14 = l5 * l9 / l8;
                long l15 = l6 * l9 / l8;
                long l16 = l7 * l9 / l8;
                NetworkStatsHistory.addLong(this.activeTime, n, l9);
                NetworkStatsHistory.addLong(this.rxBytes, n, l12);
                l3 -= l12;
                NetworkStatsHistory.addLong(this.rxPackets, n, l13);
                l4 -= l13;
                NetworkStatsHistory.addLong(this.txBytes, n, l14);
                l5 -= l14;
                NetworkStatsHistory.addLong(this.txPackets, n, l15);
                l6 -= l15;
                NetworkStatsHistory.addLong(this.operations, n, l16);
                l7 -= l16;
                l8 -= l9;
            }
            --n;
        }
    }

    public void recordEntireHistory(NetworkStatsHistory networkStatsHistory) {
        this.recordHistory(networkStatsHistory, Long.MIN_VALUE, Long.MAX_VALUE);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void recordHistory(NetworkStatsHistory networkStatsHistory, long l, long l2) {
        NetworkStats.Entry entry = new NetworkStats.Entry(NetworkStats.IFACE_ALL, -1, 0, 0, 0L, 0L, 0L, 0L, 0L);
        int n = 0;
        while (n < networkStatsHistory.bucketCount) {
            long l3 = networkStatsHistory.bucketStart[n];
            long l4 = l3 + networkStatsHistory.bucketDuration;
            if (l3 >= l && l4 <= l2) {
                entry.rxBytes = NetworkStatsHistory.getLong(networkStatsHistory.rxBytes, n, 0L);
                entry.rxPackets = NetworkStatsHistory.getLong(networkStatsHistory.rxPackets, n, 0L);
                entry.txBytes = NetworkStatsHistory.getLong(networkStatsHistory.txBytes, n, 0L);
                entry.txPackets = NetworkStatsHistory.getLong(networkStatsHistory.txPackets, n, 0L);
                entry.operations = NetworkStatsHistory.getLong(networkStatsHistory.operations, n, 0L);
                this.recordData(l3, l4, entry);
            }
            ++n;
        }
        return;
    }

    @Deprecated
    public void removeBucketsBefore(long l) {
        int n = 0;
        while (true) {
            if (n >= this.bucketCount || this.bucketStart[n] + this.bucketDuration > l) {
                if (n > 0) {
                    int n2 = this.bucketStart.length;
                    this.bucketStart = Arrays.copyOfRange(this.bucketStart, n, n2);
                    if (this.activeTime != null) {
                        this.activeTime = Arrays.copyOfRange(this.activeTime, n, n2);
                    }
                    if (this.rxBytes != null) {
                        this.rxBytes = Arrays.copyOfRange(this.rxBytes, n, n2);
                    }
                    if (this.rxPackets != null) {
                        this.rxPackets = Arrays.copyOfRange(this.rxPackets, n, n2);
                    }
                    if (this.txBytes != null) {
                        this.txBytes = Arrays.copyOfRange(this.txBytes, n, n2);
                    }
                    if (this.txPackets != null) {
                        this.txPackets = Arrays.copyOfRange(this.txPackets, n, n2);
                    }
                    if (this.operations != null) {
                        this.operations = Arrays.copyOfRange(this.operations, n, n2);
                    }
                    this.bucketCount -= n;
                }
                return;
            }
            ++n;
        }
    }

    public int size() {
        return this.bucketCount;
    }

    public String toString() {
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        this.dump(new IndentingPrintWriter((Writer)charArrayWriter, "  "), false);
        return charArrayWriter.toString();
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeLong(this.bucketDuration);
        ParcelUtils.writeLongArray(parcel, this.bucketStart, this.bucketCount);
        ParcelUtils.writeLongArray(parcel, this.activeTime, this.bucketCount);
        ParcelUtils.writeLongArray(parcel, this.rxBytes, this.bucketCount);
        ParcelUtils.writeLongArray(parcel, this.rxPackets, this.bucketCount);
        ParcelUtils.writeLongArray(parcel, this.txBytes, this.bucketCount);
        ParcelUtils.writeLongArray(parcel, this.txPackets, this.bucketCount);
        ParcelUtils.writeLongArray(parcel, this.operations, this.bucketCount);
        parcel.writeLong(this.totalBytes);
    }

    public void writeToStream(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(3);
        dataOutputStream.writeLong(this.bucketDuration);
        DataStreamUtils.writeVarLongArray(dataOutputStream, this.bucketStart, this.bucketCount);
        DataStreamUtils.writeVarLongArray(dataOutputStream, this.activeTime, this.bucketCount);
        DataStreamUtils.writeVarLongArray(dataOutputStream, this.rxBytes, this.bucketCount);
        DataStreamUtils.writeVarLongArray(dataOutputStream, this.rxPackets, this.bucketCount);
        DataStreamUtils.writeVarLongArray(dataOutputStream, this.txBytes, this.bucketCount);
        DataStreamUtils.writeVarLongArray(dataOutputStream, this.txPackets, this.bucketCount);
        DataStreamUtils.writeVarLongArray(dataOutputStream, this.operations, this.bucketCount);
    }

    public static class DataStreamUtils {
        @Deprecated
        public static long[] readFullLongArray(DataInputStream dataInputStream) throws IOException {
            int n = dataInputStream.readInt();
            if (n < 0) {
                throw new ProtocolException("negative array size");
            }
            long[] lArray = new long[n];
            for (int i = 0; i < lArray.length; ++i) {
                lArray[i] = dataInputStream.readLong();
            }
            return lArray;
        }

        public static long readVarLong(DataInputStream dataInputStream) throws IOException {
            long l = 0L;
            for (int i = 0; i < 64; i += 7) {
                byte by = dataInputStream.readByte();
                l |= (long)(by & 0x7F) << i;
                if ((by & 0x80) != 0) continue;
                return l;
            }
            throw new ProtocolException("malformed long");
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static long[] readVarLongArray(DataInputStream dataInputStream) throws IOException {
            int n = dataInputStream.readInt();
            if (n == -1) {
                return null;
            }
            if (n < 0) {
                throw new ProtocolException("negative array size");
            }
            long[] lArray = new long[n];
            int n2 = 0;
            while (n2 < lArray.length) {
                lArray[n2] = DataStreamUtils.readVarLong(dataInputStream);
                ++n2;
            }
            return lArray;
        }

        public static void writeVarLong(DataOutputStream dataOutputStream, long l) throws IOException {
            while (true) {
                if ((0xFFFFFFFFFFFFFF80L & l) == 0L) {
                    dataOutputStream.writeByte((int)l);
                    return;
                }
                dataOutputStream.writeByte(0x80 | 0x7F & (int)l);
                l >>>= 7;
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        public static void writeVarLongArray(DataOutputStream dataOutputStream, long[] lArray, int n) throws IOException {
            if (lArray == null) {
                dataOutputStream.writeInt(-1);
                return;
            } else {
                if (n > lArray.length) {
                    throw new IllegalArgumentException("size larger than length");
                }
                dataOutputStream.writeInt(n);
                for (int i = 0; i < n; ++i) {
                    DataStreamUtils.writeVarLong(dataOutputStream, lArray[i]);
                }
            }
        }
    }

    public static class Entry {
        public static final long UNKNOWN = -1L;
        public long activeTime;
        public long bucketDuration;
        public long bucketStart;
        public long operations;
        public long rxBytes;
        public long rxPackets;
        public long txBytes;
        public long txPackets;
    }

    public static class ParcelUtils {
        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static long[] readLongArray(Parcel parcel) {
            int n = parcel.readInt();
            if (n == -1) {
                return null;
            }
            long[] lArray = new long[n];
            int n2 = 0;
            while (n2 < lArray.length) {
                lArray[n2] = parcel.readLong();
                ++n2;
            }
            return lArray;
        }

        /*
         * Enabled aggressive block sorting
         */
        public static void writeLongArray(Parcel parcel, long[] lArray, int n) {
            if (lArray == null) {
                parcel.writeInt(-1);
                return;
            } else {
                if (n > lArray.length) {
                    throw new IllegalArgumentException("size larger than length");
                }
                parcel.writeInt(n);
                for (int i = 0; i < n; ++i) {
                    parcel.writeLong(lArray[i]);
                }
            }
        }
    }
}

