/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.os.Parcel;
import android.os.Parcelable;

public final class UidRange
implements Parcelable {
    public static final Parcelable.Creator<UidRange> CREATOR = new Parcelable.Creator<UidRange>(){

        @Override
        public UidRange createFromParcel(Parcel parcel) {
            return new UidRange(parcel.readInt(), parcel.readInt());
        }

        public UidRange[] newArray(int n) {
            return new UidRange[n];
        }
    };
    public final int start;
    public final int stop;

    public UidRange(int n, int n2) {
        if (n < 0) {
            throw new IllegalArgumentException("Invalid start UID.");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("Invalid stop UID.");
        }
        if (n > n2) {
            throw new IllegalArgumentException("Invalid UID range.");
        }
        this.start = n;
        this.stop = n2;
    }

    public static UidRange createForUser(int n) {
        return new UidRange(n * 100000, -1 + 100000 * (n + 1));
    }

    @Override
    public int describeContents() {
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean equals(Object object) {
        block5: {
            block4: {
                if (this == object) break block4;
                if (!(object instanceof UidRange)) {
                    return false;
                }
                UidRange uidRange = (UidRange)object;
                if (this.start != uidRange.start || this.stop != uidRange.stop) break block5;
            }
            return true;
        }
        return false;
    }

    public int getStartUser() {
        return this.start / 100000;
    }

    public int hashCode() {
        return 31 * (527 + this.start) + this.stop;
    }

    public String toString() {
        return this.start + "-" + this.stop;
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeInt(this.start);
        parcel.writeInt(this.stop);
    }
}

