/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.app.PendingIntent;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.content.pm.IPackageManager;
import android.content.pm.PackageManager;
import android.net.IConnectivityManager;
import android.net.LinkAddress;
import android.net.NetworkUtils;
import android.net.RouteInfo;
import android.os.Binder;
import android.os.IBinder;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.UserHandle;
import android.system.OsConstants;
import com.android.internal.net.VpnConfig;
import java.net.DatagramSocket;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;

public class VpnService
extends Service {
    public static final String SERVICE_INTERFACE = "android.net.VpnService";

    private static void check(InetAddress inetAddress, int n) {
        if (inetAddress.isLoopbackAddress()) {
            throw new IllegalArgumentException("Bad address");
        }
        if (inetAddress instanceof Inet4Address) {
            if (n < 0 || n > 32) {
                throw new IllegalArgumentException("Bad prefixLength");
            }
        } else if (inetAddress instanceof Inet6Address) {
            if (n < 0 || n > 128) {
                throw new IllegalArgumentException("Bad prefixLength");
            }
        } else {
            throw new IllegalArgumentException("Unsupported family");
        }
    }

    private static IConnectivityManager getService() {
        return IConnectivityManager.Stub.asInterface(ServiceManager.getService("connectivity"));
    }

    public static Intent prepare(Context context) {
        try {
            boolean bl = VpnService.getService().prepareVpn(context.getPackageName(), null);
            if (bl) {
                return null;
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return VpnConfig.getIntentForConfirmation();
    }

    public boolean addAddress(InetAddress inetAddress, int n) {
        VpnService.check(inetAddress, n);
        try {
            boolean bl = VpnService.getService().addVpnAddress(inetAddress.getHostAddress(), n);
            return bl;
        }
        catch (RemoteException remoteException) {
            throw new IllegalStateException(remoteException);
        }
    }

    @Override
    public IBinder onBind(Intent intent) {
        if (intent != null && SERVICE_INTERFACE.equals(intent.getAction())) {
            return new Callback();
        }
        return null;
    }

    public void onRevoke() {
        this.stopSelf();
    }

    public boolean protect(int n) {
        return NetworkUtils.protectFromVpn(n);
    }

    public boolean protect(DatagramSocket datagramSocket) {
        return this.protect(datagramSocket.getFileDescriptor$().getInt$());
    }

    public boolean protect(Socket socket) {
        return this.protect(socket.getFileDescriptor$().getInt$());
    }

    public boolean removeAddress(InetAddress inetAddress, int n) {
        VpnService.check(inetAddress, n);
        try {
            boolean bl = VpnService.getService().removeVpnAddress(inetAddress.getHostAddress(), n);
            return bl;
        }
        catch (RemoteException remoteException) {
            throw new IllegalStateException(remoteException);
        }
    }

    public class Builder {
        private final List<LinkAddress> mAddresses;
        private final VpnConfig mConfig = new VpnConfig();
        private final List<RouteInfo> mRoutes;

        public Builder() {
            this.mAddresses = new ArrayList<LinkAddress>();
            this.mRoutes = new ArrayList<RouteInfo>();
            this.mConfig.user = VpnService.this.getClass().getName();
        }

        private void verifyApp(String string2) throws PackageManager.NameNotFoundException {
            IPackageManager iPackageManager = IPackageManager.Stub.asInterface(ServiceManager.getService("package"));
            try {
                iPackageManager.getApplicationInfo(string2, 0, UserHandle.getCallingUserId());
                return;
            }
            catch (RemoteException remoteException) {
                throw new IllegalStateException(remoteException);
            }
        }

        public Builder addAddress(String string2, int n) {
            return this.addAddress(InetAddress.parseNumericAddress((String)string2), n);
        }

        public Builder addAddress(InetAddress inetAddress, int n) {
            VpnService.check(inetAddress, n);
            if (inetAddress.isAnyLocalAddress()) {
                throw new IllegalArgumentException("Bad address");
            }
            this.mAddresses.add(new LinkAddress(inetAddress, n));
            this.mConfig.updateAllowedFamilies(inetAddress);
            return this;
        }

        public Builder addAllowedApplication(String string2) throws PackageManager.NameNotFoundException {
            if (this.mConfig.disallowedApplications != null) {
                throw new UnsupportedOperationException("addDisallowedApplication already called");
            }
            this.verifyApp(string2);
            if (this.mConfig.allowedApplications == null) {
                this.mConfig.allowedApplications = new ArrayList<String>();
            }
            this.mConfig.allowedApplications.add(string2);
            return this;
        }

        public Builder addDisallowedApplication(String string2) throws PackageManager.NameNotFoundException {
            if (this.mConfig.allowedApplications != null) {
                throw new UnsupportedOperationException("addAllowedApplication already called");
            }
            this.verifyApp(string2);
            if (this.mConfig.disallowedApplications == null) {
                this.mConfig.disallowedApplications = new ArrayList<String>();
            }
            this.mConfig.disallowedApplications.add(string2);
            return this;
        }

        public Builder addDnsServer(String string2) {
            return this.addDnsServer(InetAddress.parseNumericAddress((String)string2));
        }

        public Builder addDnsServer(InetAddress inetAddress) {
            if (inetAddress.isLoopbackAddress() || inetAddress.isAnyLocalAddress()) {
                throw new IllegalArgumentException("Bad address");
            }
            if (this.mConfig.dnsServers == null) {
                this.mConfig.dnsServers = new ArrayList<String>();
            }
            this.mConfig.dnsServers.add(inetAddress.getHostAddress());
            return this;
        }

        public Builder addRoute(String string2, int n) {
            return this.addRoute(InetAddress.parseNumericAddress((String)string2), n);
        }

        public Builder addRoute(InetAddress inetAddress, int n) {
            int n2;
            VpnService.check(inetAddress, n);
            byte[] byArray = inetAddress.getAddress();
            if (n2 < byArray.length) {
                byArray[n2] = (byte)(byArray[n2] << n % 8);
                for (n2 = n / 8; n2 < byArray.length; ++n2) {
                    if (byArray[n2] == 0) continue;
                    throw new IllegalArgumentException("Bad address");
                }
            }
            this.mRoutes.add(new RouteInfo(new LinkAddress(inetAddress, n), null));
            this.mConfig.updateAllowedFamilies(inetAddress);
            return this;
        }

        public Builder addSearchDomain(String string2) {
            if (this.mConfig.searchDomains == null) {
                this.mConfig.searchDomains = new ArrayList<String>();
            }
            this.mConfig.searchDomains.add(string2);
            return this;
        }

        public Builder allowBypass() {
            this.mConfig.allowBypass = true;
            return this;
        }

        public Builder allowFamily(int n) {
            if (n == OsConstants.AF_INET) {
                this.mConfig.allowIPv4 = true;
                return this;
            }
            if (n == OsConstants.AF_INET6) {
                this.mConfig.allowIPv6 = true;
                return this;
            }
            throw new IllegalArgumentException(n + " is neither " + OsConstants.AF_INET + " nor " + OsConstants.AF_INET6);
        }

        public ParcelFileDescriptor establish() {
            this.mConfig.addresses = this.mAddresses;
            this.mConfig.routes = this.mRoutes;
            try {
                ParcelFileDescriptor parcelFileDescriptor = VpnService.getService().establishVpn(this.mConfig);
                return parcelFileDescriptor;
            }
            catch (RemoteException remoteException) {
                throw new IllegalStateException(remoteException);
            }
        }

        public Builder setBlocking(boolean bl) {
            this.mConfig.blocking = bl;
            return this;
        }

        public Builder setConfigureIntent(PendingIntent pendingIntent) {
            this.mConfig.configureIntent = pendingIntent;
            return this;
        }

        public Builder setMtu(int n) {
            if (n <= 0) {
                throw new IllegalArgumentException("Bad mtu");
            }
            this.mConfig.mtu = n;
            return this;
        }

        public Builder setSession(String string2) {
            this.mConfig.session = string2;
            return this;
        }
    }

    private class Callback
    extends Binder {
        private Callback() {
        }

        @Override
        protected boolean onTransact(int n, Parcel parcel, Parcel parcel2, int n2) {
            if (n == 0xFFFFFF) {
                VpnService.this.onRevoke();
                return true;
            }
            return false;
        }
    }
}

