/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.net.ParseException;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class WebAddress {
    static final int MATCH_GROUP_AUTHORITY = 2;
    static final int MATCH_GROUP_HOST = 3;
    static final int MATCH_GROUP_PATH = 5;
    static final int MATCH_GROUP_PORT = 4;
    static final int MATCH_GROUP_SCHEME = 1;
    static Pattern sAddressPattern = Pattern.compile("(?:(http|https|file)\\:\\/\\/)?(?:([-A-Za-z0-9$_.+!*'(),;?&=]+(?:\\:[-A-Za-z0-9$_.+!*'(),;?&=]+)?)@)?([a-zA-Z0-9\u00a0-\ud7ff\uf900-\ufdcf\ufdf0-\uffef%_-][a-zA-Z0-9\u00a0-\ud7ff\uf900-\ufdcf\ufdf0-\uffef%_\\.-]*|\\[[0-9a-fA-F:\\.]+\\])?(?:\\:([0-9]*))?(\\/?[^#]*)?.*", 2);
    private String mAuthInfo;
    private String mHost;
    private String mPath;
    private int mPort;
    private String mScheme;

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public WebAddress(String string2) throws ParseException {
        block12: {
            block11: {
                String string3;
                String string4;
                String string5;
                String string6;
                if (string2 == null) {
                    throw new NullPointerException();
                }
                this.mScheme = "";
                this.mHost = "";
                this.mPort = -1;
                this.mPath = "/";
                this.mAuthInfo = "";
                Matcher matcher = sAddressPattern.matcher(string2);
                if (!matcher.matches()) {
                    throw new ParseException("Bad address");
                }
                String string7 = matcher.group(1);
                if (string7 != null) {
                    this.mScheme = string7.toLowerCase(Locale.ROOT);
                }
                if ((string6 = matcher.group(2)) != null) {
                    this.mAuthInfo = string6;
                }
                if ((string5 = matcher.group(3)) != null) {
                    this.mHost = string5;
                }
                if ((string4 = matcher.group(4)) != null && string4.length() > 0) {
                    this.mPort = Integer.parseInt(string4);
                }
                if ((string3 = matcher.group(5)) != null && string3.length() > 0) {
                    this.mPath = string3.charAt(0) == '/' ? string3 : "/" + string3;
                }
                if (this.mPort != 443 || !this.mScheme.equals("")) break block11;
                this.mScheme = "https";
                break block12;
                catch (NumberFormatException numberFormatException) {
                    throw new ParseException("Bad port");
                }
            }
            if (this.mPort == -1) {
                this.mPort = this.mScheme.equals("https") ? 443 : 80;
            }
        }
        if (this.mScheme.equals("")) {
            this.mScheme = "http";
        }
    }

    public String getAuthInfo() {
        return this.mAuthInfo;
    }

    public String getHost() {
        return this.mHost;
    }

    public String getPath() {
        return this.mPath;
    }

    public int getPort() {
        return this.mPort;
    }

    public String getScheme() {
        return this.mScheme;
    }

    public void setAuthInfo(String string2) {
        this.mAuthInfo = string2;
    }

    public void setHost(String string2) {
        this.mHost = string2;
    }

    public void setPath(String string2) {
        this.mPath = string2;
    }

    public void setPort(int n) {
        this.mPort = n;
    }

    public void setScheme(String string2) {
        this.mScheme = string2;
    }

    public String toString() {
        String string2 = "";
        if (this.mPort != 443 && this.mScheme.equals("https") || this.mPort != 80 && this.mScheme.equals("http")) {
            string2 = ":" + Integer.toString(this.mPort);
        }
        String string3 = "";
        if (this.mAuthInfo.length() > 0) {
            string3 = this.mAuthInfo + "@";
        }
        return this.mScheme + "://" + string3 + this.mHost + string2 + this.mPath;
    }
}

